	<?php
/***************************************** for time field ****************************************************************************/
//var_dump($field->type);
if ( $field->type === 'time' ) {
	
	$content_xpath = new DomXPath($dom);

	$complex_field = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' ginput_complex ')]");

	$validation_errors = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' validation_message ')]");
	$validation_error_class = '';

	if( !empty( $validation_errors->length ) ) { // contains error

		foreach ( $validation_errors as $validation_error ) {
			$validation_error->setAttribute( 'class', $validation_error->getAttribute( 'class' ) . ' mdc-text-field-helper-text mdc-text-field-helper-text--persistent mdc-text-field-helper-text--validation-msg' );
		}

		// error present then set varialbe
		$validation_error_class = 'mdc-text-field--invalid';
	}

	$time_fields = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' ginput_container ') and not(contains(concat(' ', normalize-space(@class), ' '), ' gfield_time_ampm '))] ");

	foreach( $time_fields as $time_field ){

		// Remove 'i' element
		$separators = $time_field->getElementsByTagName('i');
		foreach($separators as $separator ) {
			$separator->parentNode->removeChild($separator);
		}

		$time_field->setAttribute( 'data-mdc-auto-init', 'MDCTextField' );

		$labels = $time_field->getElementsByTagName( 'label' );
		

		$inputs = $time_field->getElementsByTagName( 'input' );
		

		if( $type === 'filled' ){
			/******For Filled Input ******/

			$time_field->setAttribute( 'class', $time_field->getAttribute( 'class' ) . ' mdc-text-field mdc-text-field--filled'. $validation_error_class  );

			$text_ripple = $dom->createElement( 'div' );
			$text_ripple->setAttribute( 'class', 'mdc-text-field__ripple' );
			$time_field->appendChild( $text_ripple );

			foreach( $labels as $label ){
				$label->setAttribute( 'class', $label->getAttribute( 'class' ) . ' mdc-floating-label' );
				$time_field->appendChild( $label );
			}

			foreach( $inputs as $input ){
				$input->setAttribute( 'class', $input->getAttribute( 'class' ) . ' mdc-text-field__input' );
				$time_field->appendChild( $input );
			}

			$field_ripple = $dom->createElement( 'div' );
			$field_ripple->setAttribute( 'class', 'mdc-line-ripple' );
			$time_field->appendChild( $field_ripple );
		}else{
			/******For outline Input ******/
			$time_field->setAttribute( 'class', $time_field->getAttribute( 'class' ) . ' mdc-text-field mdc-text-field--outlined'. $validation_error_class );

			$notched_outline = $dom->createElement( 'div' );
			$notched_outline->setAttribute( 'class', 'mdc-notched-outline' );
			$time_field->appendChild( $notched_outline );

			$outline__leading = $dom->createElement( 'div' );
			$outline__leading->setAttribute( 'class', 'mdc-notched-outline__leading' );
			$notched_outline->appendChild( $outline__leading );

			$outline_notch = $dom->createElement( 'div' );
			$outline_notch->setAttribute( 'class', 'mdc-notched-outline__notch' );
			$notched_outline->appendChild( $outline_notch );
			
			foreach( $labels as $label ){
				$label->setAttribute( 'class', $label->getAttribute( 'class' ) . ' mdc-floating-label' );
				$outline_notch->appendChild( $label );
			}
			
			$outline_trailing = $dom->createElement( 'div' );
			$outline_trailing->setAttribute( 'class', 'mdc-notched-outline__trailing' );
			$notched_outline->appendChild( $outline_trailing );
			
			foreach( $inputs as $input ){
				$input->setAttribute( 'class', $input->getAttribute( 'class' ) . ' mdc-text-field__input' );
				$time_field->appendChild( $input );
			}
			

		}

	}

	
	
	$content = utf8_decode($dom->saveHTML($dom->documentElement));

}
