<?php

/***************************************** for radio ****************************************************************************/

if ( in_array( $field->type, $radio_fields ) ) {
	
	$content_xpath = new DomXPath($dom);

	$radio_fields = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' ginput_container_radio ')]");

	$field_labels =  $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' gfield_label ')]");

	// set class on field labels.
	foreach( $field_labels as $field_label ){
		$label_class = $field_label->getAttribute( 'class' );

		$field_label->setAttribute( 'class', $label_class. ' mdc-typography--subtitle1' );
	}

	$validation_errors = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' validation_message ')]");

	if( !empty( $validation_errors->length ) ) { // contains error

		foreach ( $validation_errors as $validation_error ) {
			$validation_error->setAttribute( 'class', $validation_error->getAttribute( 'class' ) . ' mdc-text-field-helper-text mdc-text-field-helper-text--persistent mdc-text-field-helper-text--validation-msg' );
		}

		foreach( $radio_fields as $radio_field ) {
			$radio_field->setAttribute( 'class', $radio_field->getAttribute( 'class' ) . '  mdc-text-field--invalid' );
		}

	}

	if( $radio_fields->length ){
		
		$choices = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' gchoice ')]");

		if( $has_old_gf ){
			
			$choice_containers = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' gfield_radio ')]");
			foreach( $choice_containers as $choice_container ){
				
				$choices = $choice_container->getElementsByTagName( 'li' );

			}
		}

		foreach( $choices as $choice ) {
			$inputs = $choice->getElementsByTagName('input');
			
			if( $inputs->length >= 2 ){
				$choice->setAttribute( 'class', $choice->getAttribute( 'class' ) . ' stla-other-choice' );
	
			}
			// Set structure of radio field
			$choice->setAttribute( 'class', $choice->getAttribute( 'class' ) . ' mdc-form-field' );
			$outer_div = $dom->createElement( 'div' );
			$outer_div->setAttribute( 'class', 'mdc-radio' );
			$choice->appendChild( $outer_div );
			$outer_div = $choice->lastChild;
	
			$input = $inputs[0];
	
			$input->setAttribute( 'class', $input->getAttribute( 'class' ) . ' mdc-radio__native-control' );
			$outer_div->appendChild( $input );
			$outer_background_div = $dom->createElement( 'div' );
			$outer_background_div->setAttribute( 'class', 'mdc-radio__background' );
			$outer_div->appendChild( $outer_background_div );
			$outer_background_div = $choice->lastChild->lastChild;
			$inner_circle_div = $dom->createElement( 'div' );
			$inner_circle_div->setAttribute( 'class', 'mdc-radio__inner-circle' );
			$outer_circle_div = $dom->createElement( 'div' );
			$outer_circle_div->setAttribute( 'class', 'mdc-radio__outer-circle' );
			$outer_background_div->appendChild( $outer_circle_div );
			$outer_background_div->appendChild( $inner_circle_div );
	
			// ripple
			$ripple = $dom->createElement( 'div' );
			$ripple->setAttribute( 'class', 'mdc-radio__ripple' );
			$outer_div->appendChild( $ripple );
	
			$labels = $choice->getElementsByTagName('label');
			
			// moving label to last
			foreach( $labels as $label ) {
				$choice->appendChild( $label );
			}
	
			// dealing with other choice input text
			if( !empty( $inputs[1] ) ){  
	
				$br_line_break = $choice->getElementsByTagName('br');
				if( $br_line_break->length !== 0 ){
					$choice->appendChild( $br_line_break[0] );
				}
	
				if( $type === 'filled'  ){
					$text_field = $dom->createElement( 'span' );
					$text_field->setAttribute( 'class', 'mdc-text-field mdc-text-field--filled  stla-other-input' );
					$text_field->setAttribute( 'data-mdc-auto-init', 'MDCTextField' );
		
					$field_ripple = $dom->createElement( 'div' );
					$field_ripple->setAttribute( 'class', 'mdc-text-field__ripple' );
					$text_field->appendChild( $field_ripple );
		
					$input = $inputs[0];
					$input->setAttribute( 'class', $input->getAttribute( 'class' ) . ' mdc-text-field__input' );
					$text_field->appendChild( $input );
		
					$line_ripple = $dom->createElement( 'div' );
					$line_ripple->setAttribute( 'class', 'mdc-line-ripple' );
					$text_field->appendChild( $line_ripple );
					$choice->appendChild( $text_field );
				} else{
					$outline_field = $dom->createElement( 'span' );
					$outline_field->setAttribute( 'class', 'mdc-text-field mdc-text-field--outlined' );
					$outline_field->setAttribute( 'data-mdc-auto-init', 'MDCTextField' );
	
					$notched_outline = $dom->createElement( 'div' );
					$notched_outline->setAttribute( 'class', 'mdc-notched-outline' );
					$outline_field->appendChild( $notched_outline );
	
					$outline__leading = $dom->createElement( 'div' );
					$outline__leading->setAttribute( 'class', 'mdc-notched-outline__leading' );
					$notched_outline->appendChild( $outline__leading );
	
					$outline_notch = $dom->createElement( 'div' );
					$outline_notch->setAttribute( 'class', 'mdc-notched-outline__notch' );
					$notched_outline->appendChild( $outline_notch );
	
					$outline_trailing = $dom->createElement( 'div' );
					$outline_trailing->setAttribute( 'class', 'mdc-notched-outline__trailing' );
					$notched_outline->appendChild( $outline_trailing );
	
					$input = $inputs[0];
					$input->setAttribute( 'class', $input->getAttribute( 'class' ) . ' mdc-text-field__input' );
					$outline_field->appendChild( $input );
	
					$choice->appendChild( $outline_field );
	
				}
				
				$inputs[0]->setAttribute( 'onfocus', "jQuery(this).parent('div').parent('li').find('.mdc-text-field  input').focus();" );
				
				// Other input text field
				$defualt_onfocus = $inputs[1]->getAttribute('onfocus') ;
				$new_onfocus = str_replace( "jQuery(this).prev(\"input\")[0].click();", "jQuery(this).parents('.stla-other-choice').find('.mdc-radio__native-control').click();", $defualt_onfocus);

				$inputs[1]->setAttribute( 'onfocus', $new_onfocus );				
	
			}
			
		}
	}
	$content = utf8_decode( $dom->saveHTML( $dom->documentElement ) );

	


}
