<?php
/***************************************** for complex fields like address and name *************************************/

if ( in_array( $field->type, $email_confirmation ) ) {
	//var_dump($content);

	$content_xpath = new DomXPath($dom);

	$complex_emails = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' ginput_complex ')]");

	
	$field_labels =  $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' gfield_label ')]");
	
	// set class on field labels.
	foreach( $field_labels as $field_label ){
		$label_class = $field_label->getAttribute( 'class' );

		$field_label->setAttribute( 'class', $label_class. ' mdc-typography--subtitle1' );
	}

	$validation_errors = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' validation_message ')]");
	$validation_error_class = '';

	foreach ( $validation_errors as $validation_error ) {
		$validation_error->setAttribute( 'class', $validation_error->getAttribute( 'class' ) . ' mdc-text-field-helper-text mdc-text-field-helper-text--persistent mdc-text-field-helper-text--validation-msg' );

		// error present then set varialbe
		$validation_error_class = 'mdc-text-field--invalid';
	}
	foreach( $complex_emails as $complex_email ){
		$email_containers = $complex_email->getElementsByTagName( 'span' );
		foreach($email_containers as $email_container ){

			// common outer for filled and outline
			$outer_div = $email_container;
			$outer_div->setAttribute( 'data-mdc-auto-init', 'MDCTextField' );
			// $email_container->appendChild( $outer_div );

			if( $type === 'filled' ){
				/******For Filled Input ******/
				
				$outer_div->setAttribute( 'class', $outer_div->getAttribute( 'class' ) . ' mdc-text-field mdc-text-field--filled ' . $validation_error_class );
	
				//Ripple text.
				$text_ripple = $dom->createElement( 'div' );
				$text_ripple->setAttribute( 'class', 'mdc-text-field__ripple' );
				$outer_div->appendChild( $text_ripple );

				$inputs = $email_container->getElementsByTagName( 'input' );
				foreach( $inputs as $input ){
					$input->setAttribute( 'class', $input->getAttribute( 'class' ) . ' mdc-text-field__input' );
					$outer_div->appendChild( $input );
				}
				
				$labels = $email_container->getElementsByTagName( 'label' );
				foreach( $labels as $label ){
					$label->setAttribute( 'class', $label->getAttribute( 'class' ) . ' mdc-floating-label');
					$outer_div->appendChild( $label );
				}
				stla_material_field_icon( $outer_div, $dom );
	
				//Line Ripple.
				$line_ripple = $dom->createElement( 'div' );
				$line_ripple->setAttribute( 'class', 'mdc-line-ripple' );
				$outer_div->appendChild( $line_ripple );
			}else{
				/******For Outline Input ******/
				$outer_div->setAttribute( 'class', $outer_div->getAttribute( 'class' ) . ' mdc-text-field mdc-text-field--outlined '. $validation_error_class );

				$notched_outline = $dom->createElement( 'div' );
				$notched_outline->setAttribute( 'class', 'mdc-notched-outline' );
				$outer_div->appendChild( $notched_outline );

				$outline__leading = $dom->createElement( 'div' );
				$outline__leading->setAttribute( 'class', 'mdc-notched-outline__leading' );
				$notched_outline->appendChild( $outline__leading );

				$outline_notch = $dom->createElement( 'div' );
				$outline_notch->setAttribute( 'class', 'mdc-notched-outline__notch' );
				$notched_outline->appendChild( $outline_notch );

				$labels = $email_container->getElementsByTagName( 'label' );
				foreach( $labels as $label ){
					$label->setAttribute( 'class', $label->getAttribute( 'class' ) . ' mdc-floating-label');
					$outline_notch->appendChild( $label );
				}

				$outline_trailing = $dom->createElement( 'div' );
				$outline_trailing->setAttribute( 'class', 'mdc-notched-outline__trailing' );
				$notched_outline->appendChild( $outline_trailing );

				$inputs = $email_container->getElementsByTagName( 'input' );
				foreach( $inputs as $input ){
					$input->setAttribute( 'class', $input->getAttribute( 'class' ) . ' mdc-text-field__input' );
					$outer_div->appendChild( $input );
				}
				stla_material_field_icon( $outer_div, $dom );

			}

			$container_classes = $outer_div->getAttribute('class');

			if ( strpos( $container_classes, 'stla-fontawesome') !== false) {
				$outer_div->setAttribute( 'class', $container_classes . ' mdc-text-field--with-leading-icon' );
			}

		}
	}

	$is_complex_field = false;
	$contains_error = false;

	//check if error is present
	$all_divs = $dom->getElementsByTagName( 'div' );
	foreach ( $all_divs as $current_div ) {
		$current_div_classes = $current_div->getAttribute( 'class' );
		if ( strpos( $current_div_classes, 'validation_message' ) !== false ) {
			$contains_error = true;
			$current_div->setAttribute( 'class', $current_div->getAttribute( 'class' ) . ' mdc-text-field-helper-text mdc-text-field-helper-text--persistent mdc-text-field-helper-text--validation-msg' );
		}

		// if ( strpos( $current_div_classes, 'ginput_complex' ) !== false ) {
		// 	$is_complex_field = true;
		// }
	}
	// if its complex field only then process it.. ( added because of confirm email )
	if ( $is_complex_field  ) {
		$get_span = $dom->getElementsByTagName( 'span' );

		foreach ( $get_span as $input_element ) {

			$span_classes = $input_element->getAttribute( 'class' );

			//check if the current span is not 'required' * span
			if ( strpos( $span_classes, 'gfield_required' ) === false ) {
				//create a new div to append to span

				$container_div = $dom->createElement( 'div' );
				$container_div->setAttribute( 'class', 'MDCTextField' );
				$input_element->appendChild( $container_div );


				//get newly appended container div

				$container_div = $input_element->getElementsByTagName( 'div' )->item( 0 );
				$add_classes = $container_div->getAttribute( 'class' ). ' stla_material_large  mdc-text-field';
				// outlined design
				$add_classes .= $type === 'outlined' ?' mdc-text-field--outlined': ' mdc-text-field--filled';

				if ( $contains_error ) {
					$add_classes .= ' mdc-text-field--invalid';
				}

				$container_div->setAttribute( 'class', $add_classes );
				$container_div->setAttribute( 'data-mdc-auto-init', 'MDCTextField' );

				$inputs = $input_element->getElementsByTagName( 'input' );
				foreach ( $inputs as $input ) {
					$input->setAttribute( 'class', $input->getAttribute( 'class' ) . '  mdc-text-field__input' );

					// add a div before container .. can't add span because we have foreach for span above and adding a new one will create loop
					$top_ripple_span = $dom->createElement('div');
					$top_ripple_span->setAttribute('class', 'mdc-text-field__ripple');
					$container_div->appendChild($top_ripple_span);

					$container_div->appendChild( $input );
					$add_label_classes = ' mdc-floating-label';
					if ( $input->getAttribute( 'placeholder' ) !== ''  && $type !== 'outlined' ) {
						$add_label_classes .= ' mdc-floating-label--float-above';
					}
				}
				$labels = $input_element->getElementsByTagName( 'label' );
				foreach ( $labels as $label ) {

					// outlined design
					if( $type === 'outlined' ) {
						$notched_outline = $dom->createElement('div');
						$notched_outline->setAttribute( 'class', 'mdc-notched-outline' );

						$notched_outline_leading = $dom->createElement( 'div' );
						$notched_outline_leading->setAttribute( 'class', 'mdc-notched-outline__leading' );
						
						$notched_outline_notch = $dom->createElement( 'div' );
						$notched_outline_notch->setAttribute( 'class', 'mdc-notched-outline__notch' );

						$notched_outline_trailing = $dom->createElement( 'div' );
						$notched_outline_trailing->setAttribute( 'class', 'mdc-notched-outline__trailing' );
						
						if ($contains_placeholder) {
							$notched_outline->setAttribute( 'class', 'mdc-notched-outline mdc-notched-outline--notched' );
						}
						$container_div->appendChild( $notched_outline );

						$notched_outline->appendChild( $notched_outline_leading );
						$notched_outline->appendChild( $notched_outline_notch );
						$notched_outline->appendChild( $notched_outline_trailing );

						$label->setAttribute('class', $label->getAttribute( 'class' ) . $add_label_classes );
						$notched_outline_notch->appendChild( $label );
					}
					else{
						$label->setAttribute( 'class', $label->getAttribute( 'class' ) . $add_label_classes );
						$container_div->appendChild( $label );
					}
				}

				//create a new div
                if ($type === 'filled') {
                    $bottom_line_div = $dom->createElement('div');
                    $bottom_line_div->setAttribute('class', 'mdc-line-ripple');
                    $container_div->appendChild($bottom_line_div);
                }
			}
		}
	}
	$content = utf8_decode( $dom->saveHTML( $dom->documentElement ) );
}
