<?php
/***************************************** for input fields like text, numbers, email and website **************************************/

$select_icon = $dom->createElement('i');
$select_icon->setAttribute( 'class', 'mdc-select__dropdown-icon' );

if ( in_array( $field->type, $date_field ) ) {
	$content_xpath = new DomXPath($dom);

	$date_inputs = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' ginput_container_date ')]");

	
	$field_labels =  $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' gfield_label ')]");
	// set class on field labels.
	foreach( $field_labels as $field_label ){
		$label_class = $field_label->getAttribute( 'class' );

		$field_label->setAttribute( 'class', $label_class. ' mdc-typography--subtitle1' );
	}


	

	$validation_errors = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' validation_message ')]");
	$validation_error_class = '';

	foreach ( $validation_errors as $validation_error ) {
		$validation_error->setAttribute( 'class', $validation_error->getAttribute( 'class' ) . ' mdc-text-field-helper-text mdc-text-field-helper-text--persistent mdc-text-field-helper-text--validation-msg' );

		// error present then set varialbe
		$validation_error_class = 'mdc-text-field--invalid';
	}

	foreach( $date_inputs as $date_input ){

		// skip first element if not datepicker
		if( $field->dateType !== "datepicker" && $date_input->parentNode->tagName === 'body' ){
			continue;
		}

		$outer_div = $dom->createElement( 'div' );
		$outer_div->setAttribute( 'data-mdc-auto-init', 'MDCTextField' );
		$date_input->appendChild( $outer_div );

		//Helper line div.
		$helper_line = $dom->createElement( 'div' );
		$helper_line->setAttribute( 'class', 'mdc-text-field-helper-line' );

		$date_format_helpers = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' gfield_date_format ')]");
		foreach( $date_format_helpers as $date_format_helper ){
			$date_format_helper->setAttribute( 'class', $date_format_helper->getAttribute( 'class' ) . ' mdc-text-field-helper-text mdc-text-field-helper-text--persistent' );
			$helper_line->appendChild( $date_format_helper );
		}

		$screenreader_texts = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' screen-reader-text ')]");
		foreach( $screenreader_texts as $screenreader_text ){
			$helper_line->appendChild( $screenreader_text );
		}

		//Trailling Icon.
		$trailling_icon = $dom->createElement('img');
		$outer_inputs = $dom->getElementsByTagName('input');
		foreach( $outer_inputs as $outer_input ){
			$input_type = $outer_input->getAttribute( 'type' );
			if( $input_type === 'hidden' ){
				$trailling_icon->setAttribute( 'class', 'ui-datepicker-trigger mdc-text-field__icon mdc-text-field__icon--trailing' );
				$trailling_icon->setAttribute( 'src', $outer_input->getAttribute( 'value' ) );
			}
		}

		if( $type === 'filled' ){

			$outer_div->setAttribute( 'class', 'mdc-text-field mdc-text-field--filled ' . $validation_error_class);

			if( $field->dateType !== "datepicker"){
				$outer_div->setAttribute( 'class', $outer_div->getAttribute( 'class' ). ' mdc-text-field--no-label');
			}
			//Text Ripple.
			$text_ripple = $dom->createElement( 'div' );
			$text_ripple->setAttribute( 'class', 'mdc-text-field__ripple' );
			$outer_div->appendChild( $text_ripple );

			//Label.
			$labels = $date_input->getElementsByTagName('label');
			if( $field->dateType == "datepicker" ){
				$labels = $dom->getElementsByTagName('label');
			}
			foreach( $labels as $label ){
				$label->setAttribute( 'class', $label->getAttribute( 'class' ) . ' mdc-floating-label' );
				$outer_div->appendChild( $label );
			}

			//Input.
			$inputs = $date_input->getElementsByTagName('input');
			foreach( $inputs as $input ){
				$input->setAttribute( 'class', $input->getAttribute( 'class' ) . ' mdc-text-field__input' );
				$outer_div->appendChild( $input );
			}

			//dropdown selects
			$selects = $date_input->getElementsByTagName('select');
			foreach( $selects as $select ){
				$select->setAttribute( 'class', $select->getAttribute( 'class' ) . ' mdc-text-field__input' );
				$outer_div->appendChild( $select );
			}
			if( $field->dateType === "datedropdown" ){
				$outer_div->setAttribute( 'class', $outer_div->getAttribute( 'class' ). ' stla_complex_field_dropdown ');
				stla_material_dropdown_svg_icon( $dom, $outer_div );
			}
			if( $field->dateType === "datepicker" ){
				$outer_div->appendChild( $trailling_icon );
			}
	
			//Line Ripple.
			$line_ripple = $dom->createElement( 'div' );
			$line_ripple->setAttribute( 'class', 'mdc-line-ripple' );
			$outer_div->appendChild( $line_ripple );

			if( $field->dateType === "datepicker" ){

				$date_input->appendChild( $helper_line );
			}
			
		}else{
			/******For Outline Input ******/
			$outer_div->setAttribute( 'class', $outer_div->getAttribute( 'class' ) . ' mdc-text-field mdc-text-field--outlined ' . $validation_error_class);

			$notched_outline = $dom->createElement( 'div' );
			$notched_outline->setAttribute( 'class', 'mdc-notched-outline' );
			$outer_div->appendChild( $notched_outline );

			$outline__leading = $dom->createElement( 'div' );
			$outline__leading->setAttribute( 'class', 'mdc-notched-outline__leading' );
			$notched_outline->appendChild( $outline__leading );

			$outline_notch = $dom->createElement( 'div' );
			$outline_notch->setAttribute( 'class', 'mdc-notched-outline__notch' );
			$notched_outline->appendChild( $outline_notch );

			//Label.
			$labels = $date_input->getElementsByTagName('label');
			if( $field->dateType == "datepicker" ){
				$labels = $dom->getElementsByTagName('label');
			}
			foreach( $labels as $label ){
				$label->setAttribute( 'class', $label->getAttribute( 'class' ) . ' mdc-floating-label' );
				$outline_notch->appendChild( $label );
			}

			$outline_trailing = $dom->createElement( 'div' );
			$outline_trailing->setAttribute( 'class', 'mdc-notched-outline__trailing' );
			$notched_outline->appendChild( $outline_trailing );


			//Input.
			$inputs = $date_input->getElementsByTagName('input');
			foreach( $inputs as $input ){
				$input->setAttribute( 'class', $input->getAttribute( 'class' ) . ' mdc-text-field__input' );
				$outer_div->appendChild( $input );
			}

			//dropdown selects
			$selects = $date_input->getElementsByTagName('select');
			foreach( $selects as $select ){
				$select->setAttribute( 'class', $select->getAttribute( 'class' ) . ' mdc-text-field__input' );
				$outer_div->appendChild( $select );
			}

			if( $field->dateType === "datedropdown" ){
				$outer_div->setAttribute( 'class', $outer_div->getAttribute( 'class' ). ' stla_complex_field_dropdown ');
				
				stla_material_dropdown_svg_icon( $dom, $outer_div );
			}
			if( $field->dateType === "datepicker" ){
				$outer_div->appendChild( $trailling_icon );
				$date_input->appendChild( $helper_line );
			}
		}
	}

	$content = utf8_decode($dom->saveHTML($dom->documentElement));



	// //$input_classes_types = array( 'ginput_container_date' );
	// $contains_error = false;
	// $contains_placeholder = false;
	// $input_id = '';
	// $all_divs = $dom->getElementsByTagName( 'div' );
	// $is_date_boxes_field = false;
	// $date_boxes_classes = array( 'gfield_date_day', 'gfield_date_month', 'gfield_date_year' );
	// $is_date_dropdown_field = false;
	// $date_dropdown_classes = array( 'gfield_date_dropdown_day', 'gfield_date_dropdown_month', 'gfield_date_dropdown_year' );

	// //get the first div
	// foreach ( $all_divs as $div ) {
	// 	$div_classes = $div->getAttribute( 'class' );

	// 	$div_classes_array = explode( ' ', $div_classes );


	// 	$is_valid_input_field = false;

	// 	foreach ( $div_classes_array as $div_class_value ) {
	// 		// if ( in_array( $div_class_value, $input_classes_types ) ) {
	// 		//  $is_valid_input_field = true;
	// 		// }
	// 		if ( in_array( $div_class_value, $date_boxes_classes ) ) {
	// 			// $is_date_boxes_field = true;
	// 		}
	// 		if ( in_array( $div_class_value, $date_dropdown_classes ) ) {
	// 			// $is_date_dropdown_field = true;
	// 		}
	// 	}
	// }
	// foreach ( $all_divs as $div ) {
	// 	$div_classes = $div->getAttribute( 'class' );
	// 	$div_classes_array = explode( ' ', $div_classes );
	// 		$is_valid_datepicker_container = false;
	// 		foreach ( $div_classes_array as $div_class_value ) {
	// 			if ( $div_class_value === 'ginput_container_date' )  {
	// 				// $is_valid_datepicker_container = true;
	// 			}
	// 		}
	// 	// for datepicker date field
	// 	if (  ! $is_date_dropdown_field && ! $is_date_boxes_field && $is_valid_datepicker_container ) {

	// 		//add class to input
	// 		$inputs = $div->getElementsByTagName( 'input' );
	// 		foreach ( $inputs as $input ) {
	// 			$id = $input->getAttribute( 'id' );
	// 			//$input_type = $input->getAttribute( 'type' );
	// 			if ( preg_match( '/^input_/', $id ) ) {
	// 				$input_id = $id;
	// 				$input_classes = $input->getAttribute( 'class' );
	// 				$input->setAttribute( 'class', $input_classes . ' mdc-text-field__input' );

	// 				// check if contains placeholder
	// 				if ( $input->getAttribute( 'placeholder' ) !== ''  && $type !== 'outlined' ) {
	// 					$contains_placeholder = true;
	// 				}
	// 			}
	// 		}

	// 		// add a div before container div
	// 		$top_ripple_span = $dom->createElement('div');
	// 		$top_ripple_span->setAttribute('class', 'mdc-text-field__ripple');
	// 		$div->appendChild($top_ripple_span);

	// 		$div->appendChild($input);

	// 		// get icons
	// 		$icons = $div->getElementsByTagName('i');
	// 		$icon_parent_class = '';
	// 		foreach( $icons as $icon ) {
	// 			$icon_classes = $icon->getAttribute('class');
	// 			if ( strpos( $icon_classes, 'stla-fontawesome-icon') !== false) {
	// 				$icon_parent_class = 'mdc-text-field--with-leading-icon';
	// 				$icon->setAttribute('class', $icon->getAttribute('class') . ' mdc-text-field__icon');
	// 			}
	// 		}

	// 		//add classes to div
	// 		$add_div_classes = ' mdc-text-field '.$icon_parent_class;

	// 		// outlined design
	// 		$add_div_classes .= $type === 'outlined' ? ' mdc-text-field--outlined': 'mdc-text-field--filled';

	// 		//if has error then add the error class
	// 		if ( $contains_error ) {
	// 			$add_div_classes .= ' mdc-text-field--invalid';
	// 		}
	// 		$div->setAttribute( 'class', $div->getAttribute( 'class' ) . $add_div_classes );
	// 		$div->setAttribute( 'data-mdc-auto-init', 'MDCTextField' );

	// 		//get the first label
	// 		$labels = $dom->getElementsByTagName( 'label' );
	// 		foreach ( $labels as $label ) {
	// 			$label_for = $label->getAttribute( 'for' );

	// 			if ( $input_id === $label_for ) {
	// 				$add_label_classes = ' mdc-floating-label';
	// 				// if ( $contains_placeholder ) {
	// 				// 	$add_label_classes .= ' mdc-floating-label--float-above';
	// 				// }

	// 				// outlined design
	// 				if( $type === 'outlined' ) {
	// 					$notched_outline = $dom->createElement('div');
	// 					$notched_outline->setAttribute( 'class', 'mdc-notched-outline' );

	// 					$notched_outline_leading = $dom->createElement( 'div' );
	// 					$notched_outline_leading->setAttribute( 'class', 'mdc-notched-outline__leading' );
						
	// 					$notched_outline_notch = $dom->createElement( 'div' );
	// 					$notched_outline_notch->setAttribute( 'class', 'mdc-notched-outline__notch' );

	// 					$notched_outline_trailing = $dom->createElement( 'div' );
	// 					$notched_outline_trailing->setAttribute( 'class', 'mdc-notched-outline__trailing' );
						
	// 					// if ($contains_placeholder) {
	// 					// 	$notched_outline->setAttribute( 'class', 'mdc-notched-outline mdc-notched-outline--notched' );
	// 					// }
	// 					$div->appendChild( $notched_outline );

	// 					$notched_outline->appendChild( $notched_outline_leading );
	// 					$notched_outline->appendChild( $notched_outline_notch );
	// 					$notched_outline->appendChild( $notched_outline_trailing );

	// 					$label->setAttribute('class', $label->getAttribute( 'class' ) . $add_label_classes );
	// 					$notched_outline_notch->appendChild( $label );
	// 				}

	// 				else{

	// 					$label->setAttribute( 'class', $label->getAttribute( 'class' ) . $add_label_classes );
	// 					$div->appendChild( $label );
	// 				}
	// 			}
	// 		}

	// 		//create a new div
    //         if ( $type === 'filled' ) {
    //             //create a new div
    //             //using a div here is making the site to not load.. temporary solution.. use span
    //             $bottom_line_div = $dom->createElement('div');
    //             $bottom_line_div->setAttribute('class', 'mdc-line-ripple');
    //             // var_dump($bottom_line_div);
	// 			$div->appendChild($bottom_line_div);
				
	// 			// Get screenreader span
	// 			$screenreader_spans = $div->getElementsByTagName( 'span' );
	// 			foreach( $screenreader_spans as $screenreader_span ) {
	// 				$div->appendChild( $screenreader_span );
	// 			}
	// 		}

	// 	}

	// 	//for date boxes date field

	// 	if ( $is_date_boxes_field ) {
	// 		$div_classes = $div->getAttribute( 'class' );
	// 	$div_classes_array = explode( ' ', $div_classes );
	// 		$is_valid_box_div = false;
	// 		foreach ( $div_classes_array as $div_class_value ) {
	// 			if ( in_array( $div_class_value, $date_boxes_classes ) ) {
	// 				$is_valid_box_div = true;
	// 			}
	// 		}
	// 		if ( $is_valid_box_div ) {
	// 			//add class to input
	// 			$inputs = $div->getElementsByTagName( 'input' );
	// 			foreach ( $inputs as $input ) {
	// 				$id = $input->getAttribute( 'id' );

	// 				//$input_type = $input->getAttribute( 'type' );
	// 				if ( preg_match( '/^input_/', $id ) ) {
	// 					$input_id = $id;
	// 					$input_classes = $input->getAttribute( 'class' );
	// 					$input->setAttribute( 'class', $input_classes . ' mdc-text-field__input' );

	// 					// check if contains placeholder
	// 					if ( $input->getAttribute( 'placeholder' ) !== ''  && $type !== 'outlined' ) {
	// 						$contains_placeholder = true;
	// 					}

	// 					// add a div before div
	// 					$top_ripple_span = $dom->createElement('div');
	// 					$top_ripple_span->setAttribute('class', 'mdc-text-field__ripple');
	// 					$div->appendChild($top_ripple_span);

	// 					$div->appendChild($input);
	// 				}
	// 			}



	// 			//add classes to div
	// 			$add_div_classes = ' mdc-text-field ';

	// 			// outlined design
	// 			$add_div_classes .= $type === 'outlined' ? ' mdc-text-field--outlined': 'mdc-text-field--filled';

	// 			//if has error then add the error class
	// 			if ( $contains_error ) {
	// 				$add_div_classes .= ' mdc-text-field--invalid';
	// 			}
	// 			$div->setAttribute( 'class', $div->getAttribute( 'class' ) . $add_div_classes );
	// 			$div->setAttribute( 'data-mdc-auto-init', 'MDCTextField' );

	// 			//get the first label
	// 			$labels = $div->getElementsByTagName( 'label' );
	// 			foreach ( $labels as $label ) {
	// 				$label_for = $label->getAttribute( 'for' );
	// 				$label_classes = $label->getAttribute( 'class' );
	// 				$label_classes_array = explode( ' ', $label_classes );
	// 				//var_dump( $input_id );

	// 				if ( $input_id === $label_for ) {
	// 					$add_label_classes = ' mdc-floating-label';
	// 					// if ( $contains_placeholder ) {
	// 					// 	$add_label_classes .= ' mdc-floating-label--float-above';
	// 					// }

	// 					// outlined design
	// 					if( $type === 'outlined' ) {
	// 						$notched_outline = $dom->createElement('div');
	// 						$notched_outline->setAttribute( 'class', 'mdc-notched-outline' );

	// 						$notched_outline_leading = $dom->createElement( 'div' );
	// 						$notched_outline_leading->setAttribute( 'class', 'mdc-notched-outline__leading' );
							
	// 						$notched_outline_notch = $dom->createElement( 'div' );
	// 						$notched_outline_notch->setAttribute( 'class', 'mdc-notched-outline__notch' );

	// 						$notched_outline_trailing = $dom->createElement( 'div' );
	// 						$notched_outline_trailing->setAttribute( 'class', 'mdc-notched-outline__trailing' );
							
	// 						// if ($contains_placeholder) {
	// 						// 	$notched_outline->setAttribute( 'class', 'mdc-notched-outline mdc-notched-outline--notched' );
	// 						// }
	// 						$div->appendChild( $notched_outline );

	// 						$notched_outline->appendChild( $notched_outline_leading );
	// 						$notched_outline->appendChild( $notched_outline_notch );
	// 						$notched_outline->appendChild( $notched_outline_trailing );

	// 						$label->setAttribute('class', $label->getAttribute( 'class' ) . $add_label_classes );
	// 						$notched_outline_notch->appendChild( $label );
	// 					}
	// 					else{
	// 						$label->setAttribute( 'class', $label->getAttribute( 'class' ) . $add_label_classes );
	// 						$div->appendChild( $label );
	// 					}	
	// 				}
	// 			}

	// 			//create a new div
    //             if ($type === 'filled') {
    //                 $bottom_line_div = $dom->createElement('div');
    //                 $bottom_line_div->setAttribute('class', 'mdc-line-ripple');
    //                 $div->appendChild($bottom_line_div);
    //             }
	// 		}
	// 	}


	// 	//for date dropdown fields
	// 	if ( $is_date_dropdown_field ) {
	// 		$div_classes = $div->getAttribute( 'class' );
	// 		$div_classes_array = explode( ' ', $div_classes );
	// 		$is_valid_dropdown_div = false;
	// 		foreach ( $div_classes_array as $div_class_value ) {
	// 			if ( in_array( $div_class_value, $date_dropdown_classes ) ) {
	// 				$is_valid_dropdown_div = true;
	// 			}
	// 		}
			
	// 		if ( $is_valid_dropdown_div ) {

	// 			//add class to input
	// 			$get_selects = $div->getElementsByTagName( 'select' );
	// 			//var_dump($get_input->getAttribute('placeholder'));

	// 			foreach ( $get_selects as $get_select ) {
	// 				$select_classes = $get_select->getAttribute( 'class' );
	// 				$select_id = $get_select->getAttribute( 'id' );
	// 				$select_classes .= ' mdc-select__native-control';
	// 				if ( $contains_error ) {
	// 					$select_classes .= ' mdc-text-field--invalid';
	// 				}
	// 				$get_select->setAttribute( 'class', $select_classes );
	// 			}

	// 			$div_classes .= ' mdc-select mdc-text-field--no-label';
	// 			$div_classes .= $type === 'outlined' ? ' mdc-select--outlined':'';

	// 			$div->setAttribute( 'class', $div_classes );

	// 			if( $type === 'outlined' ) {

	// 				$notched_outline = $dom->createElement( 'div' );
	// 				$notched_outline->setAttribute( 'class', 'mdc-notched-outline' );

	// 				$notched_outline_leading = $dom->createElement( 'div' );
	// 				$notched_outline_leading->setAttribute( 'class', 'mdc-notched-outline__leading' );
					
	// 				$notched_outline_notch = $dom->createElement( 'div' );
	// 				$notched_outline_notch->setAttribute( 'class', 'mdc-notched-outline__notch' );

	// 				$notched_outline_trailing = $dom->createElement( 'div' );
	// 				$notched_outline_trailing->setAttribute( 'class', 'mdc-notched-outline__trailing' );
	// 				$div->appendChild( $select_icon );
	// 				$div->appendChild( $notched_outline );
					

	// 				$notched_outline->appendChild( $notched_outline_leading );
	// 				$notched_outline->appendChild( $notched_outline_notch );
	// 				$notched_outline->appendChild( $notched_outline_trailing );

	// 				// $label->setAttribute('class', $label->getAttribute( 'class' ) . $add_label_classes );
	// 				// $notched_outline_notch->appendChild( $label );
	// 			}
	// 			// $div->setAttribute( 'data-mdc-auto-init', 'MDCTextField' );

	// 			//get the first label
	// 			// $get_label = $dom->getElementsByTagName( 'label' )->item( 0 );

	// 			// $get_label->setAttribute( 'class', $get_label->getAttribute( 'class' ) . ' mdc-floating-label  mdc-floating-label--float-above' );
	// 			// //move label to be the last child of div
	// 			// $div->appendChild( $get_label );

	// 			//create a new div
    //             if ($type === 'filled') {
					
    //                 $bottom_line_div = $dom->createElement('span');
	// 				$bottom_line_div->setAttribute('class', 'mdc-line-ripple');
	// 				$div->appendChild( $select_icon );
    //                 $div->appendChild($bottom_line_div);
    //             }
	// 			//$content = utf8_decode($dom->saveHTML($dom->documentElement));
	// 		}
	// 	}

	// }

}
