<?php

/***************************************** for checkbox ****************************************************************************/

if ( in_array( $field->type, $checkbox_fields ) ) {
	// custom checkbox plugin is not enabled
	// if ( !isset( $material_options['checkbox-to-switch'] ) || $material_options['checkbox-to-switch'] === false  ) {

		$content_xpath = new DomXPath( $dom );

		$checkbox_containers = $content_xpath->query( "//*[contains(concat(' ', normalize-space(@class), ' '), ' ginput_container_checkbox ')]" );

		$field_labels = $content_xpath->query( "//*[contains(concat(' ', normalize-space(@class), ' '), ' gfield_label ')]" );
		// set class on field labels.
	foreach ( $field_labels as $field_label ) {
		$label_class = $field_label->getAttribute( 'class' );

		$field_label->setAttribute( 'class', $label_class . ' mdc-typography--subtitle1' );
	}

		$consent_field = $content_xpath->query( "//*[contains(concat(' ', normalize-space(@class), ' '), ' ginput_container_consent ')]" );

		$validation_errors      = $content_xpath->query( "//*[contains(concat(' ', normalize-space(@class), ' '), ' validation_message ')]" );
		$validation_error_class = '';
	if ( ! empty( $validation_errors->length ) ) { // contains error

		foreach ( $validation_errors as $validation_error ) {
			$validation_error->setAttribute( 'class', $validation_error->getAttribute( 'class' ) . ' mdc-text-field-helper-text mdc-text-field-helper-text--persistent mdc-text-field-helper-text--validation-msg' );

			// error present then set varialbe
			$validation_error_class = 'mdc-text-field--invalid';
		}

		foreach ( $checkbox_containers as $checkbox_field ) {
			$checkbox_field->setAttribute( 'class', $checkbox_field->getAttribute( 'class' ) . '  mdc-text-field--invalid' );
		}
	}



	if ( ! empty( $checkbox_containers->length ) ) { // checkbox field
		$choices = $content_xpath->query( "//*[contains(concat(' ', normalize-space(@class), ' '), ' gchoice ')]" );

		if ( $has_old_gf ) {
			$choice_containers = $content_xpath->query( "//*[contains(concat(' ', normalize-space(@class), ' '), ' gfield_checkbox ')]" );
			foreach ( $choice_containers as $choice_container ) {

				$choices = $choice_container->getElementsByTagName( 'li' );

			}
		}

		foreach ( $choices as $choice ) {
			$choice->setAttribute(
				'class',
				$choice->getAttribute( 'class' ) . ' mdc-form-field'
			);

					$outer_div = $dom->createElement( 'div' );
					$outer_div->setAttribute( 'class', 'mdc-checkbox' );
					$choice->appendChild( $outer_div );

					// $outer_div = $choice->lastChild;

					$input      = $choice->getElementsByTagName( 'input' )->item( 0 );
					$input_type = $input->getAttribute( 'type' );
			if ( $input_type === 'checkbox' ) {
				$input->setAttribute(
					'class',
					$input->getAttribute( 'class' ) . ' mdc-checkbox__native-control'
				);
			}
					$outer_div->appendChild( $input );
					$outer_background_div = $dom->createElement( 'div' );
					$outer_background_div->setAttribute( 'class', 'mdc-checkbox__background' );
					$outer_div->appendChild( $outer_background_div );

					// $outer_background_div = $choice->lastChild->lastChild;

					$ripple = $dom->createElement( 'div' );
					$ripple->setAttribute( 'class', 'mdc-checkbox__ripple' );
					$outer_div->appendChild( $ripple );


					$svg = $dom->createElement( 'svg' );
					$svg->setAttribute( 'class', 'mdc-checkbox__checkmark' );
					$svg->setAttribute( 'viewBox', '0 0 24 24' );

					$path = $dom->createElement( 'path' );
					$path->setAttribute( 'class', 'mdc-checkbox__checkmark-path' );
					$path->setAttribute( 'fill', 'none' );
					$path->setAttribute( 'stroke', 'white' );
					$path->setAttribute( 'd', 'M1.73,12.91 8.1,19.28 22.79,4.59' );

					$mixed_div = $dom->createElement( 'div' );
					$mixed_div->setAttribute( 'class', 'mdc-checkbox__mixedmark' );

					$outer_background_div->appendChild( $svg );

					$outer_background_div->appendChild( $mixed_div );

					$get_svg = $choice->getElementsByTagName( 'svg' )->item( 0 );
					$get_svg->appendChild( $path );

					$choice->appendChild( $choice->getElementsByTagName( 'label' )->item( 0 ) );
		}

		// Select all button ( gravity forms 2.5+)
		$select_all_buttons = $checkbox_containers[0]->getElementsByTagName( 'button' );

		foreach ( $select_all_buttons as $select_all_button ) {
			$ripple = $dom->createElement( 'span' );
			$ripple->setAttribute( 'class', 'mdc-button__ripple' );
			$select_all_button->appendChild( $ripple );

			$select_all_button->setAttribute(
				'class',
				$select_all_button->getAttribute( 'class' ) . ' mdc-button mdc-button--unelevated'
			);
		}
	}


		/**************************** Consent Field */

	if ( ! empty( $consent_field->length ) ) { // Consent field
		$field_labels = $content_xpath->query( "//*[contains(concat(' ', normalize-space(@class), ' '), ' gfield_label_before_complex ')]" );
		foreach ( $field_labels as $field_label ) {
			$field_label->setAttribute( 'class', $field_label->getAttribute( 'class' ) . ' stla_material_large' );
		}


		foreach ( $consent_field as $choice ) {

			$choice->setAttribute(
				'class',
				$choice->getAttribute( 'class' ) . ' mdc-form-field'
			);

			$outer_div = $dom->createElement( 'div' );
			$outer_div->setAttribute( 'class', 'mdc-checkbox' );
			$choice->appendChild( $outer_div );

			$inputs = $choice->getElementsByTagName( 'input' );

			foreach ( $inputs as $input ) {
				$input_type = $input->getAttribute( 'type' );
				if ( $input_type === 'checkbox' ) {
							$input->setAttribute(
								'class',
								$input->getAttribute( 'class' ) . ' mdc-checkbox__native-control'
							);
				}
				$outer_div->appendChild( $input );
			}

			$outer_background_div = $dom->createElement( 'div' );
			$outer_background_div->setAttribute( 'class', 'mdc-checkbox__background' );
			$outer_div->appendChild( $outer_background_div );

			$outer_background_div = $choice->lastChild->lastChild;

			$ripple = $dom->createElement( 'div' );
			$ripple->setAttribute( 'class', 'mdc-checkbox__ripple' );
			$outer_div->appendChild( $ripple );

			$svg = $dom->createElement( 'svg' );
			$svg->setAttribute( 'class', 'mdc-checkbox__checkmark' );
			$svg->setAttribute( 'viewBox', '0 0 24 24' );

			$path = $dom->createElement( 'path' );
			$path->setAttribute( 'class', 'mdc-checkbox__checkmark-path' );
			$path->setAttribute( 'fill', 'none' );
			$path->setAttribute( 'stroke', 'white' );
			$path->setAttribute( 'd', 'M1.73,12.91 8.1,19.28 22.79,4.59' );

			$mixed_div = $dom->createElement( 'div' );
			$mixed_div->setAttribute( 'class', 'mdc-checkbox__mixedmark' );

			$outer_background_div->appendChild( $svg );
			// $outer_background_div->appendChild( $path );
			$outer_background_div->appendChild( $mixed_div );

			$get_svg = $choice->getElementsByTagName( 'svg' )->item( 0 );
			$get_svg->appendChild( $path );

			$choice->appendChild( $choice->getElementsByTagName( 'label' )->item( 0 ) );
		}
	}
		$content = utf8_decode( $dom->saveHTML( $dom->documentElement ) );
	// }
}
