// Overwrite default gravity form 'select all and deselect all '

function gformToggleCheckboxes( toggleElement ) {
	
	var checked,
        $toggleElement = jQuery( toggleElement ),
        legacy         = $toggleElement.is( 'input[type="checkbox"]' ),
        $toggle        = legacy ? $toggleElement.closest('li'): $toggleElement.prev(),
	    $toggleLabel   = $toggle.find( 'label' ),
	    $checkboxes    = $toggle.parent().find( '.gchoice:not( .gchoice_select_all )' ),
	    formId         = gf_get_form_id_by_html_id( $toggle.parents( '.gfield' ).attr( 'id' ) ),
		calcObj        = rgars( window, 'gf_global/gfcalc/' + formId );

    // Determine checked state.
    if ( legacy ) {

	    $checkboxes    = $toggle.parent().find( 'li:not( .gchoice_select_all )' );
        checked = toggleElement.checked;
		
    } else {

        // Get checked data.
        var checkedData = $toggleElement.data( 'checked' );

        if ( typeof checkedData === 'boolean' ) {
            checked = !checkedData;
        } else {
            checked = !( parseInt( checkedData ) === 1 )
        }

    }

    // Set checkboxes state.
	$checkboxes.each( function() {

		// Set checkbox checked state.
		jQuery( 'input[type="checkbox"]', this ).prop( 'checked', checked ).trigger( 'change' );
        console.log(jQuery( 'input[type="checkbox"]', this ));

		// Execute onclick event.
		if ( typeof jQuery( 'input[type="checkbox"]', this )[0].onclick === 'function' ) {
			jQuery( 'input[type="checkbox"]', this )[0].onclick();
		}

	} );

	// Change toggle label, checked state.
    if ( legacy ) {

        $toggleLabel.html( checked ? $toggleLabel.data( 'label-deselect' ) : $toggleLabel.data( 'label-select' ) );

    } else {

        $toggleElement.html( checked ? $toggleElement.data( 'label-deselect' ) : $toggleElement.data( 'label-select' ) );
        $toggleElement.data( 'checked', checked );

    }

	if ( calcObj ) {
		calcObj.runCalcs( formId, calcObj.formulaFields );
	}

}

// setting the focus on other field input
function gformToggleRadioOther( radioElement ) {

    // Get Other input element.
    var $other = radioElement.parentElement.parentElement.parentElement.lastChild.querySelector( 'input[type="text"]' );
    if ( $other ) {
        $other.disabled = radioElement.value !== 'gf_other_choice';
        var otherInputContainer = jQuery($other).parent('.mdc-text-field');

        var field = mdc.textField.MDCTextField.attachTo(otherInputContainer[0]);
        field.focus();
    }

}