<?php

/***************************************** for checkbox ****************************************************************************/

if ( in_array( $field->type, $checkbox_fields ) ) {
	if (  isset( $material_options['checkbox-to-switch'] ) && $material_options['checkbox-to-switch'] === true  ) {
		
		$content_xpath = new DomXPath($dom);

		$checkbox_containers = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' ginput_container_checkbox ')]");

		$consent_field = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' ginput_container_consent ')]");

		$validation_errors = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' validation_message ')]");
		$validation_error_class = '';
		if( !empty( $validation_errors->length ) ) { // contains error

			foreach ( $validation_errors as $validation_error ) {
				$validation_error->setAttribute( 'class', $validation_error->getAttribute( 'class' ) . ' mdc-text-field-helper-text mdc-text-field-helper-text--persistent mdc-text-field-helper-text--validation-msg' );
	
				// error present then set varialbe
				$validation_error_class = 'mdc-text-field--invalid';
			}

			foreach( $checkbox_containers as $checkbox_field ) {
				$checkbox_field->setAttribute( 'class', $checkbox_field->getAttribute( 'class' ) . '  mdc-text-field--invalid' );
			}
		
		}

		if( ! empty( $checkbox_containers->length ) ) { 
			$choices = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' gchoice ')]");
			
			if( $has_old_gf ){
				$choice_containers = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' gfield_checkbox ')]");
				foreach( $choice_containers as $choice_container ){
					
					$choices = $choice_container->getElementsByTagName( 'li' );
	
				}
			}
			foreach( $choices as $choice ) {
				$switch_contianer = $dom->createElement( 'div' );
				$switch_contianer->setAttribute( 'class', 'mdc-switch' );
				$choice->appendChild( $switch_contianer );

				$switch_track = $dom->createElement( 'div' );
				$switch_track->setAttribute( 'class', 'mdc-switch__track' );
				$switch_contianer->appendChild( $switch_track );

				$switch_thumb_underlay = $dom->createElement( 'div' );
				$switch_thumb_underlay->setAttribute( 'class', 'mdc-switch__thumb-underlay' );
				$switch_contianer->appendChild( $switch_thumb_underlay );

				$switch_thumb = $dom->createElement( 'div' );
				$switch_thumb->setAttribute( 'class', 'mdc-switch__thumb' );
				$switch_thumb_underlay->appendChild( $switch_thumb );

				$inputs = $choice->getElementsByTagName( 'input' );
				foreach( $inputs as $input ){
					$input->setAttribute( 'class', $input->getAttribute( 'class' ) . ' mdc-switch__native-control' );
					$input->setAttribute( 'role', 'switch' );
					$switch_thumb_underlay->appendChild( $input );

				}

				$labels = $choice->getElementsByTagName( 'label' );
				foreach( $labels as $label ){
					$choice->appendChild( $label );
				}


			}

		}
		$content = utf8_decode( $dom->saveHTML( $dom->documentElement ) );
	}
}