<?php

/***************************************** for dropdown inputs *****************************************/


if ( in_array( $field->type, $select_fields ) && $field->enableEnhancedUI !== 1 ) {


	$content_xpath = new DomXPath($dom);

	$outer_divs = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' ginput_container_select ')]");

	$validation_errors = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' validation_message ')]");
	$validation_error_class = '';

	foreach ( $validation_errors as $validation_error ) {
		$validation_error->setAttribute( 'class', $validation_error->getAttribute( 'class' ) . ' mdc-text-field-helper-text mdc-text-field-helper-text--persistent mdc-text-field-helper-text--validation-msg' );

		// error present then set varialbe
		$validation_error_class = 'mdc-text-field--invalid';
	}

	foreach( $outer_divs as $outer_div ){
		$outer_div->setAttribute( 'data-mdc-auto-init', 'MDCTextField' );

		$labels = $dom->getElementsByTagName( 'label' );
			

		$selects = $outer_div->getElementsByTagName( 'select' );

		
		if( $type === 'filled' ){
			/******For Filled Input ******/

			$outer_div->setAttribute( 'class', $outer_div->getAttribute( 'class' ) . ' mdc-text-field mdc-text-field--filled '. $field_size_class. ' '. $validation_error_class  );

			//Ripple text.
			$text_ripple = $dom->createElement( 'div' );
			$text_ripple->setAttribute( 'class', 'mdc-text-field__ripple' );
			$outer_div->appendChild( $text_ripple );

			foreach( $selects as $select ){
				$select->setAttribute( 'class', $select->getAttribute( 'class' ) . ' mdc-text-field__input' );
				$outer_div->appendChild( $select );
			}
			
			// $outer_div->appendChild( $icon_container );

			stla_material_dropdown_svg_icon( $dom, $outer_div );

			
			foreach( $labels as $label ){
				$label->setAttribute( 'class', $label->getAttribute( 'class' ) . ' mdc-floating-label' );
				$outer_div->appendChild( $label );
			}

			//Line Ripple.
			$line_ripple = $dom->createElement( 'div' );
			$line_ripple->setAttribute( 'class', 'mdc-line-ripple' );
			$outer_div->appendChild( $line_ripple );

		} else{
			/******For Outline Input ******/
			$outer_div->setAttribute( 'class', $outer_div->getAttribute( 'class' ) . ' mdc-text-field mdc-text-field--outlined '. $field_size_class. ' '. $validation_error_class  );

			$notched_outline = $dom->createElement( 'div' );
			$notched_outline->setAttribute( 'class', 'mdc-notched-outline' );
			$outer_div->appendChild( $notched_outline );

			$outline__leading = $dom->createElement( 'div' );
			$outline__leading->setAttribute( 'class', 'mdc-notched-outline__leading' );
			$notched_outline->appendChild( $outline__leading );

			$outline_notch = $dom->createElement( 'div' );
			$outline_notch->setAttribute( 'class', 'mdc-notched-outline__notch' );
			$notched_outline->appendChild( $outline_notch );

			foreach( $labels as $label ){
				$label->setAttribute( 'class', $label->getAttribute( 'class' ) . ' mdc-floating-label' );
				$outline_notch->appendChild( $label );
			}

			$outline_trailing = $dom->createElement( 'div' );
			$outline_trailing->setAttribute( 'class', 'mdc-notched-outline__trailing' );
			$notched_outline->appendChild( $outline_trailing );

			foreach( $selects as $select ){
				$select->setAttribute( 'class', $select->getAttribute( 'class' ) . ' mdc-text-field__input' );
				$outer_div->appendChild( $select );
			}
			stla_material_dropdown_svg_icon( $dom, $outer_div );

			// $outer_div->appendChild( $icon_container );

			// $icon_container->appendChild( $svg );
		}
	}



	$is_valid_input_field = false;
	if ( $is_valid_input_field ) {
		//add class to input
		$get_selects = $dom->getElementsByTagName( 'select' );
		//var_dump($get_input->getAttribute('placeholder'));

		foreach ( $get_selects as $get_select ) {
			$select_classes = $get_select->getAttribute( 'class' );
			$select_id = $get_select->getAttribute( 'id' );
			$select_classes .=  ' mdc-select__native-control';
			if ( $contains_error ) {
				$select_classes .= ' mdc-text-field--invalid';
			}
			$get_select->setAttribute( 'class', $select_classes );
		}

		//find the size of field
		if ( strpos( $select_classes, 'large' ) !== false ) {
			$field_size_class = 'stla_material_large';
		}
		else if ( strpos( $select_classes, 'medium' ) !== false ) {
			$field_size_class = 'stla_material_medium';
		}
		else {
			$field_size_class = 'stla_material_small';
		}

		$container_classes = $div->getAttribute( 'class' ).' mdc-select '.$field_size_class;
		$container_classes .= $type === 'outlined' ? ' mdc-select--outlined':'';

		$div->setAttribute( 'class', $container_classes );
		// $div->setAttribute( 'data-mdc-auto-init', 'MDCTextField' );

		// $icon_element = $dom->createElement( 'i' );
		// $icon_element->setAttribute( 'class', 'mdc-notched-outline' );
		// $div->appendChild( $notched_outline );

		//get the first label
		$labels = $dom->getElementsByTagName( 'label' );

		foreach ( $labels as $label ) {
			$label_for = $label->getAttribute( 'for' );


			if ( $select_id === $label_for ) {
				$add_label_classes = ' mdc-floating-label';
				
				// if ( $contains_placeholder ) {
				// 	$add_label_classes .= ' mdc-floating-label--float-above';
				// }

				// outlined design
				if( $type === 'outlined' ) {
					

					$notched_outline = $dom->createElement( 'div' );
					$notched_outline->setAttribute( 'class', 'mdc-notched-outline' );

					$notched_outline_leading = $dom->createElement( 'div' );
					$notched_outline_leading->setAttribute( 'class', 'mdc-notched-outline__leading' );
					
					$notched_outline_notch = $dom->createElement( 'div' );
					$notched_outline_notch->setAttribute( 'class', 'mdc-notched-outline__notch' );

					$notched_outline_trailing = $dom->createElement( 'div' );
					$notched_outline_trailing->setAttribute( 'class', 'mdc-notched-outline__trailing' );
					
					// if ($contains_placeholder) {
						$notched_outline->setAttribute( 'class', 'mdc-notched-outline mdc-notched-outline--notched' );
					// }
					$div->appendChild( $notched_outline );
						$div->appendChild( $select_icon );
					$notched_outline->appendChild( $notched_outline_leading );
					$notched_outline->appendChild( $notched_outline_notch );
					$notched_outline->appendChild( $notched_outline_trailing );

					$label->setAttribute('class', $label->getAttribute( 'class' ) . $add_label_classes );
					$notched_outline_notch->appendChild( $label );

				}
				else { // Filled style
					$label->setAttribute( 'class', $label->getAttribute( 'class' ) . $add_label_classes );
					$div->appendChild( $label );
				}
			}
		}

		//create a new div
			if ( $type === 'filled' ) {
				$bottom_line_div = $dom->createElement( 'div' );
				$bottom_line_div->setAttribute( 'class', 'mdc-line-ripple' );
				$div->appendChild( $select_icon );
				$div->appendChild( $bottom_line_div );
			}

		// $label->setAttribute( 'class', $label->getAttribute( 'class' ) . ' mdc-floating-label  mdc-floating-label--float-above' );
		// //move label to be the last child of div
		// $div->appendChild( $label );

		// //create a new div
		// $bottom_line_div = $dom->createElement( 'div' );
		// $bottom_line_div->setAttribute( 'class', 'mdc-line-ripple' );
		// $div->appendChild( $bottom_line_div );
		
	}
	$content = utf8_decode( $dom->saveHTML( $dom->documentElement ) );
}



/***************************************** for time dropdown ****************************************************************************/

if ( $field->type === 'time' ) {

	$content_xpath = new DomXPath($dom);

	$outer_divs = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' gfield_time_ampm ')]");

	foreach( $outer_divs as $outer_div ){
		$outer_div->setAttribute( 'data-mdc-auto-init', 'MDCTextField' );

		$labels = $outer_div->getElementsByTagName( 'label' );
		

		$selects = $outer_div->getElementsByTagName( 'select' );
		

		if( $type === 'filled' ){
			/******For Filled Input ******/

			$outer_div->setAttribute( 'class', $outer_div->getAttribute( 'class' ) . ' mdc-text-field mdc-text-field--filled mdc-text-field--no-label' );

			//Ripple text.
			$text_ripple = $dom->createElement( 'div' );
			$text_ripple->setAttribute( 'class', 'mdc-text-field__ripple' );
			$outer_div->appendChild( $text_ripple );
			foreach( $selects as $select ){
				$select->setAttribute( 'class', $select->getAttribute( 'class' ) . ' mdc-text-field__input' );
				$outer_div->appendChild( $select );
			}

			stla_material_dropdown_svg_icon( $dom, $outer_div );

			foreach( $labels as $label ){
				$label->setAttribute( 'class', $label->getAttribute( 'class' ) . ' mdc-floating-label' );
				$outer_div->appendChild( $label );
			}

			//Line Ripple.
			$line_ripple = $dom->createElement( 'div' );
			$line_ripple->setAttribute( 'class', 'mdc-line-ripple' );
			$outer_div->appendChild( $line_ripple );

		} else{
			/******For Outline Input ******/
			$outer_div->setAttribute( 'class', $outer_div->getAttribute( 'class' ) . ' mdc-text-field mdc-text-field--outlined' );

			$notched_outline = $dom->createElement( 'div' );
			$notched_outline->setAttribute( 'class', 'mdc-notched-outline' );
			$outer_div->appendChild( $notched_outline );

			$outline__leading = $dom->createElement( 'div' );
			$outline__leading->setAttribute( 'class', 'mdc-notched-outline__leading' );
			$notched_outline->appendChild( $outline__leading );

			$outline_notch = $dom->createElement( 'div' );
			$outline_notch->setAttribute( 'class', 'mdc-notched-outline__notch' );
			$notched_outline->appendChild( $outline_notch );

			foreach( $labels as $label ){
				$label->setAttribute( 'class', $label->getAttribute( 'class' ) . ' mdc-floating-label' );
				$outline_notch->appendChild( $label );
			}

			$outline_trailing = $dom->createElement( 'div' );
			$outline_trailing->setAttribute( 'class', 'mdc-notched-outline__trailing' );
			$notched_outline->appendChild( $outline_trailing );

			foreach( $selects as $select ){
				$select->setAttribute( 'class', $select->getAttribute( 'class' ) . ' mdc-text-field__input' );
				$outer_div->appendChild( $select );
			}

			stla_material_dropdown_svg_icon( $dom, $outer_div );
		}
	}
	
	
	$content = utf8_decode( $dom->saveHTML( $dom->documentElement ) );
}

/***************************************** for address dropdown inputs ****************************************************************************/
if ( $field->type == 'address' ) {
	$allowed_address_fields = array( 'address_country', 'address_state' );
	$get_spans = $dom->getElementsByTagName( 'span' );
	$contains_error = false;
	foreach ( $get_spans as $get_span ) {
		$address_classes = $get_span->getAttribute( 'class' );
		$address_classes_array = explode( ' ', $address_classes );
		$is_allowed_field = false;
		foreach ( $address_classes_array as $address_class ) {
			if ( in_array( $address_class, $allowed_address_fields ) ) {
				$is_allowed_field = true;
			}
		}
		$get_selects = $get_span->getElementsByTagName( 'select' );
			
		if ( $is_allowed_field && count( $get_selects )) {
			$get_span->setAttribute( 'data-mdc-auto-init', 'MDCTextField' );
			$labels = $get_span->getElementsByTagName( 'label' );
			$selects = $get_span->getElementsByTagName( 'select' );

			if( $type === 'filled' ){
				$get_span->setAttribute( 'class', $get_span->getAttribute( 'class' ) . ' mdc-text-field mdc-text-field--filled stla_complex_field_dropdown' );

				//Ripple text.
				$text_ripple = $dom->createElement( 'div' );
				$text_ripple->setAttribute( 'class', 'mdc-text-field__ripple' );
				$get_span->appendChild( $text_ripple );

				stla_material_field_icon( $get_span, $dom );
				foreach( $selects as $select ){
					$select->setAttribute( 'class', $select->getAttribute( 'class' ) . ' mdc-text-field__input' );
					$get_span->appendChild( $select );
				}
				stla_material_dropdown_svg_icon( $dom, $get_span );
				foreach( $labels as $label ){
					$label->setAttribute( 'class', $label->getAttribute( 'class' ) . ' mdc-floating-label' );
					$get_span->appendChild( $label );
				}
	
				//Line Ripple.
				$line_ripple = $dom->createElement( 'div' );
				$line_ripple->setAttribute( 'class', 'mdc-line-ripple' );
				$get_span->appendChild( $line_ripple );
			} else{

				/******For Outline Input ******/
				$get_span->setAttribute( 'class', $get_span->getAttribute( 'class' ) . ' mdc-text-field mdc-text-field--outlined stla_complex_field_dropdown' );

				$notched_outline = $dom->createElement( 'div' );
				$notched_outline->setAttribute( 'class', 'mdc-notched-outline' );
				$get_span->appendChild( $notched_outline );
	
				$outline__leading = $dom->createElement( 'div' );
				$outline__leading->setAttribute( 'class', 'mdc-notched-outline__leading' );
				$notched_outline->appendChild( $outline__leading );
	
				$outline_notch = $dom->createElement( 'div' );
				$outline_notch->setAttribute( 'class', 'mdc-notched-outline__notch' );
				$notched_outline->appendChild( $outline_notch );

				foreach( $labels as $label ){
					$label->setAttribute( 'class', $label->getAttribute( 'class' ) . ' mdc-floating-label' );
					$outline_notch->appendChild( $label );
				}

				$outline_trailing = $dom->createElement( 'div' );
				$outline_trailing->setAttribute( 'class', 'mdc-notched-outline__trailing' );
				$notched_outline->appendChild( $outline_trailing );

				stla_material_field_icon( $get_span, $dom );
				foreach( $selects as $select ){
					$select->setAttribute( 'class', $select->getAttribute( 'class' ) . ' mdc-text-field__input' );
					$get_span->appendChild( $select );
				}
				stla_material_dropdown_svg_icon( $dom, $get_span );

			}
		}
	}
	$content = utf8_decode( $dom->saveHTML( $dom->documentElement ) );
}


/***************************************** for name prefix dropdown  ****************************************************************************/

if ( $field->type === 'name' ) {
	$get_spans = $dom->getElementsByTagName( 'span' );
	foreach ( $get_spans as $get_span ) {
		$span_classes = $get_span->getAttribute( 'class' );
		if ( strpos( $span_classes, 'name_prefix_select' ) !== false ) {
			$get_span->setAttribute( 'data-mdc-auto-init', 'MDCTextField' );
			$labels = $get_span->getElementsByTagName( 'label' );
			$selects = $get_span->getElementsByTagName( 'select' );
			if( $type === 'filled' ){
				$get_span->setAttribute( 'class', $get_span->getAttribute( 'class' ) . ' mdc-text-field mdc-text-field--filled' );

				//Ripple text.
				$text_ripple = $dom->createElement( 'div' );
				$text_ripple->setAttribute( 'class', 'mdc-text-field__ripple' );
				$get_span->appendChild( $text_ripple );

				foreach( $selects as $select ){
					$select->setAttribute( 'class', $select->getAttribute( 'class' ) . ' mdc-text-field__input' );
					$get_span->appendChild( $select );
				}
				stla_material_dropdown_svg_icon( $dom, $get_span );

				foreach( $labels as $label ){
					$label->setAttribute( 'class', $label->getAttribute( 'class' ) . ' mdc-floating-label' );
					$get_span->appendChild( $label );
				}
	
				//Line Ripple.
				$line_ripple = $dom->createElement( 'div' );
				$line_ripple->setAttribute( 'class', 'mdc-line-ripple' );
				$get_span->appendChild( $line_ripple );
			}else{
				/******For Outline Input ******/
				$get_span->setAttribute( 'class', $get_span->getAttribute( 'class' ) . ' mdc-text-field mdc-text-field--outlined' );

				$notched_outline = $dom->createElement( 'div' );
				$notched_outline->setAttribute( 'class', 'mdc-notched-outline' );
				$get_span->appendChild( $notched_outline );
	
				$outline__leading = $dom->createElement( 'div' );
				$outline__leading->setAttribute( 'class', 'mdc-notched-outline__leading' );
				$notched_outline->appendChild( $outline__leading );
	
				$outline_notch = $dom->createElement( 'div' );
				$outline_notch->setAttribute( 'class', 'mdc-notched-outline__notch' );
				$notched_outline->appendChild( $outline_notch );

				foreach( $labels as $label ){
					$label->setAttribute( 'class', $label->getAttribute( 'class' ) . ' mdc-floating-label' );
					$outline_notch->appendChild( $label );
				}

				$outline_trailing = $dom->createElement( 'div' );
				$outline_trailing->setAttribute( 'class', 'mdc-notched-outline__trailing' );
				$notched_outline->appendChild( $outline_trailing );

				foreach( $selects as $select ){
					$select->setAttribute( 'class', $select->getAttribute( 'class' ) . ' mdc-text-field__input' );
					$get_span->appendChild( $select );
				}
				stla_material_dropdown_svg_icon( $dom, $get_span );
			}
		}
	}
	$content = utf8_decode( $dom->saveHTML( $dom->documentElement ) );
}

