<?php
if ( $field->type === 'creditcard'  ) { 

	$content_xpath = new DomXPath($dom);

	$credit_card = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' ginput_complex ')]");

	$validation_errors = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' validation_message ')]");
	$validation_error_class = '';


	foreach ( $validation_errors as $validation_error ) {
		$validation_error->setAttribute( 'class', $validation_error->getAttribute( 'class' ) . ' mdc-text-field-helper-text mdc-text-field-helper-text--persistent mdc-text-field-helper-text--validation-msg' );

		// error present then set varialbe
		$validation_error_class = 'mdc-text-field--invalid';
	}

	//check if error is present
	// $all_divs = $dom->getElementsByTagName( 'div' );
	$get_spans = $dom->getElementsByTagName( 'span' );

	// Complex field only then process it.. ( added because of confirm email )
	if ( !empty( $credit_card->length )  ) {

		foreach ( $get_spans as $span ) {
			$span_classes = $span->getAttribute( 'class' );
				// var_dump($span); 
			// if( $type === 'filled' ){

				if ( strpos( $span_classes, 'ginput_cardextras' ) === false && strpos( $span_classes, 'ginput_full' ) !== false ) {
					$text_field = $dom->createElement( 'div' );
					$text_field->setAttribute( 'style', 'width: 100%;' );
					$span->appendChild( $text_field );

					$inputs = $span->getElementsByTagName( 'input' );
					$labels = $span->getElementsByTagName( 'label' );

					if( $type === 'filled' ){
		
						$text_field->setAttribute( 'class', $text_field->getAttribute( 'class' ) .' mdc-text-field mdc-text-field--filled ' . $validation_error_class );
		
						// $text_field->setAttribute( 'style', 'width: 100%;' );
		
						$text_ripple = $dom->createElement( 'div' );
						$text_ripple->setAttribute( 'class', 'mdc-text-field__ripple' );
						$text_field->appendChild( $text_ripple );
		
						foreach( $labels as $label ){
							$label->setAttribute( 'class', $label->getAttribute( 'class' ) . ' mdc-floating-label' );
							$text_field->appendChild( $label );
						}
		
						foreach( $inputs as $input ){
							$input->setAttribute( 'class', $input->getAttribute( 'class' ) . ' mdc-text-field__input' );
							$text_field->appendChild( $input );
						}
		
						$field_ripple = $dom->createElement( 'div' );
						$field_ripple->setAttribute( 'class', 'mdc-line-ripple' );
						$text_field->appendChild( $field_ripple );
					} else{
						/******For outline Input ******/

						$text_field->setAttribute( 'class', $text_field->getAttribute( 'class' ) .' mdc-text-field mdc-text-field--outlined ' . $validation_error_class );

						$notched_outline = $dom->createElement( 'div' );
						$notched_outline->setAttribute( 'class', 'mdc-notched-outline' );
						$text_field->appendChild( $notched_outline );

						$outline__leading = $dom->createElement( 'div' );
						$outline__leading->setAttribute( 'class', 'mdc-notched-outline__leading' );
						$notched_outline->appendChild( $outline__leading );

						$outline_notch = $dom->createElement( 'div' );
						$outline_notch->setAttribute( 'class', 'mdc-notched-outline__notch' );
						$notched_outline->appendChild( $outline_notch );

						foreach( $labels as $label ){
							$label->setAttribute( 'class', $label->getAttribute( 'class' ) . ' mdc-floating-label' );
							$outline_notch->appendChild( $label );
						}

						$outline_trailing = $dom->createElement( 'div' );
						$outline_trailing->setAttribute( 'class', 'mdc-notched-outline__trailing' );
						$notched_outline->appendChild( $outline_trailing );

						foreach( $inputs as $input ){
							$input->setAttribute( 'class', $input->getAttribute( 'class' ) . ' mdc-text-field__input' );
							$text_field->appendChild( $input );
						}
					}
				}

				if(strpos( $span_classes, 'ginput_cardextras' ) !== false && strpos( $span_classes, 'ginput_full' ) !== false){

					$card_expiration_containers = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' ginput_card_expiration_container ')]");

					foreach( $card_expiration_containers as $card_expiration_container ){

						// comparing gf version with old version
						$gf_version_info = GFForms::$version;
						$has_old_gf = version_compare( $gf_version_info, '2.5', '<' );

						$selects = $card_expiration_container->getElementsByTagName( 'select' );

						$select_count = count( $selects );

						$outer_divs = $card_expiration_container->getElementsByTagName( 'span' );

						for( $i=$select_count-1; $i>=0; $i--){
							if ( ( isset( $form['markupVersion']) && $form['markupVersion'] === 2 ) && ! $has_old_gf ) {

								$outer_div = $outer_divs[$i];
							} else{
								
								$outer_div = $dom->createElement( 'div' );
								$card_expiration_container->appendChild( $outer_div );

							}

							if( $type === 'filled' ){
	
								$outer_div->setAttribute( 'class', $outer_div->getAttribute( 'class' ) . ' mdc-text-field mdc-text-field--filled '. $field_size_class. ' '. $validation_error_class  );
	
								//Ripple text.
								$text_ripple = $dom->createElement( 'div' );
								$text_ripple->setAttribute( 'class', 'mdc-text-field__ripple' );
								$outer_div->appendChild( $text_ripple );
	
								$selects[$i]->setAttribute( 'class', $selects[$i]->getAttribute( 'class' ) . ' mdc-text-field__input' );
								$outer_div->appendChild( $selects[$i] );
					
								//Line Ripple.
								$line_ripple = $dom->createElement( 'div' );
								$line_ripple->setAttribute( 'class', 'mdc-line-ripple' );
								$outer_div->appendChild( $line_ripple );

							} else{

								$outer_div->setAttribute( 'class', $outer_div->getAttribute( 'class' ) . ' mdc-text-field mdc-text-field--outlined ' . $validation_error_class );

								$notched_outline = $dom->createElement( 'div' );
								$notched_outline->setAttribute( 'class', 'mdc-notched-outline' );
								$outer_div->appendChild( $notched_outline );

								$outline__leading = $dom->createElement( 'div' );
								$outline__leading->setAttribute( 'class', 'mdc-notched-outline__leading' );
								$notched_outline->appendChild( $outline__leading );

								$outline_notch = $dom->createElement( 'div' );
								$outline_notch->setAttribute( 'class', 'mdc-notched-outline__notch' );
								$notched_outline->appendChild( $outline_notch );

								$outline_trailing = $dom->createElement( 'div' );
								$outline_trailing->setAttribute( 'class', 'mdc-notched-outline__trailing' );
								$notched_outline->appendChild( $outline_trailing );

								$selects[$i]->setAttribute( 'class', $selects[$i]->getAttribute( 'class' ) . ' mdc-text-field__input' );
								$outer_div->appendChild( $selects[$i] );
							}
							if( $i === 0 ){
								if(( isset( $form['markupVersion']) && $form['markupVersion'] === 1 ) || $has_old_gf){
									$get_div = $selects[$i]->parentNode;
									$card_expiration_container->appendChild($get_div);
								}
							}
						}


						$card_left_info_containers = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' ginput_cardinfo_left')]");
						
						foreach( $card_left_info_containers as $card_left_info_container ){

							$labels = $card_left_info_container->getElementsByTagName('label');

							$outer_helper_div = $dom->createElement( 'div' );
							$outer_helper_div->setAttribute( 'class', 'mdc-text-field-helper-line' );
							$card_left_info_container->appendChild( $outer_helper_div );

							foreach($labels as $label){
								$label->setAttribute( 'class', $label->getAttribute('class') . ' mdc-text-field-helper-text mdc-text-field-helper-text--persistent'  );
								$outer_helper_div->appendChild( $label );
							}

						}
					

					}
					
					$security_code_containers = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' ginput_cardinfo_right ')]");

					$security_code_icons = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' ginput_card_security_code_icon ')]");

					foreach( $security_code_containers as $security_code_container ){

						$inputs = $security_code_container->getElementsByTagName( 'input' );
						$labels = $security_code_container->getElementsByTagName( 'label' );

						

						if( $type === 'filled' ){

							$security_code_container->setAttribute( 'class', $security_code_container->getAttribute( 'class' ) .' mdc-text-field mdc-text-field--filled mdc-text-field--with-trailing-icon' . $validation_error_class );

							$text_ripple = $dom->createElement( 'div' );
							$security_code_container->appendChild( $text_ripple );
							$text_ripple->setAttribute( 'class', 'mdc-text-field__ripple' );

							foreach( $labels as $label ){
								$label->setAttribute( 'class', $label->getAttribute( 'class' ) . ' mdc-floating-label' );
								$security_code_container->appendChild( $label );
							}
			
							foreach( $inputs as $input ){
								$input->setAttribute( 'class', $input->getAttribute( 'class' ) . ' mdc-text-field__input' );
								$security_code_container->appendChild( $input );
							}

							foreach( $security_code_icons as $security_code_icon ){
								$security_code_icon->setAttribute( 'class', $security_code_icon->getAttribute( 'class' ) . ' mdc-text-field__icon mdc-text-field__icon--trailing' );
								$security_code_container->appendChild( $security_code_icon );
								// mdc-text-field__icon mdc-text-field__icon--trailing
							}
			
							$field_ripple = $dom->createElement( 'div' );
							$field_ripple->setAttribute( 'class', 'mdc-line-ripple' );
							$security_code_container->appendChild( $field_ripple );
						} else{

							$security_code_container->setAttribute( 'class', $security_code_container->getAttribute( 'class' ) .' mdc-text-field mdc-text-field--outlined mdc-text-field--with-trailing-icon' . $validation_error_class );

							$notched_outline = $dom->createElement( 'div' );
							$notched_outline->setAttribute( 'class', 'mdc-notched-outline' );
							$security_code_container->appendChild( $notched_outline );

							$outline__leading = $dom->createElement( 'div' );
							$outline__leading->setAttribute( 'class', 'mdc-notched-outline__leading' );
							$notched_outline->appendChild( $outline__leading );

							$outline_notch = $dom->createElement( 'div' );
							$outline_notch->setAttribute( 'class', 'mdc-notched-outline__notch' );
							$notched_outline->appendChild( $outline_notch );

							foreach( $labels as $label ){
								$label->setAttribute( 'class', $label->getAttribute( 'class' ) . ' mdc-floating-label' );
								$outline_notch->appendChild( $label );
							}

							$outline_trailing = $dom->createElement( 'div' );
							$outline_trailing->setAttribute( 'class', 'mdc-notched-outline__trailing' );
							$notched_outline->appendChild( $outline_trailing );

							foreach( $inputs as $input ){
								$input->setAttribute( 'class', $input->getAttribute( 'class' ) . ' mdc-text-field__input' );
								$security_code_container->appendChild( $input );
							}

							foreach( $security_code_icons as $security_code_icon ){
								$security_code_icon->setAttribute( 'class', $security_code_icon->getAttribute( 'class' ) . ' mdc-text-field__icon mdc-text-field__icon--trailing' );
								$security_code_container->appendChild( $security_code_icon );
								// mdc-text-field__icon mdc-text-field__icon--trailing
							}
						}
					}
					
				}
				

			// }
			
		}

	}


	$content = utf8_decode( $dom->saveHTML( $dom->documentElement ) );
}