<?php
/***************************************** for complex fields like address and name *************************************/

if ( in_array( $field->type, $complex_fields ) ) {

	$content_xpath = new DomXPath($dom);

	$complex_field = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' ginput_complex ')]");

	$validation_errors = $content_xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' validation_message ')]");
	$validation_error_class = '';


	foreach ( $validation_errors as $validation_error ) {
		$validation_error->setAttribute( 'class', $validation_error->getAttribute( 'class' ) . ' mdc-text-field-helper-text mdc-text-field-helper-text--persistent mdc-text-field-helper-text--validation-msg' );

		// error present then set varialbe
		$validation_error_class = 'mdc-text-field--invalid';
	}

	//check if error is present
	$all_divs = $dom->getElementsByTagName( 'div' );
	$get_spans = $dom->getElementsByTagName( 'span' );

	// Complex field only then process it.. ( added because of confirm email )
	if ( !empty( $complex_field->length )  ) {
		// Add classes to the main field label
		$labels = $dom->getElementsByTagName('label');

		// Loop inside all the spans
		foreach ( $get_spans as $input_element ) {
			$span_classes = $input_element->getAttribute( 'class' );
			// Only modify fields if first, middle , last name or address field except for country selection
			if ( strpos( $span_classes, 'name_' ) !== false || strpos( $span_classes, 'address_' ) !== false  ) {
				$inputs = $input_element->getElementsByTagName( 'input' );
			
				if ( strpos( $span_classes, 'address_country' ) === false && count( $inputs ) ) {
					$input_element->setAttribute( 'data-mdc-auto-init', 'MDCTextField' );
					$labels = $input_element->getElementsByTagName( 'label' );

					if( $type === 'filled' ){
						$input_element->setAttribute( 'class', $input_element->getAttribute( 'class' ) .' mdc-text-field mdc-text-field--filled ' . $validation_error_class );

						$text_ripple = $dom->createElement( 'div' );
						$text_ripple->setAttribute( 'class', 'mdc-text-field__ripple' );
						$input_element->appendChild( $text_ripple );
						foreach( $labels as $label ){
							$label->setAttribute( 'class', $label->getAttribute( 'class' ) . ' mdc-floating-label' );
							$input_element->appendChild( $label );
						}
						// adding field icon tag in material element
						stla_material_field_icon( $input_element, $dom );
						foreach( $inputs as $input ){
							$input->setAttribute( 'class', $input->getAttribute( 'class' ) . ' mdc-text-field__input' );
							$input_element->appendChild( $input );
						}
						$field_ripple = $dom->createElement( 'div' );
						$field_ripple->setAttribute( 'class', 'mdc-line-ripple' );
						$input_element->appendChild( $field_ripple );
					}else{
						/******For outline Input ******/
						$input_element->setAttribute( 'class', $input_element->getAttribute( 'class' ) . ' mdc-text-field mdc-text-field--outlined ' . $validation_error_class );

						$notched_outline = $dom->createElement( 'div' );
						$notched_outline->setAttribute( 'class', 'mdc-notched-outline' );
						$input_element->appendChild( $notched_outline );

						$outline__leading = $dom->createElement( 'div' );
						$outline__leading->setAttribute( 'class', 'mdc-notched-outline__leading' );
						$notched_outline->appendChild( $outline__leading );

						$outline_notch = $dom->createElement( 'div' );
						$outline_notch->setAttribute( 'class', 'mdc-notched-outline__notch' );
						$notched_outline->appendChild( $outline_notch );
						
						foreach( $labels as $label ){
							$label->setAttribute( 'class', $label->getAttribute( 'class' ) . ' mdc-floating-label' );
							$outline_notch->appendChild( $label );
						}
						
						$outline_trailing = $dom->createElement( 'div' );
						$outline_trailing->setAttribute( 'class', 'mdc-notched-outline__trailing' );
						$notched_outline->appendChild( $outline_trailing );
						
						// adding field icon tag in material element
						stla_material_field_icon( $input_element, $dom );

						foreach( $inputs as $input ){
							$input->setAttribute( 'class', $input->getAttribute( 'class' ) . ' mdc-text-field__input' );
							$input_element->appendChild( $input );
						}

					}

					$container_classes = $input_element->getAttribute('class');

					if( strpos( $container_classes, 'stla-fontawesome') !== false ){
						$input_element->setAttribute( 'class', $container_classes . ' mdc-text-field--with-leading-icon' );
					}

				}
			}
		}
	}


	$content = utf8_decode( $dom->saveHTML( $dom->documentElement ) );
}
