<?php
global $SEOAIC;

$progress_colors = '
<ul class="progress-colors">
    <li class="green">' . esc_html__('90-100', 'seoaic') . '</li>
    <li class="yellow">' . esc_html__('50-89', 'seoaic') . '</li>
    <li class="red">' . esc_html__('0-49', 'seoaic') . '</li>
</ul>';
$charts = ['performance', 'accessibility', 'best_practices', 'seo'];
$prefixes = ['mobile' => 'mobile', 'desktop' => 'desktop'];
?>

<div class="tab-content" data-tab-list="page-speed-analysis">
    <div class="page-speed-analysis-section">
        <div class="col col-3-4 waiting-for-analysis-speed-data">
            <div class="loader-ellipsis small position-absolute"></div>
            <div class="top-tabs" id="seoaic_tabs_speed_device">
                <label for="seoaic_tab_collapse_mobile" class="mini-tab mb-0 active">
                    <span class="mobile"><?php esc_html_e('Mobile', 'seoaic'); ?></span>
                </label>
                <label for="seoaic_tab_collapse_desktop" class="mini-tab mb-0">
                    <span class="desktop"><?php esc_html_e('Desktop', 'seoaic'); ?></span>
                </label>
            </div>

            <?php foreach ($prefixes as $key => $prefix): ?>
                <input type="radio" name="seoaic_checked_minitab" id="seoaic_tab_collapse_<?php echo esc_attr($key); ?>" <?php echo $key === 'mobile' ? 'checked' : ''; ?>>
                <div id="seoaic_analysis_metrics_<?php echo esc_attr($prefix); ?>" class="analysis">
                    <div class="title-section">
                        <h3><?php echo $key === 'mobile' ? esc_html__('Mobile Core Metrics', 'seoaic') : esc_html__('Desktop Core Metrics', 'seoaic'); ?></h3>
                    </div>
                    <div class="seoaic-top-charts-audit">
                        <?php
                        foreach ($charts as $chart): ?>
                            <div class="<?php echo esc_attr($chart); ?>-chart" data-scroll-to=".<?php echo esc_attr($chart) . '_' . esc_attr($prefix); ?>">
                                <div class="chart" id="seoaic_chart_speed_<?php echo esc_attr($chart) . '_' . esc_attr($prefix); ?>"></div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <div id="seoaic-sticky-trigger"></div>
                    <div class="seoaic-top-charts-labels">
                        <?php
                        $charts = ['performance', 'accessibility', 'best_practices', 'seo'];
                        foreach ($charts as $chart): ?>
                            <div class="label-chart <?php echo esc_attr($chart); ?>-chart-label" data-scroll-to=".<?php echo esc_attr($chart) . '_' . esc_attr($prefix); ?>">
                                <span><?php esc_html_e(ucfirst($chart), 'seoaic'); ?></span>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <div class="content-section performance_<?php echo esc_attr($prefix); ?>">
                        <div class="charts-body performance-data_<?php echo esc_attr($prefix); ?>">
                            <div class="chart-preview">
                                <div class="performance-large-chart">
                                    <div class="chart" id="seoaic_chart_speed_performance_preview_<?php echo esc_attr($prefix); ?>"></div>
                                    <?php echo $progress_colors; ?>
                                </div>
                            </div>
                            <div class="interactive-preview">
                                <div class="small"><?php esc_html_e('Time To Interactive', 'seoaic'); ?></div>
                                <div id="seoaic_time-to-interactive-value_<?php echo esc_attr($prefix); ?>" class="large"></div>
                            </div>
                            <div class="screen-preview">
                                <img id="seoaic_page_score_final-screenshot_<?php echo esc_attr($prefix); ?>" src="#" alt="screen">
                            </div>
                        </div>
                    </div>
                    <div class="title-section">
                        <h3><?php esc_html_e('Detailed performance', 'seoaic'); ?></h3>
                    </div>
                    <div class="content-section">
                        <div id="seoaic_performance_details_<?php echo esc_attr($prefix); ?>" class="analysis-details-section"></div>
                    </div>
                    <?php foreach ($charts as $chart): if($chart === 'performance') continue; ?>
                        <div class="content-section <?php echo esc_attr($chart) . '_' . esc_attr($prefix); ?> seoaic-mt-30">
                            <div class="charts-body">
                                <div class="chart-preview">
                                    <div class="performance-large-chart">
                                        <div class="chart" id="seoaic_chart_speed_<?php echo esc_attr($chart) . '_preview_' . esc_attr($prefix); ?>"></div>
                                        <?php echo $progress_colors; ?>
                                    </div>
                                </div>
                                <div class="interactive-preview">
                                    <div class="small"><?php esc_html_e(ucfirst($chart), 'seoaic'); ?></div>
                                </div>
                            </div>
                        </div>
                        <div class="content-section">
                            <div id="seoaic_<?php echo esc_attr($chart); ?>_details_<?php echo esc_attr($prefix); ?>" class="analysis-details-section"></div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endforeach; ?>
        </div>
        <div class="col col-1-4">
            <div class="inner">
                <div class="top mb-0">
                    <a class="rescan-page-speed" href="#"><?php esc_html_e('Create new audit', 'seoaic'); ?></a>
                </div>
                <div class="content-section">
                    <label for="seoaic_select_url"><?php esc_html_e('URL / Domain', 'seoaic'); ?></label>
                    <select id="seoaic_select_url" data-offset="0" data-limit="5">
                        <?php $home = $SEOAIC->audit_data->get_all_site_links(0, 1, true, true); ?>
                        <option value="<?php esc_attr_e($home['id']);?>" data-url="<?php esc_attr_e($home['url']);?>"><?php esc_attr_e($home['text']);?></option>
                    </select>
                    <label for="seoaic_history_analysis"><?php esc_html_e('History Analyze', 'seoaic'); ?></label>
                    <ul id="seoaic_analysis_dates_available" class="history_dates position-relative"></ul>
                </div>
            </div>
        </div>
    </div>
</div>