<?php
if (!current_user_can('seoaic_edit_plugin')) {
    return;
}

if (isset($_GET['settings-updated'])) {
    add_settings_error('seoaic_messages', 'seoaic_message', esc_html__('Settings Saved', 'mdsf'), 'updated');
}

global $SEOAIC, $SEOAIC_OPTIONS;
?>

<div id="seoaic-admin-container" class="wrap">
    <h1 class="hidden-notice-title" style="display: none"></h1>
    <h3 id="seoaic-admin-title">
        <?php
        echo wp_kses(seoai_get_logo('logo.svg'), [
            'img' => [
                'title' => [],
                'src'	=> [],
                'alt'	=> [],
            ],
        ]);
        ?>
        <span>
            <?php echo esc_html(get_admin_page_title()); ?>
        </span>
    </h3>
    <div id="seoaic-admin-body" class="seoaic-streamlined-onboarding seoaic-with-loader wizard bg-wizard" data-admin-url="<?php echo esc_url(admin_url()); ?>">
        <div class="inner">
            <div id="seoaic-streamlined-onboarding" class="content">
                <?php
                $step = isset($_GET['step']) && intval($_GET['step']) > 0 ? intval($_GET['step']) : 1;
                echo $SEOAIC->onboarding->run_streamline_onboarding($step);
                ?>
            </div>
        </div>
        <div class="lds-dual-ring"></div>
        <div id="seoiac_settings_saved_notice"><?php esc_html_e('Saved', 'seoaic')?></div>
    </div>
</div>