<?php

use SEOAIC\helpers\HTMLBuilers;
use SEOAIC\SEOAIC;
use SEOAIC\SEOAIC_SETTINGS;

if (!current_user_can('seoaic_edit_plugin')) {
    return;
}

$isBlockTheme = function_exists('wp_is_block_theme') && wp_is_block_theme();

if (!$isBlockTheme) {
    add_settings_error('seoaic_messages', 'seoaic_message', esc_html__('Current theme does not support FSE editing', 'seoaic'));
}

if (isset($_GET['settings-updated'])) {
    add_settings_error('seoaic_messages', 'seoaic_message', esc_html__('Settings Saved', 'seoaic'), 'updated');
}

settings_errors('seoaic_messages');

global $SEOAIC, $SEOAIC_OPTIONS;

$locations = $SEOAIC_OPTIONS['seoaic_locations'] ?? [];

$loc = '';
foreach ((array)$locations as $s) {
    $loc .= '<div class="item">
                <input type="text" class="form-input light location-input" name="location-input" value="' . esc_attr($s) . '" required readonly/>
                <a href="#" class="delete delete-location" title="' . esc_html__('Remove', 'seoaic') . '"></a>
             </div>';
}

$languages = seoaic_get_languages();
$selected_language = !empty($SEOAIC_OPTIONS['seoaic_language']) ? $SEOAIC_OPTIONS['seoaic_language'] : 'English';

/*$writing_styles = seoaic_get_writing_styles();
$selected_writing_style = !empty($SEOAIC_OPTIONS['seoaic_writing_style']) ? $SEOAIC_OPTIONS['seoaic_writing_style'] : 'Default';*/

$locations = seoaic_get_locations();
$selected_location = !empty($SEOAIC_OPTIONS['seoaic_location']) ? $SEOAIC_OPTIONS['seoaic_location'] : 'United States';

$image_generator_default = !empty($SEOAIC_OPTIONS['seoaic_image_generator']) ? $SEOAIC_OPTIONS['seoaic_image_generator'] : 'no_image';
$image_generators = seoaic_get_image_generators();

$post_types = seoaic_get_post_types();
$selected_post_type = !empty($SEOAIC_OPTIONS['seoaic_post_type']) ? $SEOAIC_OPTIONS['seoaic_post_type'] : 'post';
$exclude_taxonomies = seoaic_get_taxonomies_checkboxes();

$postTemplates = get_page_templates(null, $selected_post_type);
$selectedPostTemplate = !empty($SEOAIC_OPTIONS['seoaic_post_template']) ? $SEOAIC_OPTIONS['seoaic_post_template'] : '';
$selectedPostAuthor = !empty($SEOAIC_OPTIONS['seoaic_post_author']) ? trim($SEOAIC_OPTIONS['seoaic_post_author']) : [];

$categories = seoaic_get_categories($selected_post_type);

$image_styles = [
    'default' => 'Default'
];

$colors = [
    '#d62828' => '#d62828',
    '#ff99c8' => '#ff99c8',
    '#3a86ff' => '#3a86ff',
    '#ffc300' => '#ffc300',
    '#03045e' => '#03045e',
    '#6c584c' => '#6c584c',
    '#00bbf9' => '#00bbf9',
    '#415a77' => '#415a77',
    '#7b2cbf' => '#7b2cbf',
    '#fdf0d5' => '#fdf0d5',
    '#38b000' => '#38b000',
    '#b23a48' => '#b23a48'
];

$createdPostsQuery = new WP_Query([
    'posts_per_page'    => -1,
    'post_type'         => 'post',
    'meta_key'          => 'seoaic_posted',
    'meta_value'        => '1',
    'lang'              => '',
]);

$defaultScheduleChecked = !isset($SEOAIC_OPTIONS['seoaic_schedule_days']) ? 'checked' : '';

$isVerifiedGSC = $SEOAIC->content_improvement->checkIntegratedSiteWithGoogle();
$cptSsettings = SEOAIC_SETTINGS::getCustomPostTypeSettings();
$cptEnabledClass = 'on' == $cptSsettings['enabled'] ? 'seoai-cpt-enabled' : '';
?>
<form id="seoaic-settings" class="seoaic-form row <?php echo esc_attr($cptEnabledClass);?>" name="seoaic-settings" method="post" autocomplete="off">
    <input type="hidden" class="seoaic-form-item" name="action" value="seoaic_settings">

    <div class="col-6 left-side">
        <div class="row">
            <div class="col-12 d-flex seoaic-integration-button">
                <?php
                    $checkboxEmpty = SEOAIC_SETTINGS::isGSCIntegrated();
                    $verificationMethod = $SEOAIC_OPTIONS['seoaicGscIntegrationMethod'] ?? '';
                    $showChangeText = !$checkboxEmpty && $verificationMethod !== 'META';
                    $buttonText = ($checkboxEmpty || $showChangeText) ? esc_html__('Change integration', 'seoaic') : esc_html__('Integrate', 'seoaic');
                ?>
                <button id="integrate_gsc" class="seoaic-settings__btn"><?php echo esc_html($buttonText); ?></button>
                <?php if (!$isVerifiedGSC): ?>
                    <button id="verify-gsc-integration" class="seoaic-button-primary">
                        Verify GSC integration
                    </button>
                <?php endif; ?>
            </div>
            <div class="col-12">
                <label for="seoaic_gsc_url"><?php esc_html_e('Google Search Console integration URL', 'seoaic');?></label>

                <input id="seoaic_gsc_url" class="seoaic-form-item form-input light" name="seoaic_gsc_url"
                    type="url"
                    placeholder="https://example.com"
                    autocomplete="none"
                    pattern="[Hh][Tt][Tt][Pp][Ss]?:\/\/(?:(?:[a-zA-Z\u00a1-\uffff0-9]+-?)*[a-zA-Z\u00a1-\uffff0-9]+)(?:\.(?:[a-zA-Z\u00a1-\uffff0-9]+-?)*[a-zA-Z\u00a1-\uffff0-9]+)*(?:\.(?:[a-zA-Z\u00a1-\uffff]{2,}))(?::\d{2,5})?(?:\/[^\s]*)?"
                    value="<?php echo !empty($SEOAIC_OPTIONS['seoaic_gsc_url']) ? esc_url($SEOAIC_OPTIONS['seoaic_gsc_url']) : esc_url(get_home_url());?>"
                    required
                />
                <span class="validation-message"><?php esc_html_e('Not valid URL', 'seoaic');?></span>
            </div>
            <div class="col-12 d-flex seoaic-single-row-switcher">
                <div class="toggle-choose-server">
                    <label class="switch">
                        <input type="checkbox"
                            id="seoaic_ssl_verifypeer"
                            name="seoaic_ssl_verifypeer"
                            class="seoaic-toggle seoaic-form-item"
                            value="on"
                            <?php echo !empty($SEOAIC_OPTIONS['seoaic_ssl_verifypeer']) ? 'checked' : '';?>
                        >
                        <span class="slider round"><span
                                    class="seoaic-toggle-value seoaic-toggle-value-1">On</span><span
                                    class="seoaic-toggle-value seoaic-toggle-value-2">Off</span></span>
                    </label>
                </div>
                <label for="seoaic_ssl_verifypeer"><?php esc_html_e('Use SSL Verification', 'seoaic');?></label>
            </div>

            <div class="col-12 d-flex seoaic-single-row-switcher">
                <div class="toggle-choose-server">
                    <label class="switch">
                        <input type="checkbox"
                            id="seoaic_competitors_traffic_graph"
                            name="seoaic_competitors_traffic_graph"
                            class="seoaic-toggle seoaic-form-item"
                            value="on"
                            <?php echo !empty($SEOAIC_OPTIONS['seoaic_competitors_traffic_graph']) ? 'checked' : '';?>
                        >
                        <span class="slider round"><span
                                    class="seoaic-toggle-value seoaic-toggle-value-1">On</span><span
                                    class="seoaic-toggle-value seoaic-toggle-value-2">Off</span></span>
                    </label>
                </div>
                <label for="seoaic_competitors_traffic_graph"><?php esc_html_e('Show competitor traffic graph', 'seoaic');?></label>
            </div>

            <div class="col-12 d-flex seoaic-single-row-switcher">
                <div class="toggle-choose-server">
                    <label class="switch">
                        <input type="checkbox"
                            id="seoaic_activate_content_improvement"
                            name="seoaic_activate_content_improvement"
                            class="seoaic-toggle seoaic-form-item"
                            value="on"
                            <?php echo SEOAIC_SETTINGS::isContentImprovementDisabled() ? '' : 'checked';?>
                        >
                        <span class="slider round"><span
                                    class="seoaic-toggle-value seoaic-toggle-value-1">On</span><span
                                    class="seoaic-toggle-value seoaic-toggle-value-2">Off</span></span>
                    </label>
                </div>
                <label for="seoaic_activate_content_improvement"><?php esc_html_e('Activate Content Improvement', 'seoaic');?></label>
            </div>

            <div class="col-12 d-flex seoaic-single-row-switcher">
                <div class="toggle-choose-server">
                    <label class="switch">
                        <input type="checkbox"
                            id="seoaic_total_value_content_improvement"
                            name="seoaic_total_value_content_improvement"
                            class="seoaic-toggle seoaic-form-item"
                            value="on"
                            <?php echo !empty($SEOAIC_OPTIONS['seoaic_total_value_content_improvement']) ? 'checked' : '';?>
                        >
                        <span class="slider round"><span
                                    class="seoaic-toggle-value seoaic-toggle-value-1">On</span><span
                                    class="seoaic-toggle-value seoaic-toggle-value-2">Off</span></span>
                    </label>
                </div>
                <label for="seoaic_total_value_content_improvement"><?php esc_html_e('Show content improvement total value', 'seoaic');?></label>
            </div>
            <div class="col-12 d-flex seoaic-single-row-switcher">
                <div class="toggle-choose-server">
                    <label class="switch">
                        <input type="checkbox"
                            id="seoaic_hide_individual_page_graph"
                            name="seoaic_hide_individual_page_graph"
                            class="seoaic-toggle seoaic-form-item"
                            value="on"
                            <?php echo !empty($SEOAIC_OPTIONS['seoaic_hide_individual_page_graph']) ? 'checked' : '';?>
                        >
                        <span class="slider round"><span
                                    class="seoaic-toggle-value seoaic-toggle-value-1">On</span><span
                                    class="seoaic-toggle-value seoaic-toggle-value-2">Off</span></span>
                    </label>
                </div>
                <label for="seoaic_activate_content_improvement"><?php esc_html_e('Hide individual page graph', 'seoaic');?></label>
            </div>

            <div class="col-12 d-flex seoaic-single-row-switcher">
                <div>
                    <label class="switch">
                        <?php
                        $isGutenbergTinyMCEDisabled = SEOAIC_SETTINGS::isGutenbergTinyMCEDisabled();
                        ?>
                        <input type="checkbox"
                            id="seoaic_gutenberg_tinymce_on"
                            name="seoaic_gutenberg_tinymce_on"
                            class="seoaic-toggle seoaic-form-item"
                            value="on"
                            <?php echo $isGutenbergTinyMCEDisabled ? '' : 'checked';?>
                        >
                        <span class="slider round"><span
                                    class="seoaic-toggle-value seoaic-toggle-value-1">On</span><span
                                    class="seoaic-toggle-value seoaic-toggle-value-2">Off</span></span>
                    </label>
                </div>
                <label for="seoaic_gutenberg_tinymce_on"><?php esc_html_e('Enable SEOAI functions for Gutenberg and Classic editors', 'seoaic');?></label>
            </div>

            <?php if (seoaic_is_scf_active()) { ?>
                <div class="col-12 d-flex seoaic-single-row-switcher">
                    <div class="toggle-choose-server">
                        <label class="switch">
                            <input type="checkbox"
                                    id="seoaic_show_generated_content_in_custom_field"
                                    name="seoaic_show_generated_content_in_custom_field"
                                    class="seoaic-toggle seoaic-form-item"
                                    value="1"
                                <?php echo SEOAIC_SETTINGS::isGeneratedContentInCustomFieldTurnedOn() ? 'checked' : ''; ?>
                            >
                            <span class="slider round"><span
                                        class="seoaic-toggle-value seoaic-toggle-value-1">On</span><span
                                        class="seoaic-toggle-value seoaic-toggle-value-2">Off</span></span>
                        </label>
                    </div>
                    <label for="seoaic_show_generated_content_in_custom_field">
                        <?php esc_html_e('Show generated content in custom text editor', 'seoaic');?>
                    </label>
                </div>
            <?php } ?>

            <?php if (current_user_can('manage_options')) { ?>
                <div class="col-12">
                    <label for="seoaic_server"><?php esc_html_e('Allow to use plugin for the following roles', 'seoaic');?></label>
                    <div class="toggle-choose-role">
                        <div class="checkbox-list">
                            <?php
                            $roles = wp_roles()->roles;
                            unset($roles['administrator'], $roles['company']);

                            foreach ($roles as $role => $role_info) {
                                $checked = isset($SEOAIC_OPTIONS['seoaic_access_role']) && in_array($role, $SEOAIC_OPTIONS['seoaic_access_role']) ? ' checked' : '';
                                ?>
                                <div class="checkbox-wrapper-mc">
                                    <input id="<?php echo esc_attr('seoaic_access-role-' . $role);?>" class="seoaic-form-item"
                                            name="seoaic_access_role[]"
                                            type="checkbox"
                                            value="<?php echo esc_attr($role);?>"
                                            <?php echo esc_attr($checked);?> />
                                    <label for="<?php echo esc_attr('seoaic_access-role-' . $role);?>" class="check">
                                        <svg width="18px" height="18px" viewBox="0 0 18 18">
                                            <path d="M1,9 L1,3.5 C1,2 2,1 3.5,1 L14.5,1 C16,1 17,2 17,3.5 L17,14.5 C17,16 16,17 14.5,17 L3.5,17 C2,17 1,16 1,14.5 L1,9 Z"></path>
                                            <polyline points="1 9 7 14 15 4"></polyline>
                                        </svg>
                                        <span><?php echo esc_html($role_info['name']);?></span>
                                    </label>
                                </div>
                            <?php }
                            ?>
                        </div>
                    </div>
                </div>
            <?php } ?>

            <div class="col-12">
                <label for="seoaic_company_website"><?php esc_html_e('Company website', 'seoaic');?></label>

                <input id="seoaic_company_website" class="seoaic-form-item form-input light" name="seoaic_company_website"
                        type="url"
                        placeholder="https://example.com"
                        autocomplete="none"
                        pattern="[Hh][Tt][Tt][Pp][Ss]?:\/\/(?:(?:[a-zA-Z\u00a1-\uffff0-9]+-?)*[a-zA-Z\u00a1-\uffff0-9]+)(?:\.(?:[a-zA-Z\u00a1-\uffff0-9]+-?)*[a-zA-Z\u00a1-\uffff0-9]+)*(?:\.(?:[a-zA-Z\u00a1-\uffff]{2,}))(?::\d{2,5})?(?:\/[^\s]*)?"
                        value="<?php echo !empty($SEOAIC_OPTIONS['seoaic_company_website']) ? esc_attr($SEOAIC_OPTIONS['seoaic_company_website']) : esc_attr(get_bloginfo('url'));?>"
                        required
                />
                <span class="validation-message"><?php esc_html_e('Not valid URL', 'seoaic');?></span>
            </div>

            <div class="col-12">
                <label for="seoaic_business_name"><?php esc_html_e('Business Name', 'seoaic');?></label>

                <input id="seoaic_business_name" class="seoaic-form-item form-input light"
                        name="seoaic_business_name"
                        type="text"
                        value="<?php echo !empty($SEOAIC_OPTIONS['seoaic_business_name']) ? esc_attr($SEOAIC_OPTIONS['seoaic_business_name']) : esc_attr(get_option('blogname', true));?>"
                        required>
            </div>

            <div class="col-12">
                <label for="seoaic_industry"><?php esc_html_e('Industry', 'seoaic');?></label>

                <input id="seoaic_industry" class="seoaic-form-item form-input light" name="seoaic_industry"
                        type="text"
                        value="<?php echo !empty($SEOAIC_OPTIONS['seoaic_industry']) ? esc_attr($SEOAIC_OPTIONS['seoaic_industry']) : '';?>"/>
            </div>

            <div class="col-12">
                <?php echo SEOAIC_SETTINGS::createRepeaterHTML('seoaic_business_description', false, true, true); ?>
            </div>

            <div class="col-12">
                <?php echo SEOAIC_SETTINGS::createRepeaterHTML('seoaic_services', false, true); ?>
            </div>

            <div class="col-12">
                <?php echo SEOAIC_SETTINGS::createRepeaterHTML('seoaic_target_audience', false, true); ?>

            </div>

            <div class="col-12">
                <label for="seoaic_phone"><?php esc_html_e('Phone', 'seoaic');?></label>

                <input type="text"
                        id="seoaic_phone"
                        name="seoaic_phone"
                        class="seoaic-form-item form-input light"
                        value="<?php echo !empty($SEOAIC_OPTIONS['seoaic_phone']) ? esc_attr($SEOAIC_OPTIONS['seoaic_phone']) : '';?>"
                        required/>
            </div>

            <div class="col-12">
                <label for="seoaic_location"><?php esc_html_e('Location', 'seoaic');?></label>

                <select id="seoaic_location" class="seoaic-form-item form-select mb-19"
                        name="seoaic_location"
                        required>
                    <?php foreach ($locations as $key => $location) : ?>
                        <option value="<?php echo esc_attr($location);?>"
                            <?php echo ($location === $selected_location) ? 'selected' : ''; ?>
                        ><?php echo esc_html($location);?></option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="col-12">
                <label for="seoaic_language"><?php esc_html_e('Language', 'seoaic');?></label>

                <select id="seoaic_language" class="seoaic-form-item form-select mb-19"
                        name="seoaic_language"
                        required>
                    <?php foreach ($languages as $language) : ?>
                        <option value="<?php echo esc_attr($language);?>"
                            <?php echo ($language === $selected_language) ? 'selected' : ''; ?>
                        ><?php echo esc_html($language);?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="language-select-wrapp">
                <?php echo $SEOAIC->multilang->get_multilang_checkboxes(); ?>
            </div>
            <div class="col-12">
                <label for="seoaic_writing_style"><?php esc_html_e('Writing Style (ex.: Friendly, Professional, Educational, Formal)', 'seoaic');?></label>
                <input type="text" required
                        id="seoaic_writing_style"
                        name="seoaic_writing_style"
                        class="seoaic-form-item form-input light"
                        value="<?php echo !empty($SEOAIC_OPTIONS['seoaic_writing_style']) ? esc_attr($SEOAIC_OPTIONS['seoaic_writing_style']) : 'Friendly';?>"/>
            </div>

<!--                    <div class="col-12">-->
<!--                        <label for="seoaic_image_generator">--><?php //_e('Default image generator', 'seoaic');?><!--</label>-->
<!---->
<!--                        <select id="seoaic_image_generator" class="seoaic-form-item form-select mb-5px"-->
<!--                                name="seoaic_image_generator"-->
<!--                                required>-->
<!--                            --><?php
//                            foreach ($image_generators as $key => $image_generator) : ?>
<!--                                <option value="--><?php //= esc_attr($key);?><!--"-->
<!--                                    --><?php //= ($key === $image_generator_default) ? 'selected' : '';?>
<!--                                >--><?php //= esc_html($image_generator);?><!--</option>-->
<!--                            --><?php //endforeach; ?>
<!--                        </select>-->
<!--                    </div>-->
<!---->
<!--                    <div class="col-12">-->
<!--                        <label for="seoaic_image_style">--><?php //_e('Image Style', 'seoaic');?><!--</label>-->
<!---->
<!--                        <select id="seoaic_image_style" class="seoaic-form-item form-select mb-5px"-->
<!--                                name="seoaic_image_style"-->
<!--                                required>-->
<!--                            --><?php //foreach ($image_styles as $key => $img_style) : ?>
<!--                                <option value="--><?php //= esc_attr($key);?><!--"-->
<!--                                    --><?php //= (!empty($SEOAIC_OPTIONS['seoaic_image_style']) && $key === $SEOAIC_OPTIONS['seoaic_image_style']) ? 'selected' : '';?>
<!--                                >--><?php //= esc_html($img_style);?><!--</option>-->
<!--                            --><?php //endforeach; ?>
<!--                        </select>-->
<!--                    </div>-->
<!---->
<!--                    <div class="col-12">-->
<!--                        <label for="seoaic_image_colors">--><?php //_e('Image Colors', 'seoaic');?><!--</label>-->
<!---->
<!--                        <input id="seoaic_image_colors" data-name="Main colors"-->
<!--                               class="seoaic-form-item form-input light color-palette-select"-->
<!--                               name="seoaic_image_colors"-->
<!--                               type="text"-->
<!--                               value="--><?php //= !empty($SEOAIC_OPTIONS['seoaic_image_colors']) ? esc_attr($SEOAIC_OPTIONS['seoaic_image_colors']) : '';?><!--"/>-->
<!--                        <div class="color-palettes">-->
<!--                            --><?php
//                            foreach ($colors as $key => $color) {
//                                echo '<div class="color" data-color="' . esc_attr($color) . '" style="background-color: ' . esc_attr($color) . '"></div>';
//                            }
//                            ?>
<!--                        </div>-->
<!---->
<!--                        <input id="seoaic_image_colors_accent" data-name="Accent colors"-->
<!--                               class="seoaic-form-item form-input light color-palette-select"-->
<!--                               name="seoaic_image_colors_accent"-->
<!--                               type="text"-->
<!--                               value="--><?php //= !empty($SEOAIC_OPTIONS['seoaic_image_colors_accent']) ? esc_attr($SEOAIC_OPTIONS['seoaic_image_colors_accent']) : '';?><!--"/>-->
<!--                        <div class="color-palettes">-->
<!--                            --><?php
//                            foreach ($colors as $key => $color) {
//                                echo '<div class="color" data-color="' . esc_attr($color) . '" style="background-color: ' . esc_attr($color) . '"></div>';
//                            }
//                            ?>
<!--                        </div>-->
<!---->
<!--                        <input id="seoaic_image_colors_additional" data-name="Additional colors"-->
<!--                               class="seoaic-form-item form-input light color-palette-select"-->
<!--                               name="seoaic_image_colors_additional"-->
<!--                               type="text"-->
<!--                               value="--><?php //= !empty($SEOAIC_OPTIONS['seoaic_image_colors_additional']) ? esc_attr($SEOAIC_OPTIONS['seoaic_image_colors_additional']) : '';?><!--"/>-->
<!--                        <div class="color-palettes">-->
<!--                            --><?php
//                            foreach ($colors as $key => $color) {
//                                echo '<div class="color" data-color="' . esc_attr($color) . '" style="background-color: ' . esc_attr($color) . '"></div>';
//                            }
//                            ?>
<!--                        </div>-->
<!--                    </div>-->

            <div class="col-12">
                <label for="seoaic_content_guidelines"><?php esc_html_e('Content Guidelines', 'seoaic');?></label>

                <textarea rows="6"
                        id="seoaic_content_guidelines"
                        name="seoaic_content_guidelines"
                        class="seoaic-form-item form-input light mb-0 seoaic-textarea-autoresize"
                ><?php echo isset($SEOAIC_OPTIONS['seoaic_content_guidelines']) ? esc_html($SEOAIC_OPTIONS['seoaic_content_guidelines']) : 'When referring to us as a company speak about "Us" or "We" instead of them.';?></textarea>
            </div>

            <div class="col-12">
                <label for="seoaic_translating_guidelines"><?php esc_html_e('Translating guidelines', 'seoaic');?></label>

                <textarea rows="6"
                            id="seoaic_translating_guidelines"
                            name="seoaic_translating_guidelines"
                            class="seoaic-form-item form-input light mb-0 seoaic-textarea-autoresize"
                ><?php echo isset($SEOAIC_OPTIONS['seoaic_translating_guidelines']) ? esc_html($SEOAIC_OPTIONS['seoaic_translating_guidelines']) : '';?></textarea>
            </div>

            <div class="col-12">
                <label for="seoaic_custom_faq_prompt"><?php esc_html_e('Custom FAQ prompt', 'seoaic');?></label>

                <textarea rows="6"
                            id="seoaic_custom_faq_prompt"
                            name="seoaic_custom_faq_prompt"
                            class="seoaic-form-item form-input light mb-0 seoaic-textarea-autoresize"
                ><?php echo isset($SEOAIC_OPTIONS['seoaic_custom_faq_prompt']) ? esc_html($SEOAIC_OPTIONS['seoaic_custom_faq_prompt']) : '';?></textarea>
            </div>
        </div>
    </div>

    <div class="col-6 right-side">
        <a href="<?php echo esc_url(admin_url('admin.php?page=seoaic-onboarding-wizard')); ?>" class="seoaic_schedule_keywords">
            <div class="title-key">
                <h3><?php esc_html_e('Wizard', 'seoaic'); ?></h3>
                <p><?php esc_html_e('Make onboarding a breeze with our new feature - give it a try!', 'seoaic');?></p>
            </div>
            <div class="arrow-key">
                <div></div>
            </div>
        </a>

        <a href="<?php echo esc_url(admin_url('admin.php?page=seoaic-keywords')); ?>" class="seoaic_schedule_keywords">
            <div class="title-key">
                <h3>Keywords</h3>
                <p><?php esc_html_e('Go to customize keywords', 'seoaic');?></p>
            </div>
            <div class="arrow-key">
                <div></div>
            </div>
        </a>

        <a href="<?php echo esc_url(admin_url('admin.php?page=seoaic-locations')); ?>" class="seoaic_schedule_keywords">
            <div class="title-key">
                <h3><?php esc_html_e('Locations', 'seoaic'); ?></h3>
                <p><?php esc_html_e('Go to customize Locations', 'seoaic');?></p>
            </div>
            <div class="arrow-key">
                <div></div>
            </div>
        </a>
        <a href="<?php echo esc_url(admin_url('admin.php?page=seoaic-redirects')); ?>" class="seoaic_schedule_keywords">
            <div class="title-key">
                <h3><?php esc_html_e('Redirects', 'seoaic'); ?></h3>
                <p><?php esc_html_e('Check out the various redirects', 'seoaic');?></p>
            </div>
            <div class="arrow-key">
                <div></div>
            </div>
        </a>
        <a href="<?php echo esc_url(admin_url('admin.php?page=seoaic-settings-prompts')); ?>" class="seoaic_schedule_keywords">
            <div class="title-key">
                <h3><?php esc_html_e('Prompts Settings', 'seoaic'); ?></h3>
                <p><?php esc_html_e('Go to customize Prompts settings', 'seoaic');?></p>
            </div>
            <div class="arrow-key">
                <div></div>
            </div>
        </a>
        <a href="<?php echo esc_url(admin_url('admin.php?page=seoaic-pillar-links')); ?>" class="seoaic_schedule_keywords">
            <div class="title-key">
                <h3><?php esc_html_e('Pillar links', 'seoaic'); ?></h3>
                <p><?php esc_html_e('Go to customize Pillar links', 'seoaic');?></p>
            </div>
            <div class="arrow-key">
                <div></div>
            </div>
        </a>
        <a href="<?php echo esc_url(admin_url('admin.php?page=seoaic-settings-content-alerts'));?>" class="seoaic_schedule_keywords">
            <div class="title-key">
                <h3><?php esc_html_e('Content alerts', 'seoaic');?></h3>
                <p><?php esc_html_e('Set the Content alerts for your posts', 'seoaic');?></p>
            </div>
            <div class="arrow-key">
                <div></div>
            </div>
        </a>
        <a href="<?php echo esc_url(admin_url('admin.php?page=seoaic-settings-leads-interactive-form'));?>" class="seoaic_schedule_keywords">
            <div class="title-key">
                <h3><?php esc_html_e('Leads Addon', 'seoaic');?></h3>
                <p><?php esc_html_e('Settings for the Leads multistep interactive form', 'seoaic');?></p>
            </div>
            <div class="arrow-key">
                <div></div>
            </div>
        </a>
        <a target="_blank" href="<?php echo esc_url(admin_url('admin.php?page=seoaic-streamlined-onboarding'));?>" class="seoaic_schedule_keywords">
            <div class="title-key">
                <h3><?php esc_html_e('Streamlined onboarding', 'seoaic');?></h3>
                <p><?php esc_html_e('Generate Monthly Content Plan', 'seoaic');?></p>
            </div>
            <div class="arrow-key">
                <div></div>
            </div>
        </a>
        <a target="_blank" href="<?php echo esc_url(admin_url('admin.php?page=seoaic-sea-settings'));?>" class="seoaic_schedule_keywords">
            <div class="title-key">
                <h3><?php esc_html_e('SEA Settings', 'seoaic');?></h3>
                <p><?php esc_html_e('Set SEA Settings', 'seoaic');?></p>
            </div>
            <div class="arrow-key">
                <div></div>
            </div>
        </a>

        <?php
        $days = [
            'monday' => esc_html__('Monday', 'seoaic'),
            'tuesday' => esc_html__('Tuesday', 'seoaic'),
            'wednesday' => esc_html__('Wednesday', 'seoaic'),
            'thursday' => esc_html__('Thursday', 'seoaic'),
            'friday' => esc_html__('Friday', 'seoaic'),
            'saturday' => esc_html__('Saturday', 'seoaic'),
            'sunday' => esc_html__('Sunday', 'seoaic')
        ];
        ?>
        <div class="seoaic_schedule_settings"
                data-server-time="<?php esc_attr_e(ini_get('date.timezone')); ?>"
                data-saved-dates="<?php esc_attr_e(json_encode($SEOAIC->settings::get_auto_schedule_posts_dates())); ?>"
        >
            <input type="hidden" name="seoaic_schedule_changed" id="seoaic_schedule_changed" class="seoaic-form-item">
            <h2><?php
                esc_html_e('Posts generating schedule', 'seoaic');
            ?></h2>
            <button id="seoaic_drafts_queue_button" type="button" data-modal="#seoaic-alert-modal"
                    data-title="<?php esc_html_e('Scheduled drafts queue', 'seoaic'); ?>"
                    data-content="<?php esc_attr_e('<div id="seoaic-loader-auto-scheduled-posts" class="loader-ellipsis small"></div>'); ?>"
                    data-action="seoaic_"
                    class="seoaic-button-small modal-button position-absolute seoaic-load-queue-posts load_auto_scheduled_posts">
                <?php esc_html_e('Posts queue', 'seoaic'); ?>
            </button>

            <table class="table">
                <tbody>
                <?php foreach ($days as $key => $label): ?>
                    <tr>
                        <th scope="row">
                            <input id="seoaic_schedule_days_<?php echo esc_attr($key); ?>" class="seoaic-form-item"
                                    name="seoaic_schedule_days"
                                    type="checkbox"
                                    value="<?php echo esc_attr($key); ?>">
                        </th>
                        <td>
                            <label for="seoaic_schedule_days_<?php echo esc_attr($key); ?>" class="seoaic_schedule_days_label">
                                <?php echo esc_html($label); ?>
                            </label>
                        </td>
                        <td>
                            <div class="time-select">
                                <input id="seoaic_schedule_<?php echo esc_attr($key); ?>_time" class="form-input-time"
                                        type="text"
                                        data-day="<?php echo esc_attr($key); ?>"
                                        value="<?php esc_html_e('12:00 PM', 'seoaic'); ?>" />
                                <span class="done"></span><span class="edit"></span>
                                <input class="seoaic-form-item"
                                        name="seoaic_schedule_<?php echo esc_attr($key); ?>_time"
                                        type="hidden">
                            </div>
                        </td>
                        <td>
                            <div class="num-select">
                                <input id="seoaic_schedule_<?php echo esc_attr($key); ?>_posts" class="form-input-num seoaic-form-item"
                                        name="seoaic_schedule_<?php echo esc_attr($key); ?>_posts"
                                        type="number" min="1" max="999"
                                        value="1" />
                                <div class="spin">
                                    <div class="up bt"></div>
                                    <div class="down bt"></div>
                                </div>
                                <span class="ready"></span>
                                <span class="label"><?php esc_html_e('posts', 'seoaic'); ?></span><span class="edit"></span>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <div class="col-12 mb-40">
            <label for="seoaic_business_name"><?php esc_html_e('Default scheduled posts time', 'seoaic');?></label>

            <input id="seoaic_default_scheduled_posting_time" class="seoaic-form-item form-input light"
                    name="seoaic_default_scheduled_posting_time"
                    type="text"
                    value="<?php echo !empty($SEOAIC_OPTIONS['seoaic_default_scheduled_posting_time']) ? esc_attr($SEOAIC_OPTIONS['seoaic_default_scheduled_posting_time']) :  '8:00' ;?>">
        </div>

        <div id="seoaic-idea-exclude-taxonomies" class="col-12">
            <label for="seoaic-idea-exclude-taxonomies"><?php esc_html_e('Exclude taxonomies', 'seoaic');?></label>
            <div class="terms-select">
                <?php echo $exclude_taxonomies;?>
            </div>
        </div>


        <div class="col-12 d-flex seoaic-single-row-switcher">
            <div>
                <label class="switch">
                    <input type="checkbox"
                        id="seoaic_cpt_enabled"
                        name="seoaic_cpt_enabled"
                        class="seoaic-toggle seoaic-form-item"
                        value="on"
                        <?php echo esc_attr("on" == $cptSsettings['enabled'] ? 'checked' : '');?>
                    >
                    <span class="slider round"><span class="seoaic-toggle-value seoaic-toggle-value-1">On</span><span class="seoaic-toggle-value seoaic-toggle-value-2">Off</span></span>
                </label>
            </div>
            <div class="flex-align-center">
                <label for="seoaic_leads_form_box_add_shadow"><?php esc_html_e("Enable SEO AI custom post type", 'seoaic');?></label>
            </div>
        </div>

        <div class="col-12 seoaic-select-post-type">
            <label for="seoaic_post_type"><?php esc_html_e('Post type to save', 'seoaic');?></label>

            <select id="seoaic_post_type"
                    class="seoaic-form-item form-select mb-5px"
                    name="seoaic_post_type"
                    data-action="seoaic_getCategoriesOfPosttype"
                    data-target-select="seoaic-idea-content-category"
                    required>
                <?php SEOAIC::makePostTypesOptions($post_types, $selected_post_type);?>
            </select>
            <div class="seoaic-field-description"><?php esc_html_e("Note: this setting can be rewritten by individual Idea's post type.", "seoaic");?></div>
        </div>

        <div class="seoai-cpt-enabled-show col-12">
            <div class="mb-5 col-12">
                <label for="seoaic_cpt_slug"><?php esc_html_e("SEOAI post root slug", "seoaic");?></label>
                <input type="text"
                    id="seoaic_cpt_slug"
                    name="seoaic_cpt_slug"
                    class="seoaic-form-item form-input light"
                    placeholder="seoai-posts by default"
                    autocomplete="none"
                    value="<?php echo esc_attr($cptSsettings['slug']);?>"
                >
            </div>

            <div class="col-12 d-flex seoaic-single-row-switcher">
                <div>
                    <label class="switch">
                        <input type="checkbox"
                            id="seoaic_custom_template"
                            name="seoaic_custom_template"
                            class="seoaic-toggle seoaic-form-item"
                            value="on"
                            <?php echo esc_attr("on" == $cptSsettings['custom_template'] ? 'checked' : '');?>
                        >
                        <span class="slider round"><span class="seoaic-toggle-value seoaic-toggle-value-1">On</span><span class="seoaic-toggle-value seoaic-toggle-value-2">Off</span></span>
                    </label>
                </div>
                <div class="flex-align-center">
                    <label for="seoaic_leads_form_box_add_shadow"><?php esc_html_e("Custom template for SEO AI posts (for custom post type only)", 'seoaic');?></label>
                </div>
            </div>
            <div class="seoaic-text-right">
                <!-- <a class="btn-link seoaic-fs-14" href="<?php echo esc_url(admin_url("site-editor.php?postType=wp_template&activeView=WP+SEO+AI"));?>" target="_blank"><?php esc_html_e("View template", "seoaic");?></a> -->
                <a class="btn-link seoaic-fs-14" href="<?php echo esc_url(admin_url("admin.php?page=seoaic-custom-template-settings"));?>" target="_blank"><?php esc_html_e("Manage template", "seoaic");?></a>
            </div>
        </div>

        <div class="seoai-cpt-enabled-hide col-12">
            <div class="col-12 seoaic-select-post-seoaic_post_template">
                <label for="seoaic_post_template"><?php esc_html_e('Post template', 'seoaic');?></label>

                <select id="seoaic_post_template"
                        class="seoaic-form-item form-select mb-5px"
                        name="seoaic_post_template">
                    <?php
                    echo SEOAIC::makePostTemplatesOptions($postTemplates, $selectedPostTemplate);
                    ?>
                </select>
            </div>
        </div>

        <div id="seoaic-idea-content-category" class="col-12 seoaic-select-post-type-cat">
            <label for="seoaic_default_category"><?php esc_html_e('Default posts category', 'seoaic');?></label>
            <div class="terms-select">
                <?php echo $categories;?>
            </div>
        </div>

        <div class="col-12">
            <label for="seoaic_industry"><?php esc_html_e('Delay post publication, hours', 'seoaic');?></label>

            <input id="seoaic_publish_delay" class="seoaic-form-item form-input light"
                    name="seoaic_publish_delay"
                    type="text"
                    value="<?php echo !empty($SEOAIC_OPTIONS['seoaic_publish_delay']) ? esc_attr($SEOAIC_OPTIONS['seoaic_publish_delay']) : '120';?>"
                    required/>
        </div>

        <div class="col-12 seoaic-select-post-seoaic_post_author">
            <label for="seoaic_post_author"><?php esc_html_e('Post Author', 'seoaic');?></label>
            <select id="seoaic_post_author"
                    class="seoaic-form-item form-select mb-5px"
                    name="seoaic_post_author">
                <option value="0"><?php esc_html_e('Choose post author') ?></option>
                <?php
                echo SEOAIC::makeAuthorTemplateOptions($selectedPostAuthor);
                ?>
            </select>
        </div>

        <div class="col-12 d-flex seoaic-single-row-switcher">
            <div class="toggle-choose-server">
                <label class="switch">
                    <input type="checkbox"
                        id="seoaic_generate_internal_links"
                        name="seoaic_generate_internal_links"
                        class="seoaic-toggle seoaic-form-item"
                        value="1"
                        <?php echo SEOAIC_SETTINGS::isGenerateInternalLinksEnabled() ? 'checked' : '';?>
                    >
                    <span class="slider round"><span
                                class="seoaic-toggle-value seoaic-toggle-value-1">On</span><span
                                class="seoaic-toggle-value seoaic-toggle-value-2">Off</span></span>
                </label>
            </div>
            <label for="seoaic_generate_internal_links"><?php esc_html_e('Generate internal links in content', 'seoaic');?></label>
        </div>

        <div class="col-12 d-flex seoaic-single-row-switcher">
            <div class="toggle-choose-server">
                <label class="switch">
                    <input type="checkbox"
                        id="seoaic_pillar_link_action"
                        name="seoaic_pillar_link_action"
                        class="seoaic-toggle seoaic-form-item"
                        value="1"
                        <?php echo SEOAIC_SETTINGS::isAddPillarLinksEnabled() ? 'checked' : '';?>
                    >
                    <span class="slider round"><span
                                class="seoaic-toggle-value seoaic-toggle-value-1">On</span><span
                                class="seoaic-toggle-value seoaic-toggle-value-2">Off</span></span>
                </label>
            </div>
            <label for="seoaic_generate_internal_links"><?php esc_html_e('Add pillar links in content', 'seoaic');?></label>
        </div>

        <div class="col-12 d-flex seoaic-single-row-switcher">
            <div class="toggle-choose-server">
                <label class="switch">
                    <input type="checkbox"
                        id="seoaic_show_related_articles"
                        name="seoaic_show_related_articles"
                        class="seoaic-toggle seoaic-form-item"
                        value="1"
                        <?php echo SEOAIC_SETTINGS::isShowRelatedArticlesEnabled() ? 'checked' : '';?>
                    >
                    <span class="slider round"><span
                                class="seoaic-toggle-value seoaic-toggle-value-1">On</span><span
                                class="seoaic-toggle-value seoaic-toggle-value-2">Off</span></span>
                </label>
            </div>
            <label for="seoaic_show_related_articles"><?php esc_html_e('Show related articles', 'seoaic');?></label>
        </div>

        <div class="col-12">
            <label for="seoaic_related_articles_count"><?php esc_html_e('Amount of related articles', 'seoaic');?></label>
            <input id="seoaic_related_articles_count" class="seoaic-form-item form-input light"
                    name="seoaic_related_articles_count"
                    type="number"
                    min="1"
                    max="20"
                    value="<?php echo !empty($SEOAIC_OPTIONS['seoaic_related_articles_count']) ? esc_attr($SEOAIC_OPTIONS['seoaic_related_articles_count']) : '5';?>"
                    required/>
        </div>

        <div class="col-12 d-flex seoaic-single-row-switcher">
            <div class="toggle-choose-server">
                <label class="switch">
                    <input type="checkbox"
                        id="seoaic_hide_posts"
                        name="seoaic_hide_posts"
                        class="seoaic-toggle seoaic-form-item"
                        value="1"
                        <?php echo !empty($SEOAIC_OPTIONS['seoaic_hide_posts']) ? 'checked' : '';?>
                    >
                    <span class="slider round"><span
                                class="seoaic-toggle-value seoaic-toggle-value-1">On</span><span
                                class="seoaic-toggle-value seoaic-toggle-value-2">Off</span></span>
                </label>
            </div>
            <label for="seoaic_hide_posts"><?php esc_html_e('Hide posts created by SEO AI', 'seoaic');?></label>
        </div>

        <div class="col-12">
            <label for="seoaic_hide_posts"><?php esc_html_e('Make specific SEO AI posts visible', 'seoaic');?>
                <div class="info inline right">
                    <span class="info-btn">?</span>
                    <div class="info-content">
                        <p><?php esc_html_e('You can make specific posts visible even if the general SEO AI posts visibility setting is set to hidden.<br>Optional field.', 'seoaic');?></p>
                    </div>
                </div>
            </label>

            <input type="hidden" name="seoaic_visible_posts[]" class="seoaic-form-item" value="">
            <select id="seoaic_visible_posts" class="seoaic-form-item form-select mb-5px"
                    name="seoaic_visible_posts" multiple>
                <?php
                if ($createdPostsQuery->have_posts()) {
                    $visiblePostsIDs = !empty($SEOAIC_OPTIONS['seoaic_visible_posts']) ? array_values($SEOAIC_OPTIONS['seoaic_visible_posts']) : [];

                    while ($createdPostsQuery->have_posts()) {
                        $createdPostsQuery->the_post();
                        $id = get_the_ID();

                        if (in_array($id, $visiblePostsIDs)) {
                            ?>
                            <option value="<?php echo esc_attr($id);?>" selected="selected"><?php echo esc_html(get_the_title());?></option>
                            <?php
                        }
                    }

                } else {
                    ?>
                    <option value=""><?php esc_html_e('No posts found', 'seoaic');?></option>
                    <?php
                }
                ?>
            </select>
        </div>

        <div id="seoiac-subtitles-range" class="seoaic-settings-range col-12" data-min="0" data-max="15"
                data-step="1">
            <label><?php esc_html_e('Min/max subtitles in generated outline', 'seoaic');?>:
                <span class="range-min"><?php echo !empty($SEOAIC_OPTIONS['seoaic_subtitles_range_min']) ? esc_html($SEOAIC_OPTIONS['seoaic_subtitles_range_min']) : '2';?></span>
                -
                <span class="range-max"><?php echo !empty($SEOAIC_OPTIONS['seoaic_subtitles_range_max']) ? esc_html($SEOAIC_OPTIONS['seoaic_subtitles_range_max']) : '6';?></span>
                <input id="seoaic_subtitles_range_min" class="seoaic-settings-range-min seoaic-form-item"
                        type="hidden" name="seoaic_subtitles_range_min"
                        value="<?php echo !empty($SEOAIC_OPTIONS['seoaic_subtitles_range_min']) ? esc_attr($SEOAIC_OPTIONS['seoaic_subtitles_range_min']) : '2';?>">
                <input id="seoaic_subtitles_range_max" class="seoaic-settings-range-max seoaic-form-item"
                        type="hidden" name="seoaic_subtitles_range_max"
                        value="<?php echo !empty($SEOAIC_OPTIONS['seoaic_subtitles_range_max']) ? esc_attr($SEOAIC_OPTIONS['seoaic_subtitles_range_max']) : '6';?>">
            </label>
            <div id="seoiac-subtitles-range-slider" class="seoaic-settings-range-slider"></div>
        </div>

        <div id="seoiac-words-range" class="seoaic-settings-range col-12" data-min="0" data-max="2500"
                data-step="10">
            <label><?php esc_html_e('Min/max words in generated posts', 'seoaic');?>:
                <span class="range-min"><?php echo !empty($SEOAIC_OPTIONS['seoaic_words_range_min']) ? esc_html($SEOAIC_OPTIONS['seoaic_words_range_min']) : '500';?></span>
                -
                <span class="range-max"><?php echo !empty($SEOAIC_OPTIONS['seoaic_words_range_max']) ? esc_html($SEOAIC_OPTIONS['seoaic_words_range_max']) : '1000';?></span>
                <input id="seoaic_words_range_min" class="seoaic-settings-range-min seoaic-form-item"
                        type="hidden" name="seoaic_words_range_min"
                        value="<?php echo !empty($SEOAIC_OPTIONS['seoaic_words_range_min']) ? esc_attr($SEOAIC_OPTIONS['seoaic_words_range_min']) : '500';?>">
                <input id="seoaic_words_range_max" class="seoaic-settings-range-max seoaic-form-item"
                        type="hidden" name="seoaic_words_range_max"
                        value="<?php echo !empty($SEOAIC_OPTIONS['seoaic_words_range_max']) ? esc_attr($SEOAIC_OPTIONS['seoaic_words_range_max']) : '1000';?>">
            </label>
            <div id="seoiac-words-range-slider" class="seoaic-settings-range-slider"></div>
        </div>

        <div id="seoiac-words-range" class="col-12">
            <label for="seoaic_image_generate_style"><?php esc_html_e("Generated image's style", 'seoaic');?></label>
            <select
                name="seoaic_image_generate_style"
                id="seoaic_image_generate_style"
                class="seoaic-form-item form-select mb-5px"
            >
                <?php
                $defaultStyle = SEOAIC_SETTINGS::getImageGenerateStyle();
                $styles = SEOAIC_SETTINGS::getImageGenerateStylesAvailable();
                echo wp_kses(
                    HTMLBuilers::options($styles, $defaultStyle),
                    [
                        'option' => [
                            'value'     => [],
                            'selected'  => [],
                            'class'     => [],
                        ],
                    ]
                );
                ?>
            </select>
        </div>

        <div id="seoiac-image-size-range" class="col-12">
            <div class="f-words-count seoaic-settings-range seoaic-settings-range-2 mt-20 mb-0"
                 data-min="256"
                 data-max="1440"
                 data-step="32"
                 data-range="min"
            >
                <label><?php esc_html_e('Image width (optionally):', 'seoaic'); ?>
                    <span class="range-min"><?php echo !empty($SEOAIC_OPTIONS['seoaic_image_generate_width_default']) ? esc_html($SEOAIC_OPTIONS['seoaic_image_generate_width_default']) : '1024'; ?></span><?php _e('px', 'seoaic'); ?>
                    <input type="hidden"
                           id=""
                           class="seoaic-settings-range-min seoaic-form-item"
                           name="seoaic_image_generate_width_default"
                           value="<?php echo !empty($SEOAIC_OPTIONS['seoaic_image_generate_width_default']) ? esc_attr($SEOAIC_OPTIONS['seoaic_image_generate_width_default']) : '1024'; ?>"
                    >
                </label>
                <div id=""
                     class="seoaic-settings-range-slider"
                ></div>
            </div>
            <div class="f-words-count seoaic-settings-range seoaic-settings-range-2 mt-20 mb-0"
                 data-min="256"
                 data-max="1440"
                 data-step="32"
                 data-range="min"
            >
                <label><?php esc_html_e('Image height (optionally):', 'seoaic'); ?>
                    <span class="range-min"><?php echo !empty($SEOAIC_OPTIONS['seoaic_image_generate_height_default']) ? esc_html($SEOAIC_OPTIONS['seoaic_image_generate_height_default']) : '768'; ?></span><?php _e('px', 'seoaic'); ?>
                    <input type="hidden"
                           id=""
                           class="seoaic-settings-range-min seoaic-form-item"
                           name="seoaic_image_generate_height_default"
                           value="<?php echo !empty($SEOAIC_OPTIONS['seoaic_image_generate_height_default']) ? esc_attr($SEOAIC_OPTIONS['seoaic_image_generate_height_default']) : '768'; ?>"
                    >
                </label>
                <div id=""
                     class="seoaic-settings-range-slider"
                ></div>
            </div>
        </div>

        <div id="seoiac-words-range" class="col-12">
            <label for="seoaic_image_generate_prompt_default"><?php esc_html_e("Image generation prompt", 'seoaic');?></label>
            <textarea rows="6"
                id="seoaic_image_generate_prompt_default"
                name="seoaic_image_generate_prompt_default"
                class="seoaic-form-item form-input light mb-0 seoaic-textarea-autoresize"
            ><?php echo !empty($SEOAIC_OPTIONS['seoaic_image_generate_prompt_default']) ? esc_html($SEOAIC_OPTIONS['seoaic_image_generate_prompt_default']) : '';?></textarea>
        </div>

        <div class="col-12">
            <label for="seoaic_settings_branded_keywords"><?php esc_html_e('Branded keywords (separated by new line)', 'seoaic');?></label>

            <textarea rows="6"
                        id="seoaic_settings_branded_keywords"
                        name="seoaic_branded_keywords"
                        class="seoaic-form-item form-input light mb-0 seoaic-textarea-autoresize"
            ><?php echo isset($SEOAIC_OPTIONS['seoaic_branded_keywords']) ? esc_html($SEOAIC_OPTIONS['seoaic_branded_keywords']) : '';?></textarea>
        </div>

        <div class="col-12 seoaic-settings-submit-wrapper">
            <button id="seoaic_submit" type="submit" class="button button-primary seoaic-button-primary"><?php esc_html_e('Save All', 'seoaic');?></button>
        </div>
    </div>

</form>