<?php

use SEOAIC\last_used_prompts\IdeasGenerateLastUsedPrompts;
use SEOAIC\last_used_prompts\KeywordsGenerateLastUsedPrompts;
use SEOAIC\last_used_prompts\PostsMassEditLastUsedPrompts;
use SEOAIC\last_used_prompts\PostsMassGenerateLastUsedPrompts;
use SEOAIC\last_used_prompts\PostsMassReviewLastUsedPrompts;

if (!current_user_can('seoaic_edit_plugin')) {
    return;
}

if (isset($_GET['settings-updated'])) {
    add_settings_error('seoaic_messages', 'seoaic_message', esc_html__('Settings Saved', 'mdsf'), 'updated');
}

settings_errors('seoaic_messages');

global $SEOAIC_OPTIONS;

function SEOAICmakePromptHTMLRowSettings($name = 'post-prompt-teplate', $prompt='') {
    ob_start();
    ?>
    <div class="prompt-section">
        <div class="item">
            <textarea placeholder="<?php esc_attr_e('Prompt template', 'seoaic');?>" name="<?php echo esc_attr($name);?>" class="form-input light <?php echo esc_attr($name . '-input');?> seoaic-textarea-autoresize" autocomplete="off" rows="3"><?php echo esc_html($prompt);?></textarea>
            <a href="#" class="delete delete-prompt" title="<?php esc_html_e('Remove', 'seoaic');?>"></a>
        </div>
    </div>
    <?php

    return ob_get_clean();
}

$keywordsPromptTmplts = $SEOAIC_OPTIONS['seoaic_keywords_generate_prompt_templates'] ?? [];
$ideasPromptTmplts = $SEOAIC_OPTIONS['seoaic_ideas_generate_prompt_templates'] ?? [];
$postsGenerationPromptTmplts = $SEOAIC_OPTIONS['seoaic_posts_mass_generate_prompt_templates'] ?? [];
$postsEditPromptTmplts = $SEOAIC_OPTIONS['seoaic_posts_mass_edit_prompt_templates'] ?? [];
$postsReviewPromptTmplts = $SEOAIC_OPTIONS['seoaic_posts_mass_review_prompt_templates'] ?? [];
$ideasPromptTmpltsHTML_safe = '';
$keywordsPromptTmpltsHTML_safe = '';
$postsGenerationPromptTmpltsHTML_safe = '';
$postsEditPromptTmpltsHTML_safe = '';
$postsReviewPromptTmpltsHTML_safe = '';

foreach ((array)$ideasPromptTmplts as $p) {
    $ideasPromptTmpltsHTML_safe .= SEOAICmakePromptHTMLRowSettings('ideas-prompt-teplate', $p);
}

foreach ((array)$keywordsPromptTmplts as $p) {
    $keywordsPromptTmpltsHTML_safe .= SEOAICmakePromptHTMLRowSettings('keywords-prompt-teplate', $p);
}

foreach ((array)$postsGenerationPromptTmplts as $p) {
    $postsGenerationPromptTmpltsHTML_safe .= SEOAICmakePromptHTMLRowSettings('post-prompt-teplate', $p);
}

foreach ((array)$postsEditPromptTmplts as $p) {
    $postsEditPromptTmpltsHTML_safe .= SEOAICmakePromptHTMLRowSettings('post-edit-prompt-teplate', $p);
}

foreach ((array)$postsReviewPromptTmplts as $p) {
    $postsReviewPromptTmpltsHTML_safe .= SEOAICmakePromptHTMLRowSettings('post-review-prompt-teplate', $p);
}

$keywordsLastPromptsInstance = new KeywordsGenerateLastUsedPrompts();
$keywordsSettingsCountField = $keywordsLastPromptsInstance->getSettingsCountField();
$keywordsLastUsedCount = $keywordsLastPromptsInstance->getCount();
$ideasLastPromptsInstance = new IdeasGenerateLastUsedPrompts();
$ideasSettingsCountField = $ideasLastPromptsInstance->getSettingsCountField();
$ideasLastUsedCount = $ideasLastPromptsInstance->getCount();
$postsGenerationLastPromptsInstance = new PostsMassGenerateLastUsedPrompts();
$postsGenerateSettingsCountField = $postsGenerationLastPromptsInstance->getSettingsCountField();
$postsGenerateLastUsedCount = $postsGenerationLastPromptsInstance->getCount();
$postsEditLastPromptsInstance = new PostsMassEditLastUsedPrompts();
$postsEditSettingsCountField = $postsEditLastPromptsInstance->getSettingsCountField();
$postsEditLastUsedCount = $postsEditLastPromptsInstance->getCount();
$postsReviewLastPromptsInstance = new PostsMassReviewLastUsedPrompts();
$postsReviewSettingsCountField = $postsReviewLastPromptsInstance->getSettingsCountField();
$postsReviewLastUsedCount = $postsReviewLastPromptsInstance->getCount();

?>
<div id="seoaic-admin-container" class="wrap">
    <h1 id="seoaic-admin-title">
        <?php
        echo wp_kses(seoai_get_logo('logo.svg'), [
            'img' => [
                'title' => [],
                'src'	=> [],
                'alt'	=> [],
            ],
        ]);
        ?>
        <span>
            <?php echo esc_html(get_admin_page_title()); ?>
        </span>
    </h1>
    <div id="seoaic-admin-body" class="seoaic-with-loader bg-settings">
        <form id="seoaic_settings_prompts"
            class="seoaic-form row full-width seoaic-prompts-settings-form"
        >
            <input type="hidden" class="seoaic-form-item" name="action" value="seoaic_settings_prompts">

            <div class="col-6 left-side">
                <h2><?php esc_html_e("Keyword's Prompts", 'seoaic');?></h2>

                <div class="col-12">
                    <label for="<?php echo esc_attr($keywordsSettingsCountField);?>" class="seoaic-cursor-help" title="<?php esc_html_e("Minimum 0 - no prompts are saved, maximum 99.", 'seoaic');?>"><?php esc_html_e("How many last used prompts to remember?", 'seoaic');?></label>
                    <input type="number"
                        id="<?php echo esc_attr($keywordsSettingsCountField);?>"
                        class="seoaic-form-item form-input light"
                        name="<?php echo esc_attr($keywordsSettingsCountField);?>"
                        min="0"
                        max="99"
                        value="<?php echo esc_attr($keywordsLastUsedCount);?>"
                    >
                </div>

                <div class="col-12">
                    <label><?php esc_html_e('Keywords prompt templates', 'seoaic');?></label>
                    <div class="seoaic_input_repeater keywords_generate_prompt_templates">
                        <div class="prompts-list">
                            <?php echo $keywordsPromptTmpltsHTML_safe;?>
                        </div>
                        <a href="#"
                            class="add-prompt"
                            title="<?php esc_html_e('Add Keywords Prompt Template', 'seoaic');?>"
                            data-name="keywords-prompt-teplate"
                        ><?php esc_html_e('Add Keywords Prompt Template', 'seoaic');?></a>
                    </div>
                </div>

                <br><hr/>

                <h2><?php esc_html_e("Idea's Prompts", 'seoaic');?></h2>

                <div class="col-12">
                    <label for="<?php echo esc_attr($ideasSettingsCountField);?>" class="seoaic-cursor-help" title="<?php esc_html_e("Minimum 0 - no prompts are saved, maximum 99.", 'seoaic');?>"><?php esc_html_e("How many last used prompts to remember?", 'seoaic');?></label>
                    <input type="number"
                        id="<?php echo esc_attr($ideasSettingsCountField);?>"
                        class="seoaic-form-item form-input light"
                        name="<?php echo esc_attr($ideasSettingsCountField);?>"
                        min="0"
                        max="99"
                        value="<?php echo esc_attr($ideasLastUsedCount);?>"
                    >
                </div>

                <div class="col-12">
                    <label><?php esc_html_e('Ideas prompt templates', 'seoaic');?></label>
                    <div class="seoaic_input_repeater ideas_generate_prompt_templates">
                        <div class="prompts-list">
                            <?php echo $ideasPromptTmpltsHTML_safe;?>
                        </div>
                        <a href="#"
                            class="add-prompt"
                            title="<?php esc_html_e('Add Ideas Prompt Template', 'seoaic');?>"
                            data-name="ideas-prompt-teplate"
                        ><?php esc_html_e('Add Ideas Prompt Template', 'seoaic');?></a>
                    </div>
                </div>

                <div>&nbsp;</div>
            </div>

            <div class="col-6 right-side">
                <h2><?php esc_html_e("Post's Generation Prompts", 'seoaic');?></h2>

                <div class="col-12">
                    <label for="<?php echo esc_attr($postsGenerateSettingsCountField);?>" class="seoaic-cursor-help" title="<?php esc_html_e("Minimum 0 - no prompts are saved, maximum 99.", 'seoaic');?>"><?php esc_html_e("How many last used prompts to remember?", 'seoaic');?></label>
                    <input type="number"
                        id="<?php echo esc_attr($postsGenerateSettingsCountField);?>"
                        class="seoaic-form-item form-input light"
                        name="<?php echo esc_attr($postsGenerateSettingsCountField);?>"
                        min="0"
                        max="99"
                        value="<?php echo esc_attr($postsGenerateLastUsedCount);?>"
                    >
                </div>

                <div class="col-12">
                    <label><?php esc_html_e('Posts prompt templates', 'seoaic');?></label>
                    <div class="seoaic_input_repeater posts_mass_generate_prompt_templates">
                        <div class="prompts-list">
                            <?php echo $postsGenerationPromptTmpltsHTML_safe;?>
                        </div>
                        <a href="#"
                            class="add-prompt"
                            title="<?php esc_html_e('Add Posts Prompt Template', 'seoaic');?>"
                            data-name="post-prompt-teplate"
                        ><?php esc_html_e('Add Posts Prompt Template', 'seoaic');?></a>
                    </div>
                </div>

                <br><hr/>

                <h2><?php esc_html_e("Post's Edit Prompts", 'seoaic');?></h2>

                <div class="col-12">
                    <label for="<?php echo esc_attr($postsEditSettingsCountField);?>" class="seoaic-cursor-help" title="<?php esc_html_e("Minimum 0 - no prompts are saved, maximum 99.", 'seoaic');?>"><?php esc_html_e("How many last used prompts to remember?", 'seoaic');?></label>
                    <input type="number"
                        id="<?php echo esc_attr($postsEditSettingsCountField);?>"
                        class="seoaic-form-item form-input light"
                        name="<?php echo esc_attr($postsEditSettingsCountField);?>"
                        min="0"
                        max="99"
                        value="<?php echo esc_attr($postsEditLastUsedCount);?>"
                    >
                </div>

                <div class="col-12">
                    <label><?php esc_html_e('Posts edit prompt templates', 'seoaic');?></label>
                    <div class="seoaic_input_repeater posts_mass_edit_prompt_templates">
                        <div class="prompts-list">
                            <?php echo $postsEditPromptTmpltsHTML_safe;?>
                        </div>
                        <a href="#"
                            class="add-prompt"
                            title="<?php esc_html_e('Add Posts Edit Prompt Template', 'seoaic');?>"
                            data-name="post-edit-prompt-teplate"
                        ><?php esc_html_e('Add Posts Prompt Template', 'seoaic');?></a>
                    </div>
                </div>

                <br><hr/>

                <h2><?php esc_html_e("Post's Review Prompts", 'seoaic');?></h2>

                <div class="col-12">
                    <label for="<?php echo esc_attr($postsReviewSettingsCountField);?>" class="seoaic-cursor-help" title="<?php esc_html_e("Minimum 0 - no prompts are saved, maximum 99.", 'seoaic');?>"><?php esc_html_e("How many last used prompts to remember?", 'seoaic');?></label>
                    <input type="number"
                        id="<?php echo esc_attr($postsReviewSettingsCountField);?>"
                        class="seoaic-form-item form-input light"
                        name="<?php echo esc_attr($postsReviewSettingsCountField);?>"
                        min="0"
                        max="99"
                        value="<?php echo esc_attr($postsReviewLastUsedCount);?>"
                    >
                </div>

                <div class="col-12">
                    <label><?php esc_html_e('Posts edit prompt templates', 'seoaic');?></label>
                    <div class="seoaic_input_repeater posts_mass_review_prompt_templates">
                        <div class="prompts-list">
                            <?php echo $postsReviewPromptTmpltsHTML_safe;?>
                        </div>
                        <a href="#"
                            class="add-prompt"
                            title="<?php esc_html_e('Add Posts Edit Prompt Template', 'seoaic');?>"
                            data-name="post-review-prompt-teplate"
                        ><?php esc_html_e('Add Posts Prompt Template', 'seoaic');?></a>
                    </div>
                </div>

                <div>&nbsp;</div>
            </div>

            <div class="row full-width">
                <div class="col-6 left-side"></div>

                <div class="col-6 right-side">
                    <div class="col-12">
                        <button id="seoaic_submit" type="submit" class="button button-primary seoaic-button-primary"><?php esc_html_e('Save All', 'seoaic');?></button>
                    </div>
                </div>
            </div>

        </form>
        <div class="lds-dual-ring"></div>

    </div>
</div>