<?php

use SEOAIC\SeoaicLeadsAddon;

if (!current_user_can('seoaic_edit_plugin')) {
    return;
}

if (isset($_GET['settings-updated'])) {
    add_settings_error('seoaic_messages', 'seoaic_message', esc_html__('Settings Saved', 'mdsf'), 'updated');
}

settings_errors('seoaic_messages');

$settings = SeoaicLeadsAddon::getSettings();
$emailsSaved = !empty($settings['emails']) ? $settings['emails'] : [];
$emailsForOptions = $emailsSaved;
if (!empty($SEOAIC_OPTIONS['seoaic_api_email'])) {
    $emailsForOptions[] = strip_tags($SEOAIC_OPTIONS['seoaic_api_email']);
}
$emailSubject = !empty($settings['email_subject']) ? $settings['email_subject'] : '';
$currentUser = wp_get_current_user();
$emailsForOptions[] = $currentUser->user_email;
$emailsForOptions = array_unique($emailsForOptions);
$emailTypeSaved = $settings['email_type'];
$emailTypeOptions = ['plain' => 'Plain text', 'html' => 'HTML'];
$iconUrl = !empty($settings['bot_msg_icon']) ? wp_get_attachment_url($settings['bot_msg_icon']) : '';
?>
<form id="seoaic_settings_leads_form"
    class="seoaic-form row full-width"
>
    <input type="hidden" class="seoaic-form-item" name="action" value="seoaic_settings_leads_addon_form_save">

    <div class="row mb-5">
        <div class="col-6">
            <h2><?php esc_html_e("Email settings", 'seoaic');?></h2>
            <div class="mb-10">
                <label for="seoaic_settings_leads_form_email_format"
                    class="seoaic-cursor-help"
                    title="<?php esc_attr_e("Choose the emails format.", 'seoaic');?>"
                ><?php esc_html_e("Email format", 'seoaic');?></label>
                <select
                    id="seoaic_settings_leads_form_email_format"
                    name="email_type"
                    class="seoaic-form-item form-select"
                >
                    <?php
                    foreach ($emailTypeOptions as $value => $label) {
                        $selected = $emailTypeSaved == $value ? ' selected' : '';
                        ?>
                        <option value="<?php esc_attr_e($value);?>"<?php echo esc_attr($selected);?>><?php esc_html_e($label);?></option>
                        <?php
                    }
                    ?>

                </select>
            </div>

            <div class="mb-10">
                <label for="seoaic_settings_leads_form_email_format"
                    class="seoaic-cursor-help"
                    title="<?php esc_attr_e("The email subject.", 'seoaic');?>"
                ><?php esc_html_e("Email subject", 'seoaic');?></label>
                <input type="text"
                    id="seoaic_settings_leads_form_email_subject"
                    name="email_subject"
                    class="seoaic-form-item form-input light"
                    value="<?php echo esc_attr($emailSubject);?>"
                    placeholder="Leads Interactive Form Results"
                >
            </div>

            <div class="mb-10">
                <label for="seoaic_settings_leads_form_emails"
                    class="seoaic-cursor-help"
                    title="<?php esc_attr_e("Choose the emails you want the leads will be sent to.", 'seoaic');?>"
                ><?php esc_html_e("Emails", 'seoaic');?></label>
                <select
                    id="seoaic_settings_leads_form_emails"
                    name="emails"
                    class="seoaic-form-item form-select"
                    multiple
                    required
                >
                <?php
                foreach ($emailsForOptions as $email) {
                    $selected = in_array($email, $emailsSaved) ? ' selected' : '';
                    ?>
                    <option value="<?php esc_attr_e($email);?>"<?php echo esc_attr($selected);?>><?php esc_html_e($email);?></option>
                    <?php
                }
                ?>
                </select>
            </div>
        </div>
    </div>
    <hr/>

    <div class="row">
        <div class="col-6 left-side">
            <h2><?php esc_html_e("Brand colors", 'seoaic');?></h2>

            <div class="row mb-5">
                <div class="col-6 flex-align-center">
                    <label><?php esc_html_e("Lead generator background (form)", 'seoaic');?></label>
                </div>
                <div class="col-6">
                    <input
                        type="hidden"
                        name="seoaic_leads_form_bg"
                        value="<?php echo esc_attr($settings['bg']);?>"
                        class="seoaic-form-item"
                        form="seoaic_settings_leads_form"
                    >
                    <div
                        id="seoaic_leads_form_bg"
                        class="seoaic-settings-color-area"
                        data-color="<?php echo esc_attr($settings['bg']);?>"
                        style="background:<?php echo esc_attr($settings['bg']);?>"
                    ></div>
                </div>
            </div>

            <hr/>

            <div class="row mb-5">
                <div class="col-6 flex-align-center">
                    <label><?php esc_html_e("Bot message background", 'seoaic');?></label>
                </div>
                <div class="col-6">
                    <input
                        type="hidden"
                        name="seoaic_leads_form_bot_msg_bg"
                        value="<?php echo esc_attr($settings['bot_msg_bg']);?>"
                        class="seoaic-form-item"
                        form="seoaic_settings_leads_form"
                    >
                    <div
                        id="seoaic_leads_form_bot_msg_bg"
                        class="seoaic-settings-color-area"
                        data-color="<?php echo esc_attr($settings['bot_msg_bg']);?>"
                        style="background:<?php echo esc_attr($settings['bot_msg_bg']);?>"
                    ></div>
                </div>
            </div>

            <div class="row mb-5">
                <div class="col-6 flex-align-center">
                    <label><?php esc_html_e("Bot message color", 'seoaic');?></label>
                </div>
                <div class="col-6">
                    <input
                        type="hidden"
                        name="seoaic_leads_form_bot_msg_color"
                        value="<?php echo esc_attr($settings['bot_msg_color']);?>"
                        class="seoaic-form-item"
                        form="seoaic_settings_leads_form"
                    >
                    <div
                        id="seoaic_leads_form_bot_msg_color"
                        class="seoaic-settings-color-area"
                        data-color="<?php echo esc_attr($settings['bot_msg_color']);?>"
                        style="background:<?php echo esc_attr($settings['bot_msg_color']);?>"
                    ></div>
                </div>
            </div>

            <hr/>

            <div class="row mb-5">
                <div class="col-6 flex-align-center">
                    <label><?php esc_html_e("User's answer background", 'seoaic');?></label>
                </div>
                <div class="col-6">
                    <input
                        type="hidden"
                        name="seoaic_leads_form_user_msg_bg"
                        value="<?php echo esc_attr($settings['user_msg_bg']);?>"
                        class="seoaic-form-item"
                        form="seoaic_settings_leads_form"
                    >
                    <div
                        id="seoaic_leads_form_user_msg_bg"
                        class="seoaic-settings-color-area"
                        data-color="<?php echo esc_attr($settings['user_msg_bg']);?>"
                        style="background:<?php echo esc_attr($settings['user_msg_bg']);?>"
                    ></div>
                </div>
            </div>

            <div class="row mb-5">
                <div class="col-6 flex-align-center">
                    <label><?php esc_html_e("User's answer color", 'seoaic');?></label>
                </div>
                <div class="col-6">
                    <input
                        type="hidden"
                        name="seoaic_leads_form_user_msg_color"
                        value="<?php echo esc_attr($settings['user_msg_color']);?>"
                        class="seoaic-form-item"
                        form="seoaic_settings_leads_form"
                    >
                    <div
                        id="seoaic_leads_form_user_msg_color"
                        class="seoaic-settings-color-area"
                        data-color="<?php echo esc_attr($settings['user_msg_color']);?>"
                        style="background:<?php echo esc_attr($settings['user_msg_color']);?>"
                    ></div>
                </div>
            </div>


            <h2><?php esc_html_e("Font settings", 'seoaic');?></h2>

            <div class="row mb-5">
                <div class="col-6 flex-align-center">
                    <label><?php esc_html_e("Bot message font size (px)", 'seoaic');?></label>
                </div>
                <div class="col-6 flex-align-center">
                    <input
                        type="hidden"
                        name="seoaic_leads_form_bot_fontsize"
                        value="<?php echo esc_attr($settings['bot_fontsize']);?>"
                        class="seoaic-form-item"
                        form="seoaic_settings_leads_form"
                    >
                    <div
                        id="seoaic_leads_form_bot_fontsize"
                        data-value="<?php echo esc_attr($settings['bot_fontsize']);?>"
                        class="seoaic-settings-single-slider"
                    >
                        <div id="seoaic_leads_form_bot_fontsize_handle" class="ui-slider-handle"></div>
                    </div>
                </div>
            </div>

            <hr/>

            <div class="row mb-5">
                <div class="col-6 flex-align-center">
                    <label><?php esc_html_e("User's answer font size (px)", 'seoaic');?></label>
                </div>
                <div class="col-6 flex-align-center">
                    <input
                        type="hidden"
                        name="seoaic_leads_form_user_fontsize"
                        value="<?php echo esc_attr($settings['user_fontsize']);?>"
                        class="seoaic-form-item"
                        form="seoaic_settings_leads_form"
                    >
                    <div
                        id="seoaic_leads_form_user_fontsize"
                        data-value="<?php echo esc_attr($settings['user_fontsize']);?>"
                        class="seoaic-settings-single-slider"
                    >
                        <div id="seoaic_leads_form_user_fontsize_handle" class="ui-slider-handle"></div>
                    </div>
                </div>
            </div>


            <h2><?php esc_html_e("Border settings", 'seoaic');?></h2>

            <div class="row mb-5">
                <div class="col-6 flex-align-center">
                    <label><?php esc_html_e("Border radius for all items (px)", 'seoaic');?></label>
                </div>
                <div class="col-6 flex-align-center">
                    <input
                        type="hidden"
                        name="seoaic_leads_form_border_radius"
                        value="<?php echo esc_attr($settings['border_radius']);?>"
                        class="seoaic-form-item"
                        form="seoaic_settings_leads_form"
                    >
                    <div
                        id="seoaic_leads_form_border_radius"
                        data-value="<?php echo esc_attr($settings['border_radius']);?>"
                        class="seoaic-settings-single-slider"
                    >
                        <div id="seoaic_leads_form_border_radius_handle" class="ui-slider-handle"></div>
                    </div>
                </div>
            </div>

            <hr/>

            <div class="row mb-5">
                <div class="col-6 flex-align-center">
                    <label><?php esc_html_e("Multistep box borders (px)(color)", 'seoaic');?></label>
                </div>
                <div class="col-6">
                    <div class="row">
                        <div class="col-6 flex-align-center">
                            <input
                                type="hidden"
                                name="seoaic_leads_form_box_border_width"
                                value="<?php echo esc_attr($settings['box_border_width']);?>"
                                class="seoaic-form-item"
                                form="seoaic_settings_leads_form"
                            >
                            <div
                                id="seoaic_leads_form_box_border_width"
                                data-value="<?php echo esc_attr($settings['box_border_width']);?>"
                                class="seoaic-settings-single-slider"
                            >
                                <div id="seoaic_leads_form_box_border_width_handle" class="ui-slider-handle"></div>
                            </div>
                        </div>
                        <div class="col-6">
                            <input
                                type="hidden"
                                name="seoaic_leads_form_box_border_color"
                                value="<?php echo esc_attr($settings['box_border_color']);?>"
                                class="seoaic-form-item"
                                form="seoaic_settings_leads_form"
                            >
                            <div
                                id="seoaic_leads_form_box_border_color"
                                class="seoaic-settings-color-area"
                                data-color="<?php echo esc_attr($settings['box_border_color']);?>"
                                style="background:<?php echo esc_attr($settings['box_border_color']);?>"
                            ></div>
                        </div>
                    </div>

                </div>
            </div>
            <div class="row mb-5">
                <div class="col-6 flex-align-center">
                    <label for="seoaic_leads_form_box_add_shadow"><?php esc_html_e("Multistep box add shadow borders", 'seoaic');?></label>
                </div>
                <div class="col-6">
                    <label class="switch">
                        <input type="checkbox"
                            id="seoaic_leads_form_box_add_shadow"
                            name="seoaic_leads_form_box_add_shadow"
                            class="seoaic-toggle seoaic-form-item"
                            value="on"
                            <?php echo esc_attr("on" == $settings['box_add_shadow'] ? 'checked' : '');?>
                        >
                        <span class="slider round"><span class="seoaic-toggle-value seoaic-toggle-value-1">On</span><span class="seoaic-toggle-value seoaic-toggle-value-2">Off</span></span>
                    </label>
                </div>
            </div>

            <hr/>

            <div class="row mb-5">
                <div class="col-6 flex-align-center">
                    <label><?php esc_html_e("Bot icon borders (px)(color)", 'seoaic');?></label>
                </div>
                <div class="col-6">
                    <div class="row">
                        <div class="col-6 flex-align-center">
                            <input
                                type="hidden"
                                name="seoaic_leads_form_bot_icon_border_width"
                                value="<?php echo esc_attr($settings['bot_icon_border_width']);?>"
                                class="seoaic-form-item"
                                form="seoaic_settings_leads_form"
                            >
                            <div
                                id="seoaic_leads_form_bot_icon_border_width"
                                data-value="<?php echo esc_attr($settings['bot_icon_border_width']);?>"
                                class="seoaic-settings-single-slider"
                            >
                                <div id="seoaic_leads_form_bot_icon_border_width_handle" class="ui-slider-handle"></div>
                            </div>
                        </div>
                        <div class="col-6">
                            <input
                                type="hidden"
                                name="seoaic_leads_form_bot_icon_border_color"
                                value="<?php echo esc_attr($settings['bot_icon_border_color']);?>"
                                class="seoaic-form-item"
                                form="seoaic_settings_leads_form"
                            >
                            <div
                                id="seoaic_leads_form_bot_icon_border_color"
                                class="seoaic-settings-color-area"
                                data-color="<?php echo esc_attr($settings['bot_icon_border_color']);?>"
                                style="background:<?php echo esc_attr($settings['bot_icon_border_color']);?>"
                            ></div>
                        </div>
                    </div>

                </div>
            </div>

            <div class="row mb-5">
                <div class="col-6 flex-align-center">
                    <label><?php esc_html_e("Bot message borders (px)(color)", 'seoaic');?></label>
                </div>
                <div class="col-6">
                    <div class="row">
                        <div class="col-6 flex-align-center">
                            <input
                                type="hidden"
                                name="seoaic_leads_form_bot_msg_border_width"
                                value="<?php echo esc_attr($settings['bot_msg_border_width']);?>"
                                class="seoaic-form-item"
                                form="seoaic_settings_leads_form"
                            >
                            <div
                                id="seoaic_leads_form_bot_msg_border_width"
                                data-value="<?php echo esc_attr($settings['bot_msg_border_width']);?>"
                                class="seoaic-settings-single-slider"
                            >
                                <div id="seoaic_leads_form_bot_msg_border_width_handle" class="ui-slider-handle"></div>
                            </div>
                        </div>
                        <div class="col-6">
                            <input
                                type="hidden"
                                name="seoaic_leads_form_bot_msg_border_color"
                                value="<?php echo esc_attr($settings['bot_msg_border_color']);?>"
                                class="seoaic-form-item"
                                form="seoaic_settings_leads_form"
                            >
                            <div
                                id="seoaic_leads_form_bot_msg_border_color"
                                class="seoaic-settings-color-area"
                                data-color="<?php echo esc_attr($settings['bot_msg_border_color']);?>"
                                style="background:<?php echo esc_attr($settings['bot_msg_border_color']);?>"
                            ></div>
                        </div>
                    </div>

                </div>
            </div>

            <hr/>

            <div class="row mb-5">
                <div class="col-6 flex-align-center">
                    <label><?php esc_html_e("User answer borders (px)(color)", 'seoaic');?></label>
                </div>
                <div class="col-6">
                    <div class="row">
                        <div class="col-6 flex-align-center">
                            <input
                                type="hidden"
                                name="seoaic_leads_form_user_msg_border_width"
                                value="<?php echo esc_attr($settings['user_msg_border_width']);?>"
                                class="seoaic-form-item"
                                form="seoaic_settings_leads_form"
                            >
                            <div
                                id="seoaic_leads_form_user_msg_border_width"
                                data-value="<?php echo esc_attr($settings['user_msg_border_width']);?>"
                                class="seoaic-settings-single-slider"
                            >
                                <div id="seoaic_leads_form_user_msg_border_width_handle" class="ui-slider-handle"></div>
                            </div>
                        </div>
                        <div class="col-6">
                            <input
                                type="hidden"
                                name="seoaic_leads_form_user_msg_border_color"
                                value="<?php echo esc_attr($settings['user_msg_border_color']);?>"
                                class="seoaic-form-item"
                                form="seoaic_settings_leads_form"
                            >
                            <div
                                id="seoaic_leads_form_user_msg_border_color"
                                class="seoaic-settings-color-area"
                                data-color="<?php echo esc_attr($settings['user_msg_border_color']);?>"
                                style="background:<?php echo esc_attr($settings['user_msg_border_color']);?>"
                            ></div>
                        </div>
                    </div>

                </div>
            </div>


            <h2><?php esc_html_e("Icon", 'seoaic');?></h2>

            <div class="row mb-5">
                <div class="seoaic_image_uploader <?php echo $iconUrl ? esc_attr('selected') : '';?>">

                    <div class="image-preview-wrapper">
                        <div class="top">
                            <?php
                            if ($iconUrl) {
                                ?>
                                <img src="<?php echo esc_url($iconUrl);?>">
                                <?php
                            }
                            ?>
                        </div>
                        <div class="bottom">
                            <a href="#"
                                data-upl="<?php esc_attr_e('Select', 'seoaic');?>"
                                class="seoaic-settings-ms-bot-remove-icon-btn"
                                title="<?php esc_attr_e("Remove", "seoaic");?>"
                            >
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-x-circle" viewBox="0 0 16 16">
                                <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"/>
                                <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z"/>
                                </svg>
                            </a>
                            <a href="#"
                                class="change_selected_image seoaic-settings-ms-bot-upload-icon-btn"
                                title="<?php esc_attr_e("Change", "seoaic");?>"
                            ><?php esc_html_e('Change', 'seoaic');?></a>
                        </div>
                    </div>

                    <div class="uploader_buttons_wrapper">
                        <a href="#"
                            class="seoaic-settings-ms-bot-upload-icon-btn"
                            data-change="<?php esc_attr_e('Change', 'seoaic');?>"
                            title="<?php esc_attr_e("Select", "seoaic");?>"
                        ><?php esc_html_e('Select', 'seoaic');?></a>

                        <input type="hidden"
                            name="seoaic_leads_form_bot_msg_icon"
                            class="set_image_id seoaic-form-item"
                            value="<?php echo esc_attr($settings['bot_msg_icon']);?>"
                            data-thumb-id=""
                        >
                    </div>
                </div>
            </div>


            <h2><?php esc_html_e("Progress bar", 'seoaic');?></h2>

            <div class="row mb-5">
                <div class="col-6 flex-align-center">
                    <label><?php esc_html_e("Height (px) / color", 'seoaic');?></label>
                </div>
                <div class="col-6">
                    <div class="row">
                        <div class="col-6 flex-align-center">
                            <input
                                type="hidden"
                                name="seoaic_leads_form_progress_height"
                                value="<?php echo esc_attr($settings['progress_height']);?>"
                                class="seoaic-form-item"
                                form="seoaic_settings_leads_form"
                            >
                            <div
                                id="seoaic_leads_form_progress_height"
                                data-value="<?php echo esc_attr($settings['progress_height']);?>"
                                class="seoaic-settings-single-slider"
                            >
                                <div id="seoaic_leads_form_progress_height_handle" class="ui-slider-handle"></div>
                            </div>
                        </div>
                        <div class="col-6">
                            <input
                                type="hidden"
                                name="seoaic_leads_form_progress_color"
                                value="<?php echo esc_attr($settings['progress_color']);?>"
                                class="seoaic-form-item"
                                form="seoaic_settings_leads_form"
                            >
                            <div
                                id="seoaic_leads_form_progress_color"
                                class="seoaic-settings-color-area"
                                data-color="<?php echo esc_attr($settings['progress_color']);?>"
                                style="background:<?php echo esc_attr($settings['progress_color']);?>"
                            ></div>
                        </div>
                    </div>

                </div>
            </div>

            <div>&nbsp;</div>
            <div class="col-12 seoaic-settings-submit-wrapper">
                <button id="seoaic_submit" type="submit" class="button button-primary seoaic-button-primary"><?php esc_html_e('Save', 'seoaic');?></button>
            </div>
        </div>

        <div class="col-6 right-side">
            <div class="sticky-top">
                <h2><?php esc_html_e("Example preview", 'seoaic');?></h2>

                <div class="col-12">
                    <div
                        class="seoaic-multistep-form
                        seoaic-multistep-form-preview
                        seoaic_leads_form_bg
                        seoaic_leads_form_border_radius
                        seoaic_leads_form_box_border_width
                        seoaic_leads_form_box_border_color
                        seoaic_leads_form_box_add_shadow"
                    >
                        <div class="seoaic-ms-step">
                            <div
                                class="seoaic-ms-bot-icon
                                seoaic_leads_form_bot_msg_bg
                                seoaic_leads_form_border_radius
                                seoaic_leads_form_bot_icon_border_width
                                seoaic_leads_form_bot_icon_border_color"
                            ></div>
                            <div class="seoaic-ms-step-question-wrapper">
                                <h4
                                    class="seoaic-ms-step-question seoaic_leads_form_bot_msg_bg seoaic_leads_form_bot_msg_color seoaic_leads_form_bot_fontsize seoaic_leads_form_border_radius seoaic_leads_form_bot_msg_border_width seoaic_leads_form_bot_msg_border_color"
                                >Step message/question.</h4>
                            </div>
                            <div class="seoaic-ms-step-content">
                                <div
                                    class="seoaic-ms-text-message-wrapper seoaic_leads_form_bot_msg_bg seoaic_leads_form_bot_msg_color seoaic_leads_form_bot_fontsize seoaic_leads_form_border_radius seoaic_leads_form_bot_msg_border_width seoaic_leads_form_bot_msg_border_color"
                                >Step text message. Lorem ipsum dolor sith amet consectetus adipisicing elit.</div>
                            </div>
                        </div>
                        <div class="seoaic-ms-step">
                            <div
                                class="seoaic-ms-bot-icon
                                seoaic_leads_form_bot_msg_bg
                                seoaic_leads_form_border_radius
                                seoaic_leads_form_bot_icon_border_width
                                seoaic_leads_form_bot_icon_border_color"
                            ></div>
                            <div class="seoaic-ms-step-question-wrapper">
                                <h4
                                    class="seoaic-ms-step-question seoaic_leads_form_bot_msg_bg seoaic_leads_form_bot_msg_color seoaic_leads_form_bot_fontsize seoaic_leads_form_border_radius seoaic_leads_form_bot_msg_border_width seoaic_leads_form_bot_msg_border_color"
                                >What's your favorite food?</h4>
                            </div>
                            <div class="seoaic-ms-step-content">
                                <div class="seoaic-ms-multi-items-wrapper">
                                    <label
                                        class="seoaic-ms-multi-item seoaic_leads_form_user_msg_bg seoaic_leads_form_user_msg_color seoaic_leads_form_user_fontsize seoaic_leads_form_border_radius seoaic_leads_form_user_msg_border_width seoaic_leads_form_user_msg_border_color"
                                    >
                                        <input type="checkbox">Pizza
                                    </label>
                                    <label
                                        class="seoaic-ms-multi-item seoaic_leads_form_user_msg_bg seoaic_leads_form_user_msg_color seoaic_leads_form_user_fontsize seoaic_leads_form_border_radius seoaic_leads_form_user_msg_border_width seoaic_leads_form_user_msg_border_color"
                                    >
                                        <input type="checkbox">Burger
                                    </label>
                                    <label
                                        class="seoaic-ms-multi-item seoaic_leads_form_user_msg_bg seoaic_leads_form_user_msg_color seoaic_leads_form_user_fontsize seoaic_leads_form_border_radius seoaic_leads_form_user_msg_border_width seoaic_leads_form_user_msg_border_color"
                                    >
                                        <input type="checkbox">French fries
                                    </label>
                                    <label
                                        class="seoaic-ms-multi-item seoaic_leads_form_user_msg_bg seoaic_leads_form_user_msg_color seoaic_leads_form_user_fontsize seoaic_leads_form_border_radius seoaic_leads_form_user_msg_border_width seoaic_leads_form_user_msg_border_color"
                                    >
                                        <input type="checkbox">Borscht
                                    </label>
                                </div>
                                <div class="seoaic-ms-buttons-wrapper">
                                    <div class="seoaic-ms-buttons-content">
                                        <button
                                            class="seoaic_leads_form_user_msg_bg seoaic_leads_form_user_msg_color seoaic_leads_form_user_fontsize seoaic_leads_form_border_radius seoaic_leads_form_user_msg_border_width seoaic_leads_form_user_msg_border_color"
                                        >Next</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="seoaic-ms-step">
                            <div
                                class="seoaic-ms-bot-icon
                                seoaic_leads_form_bot_msg_bg
                                seoaic_leads_form_border_radius
                                seoaic_leads_form_bot_icon_border_width
                                seoaic_leads_form_bot_icon_border_color"
                            ></div>
                            <div class="seoaic-ms-step-question-wrapper">
                                <h4
                                    class="seoaic-ms-step-question seoaic_leads_form_bot_msg_bg seoaic_leads_form_bot_msg_color seoaic_leads_form_bot_fontsize seoaic_leads_form_border_radius seoaic_leads_form_bot_msg_border_width seoaic_leads_form_bot_msg_border_color"
                                >Leave us your details</h4>
                            </div>
                            <div class="seoaic-ms-step-content">
                                <div class="seoaic-ms-contact-fields-container">
                                    <div
                                        class="seoaic-ms-contact-fields-wrapper seoaic_leads_form_user_msg_bg   seoaic_leads_form_border_radius seoaic_leads_form_user_msg_border_width seoaic_leads_form_user_msg_border_color"
                                    >
                                        <div
                                            class="seoaic-ms-contact-field-content seoaic_leads_form_user_msg_border_width seoaic_leads_form_user_msg_border_color"
                                        >
                                            <label
                                                class="seoaic_leads_form_user_msg_color seoaic_leads_form_user_fontsize"
                                            >Name</label>
                                            <div class="seoaic-input-name-icon seoaic-field-has-icon"><input type="text" class="seoaic-ms-contact-field seoaic_leads_form_border_radius seoaic_leads_form_user_fontsize"></div>

                                        </div>
                                        <div
                                            class="seoaic-ms-contact-field-content seoaic_leads_form_user_msg_border_width seoaic_leads_form_user_msg_border_color"
                                        >
                                            <label
                                                class="seoaic_leads_form_user_msg_color seoaic_leads_form_user_fontsize seoaic_leads_form_user_fontsize"
                                            >Email</label>
                                            <div class="seoaic-input-email-icon seoaic-field-has-icon"><input type="email" class="seoaic-ms-contact-field seoaic_leads_form_border_radius seoaic_leads_form_user_fontsize"></div>
                                        </div>
                                        <div
                                            class="seoaic-ms-contact-field-content seoaic_leads_form_user_msg_border_width seoaic_leads_form_user_msg_border_color"
                                        >
                                            <label
                                                class="seoaic_leads_form_user_msg_color seoaic_leads_form_user_fontsize"
                                            >Phone Number</label>
                                            <div class="seoaic-input-tel-icon seoaic-field-has-icon"><input type="tel" class="seoaic-ms-contact-field seoaic_leads_form_border_radius seoaic_leads_form_user_fontsize"></div>
                                        </div>
                                        <div
                                            class="seoaic-ms-contact-field-content seoaic_leads_form_user_msg_border_width seoaic_leads_form_user_msg_border_color"
                                        >
                                            <label
                                                class="seoaic_leads_form_user_msg_color seoaic_leads_form_user_fontsize"
                                            >Preferred Contact Method</label>
                                            <select class="seoaic-ms-contact-field seoaic_leads_form_border_radius seoaic_leads_form_user_fontsize">
                                                <option value="Phone">Phone</option>
                                                <option value="Email">Email</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="seoaic-ms-buttons-wrapper">
                                    <div class="seoaic-ms-buttons-content">
                                        <button
                                            class="seoaic_leads_form_user_msg_bg seoaic_leads_form_user_msg_color seoaic_leads_form_user_fontsize seoaic_leads_form_border_radius seoaic_leads_form_user_msg_border_width seoaic_leads_form_user_msg_border_color"
                                        >Submit</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div
                            class="seoaic-multistep-progress
                            seoaic_leads_form_progress_height
                            seoaic_leads_form_progress_color"
                        ></div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</form>