<?php

use SEOAIC\SEOAIC;
use SEOAIC\SEOAIC_SETTINGS;
use SEOAIC\shortcodes\PostThumbnail;

if (!current_user_can('seoaic_edit_plugin')) {
    return;
}

if (isset($_GET['settings-updated'])) {
    add_settings_error('seoaic_messages', 'seoaic_message', esc_html__('Settings Saved', 'mdsf'), 'updated');
}

settings_errors('seoaic_messages');

$header = SEOAIC_SETTINGS::getCustomTemplateHeaderId();
$footer = SEOAIC_SETTINGS::getCustomTemplateFooterId();
$content = SEOAIC_SETTINGS::getCustomTemplateContent();
$css = SEOAIC_SETTINGS::getCustomTemplateCSS();

?>
<form id="seoaic_settings_custom_template"
    class="seoaic-form row full-width seoaic-prompts-settings-form"
>
    <input type="hidden"
        class="seoaic-form-item"
        name="action"
        value="seoaic_settings_custom_template_save"
    >

    <div class="row mb-10">
        <div class="col-6">
            <h2><?php esc_html_e("Content", 'seoaic');?></h2>

            <div class="col-12">
                <input type="hidden"
                    name="seoaic_custom_template_content"
                    id="seoaic_custom_template_content"
                    class="seoaic-form-item"
                    value="<?php echo esc_attr($content);?>"
                >
                <div id="seoaic_custom_template_content_wrapper" class="seoaic-codemirror"></div>
                <div class="seoaic-text-right">
                    <a href="#" class="small seoaic-custom-template-content-reset"><?php esc_html_e("Reset to default", "seoaic");?></a>
                </div>
                <div class="seoaic-field-description">
                    <b><?php esc_html_e('Shortcodes:', "seoaic");?></b>
                    <br>
                    <br><code>[seoai_post_thumbnail size="large" class=""]</code> - <?php esc_html_e("Outputs post's thumbnail image.", "seoaic");?>
                    <br><?php esc_html_e("Attributes:", "seoaic");?>
                    <br>- <i>size</i> : <?php esc_html_e("Image size. Available sizes:", "seoaics");?> <i>'<?php echo wp_kses(implode("'</i>, <i>'", PostThumbnail::getSizes()), ["i" => []]);?></i>''. <?php esc_html_e("Default value:", "seoaic");?> <i>'medium_large'</i>. <a href="https://codex.wordpress.org/Post_Thumbnails#Thumbnail_Sizes" target="_blank">Doc</a>.
                    <br>- <i>class</i> : <?php esc_html_e("CSS class names separated by whitespace.", "seoaic");?>
                    <br>
                    <br><code>[seoai_post_title class=""]</code> - <?php esc_html_e("Outputs post's title wrapped with H1 tags.", "seoaic");?>
                    <br><?php esc_html_e("Attributes:", "seoaic");?>
                    <br>- <i>class</i> : <?php esc_html_e("CSS class names separated by whitespace.", "seoaic");?>
                    <br>
                    <br><code>[seoai_post_author postedByText="Posted by:"]</code> - <?php esc_html_e("Outputs post's author link.", "seoaic");?>
                    <br><?php esc_html_e("Attributes:", "seoaic");?>
                    <br>- <i>postedByText</i> : <?php esc_html_e("Hidden text read by screen readers.", "seoaic");?>
                    <br>
                    <br><code>[seoai_post_published format="Y-m-d H:i"]</code> - <?php esc_html_e("Post pusblished date.", "seoaic");?>
                    <br><?php esc_html_e("Attributes:", "seoaic");?>
                    <br>- <i>format</i> : <?php esc_html_e("Date format. Default format is taken from", "seoaic");?> <a href="<?php echo esc_url(SEOAIC::getAdminUrl('options-general.php'));?>" target="_blank">WP Settings</a>. <a href="https://wordpress.org/documentation/article/customize-date-and-time-format/" target="_blank">Formats</a>.
                    <br>
                    <br><code>[seoai_post_updated format="Y-m-d H:i" updatedText="Updated:"]</code> - <?php esc_html_e("Post last updated date.", "seoaic");?>
                    <br><?php esc_html_e("Attributes:", "seoaic");?>
                    <br>- <i>format</i> : <?php esc_html_e("Date format. Default format is taken from", "seoaic");?> <a href="<?php echo esc_url(SEOAIC::getAdminUrl('options-general.php'));?>" target="_blank">WP Settings</a>. <a href="https://wordpress.org/documentation/article/customize-date-and-time-format/" target="_blank">Formats</a>.
                    <br>- <i>updatedText</i> : <?php esc_html_e("Text that goes before the date.", "seoaic");?>
                    <br>
                    <br><code>[seoai_post_content]</code> - <?php esc_html_e("Outputs post's content.", "seoaic");?>
                    <br>
                    <br><code>[seoai_posts_archive_link class="" linkText="More SEO AI posts"]</code> - <?php esc_html_e("Link to the SEO AI posts archive page.", "seoaic");?>
                    <br><?php esc_html_e("Attributes:", "seoaic");?>
                    <br>- <i>class</i> : <?php esc_html_e("CSS class names separated by whitespace.", "seoaic");?>
                    <br>- <i>linkText</i> : <?php esc_html_e("Link text. Default value: \"More SEO AI posts\"", "seoaic");?>.
                </div>
            </div>
        </div>

        <div class="col-6">
            <h2><?php esc_html_e("CSS Styles", 'seoaic');?></h2>

            <div class="col-12">
                <input type="hidden"
                    name="seoaic_custom_template_css"
                    id="seoaic_custom_template_css"
                    class="seoaic-form-item"
                    value="<?php echo esc_attr($css);?>"
                >
                <div id="seoaic_custom_template_css_wrapper" class="seoaic-codemirror"></div>
                <div class="seoaic-text-right">
                    <a href="#" class="small seoaic-custom-template-css-reset"><?php esc_html_e("Reset to default", "seoaic");?></a>
                </div>
            </div>
        </div>

        <div class="col-6">
            <h2><?php esc_html_e("Header", 'seoaic');?></h2>

            <div class="col-12">
                <label for="seoaic_custom_template_header_id" class="seoaic-cursor-help"><?php esc_html_e("Header name", 'seoaic');?></label>
                <input type="text"
                    id="seoaic_custom_template_header_id"
                    class="seoaic-form-item form-input light"
                    name="seoaic_custom_template_header_id"
                    value="<?php echo esc_attr($header);?>"
                >
                <div class="seoaic-field-description">
                    <?php esc_html_e('If specified then a specialized header will be included, e.g. file is called "header-special.php" then specify "special".', "seoaic");?>
                    <br><?php esc_html_e('Leave empty to use a default header.', "seoaic");?>
                </div>
            </div>
        </div>

        <div class="col-6 right-side">
            <h2><?php esc_html_e("Footer", 'seoaic');?></h2>

            <div class="col-12">
                <label for="seoaic_custom_template_footer_id" class="seoaic-cursor-help"><?php esc_html_e("Footer name", 'seoaic');?></label>
                <input type="text"
                    id="seoaic_custom_template_footer_id"
                    class="seoaic-form-item form-input light"
                    name="seoaic_custom_template_footer_id"
                    value="<?php echo esc_attr($footer);?>"
                >
                <div class="seoaic-field-description">
                    <?php esc_html_e('If specified then a specialized footer will be included, e.g. file is called "footer-special.php" then specify "special".', "seoaic");?>
                    <br><?php esc_html_e('Leave empty to use a default footer.', "seoaic");?>
                </div>
            </div>
        </div>

        <div class="col-6"></div>

        <div class="col-6 seoaic-settings-submit-wrapper">
            <button id="seoaic_submit" type="submit" class="button button-primary seoaic-button-primary"><?php esc_html_e('Save', 'seoaic');?></button>
        </div>

    </div>
</form>