<?php

if (!current_user_can('seoaic_edit_plugin')) {
    return;
}

global $SEOAIC_OPTIONS, $SEOAIC;

if (isset($_GET['settings-updated'])) {
    add_settings_error('seoaic_messages', 'seoaic_message', esc_html__('Settings Saved', 'mdsf'), 'updated');
}

$savedSettings = $SEOAIC->settings->contentAlertsLoad();
if (!empty($savedSettings['error'])) {
    add_settings_error('seoaic_messages', 'seoaic_message', $savedSettings['error'], 'error');
}

settings_errors('seoaic_messages');

$alertsEnabled  = !empty($savedSettings['status']) && 'enabled' == $savedSettings['status'];
$clicksCount    = !empty($savedSettings['clicks']) ? $savedSettings['clicks'] : 5;
$timeframe      = !empty($savedSettings['timeframe']) ? $savedSettings['timeframe'] : 7;
$emailsSaved    = !empty($savedSettings['emails']) ? $savedSettings['emails'] : [];
$emailsForOptions = $emailsSaved;
if (!empty($SEOAIC_OPTIONS['seoaic_api_email'])) {
    $emailsForOptions[] = strip_tags($SEOAIC_OPTIONS['seoaic_api_email']);
}
$current_user = wp_get_current_user();
$emailsForOptions[] = $current_user->user_email;
$emailsForOptions = array_unique($emailsForOptions);

?>
<div id="seoaic_settings_content_alerts"
    class="row full-width"
>
    <h3><?php esc_html_e("Here you can set up how you want receive alerts when specific pieces of content start gaining traction, so that you can focus on optimizing posts that have the potential to rank better and drive traffic.", "seoaic");?></h3>

    <div class="col-6 left-side">
        <form
            class="seoaic-form seoaic-prompts-settings-form"
            id="seoaic_settings_content_alerts_form"
        >
            <input type="hidden"
                class="seoaic-form-item"
                name="action"
                value="seoaic_settings_content_alerts_save">
            <div class="flex-justify seoaic-w-100">
                <div class="d-flex seoaic-single-row-switcher">
                    <div class="toggle-choose-server">
                        <label class="switch">
                            <input type="checkbox"
                                id="seoaic_enable_content_alerts"
                                name="seoaic_enable_content_alerts"
                                class="seoaic-toggle seoaic-form-item"
                                value="1"
                                <?php echo esc_attr($alertsEnabled ? 'checked' : '');?>
                            >
                            <span class="slider round"><span
                                        class="seoaic-toggle-value seoaic-toggle-value-1">On</span><span
                                        class="seoaic-toggle-value seoaic-toggle-value-2">Off</span></span>
                        </label>
                    </div>
                    <label for="seoaic_enable_content_alerts"><?php esc_html_e('Enable content alerts', 'seoaic');?></label>
                </div>
            </div>

            <div class="col-12">
                <label for="seoaic_content_alert_clicks_threshold"
                    class="seoaic-cursor-help123"
                    title="<?php esc_attr_e("", 'seoaic');?>"
                ><?php esc_html_e("Clicks threshold per the timeframe", 'seoaic');?></label>
                <input type="number"
                    id="seoaic_content_alert_clicks_threshold"
                    class="seoaic-form-item form-input light"
                    name="content_alert_clicks_threshold"
                    min="1"
                    value="<?php echo esc_attr($clicksCount);?>"
                    required
                >
                <div class="seoaic-content-alerts-clicks-btns-wrapper d-flex gap-10 mt-5">
                    <?php
                    $clicksButtons = [2, 5, 10, 20, 50, 100, 200, 500, 1000];
                    for ($i = 0, $count = count($clicksButtons); $i < $count; $i++) {
                        ?>
                        <button type="button"
                            class="seoaic-content-alerts-input-btn"
                            data-for="seoaic_content_alert_clicks_threshold"
                        ><?php esc_html_e($clicksButtons[$i]);?></button>
                        <?php
                    }
                    ?>
                </div>
            </div>

            <div class="col-12">
                <label for="seoaic_content_alert_days_timeframe"
                    class="seoaic-cursor-help123"
                    title="<?php esc_attr_e("", 'seoaic');?>"
                ><?php esc_attr_e("Timeframe (days)", 'seoaic');?></label>
                <input type="number"
                    id="seoaic_content_alert_days_timeframe"
                    class="seoaic-form-item form-input light"
                    name="content_alert_days_timeframe"
                    min="1"
                    value="<?php echo esc_attr($timeframe);?>"
                    required
                >
                <div class="seoaic-content-alerts-days-btns-wrapper d-flex gap-10 mt-5">
                    <?php
                    $daysButtons = [3, 5, 7, 10, 14, 21, 30, 50, 60, 90, 100, 365];
                    for ($i = 0, $count = count($daysButtons); $i < $count; $i++) {
                        ?>
                        <button type="button"
                            class="seoaic-content-alerts-input-btn"
                            data-for="seoaic_content_alert_days_timeframe"
                        ><?php esc_html_e($daysButtons[$i]);?></button>
                        <?php
                    }
                    ?>
                </div>
            </div>

            <div class="col-12">
                <label for="seoaic_content_alert_emails"
                    class="seoaic-cursor-help"
                    title="<?php esc_attr_e("Choose the emails you want the alert will be sent to.", 'seoaic');?>"
                ><?php esc_html_e("Emails", 'seoaic');?></label>
                <select
                    id="seoaic_content_alert_emails"
                    name="content_alert_emails"
                    class="seoaic-form-item form-select"
                    multiple
                    required
                >
                <?php
                foreach ($emailsForOptions as $email) {
                    $selected = in_array($email, $emailsSaved) ? ' selected' : '';
                    ?>
                    <option value="<?php esc_attr_e($email);?>"<?php echo esc_attr($selected);?>><?php esc_html_e($email);?></option>
                    <?php
                }
                ?>
                </select>
            </div>
        </form>
        <div>&nbsp;</div>
    </div>

    <div class="col-6 right-side"></div>

    <div class="col-6 left-side">
        <div class="col-12">
            <button type="submit"
                id="seoaic_submit"
                class="button button-primary seoaic-button-primary"
                form="seoaic_settings_content_alerts_form"
            ><?php esc_html_e('Save', 'seoaic');?></button>
        </div>
    </div>

    <div class="col-6 right-side"></div>
</div>
