<?php
if (!current_user_can('seoaic_edit_plugin')) {
    return;
}

if (isset($_GET['settings-updated'])) {
    add_settings_error('seoaic_messages', 'seoaic_message', esc_html__('Settings Saved', 'mdsf'), 'updated');
}

settings_errors('seoaic_messages');
?>
<div id="seoaic-admin-container" class="wrap">
    <h1 id="seoaic-admin-title">
        <?php
        echo wp_kses(seoai_get_logo('logo.svg'), [
            'img' => [
                'title' => [],
                'src'	=> [],
                'alt'	=> [],
            ],
        ]);
        ?>
        <span>
            <?php echo esc_html(get_admin_page_title()); ?>
        </span>
    </h1>
    <div id="seoaic-admin-body">
        <div class="inner-login registration">
            <h2 class="tc"><?php esc_html_e('Set your info', 'seoaic');?></h2>
            <div class="tc"></div>
            <form id="seoaic-login" class="seoaic-form" name="seoaic-setinfo" method="post" data-callback="window_href_seoaic">
                <input type="hidden" class="seoaic-form-item" name="action" value="seoaic_setinfo">

                <div class="col-12">
                    <label for="seoaic_business_name"><?php esc_html_e('Company name', 'seoaic');?></label>
                    <input id="seoaic_business_name" class="seoaic-form-item form-input" name="seoaic_business_name" type="text" required value="<?php echo !empty($SEOAIC_OPTIONS['seoaic_business_name']) ? esc_attr($SEOAIC_OPTIONS['seoaic_business_name']) : esc_attr(get_option('blogname', true));?>">
                </div>

                <div class="col-12">
                    <label for="seoaic_phone"><?php esc_html_e('Phone', 'seoaic');?></label>
                    <input id="seoaic_phone" class="seoaic-form-item form-input" name="seoaic_phone"
                           type="tel" required value="<?php echo !empty($SEOAIC_OPTIONS['seoaic_phone']) ? esc_attr($SEOAIC_OPTIONS['seoaic_phone']) : '';?>">
                </div>

                <div class="col-12">
                    <label for="seoaic_location"><?php esc_html_e('Country', 'seoaic');?></label>
                    <select id="seoaic_location" class="seoaic-form-item form-input mb-19"
                            name="seoaic_location"
                            required>
                        <?php
                        $locations = seoaic_get_locations();
                        $selected_location = !empty($SEOAIC_OPTIONS['seoaic_location']) ? $SEOAIC_OPTIONS['seoaic_location'] : 'United States';

                        foreach ($locations as $key => $location) :
                            ?>
                            <option value="<?php echo esc_attr($location);?>"
                                <?php echo ($location === $selected_location) ? 'selected' : '';?>
                            ><?php echo esc_html($location);?></option>
                            <?php
                        endforeach; ?>
                    </select>
                </div>

                <div class="col-12">
                    <button id="seoaic_submit" type="submit" class="button-primary seoaic-button-primary"><?php esc_html_e('Save', 'seoaic');?></button>
                </div>

            </form>
        </div>
        <div class="lds-dual-ring"></div>
    </div>
</div>