<?php
if (!current_user_can('seoaic_edit_plugin')) {
    return;
}

if (isset($_GET['settings-updated'])) {
    add_settings_error('seoaic_messages', 'seoaic_message', esc_html__('Settings Saved', 'mdsf'), 'updated');
}

settings_errors('seoaic_messages');

global $SEOAIC, $SEOAIC_OPTIONS;

?>
<div id="seoaic-admin-container" class="wrap seoaic-audit-page">
    <h1 id="seoaic-admin-title">
        <?php
        echo wp_kses(seoai_get_logo('logo.svg'), [
            'img' => [
                'title' => [],
                'src'	=> [],
                'alt'	=> [],
            ],
        ]);
        ?>
        <div class="seoaic-admin-title-subtitle">
            <span><?php echo esc_html(get_admin_page_title());?></span>
            <?php
            if (
                !empty($_GET['page'])
                && "seoaic-settings" == $_GET['page']
            ) {
                ?>
                <span class="seoaic-admin-title-version">Version <?php echo esc_html(get_plugin_data(SEOAIC_FILE)['Version']); ?></span>
                <?php
            }
            ?>
        </div>
    </h1>
    <?php
    echo wp_kses($SEOAIC->get_background_process_loader(true), [
        'div' => [
            'id'    => [],
            'class' => [],
            'style' => [],
            'title' => [],
        ],
        'p' => [
            'class' => [],
        ],
        'b' => [],
        'button' => [
            'type'              => [],
            'class'             => [],
            'data-modal'        => [],
            'data-action'       => [],
            'data-form-callback' => [],
            'data-content'      => [],
        ],
    ]);
    ?>

    <div id="seoaic-admin-body" class="columns-2 seoaic-with-loader tab-sections seo-audit-page">
        <div class="seoaic-admin-sidebar">
            <div class="page-title">
                <h1><?php esc_html_e('Site Audit', 'seoaic');?>: <span><?php echo esc_html($_SERVER['SERVER_NAME']);?></span></h1>
                <div class="buttons-wrapper">
                    <div class="d-flex">
                        <button class="button-primary seoaic-button-primary seoaic_check_broken_links" data-title="<?php esc_html_e('Check broken links', 'seoaic');?>"><?php esc_html_e('Check broken links', 'seoaic');?></button>
                        <button class="seoaic_audit_btn seoaic_create_audit" data-title="<?php esc_html_e('Scan now', 'seoaic');?>"><?php esc_html_e('Scan now', 'seoaic');?></button>
                    </div>
                </div>
            </div>

            <div class="seoaic-warning-wrapper">
                <div class="seoaic-warning-box">
                    <div class="seoaic-warning-icon">
                        <span class="dashicons dashicons-info"></span>
                    </div>
                    <div class="seoaic-warning-content">
                        <div class="seoaic-warning-content-info">
                            <p><?php esc_html_e('Notice: Site Audit May Affect Site Performance', 'seoaic'); ?></p>
                            <p>
                            <?php
                                printf(
                                    esc_html__('We are currently performing a full website audit that may take up to %1$s. During this time, your site may experience %2$s or %3$s, especially on limited hosting environments.', 'seoaic'),
                                    '<strong>30 minutes</strong>',
                                    '<em>' . esc_html__('temporary load increases', 'seoaic') . '</em>',
                                    '<em>' . esc_html__('slower performance', 'seoaic') . '</em>'
                                );
                            ?>
                            </p>
                            <p><?php esc_html_e('This is a fully automated process and no changes will be made to your website. The scan will complete automatically.', 'seoaic'); ?></p>
                        </div>
                        <button type="button" class="seoaic-button-primary start-audit-btn seoaic_create_audit" title="<?php esc_html_e('Start Audit', 'seoaic'); ?>">
                            <span class="dashicons dashicons-update"></span>
                            <?php esc_html_e('Start Audit', 'seoaic'); ?>
                        </button>
                    </div>
                </div>
            </div>

            <div class="progress-container" >
                <ul>
                    <li>
                        <p><?php esc_html_e('Max Crawl Pages', 'seoaic'); ?>:</p>
                        <div id="progress-max-crawl-pages"><span>0</span></div>
                    </li>
                    <li>
                        <p><?php esc_html_e('Pages in Queue', 'seoaic');?>:</p>
                        <div id="progress-pages-in-queue"><span>0</span></div>
                    </li>
                    <li>
                        <p><?php esc_html_e('Pages Crawled', 'seoaic');?>:</p>
                        <div id="progress-pages-crawled"><span>0</span></div>
                    </li>
                </ul>

                <h2 id="progress-status-message"><span><?php esc_html_e('In progress...', 'seoaic');?></span></h2>
                <div class="progress-bar-wrap">
                    <div id="audit-progress-bar"></div>
                </div>
            </div>

            <div class="audit-container">
                <div class="menu-section">
                    <ul>
                        <li>
                            <a class="overview tab" data-tab="overview" href="#overview"><?php esc_html_e('Overview', 'seoaic');?></a>
                        </li>
                        <li>
                            <a class="issues tab" data-tab="issues" href="#issues"><?php esc_html_e('Issues', 'seoaic');?></a>
                        </li>
                        <li>
                            <a class="crawled-pages tab" data-tab="crawled-pages" href="#crawled-pages"><?php esc_html_e('Crawled pages', 'seoaic');?></a>
                        </li>
                        <li>
                            <a class="page-speed-analysis tab" data-tab="page-speed-analysis" href="#page-speed-analysis"><?php esc_html_e('Page speed', 'seoaic');?></a>
                        </li>
                    </ul>
                </div>
                <?php
                    include_once(SEOAIC_DIR . 'inc/view/tabs/overview-tab.php');
                    include_once(SEOAIC_DIR . 'inc/view/tabs/issues-tab.php');
                    include_once(SEOAIC_DIR . 'inc/view/tabs/crawled-pages-tab.php');
                    include_once(SEOAIC_DIR . 'inc/view/tabs/page-speed-tab.php');
                    // include_once(SEOAIC_DIR . 'inc/view/tabs/statistics-tab.php');
                    // include_once(SEOAIC_DIR . 'inc/view/tabs/compare-crawls-tab.php');
                ?>
            </div>
        </div>
</div>