<?php
if (!current_user_can('seoaic_edit_plugin')) {
    return;
}

if (isset($_GET['settings-updated'])) {
    add_settings_error('seoaic_messages', 'seoaic_message', __('Settings Saved', 'mdsf'), 'updated');
}

global $SEOAIC, $SEOAIC_OPTIONS;
?>

<div id="seoaic-admin-container" class="wrap">
    <h1 class="hidden-notice-title" style="display: none"></h1>
    <h3 id="seoaic-admin-title">
        <?php echo seoai_get_logo('logo.svg'); ?>
        <span>
            <?php echo esc_html(get_admin_page_title()); ?>
        </span>
    </h3>
    <div id="seoaic-admin-body" class="seoaic-streamlined-onboarding seoaic-streamlined-onboarding-clusters seoaic-with-loader wizard bg-wizard" data-home-url="<?php echo esc_url(home_url()); ?>">
        <div class="inner">
            <div id="seoaic-streamlined-onboarding" class="content">
                <div class="step-container keywords" data-step="' . esc_attr($step) . '">
                    <div class="step-content wait-for-ajaxcontent">
                        <?php ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="lds-dual-ring"></div>
    </div>
</div>