<?php
if (!current_user_can('seoaic_edit_plugin')) {
    return;
}

if (isset($_GET['settings-updated'])) {
    add_settings_error('seoaic_messages', 'seoaic_message', esc_html__('Settings Saved', 'mdsf'), 'updated');
}

settings_errors('seoaic_messages');
?>
<div id="seoaic-admin-container" class="wrap">
    <h1 id="seoaic-admin-title">
        <?php
        echo wp_kses(seoai_get_logo('logo.svg'), [
            'img' => [
                'title' => [],
                'src'	=> [],
                'alt'	=> [],
            ],
        ]);
        ?>
        <span>
            <?php echo esc_html(get_admin_page_title()); ?>
        </span>
    </h1>
    <div id="seoaic-admin-body" class="seoaic-toggle-container">
        <div class="inner-login login">
            <h2 class="tc"><?php esc_html_e('Log in', 'seoaic');?></h2>
            <div class="tc"><?php esc_html_e('Have no account?', 'seoaic');?> <a href="<?php echo esc_url(get_admin_url());?>admin.php?page=seoaic&subpage=seoaic-registration"><?php esc_html_e('Sign up', 'seoaic');?></a>
            </div>
            <form id="seoaic-login" class="seoaic-form" name="seoaic-login" method="post" data-callback="window_href_setinfo">
                <input type="hidden" class="seoaic-form-item" name="action" value="seoaic_login">

                <div class="col-12">
                    <label for="seoaic_email"><?php esc_html_e('E-mail', 'seoaic');?></label>
                    <input id="seoaic_email" class="seoaic-form-item form-input" name="email" type="email" required>
                </div>

                <div class="col-12">
                    <label for="seoaic_password" class="db"><?php esc_html_e('Password', 'seoaic');?> <a class="gradient-link fr" href="<?php echo esc_url(get_admin_url());?>admin.php?page=seoaic&subpage=seoaic-forgot"><?php esc_html_e('Forgot?', 'seoaic');?></a></label>
                    <input id="seoaic_password" class="seoaic-form-item form-input" name="password" type="password" required>
                </div>

                <div class="col-12">
                    <button id="seoaic_submit" type="submit" class="button-primary seoaic-button-primary"><?php esc_html_e('Log in', 'seoaic');?></button>
                </div>
            </form>
        </div>
        <div class="lds-dual-ring"></div>
    </div>
</div>