<?php
if (!current_user_can('seoaic_edit_plugin')) {
    return;
}

$checkActionCreate = false;

if (isset($_GET['action']) && $_GET['action'] === 'create') {
    $checkActionCreate = true;
}

$activeClass = 'hide';

if (!$checkActionCreate) {
    $activeClass = 'show';
}

global $SEOAIC;
?>
<div id="seoaic-admin-container" class="wrap">
    <h1 id="seoaic-admin-title">
        <?php
        echo wp_kses(seoai_get_logo('logo.svg'), [
            'img' => [
                'title' => [],
                'src'	=> [],
                'alt'	=> [],
            ],
        ]);
        ?>
        <span>
            <?php echo esc_html(get_admin_page_title()); ?>
        </span>
    </h1>
    <?php
        $loader_content = $SEOAIC->get_background_process_loader();
        if (!empty($loader_content)) {
            echo wp_kses($loader_content, [
                'div' => [
                    'id'    => [],
                    'class' => [],
                    'style' => [],
                    'title' => [],
                ],
                'p' => [
                    'class' => [],
                ],
                'b' => [],
                'button' => [
                    'type'              => [],
                    'class'             => [],
                    'data-modal'        => [],
                    'data-action'       => [],
                    'data-form-callback' => [],
                    'data-content'      => [],
                ],
            ]);
        }
    ?>
    <div id="seoaic-admin-body" class="seoaic-with-loader knowledge-bases">
        <div class="inner">

            <div class="top">
                <button type="button" class="button-primary seoaic-button-primary seoaic-create-kb-button" data-action="create">
                    <?php esc_html_e('+ Create An AI Knowledge Base') ?>
                </button>
            </div>

            <div class="bottom" id="knowledge_base">
                <div class="flex-table">
                    <div class="row-line heading">
                        <div class="name">
                            <?php esc_html_e('Name') ?>
                        </div>
                        <div class="description">
                            <?php esc_html_e('Description') ?>
                        </div>
                        <div class="status">
                            <?php esc_html_e('Status') ?>
                        </div>
                        <div class="tokens">
                            <?php esc_html_e('Tokens') ?>
                        </div>
                        <div class="actions">
                            <?php esc_html_e('Actions') ?>
                        </div>
                    </div>

                </div>
            </div>

        </div>

        <div class="knowledge-base-content" style="display: none;">
            <div class="knowledge-base-item">
                <div class="knowledge-base-head">
                    <h3><span>/01</span><?php esc_html_e('Basic Information', 'seoaic') ?></h3>
                    <p><?php esc_html_e('Basic information about your  AI knowledge base.', 'seoaic') ?></p>
                </div>
                <div class="knowledge-base-body">
                    <form action="" id="knowledge-base-form">
                        <div class="form-item">
                            <label for="knowledge-base-name"><?php esc_html_e('Name *', 'seoaic') ?></label>
                            <input type="text" id="knowledge-base-name" name="knowledge-base-name" require>
                        </div>
                        <div class="form-item">
                            <label for="knowledge-base-description"><?php esc_html_e('Description', 'seoaic') ?></label>
                            <textarea name="knowledge-base-description" id="knowledge-base-description" rows="4"></textarea>
                        </div>

                        <?php if ($checkActionCreate) { ?>
                            <div class="form-item-bottom">
                                <button type="button" class="button-primary seoaic-button-primary seoaic-save-kb-button" data-action="edit">
                                    <?php esc_html_e('Create Knowledge Base') ?>
                                </button>
                            </div>
                        <?php } else { ?>
                            <div class="form-item-bottom">
                                <button type="button" class="button-primary seoaic-button-primary seoaic-save-kb-action" data-action="edit">
                                    <?php esc_html_e('Save Knowledge Base') ?>
                                </button>
                            </div>
                        <?php } ?>
                    </form>
                </div>
            </div>

            <?php if (!$checkActionCreate) { ?>
            <div class="knowledge-base-item knowledge-base-data-source">
                <div class="knowledge-base-head">
                    <h3><span>/02</span><?php esc_html_e('Data Sources', 'seoaic') ?></h3>
                    <p><?php esc_html_e('Please add the sources you want to use for your knowledge base. You can use either pages, domains or plain text.', 'seoaic') ?></p>
                </div>
                <div class="knowledge-base-body">
                    <p><?php esc_html_e('Add or edit your knowledge base below.', 'seoaic') ?></p>

                    <form class="data-sources-wrap" id="data-sources">

                        <div class="data-sources-item data-sources-item-main data-sources-item-new">
                            <div class="actions">
                                <button title="Remove" type="button" class="seoaic-remove seoaic-remove_data_source-itm"></button>
                            </div>
                            <div class="data-sources-head">
                                <ul>
                                    <?php /* <li class="active"><?php esc_html_e('Domain', 'seoaic') ?></li> */ ?>
                                    <li class="active"><?php esc_html_e('Page', 'seoaic') ?></li>
                                    <li><?php esc_html_e('Text', 'seoaic') ?></li>
                                    <li class="ai-summary"><?php esc_html_e('AI summary', 'seoaic') ?></li>
                                </ul>
                                <?php /* <div class="data-sources-content-wrap active">
                                    <div class="data-sources-content">
                                        <div class="form-item seoaic-form-item-url">
                                            <label for="data-sources-domain"><?php esc_html_e('URL / Domain', 'seoaic') ?></label>
                                            <div class="data-sources-domain-wrap">
                                                <span></span>
                                                <input type="url" name="data-sources-domain" class="data_source_item data_source_url" data-mode="domain">
                                            </div>
                                        </div>
                                        <div class="form-item form-item-pages">
                                            <label for="data-sources-pages"><?php esc_html_e('Max pages', 'seoaic') ?></span></label>
                                            <input type="number" name="data-sources-pages" class="data_source_item data_source_max_pages" min="10" value="10">
                                        </div>
                                    </div>
                                </div>
                                */ ?>
                                <div class="data-sources-content-wrap active">
                                    <div class="data-sources-content">
                                        <div class="form-item seoaic-form-item-url">
                                            <label for="data-sources-page"><?php esc_html_e('URL / Page', 'seoaic') ?></label>
                                            <div class="data-source-wrapper d-flex">
                                                <div class="data-sources-domain-wrap">
                                                    <span></span>
                                                    <input type="url" name="data-sources-page" class="data_source_item data_source_url" data-mode="page">
                                                </div>
                                                <div class="page-actions d-flex">
                                                    <button title="<?php esc_html_e('Remove item', 'seoaic') ?>" type="button" class="seoaic-page-action seoaic-page-remove-action">-</button>
                                                    <button title="<?php esc_html_e('Add item', 'seoaic') ?>" type="button" class="seoaic-page-action seoaic-page-add-action">+</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="data-sources-content-wrap">
                                    <div class="data-sources-content">
                                        <div class="form-item seoaic-form-item-url textarea-container">
                                            <label for="data-sources-text"><?php esc_html_e('Text area', 'seoaic') ?></span></label>
                                            <div class="data-sources-domain-wrap">
                                                <textarea name="data-sources-text" class="data_source_item data_source_item_text" data-mode="text" data-counter-id="text-0" rows="4"></textarea>
                                            </div>
                                            <div class="counter-wrap">
                                                <div class="counter" data-count-id="text-0"></div>
                                                <div class="info">
                                                    <span class="info-btn">?</span>
                                                    <div class="info-content"><p></p></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="data-sources-content-wrap">
                                    <div class="data-sources-content">
                                        <div class="form-item seoaic-form-item-url ai-summary-container">
                                            <div class="data-sources-ai-summary data-sources-ai-summary-content">
                                                <h3><?php echo esc_html_e('AI summary has not been generaed yet', 'seoaic') ?></h3>
                                                <p><?php esc_html_e('AI summary is generated by scanning the pages set in the "Page" tab and processing them with Al to extract only the relevan information. The summary then becomes an editable text source that can be added to the knowledge base.', 'seoaic') ?></p>
                                                <button class="generate_ai_summary_content generate"><?php esc_html_e('Geneate AI summary', 'seoaic') ?></button>
                                            </div>
                                            <div class="data-source-ai-text data-sources-ai-summary-content">
                                                <div class="ai-summary-content-wrap">
                                                    <div class="data-sources-domain-wrap data-sources-domain-wrap-ai-summary">
                                                        <textarea
                                                            name="data-sources-ai-summary"
                                                            class="data_source_item data_source_item_text"
                                                            data-mode="ai-summary"
                                                            data-counter-id="ai-summary-0"
                                                            rows="4">
                                                        </textarea>
                                                    </div>
                                                    <div class="ai-summary-actions">
                                                        <button class="generate_ai_summary_content generate" data-action="generate">Regenerate summary</button>
                                                        <button class="generate_ai_summary_content update ml-15" data-action="update">Save</button>
                                                        <button class="generate_ai_summary_content delete ml-15" data-action="delete">Delete</button>
                                                    </div>
                                                </div>
                                                <div class="counter-wrap">
                                                    <div class="counter" data-count-id="ai-summary-0"></div>
                                                    <div class="info">
                                                        <span class="info-btn">?</span>
                                                        <div class="info-content"><p></p></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php /* ?>
                            <div class="scanning-rules">
                                <a href="#" class="show_scanning_rules"><?php esc_html_e('Show scanning rules', 'seoaic') ?></a>
                                <div class="scanning_rules-content">
                                    <div class="scanning_rules-content-wrap">
                                        <div class="scanning_rules-content-item scanning_rules-include">
                                            <h4><?php esc_html_e('Include rules:', 'seoaic') ?> <span><?php esc_html_e('Define the URL ranges OR URLs including words you want the scanner to include', 'seoaic') ?></span></h4>
                                            <div class="form-item">
                                                <input type="text" name="include_rules" class="include-rules data_source_item" value="*">
                                                <button class="add-rules" data-rules="include"></button>
                                                <button class="remove-rules" data-rules="exclude"><span></span></button>
                                            </div>
                                        </div>

                                        <div class="scanning_rules-content-item scanning_rules-exclude">
                                            <h4><?php esc_html_e('Exclude rules:', 'seoaic') ?> <span><?php esc_html_e('Define the URL ranges OR URLs including words you want the scanner to exclude', 'seoaic') ?></span></h4>
                                            <div class="form-item">
                                                <input type="text" name="exclude_rules" class="exclude-rules data_source_item" value="">
                                                <button class="add-rules" data-rules="exclude"></button>
                                                <button class="remove-rules" data-rules="exclude"><span></span></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            */ ?>
                        </div>

                        <div class="data-source-scan">
                            <button class="scan_sources"><?php esc_html_e('Scan Sources', 'seoaic') ?></button>
                            <a href="#" class="add_sources"><?php esc_html_e('+ Add a new data source', 'seoaic') ?></a>
                            <div class="action-knowledge-base hide">
                                <button type="button" class="button-primary seoaic-button-primary seoaic-rescan-kb-button">
                                    <?php esc_html_e('Rescan') ?>
                                </button>
                            </div>
                        </div>
                        <input type="hidden" id="knowledge_bases_id" class="data_source_mode" value="">
                    </form>

                </div>
            </div>
            <div class="knowledge-base-item knowledge-base-data-source-item data-sources-item-new" id="seoaic-knowledge-base-pages">
                <div class="knowledge-base-head flex-justify">
                    <div class="knowledge-base-head-content">
                        <h3><span>/03</span><?php esc_html_e('AI Knowledge Base', 'seoaic') ?></h3>
                        <p><?php esc_html_e('These are the pages that have been added to your knowledge base. You can rescan and train your model here.', 'seoaic') ?></p>
                    </div>
                    <div class="action-knowledge-base hide">
                        <button type="button" class="button-primary seoaic-button-primary seoaic-train-kb-button">
                            <?php esc_html_e('Train') ?>
                        </button>
                    </div>
                </div>
                <div class="knowledge-base-body">
                    <div class="data-item-actions">
                        <div class="mass-actions">
                            <div class="select-all-data-items">
                                <div class="checkbox-wrapper-mc">
                                    <input id="source-item-all" type="checkbox" class="source-item-all" name="source-item" value="all">
                                    <label for="source-item-all" class="check">
                                        <div class="checkbox-wrapper-svg">
                                            <svg width="18px" height="18px" viewBox="0 0 18 18">
                                                <path d="M1,9 L1,3.5 C1,2 2,1 3.5,1 L14.5,1 C16,1 17,2 17,3.5 L17,14.5 C17,16 16,17 14.5,17 L3.5,17 C2,17 1,16 1,14.5 L1,9 Z"></path>
                                                <polyline points="1 9 7 14 15 4"></polyline>
                                            </svg>
                                        </div>
                                    </label>
                                </div>
                                <?php esc_html_e('Select All', 'seoaic') ?>
                            </div>
                            <button id="data-source-item-remove"><?php esc_html_e('Delete Selected', 'seoaic') ?></button>
                        </div>
                        <div class="search-wrap">
                            <div class="search">
                                <input type="text" class="data_search" placeholder="<?php esc_html_e('Search...', 'seoaic') ?>">
                                <button type="submit" data-search="1" class="seoaic_data_source_search"></button>
                            </div>
                            <a href="" class="filter-clear-btn"></a>
                        </div>
                        <div class="status-wrap">
                            <label class="mr-15 mb-0"><?php esc_html_e('Knowledge base status', 'seoaic') ?>:</label>
                            <div class="status"></div>
                        </div>
                    </div>
                    <div class="bottom">
                        <div class="flex-table">
                            <div class="row-line heading">
                                <div class="name">
                                    <?php esc_html_e('URLs') ?>
                                </div>
                                <div class="status">
                                    <?php esc_html_e('Status') ?>
                                </div>
                                <div class="description">
                                    <?php esc_html_e('Last Scan') ?>
                                </div>
                                <div class="tokens">
                                    <?php esc_html_e('Tokens') ?>
                                </div>
                                <div class="actions">
                                    <?php esc_html_e('Actions') ?>
                                </div>
                            </div>

                            <div class="seoaic-pagination" id="pagination-container"></div>
                        </div>
                    </div>
                </div>
            </div>
            <?php } ?>
        </div>

        <div class="lds-dual-ring"></div>
    </div>
</div>