<?php

use SEOAIC\SEOAIC;
use SEOAIC\loaders\PostsGenerationLoader;
use SEOAIC\posts_mass_actions\FramesMassGenerate;
use SEOAIC\SEOAIC_SETTINGS;

if (!current_user_can('seoaic_edit_plugin')) {
    return;
}

$__GET = wp_unslash($_GET);

if (isset($__GET['settings-updated'])) {
    add_settings_error('seoaic_messages', 'seoaic_message', esc_html__('Settings Saved', 'mdsf'), 'updated');
}

settings_errors('seoaic_messages');

$searchValue = !empty($__GET['s']) ? sanitize_text_field($__GET['s']) : '';
$adminUrl = SEOAIC::getAdminUrl('admin.php');

$createdDateFromValue = !empty( $__GET['created_date_from'] ) ? $__GET['created_date_from'] : '';
$createdDateToValue = !empty( $__GET['created_date_to'] ) ? $__GET['created_date_to'] : '';

$allowed_order_by = ['ID', 'title', 'date'];
$allowed_order = ['asc', 'desc'];

$order_by = !empty($__GET['orderby']) && in_array($__GET['orderby'], $allowed_order_by) ? $__GET['orderby'] : 'date';
$order = !empty($__GET['order']) && in_array($__GET['order'], $allowed_order) ? $__GET['order'] : 'desc';

global $SEOAIC_OPTIONS, $SEOAIC;
$args = [
    'numberposts'   => -1,
    'post_type'     => 'seoaic-post',
    'post_status'   => 'seoaic-idea',
    'orderby'       => $order_by,
    'order'         => $order,
    'meta_query' => [
        'relation' => 'OR',
        [
	        'key' => 'seoaic_idea_source',
	        'compare' => 'NOT EXISTS'
        ]
    ]
];

if (!empty($searchValue)) {
    $args['s'] = $searchValue;
}

if (
    !empty($__GET['filter'])
    && $__GET['filter'] === 'scheduled'
) {
    $args['meta_query'] = [
        'relation' => 'OR',
        [
            'key' => 'seoaic_idea_postdate',
            'value' => [''],
            'compare' => 'NOT IN'
        ]
    ];
}

$date_query = [];

if (!empty($createdDateFromValue)) {
    $date_query['after'] = DateTime::createFromFormat('m/d/Y', $createdDateFromValue )
                                   ->format('Y-m-d');
}

if (!empty($createdDateToValue)) {
    $date_query['before'] = DateTime::createFromFormat('m/d/Y', $createdDateToValue )
                                    ->format('Y-m-d');
}

if (!empty($date_query)) {
    $date_query['inclusive'] = true;
    $args['date_query'] = [$date_query];
}
/* else {
    $args['meta_query'] = [
        'relation' => 'OR',
        [
            'key' => 'seoaic_idea_postdate',
            'compare' => 'NOT EXISTS'
        ]
    ];
}*/

//$args = $SEOAIC->multilang->update_post_args($args);

$ideas = get_posts($args);

//$multi_current_language = $SEOAIC->multilang->get_current_language();

$ideas = $SEOAIC->multilang->sort_posts_by_languages($ideas);
$locations = $SEOAIC->multilang->getLocationsWithLanguages();
$credits = $SEOAIC->get_api_credits();

$pendingFrames = (new FramesMassGenerate($SEOAIC))->getPendingFramesAll();
$pendingFramesIDs = array_map(function ($frame) {
    return $frame->ID;
}, $pendingFrames);

?>
<div id="seoaic-admin-container" class="wrap">
    <h1 id="seoaic-admin-title">
        <?php
        echo wp_kses(seoai_get_logo('logo.svg'), [
            'img' => [
                'title' => [],
                'src'	=> [],
                'alt'	=> [],
            ],
        ]);
        ?>
        <span>
            <?php echo esc_html(get_admin_page_title()); ?>
        </span>
    </h1>
    <?php echo $SEOAIC->get_background_process_loader(); ?>
    <div id="seoaic-admin-body" class="columns-2 seoaic-with-loader idea-page">
        <div class="row full-width">
            <div class="col-6 left-side">
                <div class="header seoaic-flip-box">

                    <div class="seoaic-flip-container">

                        <div class="seoaic-flip-item seoaic-flip-front">

                            <div class="head-buttons">
                                <div class="btn-sc">
                                    <div class="info">
                                        <span class="info-btn">?</span>
                                        <div class="info-content">
                                            <h4><?php esc_html_e('Mass Content Creation', 'seoaic');?></h4>
                                            <p><?php esc_html_e('You can generate multiple posts at once and schedule them over a specific period. Use Generate Ideas button, specify the number of ideas and select the “Add to posting schedule” checkbox to create a large number of blog posts in a batch process.', 'seoaic');?></p>
                                        </div>
                                    </div>
                                    <button type="button"
                                        title="<?php esc_attr_e('Generate ideas', 'seoaic');?>"
                                        class="button-primary seoaic-button-primary seoaic-generate-ideas-button modal-button"
                                        data-modal="#generate-ideas-new-keywords"
                                        data-action="seoaic_generate_ideas_new_keywords"
                                        data-form-callback="window_reload"
                                    >
                                        <?php esc_html_e('Generate ideas', 'seoaic');?>
                                    </button>
                                </div>
                                <button type="button"
                                    class="button-primary seoaic-button-primary outline modal-button"
                                    data-title="<?php esc_attr_e('Add new Idea', 'seoaic');?>"
                                    data-modal="#add-idea-manually"
                                    data-mode="add"
                                    data-single="no"
                                    data-form-callback="window_reload"
                                    <?php
                                    if ($SEOAIC->multilang->is_multilang()) {
                                        ?>
                                        data-language-parent-id=""
                                        data-languages="true"
                                        data-language="<?php echo esc_attr($SEOAIC->multilang->get_default_language());?>"
                                        <?php
                                    } ?>
                                ><span class="vertical-align-middle dashicons dashicons-plus"></span> <?php esc_html_e('Add an Idea', 'seoaic');?>
                                    <div class="dn edit-form-items">
                                        <input type="hidden"
                                            name="item_name"
                                            value=""
                                            data-label="<?php esc_attr_e('Name (separate ideas by new line)', 'seoaic');?>">
                                    </div>
                                </button>
                            </div>

                            <div class="schedule-switcher">

                                <div class="checkbox-wrapper-mc">
                                    <input type="checkbox"
                                        name="idea-mass-create-all"
                                        id="idea-mass-create-all"
                                        class="idea-mass-create"
                                        value="all"
                                    >
                                    <label for="idea-mass-create-all" class="check">
                                        <div class="checkbox-wrapper-svg">
                                            <svg width="18px" height="18px" viewBox="0 0 18 18">
                                                <path d="M1,9 L1,3.5 C1,2 2,1 3.5,1 L14.5,1 C16,1 17,2 17,3.5 L17,14.5 C17,16 16,17 14.5,17 L3.5,17 C2,17 1,16 1,14.5 L1,9 Z"></path>
                                                <polyline points="1 9 7 14 15 4"></polyline>
                                            </svg>
                                        </div>
                                    </label>
                                </div>

                                <a href="<?php echo esc_url(get_admin_url() . 'admin.php?page=seoaic-ideas');?>"
                                    title="<?php echo (!empty($__GET['filter']) && $__GET['filter'] === 'scheduled') ? esc_html__('Show scheduled ideas', 'seoaic') : esc_html__('Show unscheduled ideas', 'seoaic');?>"
                                    class="unscheduled<?php echo (!empty($__GET['filter']) && $__GET['filter'] === 'scheduled') ? '' : ' active' ?>"><?php esc_html_e('All
                                    ideas', 'seoaic');?></a>

                                <a href="<?php echo esc_url(get_admin_url() . 'admin.php?page=seoaic-ideas&filter=scheduled');?>"
                                    title="<?php echo (!empty($__GET['filter']) && $__GET['filter'] === 'scheduled') ? esc_html__('Show scheduled ideas') : esc_html__('Show unscheduled ideas', 'seoaic');?>"
                                    class="scheduled<?php echo (!empty($__GET['filter']) && $__GET['filter'] === 'scheduled') ? ' active' : '' ?>"><?php esc_html_e('Scheduled posts', 'seoaic');?></span></a>

                                <button type="button"
                                        class="button button-danger seoaic-remove-all-ideas-button ml-auto modal-button confirm-modal-button"
                                        data-post-id="all"
                                        data-modal="#seoaic-confirm-modal"
                                        data-action="seoaic_remove_idea"
                                        data-form-callback="window_reload"
                                        data-content="<?php esc_attr_e('Do you want to remove ALL ideas?', 'seoaic');?>"
                                ><?php esc_html_e('Delete all ideas', 'seoaic');?>
                                    <div class="dn additional-form-items">
                                        <label>
                                            <input type="checkbox"
                                                name="schedule_too"
                                                class="seoaic-form-item"
                                                value="1"><?php esc_html_e('Remove scheduled ideas too ', 'seoaic');?>
                                        </label>
                                    </div>
                                </button>

                            </div>
                        </div>

                        <div class="seoaic-flip-item seoaic-flip-side">
                            <div class="head-buttons">
                                <button type="button"
                                        title="<?php esc_attr_e("Create", "seoaic");?>"
                                        class="button-primary seoaic-button-primary mass-effect-button seoaic-generate-posts-button modal-button confirm-modal-button"
                                        data-modal="#seoaic-post-mass-creation-modal"
                                        data-callback-before="before_open_mass_create"
                                        data-action="seoaic_posts_mass_create"
                                        data-title="Posts creation"
                                        data-form-callback="window_reload"
                                        data-content="<?php esc_attr_e('You will generate posts from', 'seoaic');?> <b class='additional-items-amount'></b> <?php esc_attr_e('following ideas:', 'seoaic');?>"
                                ><?php esc_html_e('Create', 'seoaic');?>
                                    <div class="dn additional-form-items"></div>
                                </button>
                                <button type="button"
                                        class="button-primary seoaic-button-primary mass-effect-button outline modal-button confirm-modal-button"
                                        data-modal="#schedule-posts-modal"
                                        data-action="seoaic_schedule_posts"
                                        data-content="<?php esc_attr_e('Do you want to schedule generation of', 'seoaic');?> <b class='additional-items-amount'></b> <?php esc_attr_e('following ideas:', 'seoaic');?>"
                                        data-form-callback="window_reload"
                                >
                                    <?php esc_html_e('Schedule posts', 'seoaic');?>
                                    <div class="dn additional-form-items"></div>
                                </button>
                            </div>
                            <div class="schedule-switcher">
                                <span class="seoaic-checked-amount"><?php esc_html_e('Selected:', 'seoaic');?> <span class="seoaic-checked-amount-num"></span></span>
                                <button type="button"
                                    class="idea-mass-create-uncheck-all"
                                >
                                    <?php esc_html_e('Remove selection', 'seoaic');?>
                                </button>

                                <button type="button"
                                        class="button button-black hover-blue mass-effect-button seoaic-generate-frames-button modal-button confirm-modal-button"
                                        data-modal="#seoaic-post-mass-outline-generate-modal"
                                        data-action="seoaic_frames_mass_generate"
                                        data-form-callback="window_reload"
                                        data-content="<?php esc_attr_e('Do you want to generate outline for selected ideas?', 'seoaic');?>"
                                >
                                    <?php esc_html_e('Generate outline', 'seoaic');?>
                                    <div class="dn additional-form-items"></div>
                                </button>

                                <button type="button"
                                        class="button button-danger mass-effect-button seoaic-remove-all-ideas-button modal-button confirm-modal-button"
                                        data-modal="#seoaic-confirm-modal"
                                        data-action="seoaic_remove_idea"
                                        data-form-callback="window_reload"
                                        data-content="<?php esc_attr_e('Do you want to remove', 'seoaic');?> <b class='additional-items-amount'></b> <?php esc_attr_e('following ideas?', 'seoaic');?>"
                                >
                                    <?php esc_html_e('Delete selected ideas', 'seoaic');?>
                                    <div class="dn additional-form-items"></div>
                                </button>

                            </div>
                        </div>

                    </div>

                </div>

                <div class="seoaic-ideas-posts">
                    <?php if (count($pendingFrames)) : ?>
                        <input type="hidden"
                               value="1"
                               name="seoaic_frames_mass_generate_check_status"
                               id="seoaic_frames_mass_generate_check_status"
                               data-action="seoaic_frames_mass_generate_check_status"
                               data-modal="#seoaic-confirm-modal"
                               data-form-callback="window_reload"
                        >
                    <?php endif; ?>
                    <div class="post heading">
                        <div class="idea-content-sort-date idea-content-sort heading">
                            <div class="search">
                                <input
                                        id="ideas_search_input"
                                        type="text"
                                        placeholder="<?php esc_html_e('Enter a title', 'seoaic');?>"
                                        value="<?php echo esc_attr($searchValue);?>"
                                >
                                <a href="" id="ideas_search_do_search" class="seoaic-filter-btn"></a>
                            </div>


                            <div class="date-filter">
                                <div class="f-date">
                                    <div class="position-relative">
                                        <input type="text"
                                               name="created_date_from"
                                               value="<?php echo esc_attr($createdDateFromValue); ?>"
                                               class="mt-0 seoaic-form-item form-input"
                                               placeholder="<?php esc_attr_e('Created from', 'seoaic');?>"
                                        >
                                        <div class="picker-call"></div>
                                    </div>
                                </div>
                                <div class="f-date">
                                    <div class="position-relative">
                                        <input type="text"
                                               name="created_date_to"
                                               value="<?php echo esc_attr($createdDateToValue); ?>"
                                               class="mt-0 seoaic-form-item form-input"
                                               placeholder="<?php esc_attr_e('Created to', 'seoaic');?>"
                                        >
                                        <div class="picker-call"></div>
                                    </div>
                                </div>
                                <div class="f-btn">
                                    <a href="<?php echo esc_url($adminUrl); ?>?page=seoaic-ideas"
                                       class="filter-clear-btn filter-btn"
                                       title="<?php esc_attr_e('Clear all filters', 'seoaic'); ?>"></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="post heading">
                        <div class="idea-content-sort heading">
                            <div class="num sortable" data-orderby="ID" data-order="<?php echo esc_attr($order_by === 'ID' ? $order : '');?>">
                                <?php esc_html_e('ID', 'seoaic') ?>
                            </div>
                            <div class="date sortable" data-orderby="date" data-order="<?php echo esc_attr($order_by === 'date' ? $order : '');?>">
                                <?php esc_html_e('Date', 'seoaic'); ?>
                            </div>
                            <div class="heading sortable" data-orderby="title" data-order="<?php echo esc_attr($order_by === 'title' ? $order : '');?>">
                                <?php esc_html_e('Name', 'seoaic') ?>
                            </div>
                        </div>
                    </div>

                    <?php
                    $option = PostsGenerationLoader::getPostsOption();
                    $process_ideas = !empty($option['total']) ? $option['total'] : [];
                    $process_posts = !empty($option['done']) ? $option['done'] : [];

                    foreach ($ideas as $k => $idea) {
                        $idea_publish_date = get_the_date('Y-m-d H:i:s', $idea->ID);
                        $idea_type = get_post_meta($idea->ID, '_idea_type', true);
                        $idea_type = !empty($idea_type) ? $idea_type : 'default';
                        $generating_status = in_array($idea->ID, $process_ideas) && !in_array($idea->ID, $process_posts)? ' post-is-generating' : '';
                        $seoaic_generate_status = get_post_meta($idea->ID, 'seoaic_generate_status', true);
                        $failed_status = 'failed' == $seoaic_generate_status ? ' failed' : '';
                        $framePendingClass = in_array($idea->ID, $pendingFramesIDs) ? ' seoaic-frame-pending' : '';
                        $idea_content = get_post_meta($idea->ID, 'seoaic_idea_content', true);
                        $idea_content = !empty($idea_content) ? json_decode($idea_content, true) : '';
                        $ideaCategoriesIds = !empty($idea_content['idea_category']) ? $idea_content['idea_category'] : seoaic_get_categories_ids(SEOAIC_SETTINGS::getSEOAICPostType());
                        ?>

                        <div
                            id="<?php echo esc_attr('idea-post-' . $idea->ID);?>"
                            class="post <?php echo esc_attr($generating_status) . esc_attr($failed_status) . esc_attr($framePendingClass);?>"
                        >
                            <div class="idea-content" data-post-id="<?php echo esc_attr($idea->ID);?>">
                                <div class="num">
                                    <div class="checkbox-wrapper-mc">
                                        <input type="checkbox"
                                            id="<?php echo esc_attr('idea-mass-create-' . $idea->ID);?>"
                                            class="idea-mass-create" name="idea-mass-create"
                                            value="<?php echo esc_attr($idea->ID);?>"
                                        >
                                        <label for="<?php echo esc_attr('idea-mass-create-' . $idea->ID);?>" class="check">
                                            <div class="checkbox-wrapper-svg">
                                                <svg width="18px" height="18px" viewBox="0 0 18 18">
                                                    <path d="M1,9 L1,3.5 C1,2 2,1 3.5,1 L14.5,1 C16,1 17,2 17,3.5 L17,14.5 C17,16 16,17 14.5,17 L3.5,17 C2,17 1,16 1,14.5 L1,9 Z"></path>
                                                    <polyline points="1 9 7 14 15 4"></polyline>
                                                </svg>
                                            </div>
                                            <span class="checkbox-wrapper-item-id"><?php echo esc_html($idea->ID);?></span>
                                        </label>
                                    </div>
                                </div>
                                <div class="date">
                                    <?php if( $SEOAIC->ideas->get_idea_date($idea->ID) ): ?>
                                        <span><?php echo esc_html($SEOAIC->ideas->get_idea_date($idea->ID));?></span>
                                    <?php else: ?>
                                        <span><?php echo esc_html(date('M j, Y, H:i A', strtotime(esc_html($idea_publish_date))));?></span>
                                    <?php endif; ?>
                                </div>
                                <div class="heading">
                                    <div class="seoaic-idea-icons">
                                        <?php if( $SEOAIC->ideas->get_idea_icons($idea->ID)  ): ?>
                                            <?php echo $SEOAIC->ideas->get_idea_icons($idea->ID);?>
                                        <?php endif; ?>
                                    </div>
                                    <div class="title td-idea-title"><?php echo esc_html($idea->post_title);?></div>
                                    <?php if ($idea_type !== 'default') : ?>
                                        <div class="seoaic-idea-type"><?php echo esc_html(seoaic_get_prompt_template_types()[$idea_type])?></div>
                                    <?php endif; ?>
                                    <div class="language-translations-wrapper">
                                        <?php $SEOAIC->multilang->get_language_translations_control($idea->ID, $ideas);?>
                                    </div>
                                </div>

                                <div class="actions">
                                    <button type="button"
                                            title="<?php esc_attr_e('Edit idea', 'seoaic');?>"
                                            data-post-id="<?php echo esc_attr($idea->ID);?>"
                                            class="button button-success seoaic-edit-idea-button ml-auto modal-button"
                                            data-modal="#edit-idea"
                                            data-mode="edit"
                                            data-form-callback="idea_update_title"
                                            data-content="<?php esc_attr_e('Edit Idea', 'seoaic');?>"
                                        <?php if ( $SEOAIC->multilang->is_multilang()  && false === $SEOAIC->multilang->get_post_language($idea->ID) ) {  ?>
                                            data-languages="true"
                                        <?php }  ?>
                                    >
                                        <div class="dn edit-form-items">
                                            <input type="hidden"
                                                   name="item_id"
                                                   value="<?php echo esc_attr($idea->ID); ?>"
                                                   data-label="Id">
                                            <input type="hidden"
                                                   name="item_name"
                                                   value="<?php echo esc_attr($idea->post_title);?>"
                                                   data-label="<?php esc_attr_e('Name', 'seoaic');?>">
                                        </div>
                                    </button>
                                    <button type="button"
                                            title="<?php esc_attr_e('Remove idea', 'seoaic');?>"
                                            class="button button-danger seoaic-remove-idea-button modal-button confirm-modal-button"
                                            data-post-id="<?php echo esc_attr($idea->ID);?>"
                                            data-modal="#seoaic-confirm-modal"
                                            data-action="seoaic_remove_idea"
                                            data-form-callback="window_reload"
                                            data-content="<?php esc_attr_e('Do you want to remove this idea?', 'seoaic');?>"
                                    >
                                    </button>
                                    <?php
                                    if (isset($__GET['debug'])) {
                                        ?>
                                        <button type="button"
                                                title="<?php esc_attr_e('Transform', 'seoaic');?>"
                                                class="button seoaic-transform-idea-button modal-button confirm-modal-button"
                                                data-post-id="<?php echo esc_attr($idea->ID);?>"
                                                data-modal="#seoaic-confirm-modal"
                                                data-action="seoaic_transform_idea"
                                                data-form-callback="window_reload"
                                                data-content="<?php esc_attr_e('Do you want to transform this idea?', 'seoaic');?>"
                                        >
                                            <span class="dashicons dashicons-image-rotate"></span>
                                        </button>
                                        <?php
                                    }
                                    ?>
                                </div>
                            </div>

                            <div class="idea-btn">
                                <button type="button"
                                    title="<?php esc_attr_e('Edit idea content', 'seoaic');?>"
                                    id="<?php echo esc_attr('edit-idea-button-' . $idea->ID);?>"
                                    class="button button-primary seoaic-button-primary seoaic-get-idea-content-button seoaic-ajax-button"
                                    data-post-id="<?php echo esc_attr($idea->ID);?>"
                                    data-categories-ids="<?php echo esc_attr(implode(',', $ideaCategoriesIds));?>"
                                    data-action="seoaic_get_idea_content"
                                    data-callback="view_idea_content"
                                    data-callback-before="before_get_idea_content"
                                >
                                    <span class="post-is-generating-label"><?php esc_html_e('generating', 'seoaic');?></span>
                                </button>
                            </div>
                        </div>
                        <?php
                    }
                    ?>
                </div>
            </div>

            <div class="col-6 right-side">
                <div class="seoaic-content-idea-box">
                    <div class="seoaic-content-idea-box-slide">
                        <div class="header">
                            <div class="top-line">
                                <h4><?php esc_html_e('Credits you have:', 'seoaic');?></h4>
                                <a href="#" class="upgrade-my-plan"><?php esc_html_e('Upgrade My Plan', 'seoaic');?></a>
                            </div>
                            <div class="results seoaic-credits-panel">
                                <div class="posts">
                                    <input type="hidden"
                                        id="posts-credit"
                                        name="posts-credit"
                                        value="<?php echo esc_attr($credits['posts']);?>">
                                    <input type="hidden"
                                        id="alert-posts-credit"
                                        name="alert-posts-credit"
                                        value="<?php esc_attr_e('You have not enough posts credit!', 'seoaic');?>">
                                    <div class="num"><?php echo esc_html($credits['posts']);?></div>
                                    <div class="text"><?php esc_html_e('Posts', 'seoaic');?></div>
                                </div>
                                <div class="ideas">
                                    <div class="num"><?php echo esc_html($credits['ideas']);?></div>
                                    <div class="text"><?php esc_html_e('Ideas', 'seoaic');?></div>
                                </div>
                                <div class="frames">
                                    <div class="num"><?php echo esc_html($credits['frames']);?></div>
                                    <div class="text"><?php esc_html_e('Outlines', 'seoaic');?></div>
                                </div>
                                <div>
                                    <div class="num"><?php echo esc_html($credits['keywords']);?></div>
                                    <div class="text"><?php esc_html_e('Keywords', 'seoaic');?></div>
                                </div>
                                <div>
                                    <div class="num"><?php echo esc_html($credits['images']);?></div>
                                    <div class="text"><?php esc_html_e('Images', 'seoaic');?></div>
                                </div>
                            </div>
                        </div>
                        <div class="idea-box">
                            <div class="seoaic-idea-content-section">
                                <div id="seoaic-idea-title"></div>
                                <button type="button"
                                    title="<?php esc_attr_e('Generate outline', 'seoaic');?>"
                                    data-post-id=""
                                    data-modal="#seoaic-post-outline-generate-modal"
                                    class="seoaic-generate-skeleton-button confirm-modal-button modal-button"
                                    data-action="seoaic_generate_skeleton"
                                    data-form-callback="view_idea_content"
                                >
                                    <?php esc_html_e('Generate Outline', 'seoaic');?>
                                </button>


                                <button type="button"
                                    class="seoaic-generate-post-button mass-effect-button confirm-modal-button modal-button"
                                    title="<?php esc_attr_e('Generate post', 'seoaic');?>"
                                    data-title="<?php esc_attr_e('Generate post', 'seoaic');?>"
                                    data-post-id=""
                                    data-modal="#seoaic-post-mass-creation-modal"
                                    data-callback-before="before_open_mass_create_single"
                                    data-action="seoaic_posts_mass_create"
                                    data-form-callback="window_reload"
                                >
                                    <?php esc_html_e('Generate post', 'seoaic');?>
                                    <div class="dn additional-form-items"></div>
                                </button>
                            </div>
                            <div id="seoaic-idea-content-skeleton" class="seoaic-idea-content-section">
                                <div class="top">
                                    <h3 class="seoaic-section-idea-title"><?php esc_html_e('Subtitles', 'seoaic');?></h3>
                                    <button type="button"
                                        title="<?php esc_attr_e('Add subtitle', 'seoaic');?>"
                                        class="seoaic-add-idea-subtitle seoaic-add-idea-info modal-button confirm-modal-button"
                                        data-modal="#edit-idea-subtitle"
                                        data-mode="add"
                                        data-title="<?php esc_attr_e('Add subtitle', 'seoaic');?>"
                                        data-form-before-callback="add_subtitle"
                                        data-action="subtitle"
                                    >
                                        <span class="vertical-align-middle dashicons dashicons-plus"></span><span><?php esc_html_e('Add subtitle', 'seoaic');?></span>
                                        <div class="dn edit-form-items">
                                            <input type="hidden" name="item_name" value="" data-label="Name">
                                        </div>
                                    </button>
                                </div>

                                <ul id="seoaic-idea-skeleton-sortable"
                                    class="seoaic-idea-content-section-subtitle"
                                ></ul>
                            </div>
                            <div id="seoaic-idea-content-keywords" class="seoaic-idea-content-section">
                                <div class="top">
                                    <h3 class="seoaic-section-idea-title"><?php esc_html_e('Keywords', 'seoaic');?></h3>
                                    <button type="button"
                                        title="<?php esc_attr_e('Add keyword', 'seoaic');?>"
                                        class="seoaic-add-idea-keyword seoaic-add-idea-info modal-button confirm-modal-button"
                                        data-modal="#add-idea-subtitle-keyword"
                                        data-mode="add"
                                        data-title="<?php esc_attr_e('Add keyword', 'seoaic');?>"
                                        data-form-before-callback="add_keyword"
                                        data-action="keyword"
                                    >
                                        <span class="vertical-align-middle dashicons dashicons-plus"></span><span><?php esc_html_e('Add keyword', 'seoaic');?></span>
                                        <div class="dn edit-form-items">
                                            <input type="hidden"
                                                name="item_name"
                                                value=""
                                                data-label="<?php esc_attr_e('Name', 'seoaic');?>"
                                            >
                                        </div>
                                    </button>
                                </div>
                                <ul id="seoaic-idea-keywords" class="seoaic-idea-content-section-keyword"></ul>
                            </div>

                            <div id="seoaic-idea-content-description" class="seoaic-idea-content-section">
                                <div class="top">
                                    <h3 class="seoaic-section-idea-title"><?php esc_html_e('Meta description', 'seoaic');?></h3>
                                </div>
                                <textarea type="text"
                                          class="seoaic-idea-content-description-textarea seoaic-on-update-save-content"
                                          name="seoaic-idea-content-description" rows="6"></textarea>
                            </div>

                            <?php
                            if ($SEOAIC->multilang->is_multilang()) {
                                ?>
                                <div id="seoaic-idea-language" class="seoaic-idea-content-section" default-lang="<?php echo esc_attr(get_locale()); ?>">
                                    <div class="top">
                                        <h3 class="seoaic-section-idea-title"><?php esc_html_e('Language', 'seoaic');?></h3>
                                    </div>
                                    <?php echo $SEOAIC->multilang->get_multilang_checkboxes('', 'radio', false);?>
                                </div>
                                <?php
                            }
                            ?>

                            <div id="seoaic-idea-post-type" class="seoaic-idea-content-section">
                                <div class="top">
                                    <span class="seoaic-section-idea-title"><?php esc_html_e('Post type', 'seoaic');?></span><span class="icon"></span>
                                </div>
                                <div class="choose-label mb-19"><?php esc_html_e('Select a post type', 'seoaic');?></div>
                                <div class="choose-switchers">
                                    <select name="seoaic_post_type"
                                        id="seoaic-post-type"
                                        data-action="seoaic_selectCategoriesIdea"
                                        class="seoaic-form-item form-select"
                                        required=""
                                        default-value="<?php echo esc_attr(!empty($SEOAIC_OPTIONS['seoaic_post_type']) ? $SEOAIC_OPTIONS['seoaic_post_type'] : 'post');?>"
                                        data-target-select="seoaic-idea-content-category">
                                    <?php
                                        $post_types = seoaic_get_post_types();
                                        foreach ($post_types as $post_type) :
                                            ?>
                                            <option value="<?php echo esc_attr($post_type);?>"><?php echo esc_html(ucfirst(esc_html($post_type)));?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>

                            <div id="seoaic-idea-content-category" class="seoaic-idea-content-section">
                                <div class="top">
                                    <span class="seoaic-section-idea-title"><?php esc_html_e('Category', 'seoaic');?></span><span class="icon"></span>
                                </div>
                                <div class="choose-label mb-19"><?php esc_html_e('Select a category', 'seoaic');?></div>

                                <div class="choose-switchers terms-select"></div>
                            </div>

<!--                            <div id="seoaic-idea-content-generator" class="seoaic-idea-content-section">-->
<!--                                <div class="top">-->
<!--                                    <span class="seoaic-section-idea-title">Image generator</span><span-->
<!--                                            class="icon"></span>-->
<!--                                </div>-->
<!--                                <div class="choose-label mb-19">Select a service for generating pictures</div>-->
<!--                                <div class="choose-switchers">-->
<!--                                    <select id="seoaic-image-generator" class="seoaic-form-item form-select"-->
<!--                                            name="seoaic_image_generator" required=""-->
<!--                                            default-value="--><?php //= !empty($SEOAIC_OPTIONS['seoaic_image_generator']) ? $SEOAIC_OPTIONS['seoaic_image_generator'] : 'no_image'; ?><!--">-->
<!--                                        --><?php
//                                        $image_generators = seoaic_get_image_generators();
//                                        foreach ($image_generators as $key => $image_generator) :
//                                            ?>
<!--                                            <option value="--><?php //= $key; ?><!--">--><?php //= $image_generator ?><!--</option>-->
<!--                                        --><?php //endforeach; ?>
<!--                                    </select>-->
<!--                                </div>-->
<!--                            </div>-->

<!--                            <div id="seoaic-idea-content-thumbnail" class="seoaic-idea-content-section">-->
<!--                                <div class="top">-->
<!--                                    <span class="seoaic-section-idea-title">Image description</span>-->
<!--                                </div>-->
<!--                                <textarea type="text"-->
<!--                                          class="seoaic-idea-content-thumbnail-textarea seoaic-on-update-save-content"-->
<!--                                          name="seoaic-idea-content-thumbnail" rows="6"></textarea>-->
<!--                            </div>-->
                            <div class="seoaic-save-content-idea seoaic-idea-content-section">
                                <div class="top last">
                                    <h3 class="seoaic-section-idea-title"><?php esc_html_e('Posting time', 'seoaic');?></h3>
                                </div>
                                <div class="bottom">
                                    <div class="idea-date-picker">
                                        <input type="text"
                                               class="seoaic-posting-idea-date"
                                               name="seoaic-posting-idea-date"
                                               placeholder="dd/mm/yyyy --:--"
                                               readonly>
                                        <div class="picker-call"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="seoaic-idea-save-wrapper">
                                <button type="button" class="seoaic-cancel-content-idea-button ml-auto">
                                    <?php esc_html_e('Cancel', 'seoaic');?>
                                </button>
                                <button type="button"
                                    title="<?php esc_attr_e('Save idea', 'seoaic');?>"
                                    data-post-id=""
                                    class="button-primary seoaic-button-primary seoaic-save-content-idea-button"
                                    data-action="seoaic_save_content_idea"
                                    data-callback="skeleton_saved"
                                    data-changed="false"
                                >
                                    <?php esc_html_e('Save idea', 'seoaic');?>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="lds-dual-ring"></div>
    </div>
</div>