<?php
if (!current_user_can('seoaic_edit_plugin')) {
    return;
}

if (isset($_GET['settings-updated'])) {
    add_settings_error('seoaic_messages', 'seoaic_message', esc_html__('Settings Saved', 'mdsf'), 'updated');
}

settings_errors('seoaic_messages');
?>
<div id="seoaic-admin-container" class="wrap">
    <h1 id="seoaic-admin-title">
        <?php
        echo wp_kses(seoai_get_logo('logo.svg'), [
            'img' => [
                'title' => [],
                'src'	=> [],
                'alt'	=> [],
            ],
        ]);
        ?>
        <span>
            <?php echo esc_html(get_admin_page_title()); ?>
        </span>
    </h1>
    <div id="seoaic-admin-body">
        <div class="inner-login forgot">
            <h2 class="tc ws-nw"><?php esc_html_e('Account recovery', 'seoaic');?></h2>
            <div class="tc"><?php esc_html_e('Back to', 'seoaic');?> <a href="<?php echo esc_url(get_admin_url());?>admin.php?page=seoaic">login</a> <?php esc_html_e('page', 'seoaic');?>
            </div>
            <form id="seoaic-forgot" class="seoaic-form" name="seoaic-forgot" method="post" data-callback="forgot_callback">
                <input type="hidden" class="seoaic-form-item" name="action" value="seoaic_forgot">

                <div class="col-12 step-1">
                    <label for="seoaic_email"><?php esc_html_e('E-mail', 'seoaic');?></label>
                    <input id="seoaic_email" class="seoaic-form-item form-input" name="email" type="email" required>
                </div>

                <div class="col-12 dn step-2">
                    <label for="seoaic_recovery_code" class="db"><?php esc_html_e('Code (check your email)', 'seoaic');?></label>
                    <input id="seoaic_recovery_code" class="form-input" name="recovery_code" type="text">
                </div>

                <div class="col-12 dn step-2">
                    <label for="seoaic_password"><?php esc_html_e('Password', 'seoaic');?></label>
                    <input id="seoaic_password" class="form-input" name="password" type="password">
                </div>

                <div class="col-12 dn step-2">
                    <label for="seoaic_repeat_password"><?php esc_html_e('Repeat password', 'seoaic');?></label>
                    <input id="seoaic_repeat_password" class="form-input" name="repeat_password" type="password">
                </div>

                <div class="col-12">
                    <button id="seoaic_submit" type="submit" class="button-primary seoaic-button-primary" data-step="1" data-step-1="<?php esc_html_e('Send recovery code', 'seoaic');?>" data-step-2="<?php esc_html_e('Apply recovery code', 'seoaic');?>" data-step-3="<?php esc_html_e('Set a new password', 'seoaic');?>"><?php esc_html_e('Send recovery code', 'seoaic');?></button>
                </div>
            </form>
        </div>
        <div class="lds-dual-ring"></div>
    </div>
</div>