<?php

use SEOAIC\loaders\PostsEditLoader;
use SEOAIC\loaders\PostsReviewLoader;
use SEOAIC\posts_mass_actions\FAQGenerate;
use SEOAIC\posts_mass_actions\LeadsFormGenerate;
use SEOAIC\posts_mass_actions\PostsMassEdit;
use SEOAIC\posts_mass_actions\PostsMassReview;
use SEOAIC\posts_mass_actions\PostsMassTranslate;
use SEOAIC\posts_mass_actions\ThumbnailsGenerate;
use SEOAIC\repositories\PostRevisionRepository;
use SEOAIC\SEOAIC;
use SEOAIC\SEOAIC_POSTS;
use SEOAIC\SEOAIC_SETTINGS;
use SEOAIC\SeoaicShortcodes;

if (!current_user_can('seoaic_edit_plugin')) {
    return;
}

$__GET = wp_unslash($_GET); // phpcs:ignore WordPress.Security.NonceVerification.Recommended
if (isset($__GET['settings-updated'])) {
    add_settings_error('seoaic_messages', 'seoaic_message', esc_html__('Settings Saved', 'seoaic'), 'updated');
}

settings_errors('seoaic_messages');

global $SEOAIC, $SEOAIC_OPTIONS;

function SEOAIC_isValidDate($dateString = '')
{
    return (bool)strtotime($dateString);
}

function SEOAIC_makeDateQuery()
{
    $date_query = [];
    $__GET = wp_unslash($_GET); // phpcs:ignore WordPress.Security.NonceVerification.Recommended

    if (
        !empty($__GET['seoaic_publ_datefrom'])
        && SEOAIC_isValidDate(urldecode($__GET['seoaic_publ_datefrom']))
    ) {
        $date_query['after'] = urldecode($__GET['seoaic_publ_datefrom']);
    }
    if (
        !empty($__GET['seoaic_publ_dateto'])
        && SEOAIC_isValidDate(urldecode($__GET['seoaic_publ_dateto']))
    ) {
        $date_query['before'] = urldecode($__GET['seoaic_publ_dateto']) . ' 23:59:59';
    }
    if (!empty($date_query)) {
        $date_query['inclusive'] = true;
    }

    return [$date_query];
}

function SEOAIC_addTitleQuery(&$args)
{
    $__GET = wp_unslash($_GET); // phpcs:ignore WordPress.Security.NonceVerification.Recommended
    if (!empty($__GET['seoaic_title'])) {
        $args['post_title_like'] = $__GET['seoaic_title'];
    }
}

function SEOAIC_addClusterQuery( &$args ) {
    $__GET = wp_unslash( $_GET ); // phpcs:ignore WordPress.Security.NonceVerification.Recommended

    if ( ! empty( $__GET['seoiac_selected_cluster'] ) ) {
        $cluster = urldecode( $__GET['seoiac_selected_cluster'] );
        $cluster = sanitize_text_field( $cluster );

        if ( ! isset( $args['meta_query'] ) || ! is_array( $args['meta_query'] ) ) {
            $args['meta_query'] = [];
        }

        $args['meta_query'][] = [
            'key'     => 'seoaic_cluster',
            'value'   => $cluster,
            'compare' => '=',
        ];
    }
}

function SEOAIC_addContentLikeQuery(array &$args, string $field, string $value)
{
    if (
        '0' == $value
    ) {
        $args['post_content_not_like'] = $field;

    } else {
        $args['post_content_like'] = $field;
    }
}

function SEOAIC_addWordsRangeQuery(&$args)
{
    $__GET = wp_unslash($_GET); // phpcs:ignore WordPress.Security.NonceVerification.Recommended
    $min = null;
    $max = null;

    $is_valid = function ($value) {
        return !empty($value)
            && is_numeric($value)
            && intval($value) == $value;
    };

    $min = isset($__GET['seoaic_words_min']) && $is_valid($__GET['seoaic_words_min']) ? $__GET['seoaic_words_min'] : null;
    $max = isset($__GET['seoaic_words_max']) && $is_valid($__GET['seoaic_words_max']) ? $__GET['seoaic_words_max'] : null;

    if (empty($args['meta_query'])) {
        $args['meta_query'] = [ // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_query
            'relation' => 'AND',
        ];
    }

    if (!empty($min)) {
        $args['meta_query'][] = [
            'key' => SEOAIC_POSTS::WORDS_COUNT_FIELD, // phpcs:ignore
            'value' => $min,
            'compare' => '>=',
            'type' => 'NUMERIC',
        ];
    }
    if (!empty($max)) {
        $args['meta_query'][] = [
            'key' => SEOAIC_POSTS::WORDS_COUNT_FIELD,
            'value' => $max,
            'compare' => '<=',
            'type' => 'NUMERIC',
        ];
    }
}

function SEOAIC_addCreatedDateQuery(&$args)
{
    $__GET = wp_unslash($_GET); // phpcs:ignore WordPress.Security.NonceVerification.Recommended
    $after = null;
    $before = null;

    if (
        !empty($__GET['seoaic_create_datefrom'])
        && SEOAIC_isValidDate(urldecode($__GET['seoaic_create_datefrom']))
    ) {
        $after = strtotime(urldecode($__GET['seoaic_create_datefrom']));
    }
    if (
        !empty($__GET['seoaic_create_dateto'])
        && SEOAIC_isValidDate(urldecode($__GET['seoaic_create_dateto']))
    ) {
        $before = strtotime(urldecode($__GET['seoaic_create_dateto']) . ' 23:59:59');
    }


    if (empty($args['meta_query'])) {
        $args['meta_query'] = [ // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_query
            'relation' => 'AND',
        ];
    }

    if (!empty($after)) {
        $args['meta_query'][] = [
            'key' => 'post_created_date',
            'value' => $after,
            'compare' => '>=',
        ];
    }
    if (!empty($before)) {
        $args['meta_query'][] = [
            'key' => 'post_created_date',
            'value' => $before,
            'compare' => '<=',
        ];
    }
}

// function SEOAIC_countPostsMapLang($lang = '')
// {
//     if ('all' == $lang) {
//         $args = array(
//             'posts_per_page' => -1,
//             'post_type' => 'any',
//             'post_status' => SEOAIC_POSTS::ANY_STATUS,
//             'meta_key' => 'seoaic_posted', // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_key
//             'meta_value' => '1', // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_value
//             'date_query' => SEOAIC_makeDateQuery(),
//             'lang' => '',
//         );

//         // } else if ('none' == $lang) {
//         //     $args = array(
//         //         'posts_per_page'    => -1,
//         //         'post_type'         => 'any',
//         //         'post_status'       => 'any',
//         //         'meta_key'          => 'seoaic_posted',
//         //         'meta_value'        => '1',
//         //         'date_query'        => SEOAIC_makeDateQuery(),
//         //     );

//     } else {
//         $args = array(
//             'posts_per_page' => -1,
//             'post_type' => 'any',
//             'post_status' => SEOAIC_POSTS::ANY_STATUS,
//             'meta_key' => 'seoaic_posted', // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_key
//             'meta_value' => '1', // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_value
//             'date_query' => SEOAIC_makeDateQuery(),
//             'lang' => $lang,
//         );
//     }
//     SEOAIC_addTitleQuery($args);
//     SEOAIC_addClusterQuery($args);
//     SEOAIC_addWordsRangeQuery($args);
//     SEOAIC_addCreatedDateQuery($args);

//     $args['cache_results'] = false;

//     if (!isset($args['post_status'])) {
//         $args['post_status'] = SEOAIC_POSTS::ANY_STATUS;
//     }

//     $posts_query = new WP_Query($args);
//     return $posts_query->post_count;
// }

function SEOAIC_countPosts(array $statuses, array $otherStatusesKeys = [])
{
    return array_combine($statuses, array_map(function (string $status = '') use ($otherStatusesKeys)
    {
        if ('all' == $status) {
            $args = array(
                'posts_per_page' => -1,
                'post_type' => 'any',
                'post_status' => array_merge(SEOAIC_POSTS::ANY_STATUS, $otherStatusesKeys),
                'meta_key' => 'seoaic_posted', // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_key
                'meta_value' => '1', // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_value
                'date_query' => SEOAIC_makeDateQuery(),
            );

        } else if (
            in_array($status, SEOAIC_POSTS::ANY_STATUS)
            || in_array($status, $otherStatusesKeys)
        ) {
            $args = array(
                'posts_per_page' => -1,
                'post_type' => 'any',
                'post_status' => $status,
                'meta_key' => 'seoaic_posted', // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_key
                'meta_value' => '1', // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_value
                'date_query' => SEOAIC_makeDateQuery(),
                'meta_query' => [ // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_query
                    'relation' => 'AND',
                    [
                        'key' => 'seoaic_auto_scheduled',
                        'compare' => 'NOT EXISTS',
                    ],
                ],
            );

        } else if (0 === strpos($status, 'edit:')) {
            $status_substr = str_replace('edit:', '', $status);
            $args = array(
                'posts_per_page' => -1,
                'post_status'   => array_merge(SEOAIC_POSTS::ANY_STATUS, $otherStatusesKeys),
                'date_query'    => SEOAIC_makeDateQuery(),
                'meta_query'    => [ // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_query
                    'relation' => 'AND',
                    [
                        'key' => 'seoaic_posted',
                        'value' => '1',
                        'compare' => '=',
                    ],
                    [
                        'key' => 'seoaic_update_status',
                        'value' => $status_substr,
                        'compare' => '=',
                    ],
                ],
            );

        } else if (0 === strpos($status, 'review:')) {
            $status_substr = explode(':', str_replace('review:', '', $status));
            $args = array(
                'posts_per_page' => -1,
                'post_status'   => array_merge(SEOAIC_POSTS::ANY_STATUS, $otherStatusesKeys),
                'date_query'    => SEOAIC_makeDateQuery(),
                'meta_query'    => [ // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_query
                    'relation' => 'AND',
                    [
                        'key' => 'seoaic_posted',
                        'value' => '1',
                        'compare' => '=',
                    ],
                    [
                        'key' => 'seoaic_review_status',
                        'value' => $status_substr[0],
                        'compare' => '=',
                    ],
                ],
            );
            if (!empty($status_substr[1])) {
                $args['meta_query'][] = [
                    'key' => 'seoaic_review_result',
                    'value' => $status_substr[1],
                    'compare' => '=',
                ];
            }
        } else if ($status === 'seoaic_auto_scheduled') {
            $args = array(
                'posts_per_page' => -1,
                'post_type'     => 'any',
                'post_status'   => array_merge(SEOAIC_POSTS::ANY_STATUS, $otherStatusesKeys),
                'date_query'    => SEOAIC_makeDateQuery(),
                'meta_query' => [ // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_query
                    'relation' => 'AND',
                    [
                        'key' => 'seoaic_posted',
                        'value' => '1',
                        'compare' => '=',
                    ],
                    [
                        'key' => 'seoaic_auto_scheduled',
                        'value' => '1',
                        'compare' => '=',
                    ],
                ],
            );
        }
        SEOAIC_addTitleQuery($args);
        SEOAIC_addClusterQuery($args);
        SEOAIC_addWordsRangeQuery($args);
        SEOAIC_addCreatedDateQuery($args);

        $args['cache_results'] = false;
        $args['lang'] = '';
        $args['suppress_filters'] = true; // phpcs:ignore WordPressVIPMinimum.Performance.WPQueryParams.SuppressFilters_suppress_filters
        if (!isset($args['post_status'])) {
            $args['post_status'] = array_merge(SEOAIC_POSTS::ANY_STATUS, $otherStatusesKeys);
        }

        $args['post_type'] = ['post', SEOAIC_SETTINGS::getSEOAICPostType()];
        $args['skip_hiding'] = true;
        $posts_query = new WP_Query($args);

        return $posts_query->post_count;
    }, $statuses));
}

function SEOAIC_countPostsByLang($langs)
{
    global $SEOAIC;

    return array_combine(
        $langs,
        array_map(
            function ($item) use ($SEOAIC) {
                return $SEOAIC->multilang->countPostsMapLang(
                    $item,
                    function () {
                        return SEOAIC_makeDateQuery();
                    },
                    function (&$args) {
                        SEOAIC_addTitleQuery($args);
                        SEOAIC_addClusterQuery($args);
                        SEOAIC_addWordsRangeQuery($args);
                        SEOAIC_addCreatedDateQuery($args);
                    }
                );
            },
            $langs
        )
    );
}

function SEOAIC_postsPagination($query)
{
    $__GET = wp_unslash($_GET); // phpcs:ignore WordPress.Security.NonceVerification.Recommended
    ?>
    <div class="seoaic-pagination">
        <?php
        $big = 999999999;
        $paged = !empty($__GET['paged']) ? $__GET['paged'] : 1;
        $paginationHTML = paginate_links([
            'base' => str_replace([$big, '&#038;'], ['%#%', '&'], get_pagenum_link($big)),
            'total' => $query->max_num_pages,
            // 'current'      => max( 1, get_query_var( 'paged' ) ),
            'current' => max(1, $paged),
            'format' => '?paged=%#%',
            'show_all' => false,
            'type' => 'plain',
            'end_size' => 2,
            'mid_size' => 1,
            'prev_next' => true,
            'prev_text' => sprintf('<i></i> %1$s', esc_html__('Prev', 'seoaic')),
            'next_text' => sprintf('%1$s <i></i>', esc_html__('Next', 'seoaic')),
            'add_args' => false,
            'add_fragment' => '',
        ]);
        $paginationHTML = !empty($paginationHTML) ? $paginationHTML : '';

        echo wp_kses($paginationHTML, [
            'div' => [
                'class' => [],
            ],
            'span' => [
                'class'         => [],
                'aria-current'  => [],
            ],
            'a' => [
                'class' => [],
                'href'  => [],
            ],
            'i' => [],
        ]);
        ?>
    </div>
    <?php
}

$SEOAIC->posts->setSEOAICPostsWordsCount();

$editInProgress = (new PostsMassEdit($SEOAIC))->isRunning();
$reviewInProgress = (new PostsMassReview($SEOAIC))->isRunning();
$translateInProgress = (new PostsMassTranslate($SEOAIC))->isRunning();
$generatingThumbnailPostsAll = (new ThumbnailsGenerate($SEOAIC))->getGeneratingThumbnailPostsAll();
$generatingThumbnailPostsIDs = array_map(function ($item) {
    return $item->ID;
}, $generatingThumbnailPostsAll);
$generatingLeadFormsPostsAll = (new LeadsFormGenerate($SEOAIC))->getGeneratingPostsWithLeadsAll();
$generatingLeadFormsPostsIDs = array_column($generatingLeadFormsPostsAll, 'ID');
$leadFormsInProgress = (new LeadsFormGenerate($SEOAIC))->isRunning();

$generatingFAQPostsAll = (new FAQGenerate($SEOAIC))->getGeneratingFAQPostsAll();
$generatingFAQPostsIDs = array_column($generatingFAQPostsAll, 'ID');
$faqInProgress = (new FAQGenerate($SEOAIC))->isRunning();
// error_log('generatingFAQPostsIDs '.print_r($generatingFAQPostsIDs, true));

$otherStatuses = seoaicGetOtherStatuses();
$otherStatusesKeys = array_keys($otherStatuses);
$autoScheduledStatus = !empty($__GET['post_status']) && $__GET['post_status'] === 'seoaic_auto_scheduled';
$post_status = '';
$edit_status = '';
$review_status = '';

if (!empty($__GET['post_status'])) {
    if (
        in_array($__GET['post_status'], SEOAIC_POSTS::ANY_STATUS)
        || in_array($__GET['post_status'], $otherStatusesKeys)
        || $autoScheduledStatus
    ) {
        $post_status = $__GET['post_status'];
    }
}

if (!empty($__GET['edit_status'])) {
    switch ($__GET['edit_status']) {
        case 'pending':
        case 'completed':
        case 'failed':
            $edit_status = $__GET['edit_status'];
            break;
    }
}

if (!empty($__GET['review_status'])) {
    switch ($__GET['review_status']) {
        case 'reviewing':
        case 'completed:yes':
        case 'completed:no':
        case 'completed:unknown':
        case 'failed':
            $review_status = $__GET['review_status'];
            break;
    }
}
$selectedLang = !empty($__GET['lang-filter']) && $SEOAIC->multilang->is_multilang() ? esc_sql($__GET['lang-filter']) : '';
$multilangCurrentLang = $SEOAIC->multilang->get_current_language('code');

$postThumbnailStatus = !empty($__GET['has-thumbnail']) ? $__GET['has-thumbnail'] : '';
$hasThumbnail = 'yes' == $postThumbnailStatus;
$noThumbnail = 'no' == $postThumbnailStatus;

$postVisibleFilter = !empty($__GET['post-visibility']) ? $__GET['post-visibility'] : '';
$postVisible = 'visible' == $postVisibleFilter;
$postHide = 'hide' == $postVisibleFilter;

$faqFilter = isset($__GET['seoai-faq']) ? $__GET['seoai-faq'] : '';
$leadFilter = isset($__GET['seoai-lead']) ? $__GET['seoai-lead'] : '';
$interactiveFilter = isset($__GET['seoai-interactive']) ? $__GET['seoai-interactive'] : '';

$noFiltersSelected = empty($post_status)
                && empty($edit_status)
                && empty($review_status)
                && empty($selectedLang)
                && empty($postThumbnailStatus)
                && empty($postVisibleFilter)
                && '' == $faqFilter
                && '' == $leadFilter
                && '' == $interactiveFilter;

$postIsPublished = 'publish' == $post_status;
$postIsDraft = 'draft' == $post_status;
$postIsFuture = 'future' == $post_status;
$postIsAutoScheduled = 'seoaic_auto_scheduled' == $post_status;

$edit_is_pending = 'pending' == $edit_status;
$edit_is_completed = 'completed' == $edit_status;
$edit_is_failed = 'failed' == $edit_status;

$review_is_reviewing = 'reviewing' == $review_status;
$review_is_completed_yes = 'completed:yes' == $review_status;
$review_is_completed_no = 'completed:no' == $review_status;
$review_is_completed_unknown = 'completed:unknown' == $review_status;
$review_is_failed = 'failed' == $review_status;

$faqExists = '1' == $faqFilter;
$faqNotExists = '0' == $faqFilter;

$leadExists = '1' == $leadFilter;
$leadNotExists = '0' == $leadFilter;

$interactiveExists = '1' == $interactiveFilter;
$interactiveNotExists = '0' == $interactiveFilter;

$statuses = array_merge(['all', 'publish', 'draft', 'future', 'edit:pending', 'edit:completed', 'edit:failed', 'review:completed:yes', 'review:completed:no', 'review:completed:unknown', 'review:reviewing', 'review:failed', 'seoaic_auto_scheduled'], array_keys($otherStatuses));
$countsByStatus = SEOAIC_countPosts($statuses, array_keys($otherStatuses));

$available_per_page_options = [10, 20, 50, 100, 200, 500, 1000];
$selected_per_page = !empty($__GET['per_page']) && is_numeric($__GET['per_page']) && in_array($__GET['per_page'], $available_per_page_options) ? intval($__GET['per_page']) : 10;
$paged = !empty($__GET['paged']) && is_numeric($__GET['paged']) ? intval($__GET['paged']) : 1;

$allowed_order_by = ['ID', 'title', 'date'];
$allowed_order = ['asc', 'desc'];

$order_by = !empty($__GET['orderby']) && in_array($__GET['orderby'], $allowed_order_by) ? $__GET['orderby'] : 'date';
$order = !empty($__GET['order']) && in_array($__GET['order'], $allowed_order) ? $__GET['order'] : 'desc';


// main query
$args = [
    'posts_per_page'    => $selected_per_page,
    'paged'             => $paged,
    'post_type'         => 'any',
    'lang'              => $selectedLang,
    'orderby'           => [
        $order_by   => $order,
        'ID'        => $order
    ],
    'date_query'        => SEOAIC_makeDateQuery(),
    'meta_query'        => [ // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_query
        'relation' => 'AND',
        [
            'key'       => 'seoaic_posted',
            'value'     => '1',
            'compare'   => '=',
        ],
        [
            'key'       => 'seoaic_auto_scheduled',
            'compare'   => 'NOT EXISTS',
        ],
    ],
];

if (!empty($post_status)) {
    $args['post_status'] = $post_status;

} else {
    $args['post_status'] = array_merge(SEOAIC_POSTS::ANY_STATUS, $otherStatusesKeys);

    if (!empty($edit_status)) {
        $args['meta_query'][] = [
            [
                'key'       => 'seoaic_update_status',
                'value'     => $edit_status,
                'compare'   => '=',
            ],
        ];

    } elseif (!empty($review_status)) {
        $review_status_arr = explode(':', $review_status);
        $args['meta_query'][] = [
            [
                'key'       => 'seoaic_review_status',
                'value'     => $review_status_arr[0],
                'compare'   => '=',
            ],
        ];
        if (!empty($review_status_arr[1])) {
            $args['meta_query'][] = [
                'key'       => 'seoaic_review_result',
                'value'     => $review_status_arr[1],
                'compare'   => '=',
            ];
        }
    }
}

if ($autoScheduledStatus) {
    $args['meta_query'][1] = [
        'key'       => 'seoaic_auto_scheduled',
        'value'     => '1',
        'compare'   => '=',
    ];
    $args['post_status'] = array_merge(SEOAIC_POSTS::ANY_STATUS, $otherStatusesKeys);

} else if (empty($__GET['post_status'])) {
    unset($args['meta_query'][1]);
}

if (!empty($postThumbnailStatus)) {
    if ($postThumbnailStatus === 'yes') {
        $args['meta_query'][] = [
            [
                'key'       => '_thumbnail_id',
                'compare'   => 'EXISTS',
            ]
        ];
    }

    if ($postThumbnailStatus === 'no') {
        $args['meta_query'][] = [
            [
                'key'       => '_thumbnail_id',
                'compare'   => 'NOT EXISTS'
            ],
        ];
    }
}

if (!empty($postVisibleFilter)) {
    if ($postVisibleFilter === 'visible') {
        $args['meta_query'][] = [
            [
                'key'       => 'seoaic_visible_post',
                'compare'   => '=',
                'value'     => 1
            ]
        ];
    }

    if ($postVisibleFilter === 'hide') {
        $args['meta_query'][] = [
            'relation' => 'OR',
            [
                'key'       => 'seoaic_visible_post',
                'compare'   => 'NOT EXISTS'
            ],
            [
                'key'       => 'seoaic_visible_post',
                'compare'   => '!=',
                'value'     => 1
            ]
        ];
    }
}

SEOAIC_addTitleQuery($args);
SEOAIC_addClusterQuery($args);
SEOAIC_addWordsRangeQuery($args);
SEOAIC_addCreatedDateQuery($args);
if (isset($__GET['seoai-faq'])) {
    SEOAIC_addContentLikeQuery($args, SeoaicShortcodes::FAQ_SHORTCODE, $__GET['seoai-faq']);
}
if (isset($__GET['seoai-lead'])) {
    SEOAIC_addContentLikeQuery($args, SeoaicShortcodes::MULTISTEP_FORM_SHORTCODE, $__GET['seoai-lead']);
}
if (isset($__GET['seoai-interactive'])) {
    SEOAIC_addContentLikeQuery($args, 'interactive-article-block', $__GET['seoai-interactive']);
}

$args['cache_results'] = false;
if (empty($args['post_status'])) {
    $args['post_status'] = array_merge(SEOAIC_POSTS::ANY_STATUS, $otherStatusesKeys);
}

$SEOAIC->multilang->preProcessPostsMainQuery($args, $selectedLang);
$query = new WP_Query($args);
$SEOAIC->multilang->postProcessPostsMainQuery($multilangCurrentLang); // important for WPML
$publishedDateFromValue = !empty($__GET['seoaic_publ_datefrom']) && SEOAIC_isValidDate(urldecode($__GET['seoaic_publ_datefrom'])) ? urldecode($__GET['seoaic_publ_datefrom']) : '';
$publishedDateToValue = !empty($__GET['seoaic_publ_dateto']) && SEOAIC_isValidDate(urldecode($__GET['seoaic_publ_dateto'])) ? urldecode($__GET['seoaic_publ_dateto']) : '';
$createdDateFromValue = !empty($__GET['seoaic_create_datefrom']) && SEOAIC_isValidDate(urldecode($__GET['seoaic_create_datefrom'])) ? urldecode($__GET['seoaic_create_datefrom']) : '';
$createdDateToValue = !empty($__GET['seoaic_create_dateto']) && SEOAIC_isValidDate(urldecode($__GET['seoaic_create_dateto'])) ? urldecode($__GET['seoaic_create_dateto']) : '';

$maxWordsCount = SEOAIC_POSTS::getMaxWordsCount();
$maxWordsCountCeil = ceil($maxWordsCount / 10) * 10;
$countMinDefault = 0;
$countMaxDefault = $maxWordsCount;
$countMin = isset($__GET['seoaic_words_min']) ? $__GET['seoaic_words_min'] : $countMinDefault;
$countMax = isset($__GET['seoaic_words_max']) ? $__GET['seoaic_words_max'] : $countMaxDefault;

$adminUrl = SEOAIC::getAdminUrl('admin.php');
$isMultilang = $SEOAIC->multilang->is_multilang();

$statusesLabels = [
    'publish' => esc_html__('Published', 'seoaic'),
    'draft' => esc_html__('Draft', 'seoaic'),
];

$showAllFilters = isset($__GET['post-visibility'])
                || isset($__GET['has-thumbnail'])
                || isset($__GET['seoai-faq'])
                || isset($__GET['seoai-lead'])
                || isset($__GET['seoai-interactive']);

$makeFilterBtnURL = function (array $params = [], array $newparam = []) use ($adminUrl) {
    return $adminUrl . '?' . http_build_query(array_merge($params, $newparam));
};

?>
<div class="seoaic-posts-table full-width <?php echo $showAllFilters ? esc_attr('filters-opened') : '';?>"">
    <div class="header seoaic-flip-box">
        <div class="seoaic-flip-container">
            <div class="seoaic-flip-item seoaic-flip-front">
                <div>
                    <form action="" class="seoaic-posts-search-form mt-20 d-flex gap-15">
                        <input type="hidden"
                            name="page"
                            value="<?php echo !empty($__GET['page']) ? esc_attr($__GET['page']) : '';?>"
                        >
                        <div class="f-text">
                            <span class="filters-label"><?php esc_html_e('Search:', 'seoaic'); ?></span>
                        </div>
                        <div class="seoaic-posts-fiters-rows">
                            <div class="seoaic-posts-fiters-row d-flex gap-15">
                                <div class="f-title">
                                    <label class="text-label"><?php esc_html_e('Post title keywords', 'seoaic'); ?></label>
                                    <input type="text"
                                            name="filter_post_title"
                                            class="form-input"
                                            value="<?php echo !empty($__GET['seoaic_title']) ? esc_attr(urldecode($__GET['seoaic_title'])) : ''; ?>"
                                    >
                                </div>
                                <div id="seoaic-created-posts-cluster-filter" class="ai-start d-flex flex-column jc-e select-cluster position-relative">
                                    <label for="seoaic-onboarding-select-select-cluster" class="text-label"><?php esc_html_e('Select cluster', 'seoaic'); ?></label>
                                    <div class="seoaic-loader-container position-absolute" id="seoaic_load_clusters_progress">
                                        <span class="loader-text seoaic-loading-label accent seoaic-text-nowrap fw-600"><span class="loader-value-percentage" data-progress="0">0%</span></span>
                                        <div class="seoaic-progress-bar ml-10"><span></span></div>
                                    </div>
                                    <select id="seoaic-onboarding-select-select-cluster"
                                            class="form-input opacity-0"
                                            name="selected_cluster"
                                            data-placeholder="<?php _e('Not Selected', 'seoaic'); ?>">
                                        <option value=""></option>
                                    </select>
                                </div>
                                <div class="f-words-count seoaic-settings-range seoaic-settings-range-2 mt-0 mb-0"
                                        data-min="0"
                                        data-max="<?php echo esc_attr($maxWordsCountCeil);?>"
                                        data-step="10"
                                >
                                    <label><?php esc_html_e('Content words range:', 'seoaic'); ?>
                                        <span class="range-min"><?php echo esc_html($countMin); ?></span> -
                                        <span class="range-max"><?php echo esc_html($countMax); ?></span>
                                        <input type="hidden"
                                                id="seoaic_words_range_min"
                                                class="seoaic-settings-range-min seoaic-form-item"
                                                name="words_range_min"
                                                value="<?php echo esc_attr($countMin); ?>"
                                        >
                                        <input type="hidden"
                                                id="seoaic_words_range_max"
                                                class="seoaic-settings-range-max seoaic-form-item"
                                                name="words_range_max"
                                                value="<?php echo esc_attr($countMax); ?>"
                                        >
                                    </label>
                                    <div id="seoiac-modal-subtitles-range-slider"
                                         class="seoaic-settings-range-slider"
                                    ></div>
                                </div>

                            </div>
                            <div class="seoaic-posts-fiters-row d-flex gap-15">
                                <div class="f-date">
                                    <label class="text-label"><?php esc_html_e('Published / scheduled', 'seoaic'); ?></label>
                                    <div class="position-relative">
                                        <input type="text"
                                                name="filter_post_date_from"
                                                value="<?php echo esc_attr($publishedDateFromValue); ?>"
                                                class="mt-0 seoaic-form-item form-input"
                                                placeholder="<?php esc_attr_e('Published from', 'seoaic');?>"
                                        >
                                        <div class="picker-call"></div>
                                    </div>
                                </div>
                                <div class="f-date">
                                    <label class="text-label"></label>
                                    <div class="position-relative">
                                        <input type="text"
                                                name="filter_post_date_to"
                                                value="<?php echo esc_attr($publishedDateToValue); ?>"
                                                class="mt-0 seoaic-form-item form-input"
                                                placeholder="<?php esc_attr_e('Published to', 'seoaic');?>"
                                        >
                                        <div class="picker-call"></div>
                                    </div>
                                </div>
                                <div class="f-date">
                                    <label class="text-label"><?php esc_html_e('Created date', 'seoaic'); ?></label>
                                    <div class="position-relative">
                                        <input type="text"
                                                name="filter_post_created_date_from"
                                                value="<?php echo esc_attr($createdDateFromValue); ?>"
                                                class="mt-0 seoaic-form-item form-input"
                                                placeholder="<?php esc_attr_e('Created from', 'seoaic');?>"
                                        >
                                        <div class="picker-call"></div>
                                    </div>
                                </div>
                                <div class="f-date">
                                    <label class="text-label"></label>
                                    <div class="position-relative">
                                        <input type="text"
                                                name="filter_post_created_date_to"
                                                value="<?php echo esc_attr($createdDateToValue); ?>"
                                                class="mt-0 seoaic-form-item form-input"
                                                placeholder="<?php esc_attr_e('Created to', 'seoaic');?>"
                                        >
                                        <div class="picker-call"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="seoaic-posts-filter-btns d-flex gap-15">
                            <div class="f-btn position-relative">
                                <button type="submit"
                                        class="filter-search-btn filter-btn"
                                        title="<?php esc_attr_e('Filter', 'seoaic'); ?>"
                                ></button>
                            </div>
                            <div class="f-btn position-relative">
                                <a href="<?php echo esc_url($makeFilterBtnURL([], ['page' => 'seoaic-created-posts']));?>"
                                    class="filter-clear-btn filter-btn"
                                    title="<?php esc_attr_e('Clear all filters', 'seoaic'); ?>"></a>
                            </div>
                        </div>
                    </form>
                </div>

                <div class="filters-switcher seoaic-flex-column mt-15 <?php echo $showAllFilters ? esc_attr('opened') : '';?>">
                    <div class="seoaic-filter-rows w-100">
                        <div class="seoaic-filter-row">
                            <?php
                            $__get = $__GET;
                            $__get['paged'] = 1;
                            unset($__get['post_status']);
                            unset($__get['review_status']);
                            unset($__get['lang-filter']);
                            unset($__get['post-visibility']);
                            unset($__get['has-thumbnail']);
                            unset($__get['seoai-faq']);
                            unset($__get['seoai-lead']);
                            unset($__get['seoai-interactive']);

                            ?>
                            <label class="mb-0"><?php esc_html_e('Mass edit status:', 'seoaic');?></label>
                            <a href="<?php echo esc_url($makeFilterBtnURL($__get, ['edit_status' => 'completed']));?>"
                                title="<?php esc_attr_e('Posts that were updated', 'seoaic'); ?>"
                                class="seoaic-filter-btn <?php echo $edit_is_completed ? 'active' : ''; ?>"
                            >
                                <?php esc_html_e('Completed:', 'seoaic');?> <?php echo esc_html($countsByStatus['edit:completed']); ?>
                            </a>
                            <a href="<?php echo esc_url($makeFilterBtnURL($__get, ['edit_status' => 'pending']));?>"
                                title="<?php esc_attr_e('Posts that are still queued for updating', 'seoaic');?>"
                                class="seoaic-filter-btn <?php echo $edit_is_pending ? 'active' : ''; ?>"
                            >
                                <?php esc_html_e('Pending:', 'seoaic');?> <?php echo esc_html($countsByStatus['edit:pending']);?>
                            </a>
                            <a href="<?php echo esc_url($makeFilterBtnURL($__get, ['edit_status' => 'failed']));?>"
                                title="<?php esc_attr_e('Posts which processing failed', 'seoaic');?>"
                                class="seoaic-filter-btn <?php echo $edit_is_failed ? 'active' : '';?>"
                            >
                                <?php esc_html_e('Failed:', 'seoaic');?> <?php echo esc_html($countsByStatus['edit:failed']);?>
                            </a>
                        </div>

                        <div class="seoaic-filter-row">
                            <?php
                            $__get = $__GET;
                            $__get['paged'] = 1;
                            unset($__get['post_status']);
                            unset($__get['edit_status']);
                            unset($__get['lang-filter']);
                            unset($__get['post-visibility']);
                            unset($__get['has-thumbnail']);
                            unset($__get['seoai-faq']);
                            unset($__get['seoai-lead']);
                            unset($__get['seoai-interactive']);
                            ?>
                            <label class="mb-0"><?php esc_html_e('Mass review status:', 'seoaic');?></label>
                            <a href="<?php echo esc_url($makeFilterBtnURL($__get, ['review_status' => 'completed:yes']));?>"
                                title="<?php esc_attr_e('Posts that meet the review prompt condition', 'seoaic'); ?>"
                                class="seoaic-filter-btn <?php echo $review_is_completed_yes ? 'active' : ''; ?>"
                            >
                                <?php esc_html_e('Yes:', 'seoaic');?> <?php echo esc_html($countsByStatus['review:completed:yes']); ?>
                            </a>
                            <a href="<?php echo esc_url($makeFilterBtnURL($__get, ['review_status' => 'completed:no']));?>"
                                title="<?php esc_attr_e('Posts that do not meet the review prompt condition', 'seoaic'); ?>"
                                class="seoaic-filter-btn <?php echo $review_is_completed_no ? 'active' : ''; ?>"
                            >
                                <?php esc_html_e('No:', 'seoaic');?> <?php echo esc_html($countsByStatus['review:completed:no']); ?>
                            </a>
                            <a href="<?php echo esc_url($makeFilterBtnURL($__get, ['review_status' => 'completed:unknown']));?>"
                                title="<?php esc_attr_e('Posts that needed to be checked manually', 'seoaic'); ?>"
                                class="seoaic-filter-btn <?php echo $review_is_completed_unknown ? 'active' : ''; ?>"
                            >
                                <?php esc_html_e('Requires attention:', 'seoaic');?> <?php echo esc_html($countsByStatus['review:completed:unknown']); ?>
                            </a>
                            <a href="<?php echo esc_url($makeFilterBtnURL($__get, ['review_status' => 'reviewing']));?>"
                                title="<?php esc_attr_e('Posts that are still queued for reviewing', 'seoaic'); ?>"
                                class="seoaic-filter-btn <?php echo $review_is_reviewing ? 'active' : ''; ?>"
                            >
                                <?php esc_html_e('Reviewing:', 'seoaic');?> <?php echo esc_html($countsByStatus['review:reviewing']); ?>
                            </a>
                            <a href="<?php echo esc_url($makeFilterBtnURL($__get, ['review_status' => 'failed']));?>"
                                title="<?php esc_attr_e('Posts which processing failed', 'seoaic'); ?>"
                                class="seoaic-filter-btn <?php echo $review_is_failed ? 'active' : ''; ?>"
                            >
                                <?php esc_html_e('Failed:', 'seoaic');?> <?php echo esc_html($countsByStatus['review:failed']); ?>
                            </a>
                        </div>

                        <?php
                        if ($SEOAIC->multilang->is_multilang()) {
                            $langs = $SEOAIC->multilang->get_multilanguages();
                            $countsByLang = SEOAIC_countPostsByLang(array_merge(['all'], array_map(function ($lang) {
                                return $lang['code'];
                            }, $langs)));
                            $__get = $__GET;
                            $__get['paged'] = 1;
                            unset($__get['lang-filter']);
                            unset($__get['post_status']);
                            unset($__get['edit_status']);
                            unset($__get['review_status']);
                            unset($__get['post-visibility']);
                            unset($__get['has-thumbnail']);
                            unset($__get['seoai-faq']);
                            unset($__get['seoai-lead']);
                            unset($__get['seoai-interactive']);
                            ?>
                            <div class="seoaic-filter-row">
                                <label class="mb-0"><?php esc_html_e('Post language:', 'seoaic');?></label>
                                <a href="<?php echo esc_url($makeFilterBtnURL($__get, ['lang-filter' => 'all']));?>"
                                    title="<?php esc_attr_e('All languages', 'seoaic'); ?>"
                                    class="seoaic-filter-btn <?php echo 'all' == $selectedLang ? 'active' : ''; ?>"
                                >
                                    <?php esc_html_e('All', 'seoaic'); ?>: <?php echo esc_html($countsByLang['all']); ?>
                                </a>
                                <?php
                                if (
                                    !empty($langs)
                                    && is_array($langs)
                                ) {
                                    foreach ($langs as $lang) {
                                        ?>
                                        <a href="<?php echo esc_url($makeFilterBtnURL($__get, ['lang-filter' => esc_js($lang['code'])]));?>"
                                            title="<?php echo esc_attr($lang['name']); ?>"
                                            class="seoaic-filter-btn <?php echo $lang['code'] == $selectedLang ? 'active' : ''; ?>"
                                        >
                                            <?php if (!empty($lang['flag'])) : ?>
                                                <img src="<?php echo esc_url($lang['flag']); ?>">
                                            <?php else : ?>
                                                <?php echo esc_html(strtoupper($lang['code'])); ?>:
                                            <?php endif; ?>
                                            <?php echo esc_html($countsByLang[$lang['code']]);?>
                                        </a>
                                        <?php
                                    }
                                }
                                ?>
                            </div>
                            <?php
                        }
                        ?>

                        <div class="seoaic-filter-row">
                            <label class="mb-0"><?php esc_html_e('Post status:', 'seoaic');?></label>
                            <?php
                            $__get = $__GET;
                            $__get['paged'] = 1;
                            unset($__get['post_status']);
                            unset($__get['edit_status']);
                            unset($__get['review_status']);
                            unset($__get['lang-filter']);
                            unset($__get['post-visibility']);
                            unset($__get['has-thumbnail']);
                            unset($__get['seoai-faq']);
                            unset($__get['seoai-lead']);
                            unset($__get['seoai-interactive']);
                            ?>
                            <a href="<?php echo esc_url($makeFilterBtnURL($__get, ['post_status' => 'publish']));?>"
                                title="<?php esc_attr_e('Published posts', 'seoaic'); ?>"
                                class="seoaic-filter-btn <?php echo $postIsPublished ? 'active' : ''; ?>"
                            >
                                <?php esc_html_e('Published', 'seoaic'); ?>: <?php echo esc_html($countsByStatus['publish']); ?>
                            </a>
                            <a href="<?php echo esc_url($makeFilterBtnURL($__get, ['post_status' => 'draft']));?>"
                                title="<?php esc_attr_e('Drafts', 'seoaic'); ?>"
                                class="seoaic-filter-btn <?php echo $postIsDraft ? 'active' : ''; ?>"
                            >
                                <?php esc_html_e('Drafts', 'seoaic'); ?>: <?php echo esc_html($countsByStatus['draft']); ?>
                            </a>
                            <a href="<?php echo esc_url($makeFilterBtnURL($__get, ['post_status' => 'future']));?>"
                                title="<?php esc_attr_e('Future posts', 'seoaic'); ?>"
                                class="seoaic-filter-btn <?php echo $postIsFuture ? 'active' : ''; ?>"
                            >
                                <?php esc_html_e('Future', 'seoaic'); ?>: <?php echo esc_html($countsByStatus['future']); ?>
                            </a>
                            <a href="<?php echo esc_url($makeFilterBtnURL($__get, ['post_status' => 'seoaic_auto_scheduled']));?>"
                               title="<?php esc_attr_e('Auto scheduled', 'seoaic'); ?>"
                               class="seoaic-filter-btn <?php echo $postIsAutoScheduled ? 'active' : ''; ?>">
                                <?php esc_html_e('Auto scheduled', 'seoaic'); ?>: <?php echo esc_html($countsByStatus['seoaic_auto_scheduled']); ?>
                            </a>
                            <?php
                            if (!empty($otherStatuses)) {
                                foreach ($otherStatuses as $key => $label) {
                                    if (!empty($countsByStatus[$key])) {
                                        $isActive = $post_status == $key;
                                        ?>
                                        <a href="<?php echo esc_url($makeFilterBtnURL($__get, ['post_status' => $key]));?>"
                                            class="seoaic-filter-btn <?php echo $isActive ? 'active' : '';?>"
                                        >
                                            <?php echo esc_html($label); ?>: <?php echo esc_html($countsByStatus[$key]);?>
                                        </a>
                                        <?php
                                    }
                                }
                            }
                            ?>
                        </div>

                        <?php
                        if (SEOAIC_SETTINGS::isHidePostsEnabled()) {
                            ?>
                            <div class="seoaic-filter-row d-none">
                                <?php
                                $__get = $__GET;
                                $__get['paged'] = 1;
                                unset($__get['post_status']);
                                unset($__get['edit_status']);
                                unset($__get['lang-filter']);
                                unset($__get['post-visibility']);
                                unset($__get['has-thumbnail']);
                                unset($__get['seoai-faq']);
                                unset($__get['seoai-lead']);
                                unset($__get['seoai-interactive']);
                                ?>
                                <label class="mb-0"><?php esc_html_e('Post visibility:', 'seoaic');?></label>
                                <a href="<?php echo esc_url($makeFilterBtnURL($__get, ['post-visibility' => 'visible']));?>"
                                    title="<?php esc_attr_e('Visible posts', 'seoaic'); ?>"
                                    class="seoaic-filter-btn <?php echo $postVisible ? 'active' : ''; ?>"
                                >
                                    <?php esc_html_e('Visible', 'seoaic'); ?>
                                </a>
                                <a href="<?php echo esc_url($makeFilterBtnURL($__get, ['post-visibility' => 'hide']));?>"
                                    title="<?php esc_attr_e('Hidden posts', 'seoaic'); ?>"
                                    class="seoaic-filter-btn <?php echo $postHide ? 'active' : ''; ?>"
                                >
                                    <?php esc_html_e('Hidden', 'seoaic'); ?>
                                </a>
                            </div>
                            <?php
                        }
                        ?>

                        <div class="seoaic-filter-row d-none">
                            <?php
                            $__get = $__GET;
                            $__get['paged'] = 1;
                            unset($__get['post_status']);
                            unset($__get['edit_status']);
                            unset($__get['lang-filter']);
                            unset($__get['post-visibility']);
                            unset($__get['seoai-faq']);
                            unset($__get['seoai-lead']);
                            unset($__get['seoai-interactive']);
                            ?>
                            <label class="mb-0"><?php esc_html_e('Thumbnail:', 'seoaic');?></label>
                            <a href="<?php echo esc_url($makeFilterBtnURL($__get, ['has-thumbnail' => 'yes']));?>"
                                title="<?php esc_attr_e('Posts with thumbnail', 'seoaic'); ?>"
                                class="seoaic-filter-btn <?php echo $hasThumbnail ? 'active' : ''; ?>"
                            >
                                <?php esc_html_e('Set', 'seoaic'); ?>
                            </a>
                            <a href="<?php echo esc_url($makeFilterBtnURL($__get, ['has-thumbnail' => 'no']));?>"
                                title="<?php esc_attr_e('Posts without thumbnail', 'seoaic'); ?>"
                                class="seoaic-filter-btn <?php echo $noThumbnail ? 'active' : ''; ?>"
                            >
                                <?php esc_html_e('Not set', 'seoaic'); ?>
                            </a>
                        </div>

                        <div class="seoaic-filter-row d-none">
                            <label class="mb-0"><?php esc_html_e('FAQ:', 'seoaic');?></label>
                            <?php
                            $__get = $__GET;
                            $__get['paged'] = 1;
                            unset($__get['post_status']);
                            unset($__get['edit_status']);
                            unset($__get['review_status']);
                            unset($__get['lang-filter']);
                            unset($__get['post-visibility']);
                            unset($__get['has-thumbnail']);
                            unset($__get['seoai-lead']);
                            unset($__get['seoai-interactive']);
                            ?>
                            <a href="<?php echo esc_url($makeFilterBtnURL($__get, ['seoai-faq' => '1']));?>"
                                title="<?php esc_attr_e('Exists', 'seoaic');?>"
                                class="seoaic-filter-btn <?php echo $faqExists ? 'active' : ''; ?>"
                            >
                                <?php esc_html_e('Exists', 'seoaic');?>
                            </a>
                            <a href="<?php echo esc_url($makeFilterBtnURL($__get, ['seoai-faq' => '0']));?>"
                                title="<?php esc_attr_e('Not exists', 'seoaic');?>"
                                class="seoaic-filter-btn <?php echo $faqNotExists ? 'active' : '';?>"
                            >
                                <?php esc_html_e('Not exists', 'seoaic');?>
                            </a>
                        </div>

                        <div class="seoaic-filter-row d-none">
                            <label class="mb-0"><?php esc_html_e('Leads form:', 'seoaic');?></label>
                            <?php
                            $__get = $__GET;
                            $__get['paged'] = 1;
                            unset($__get['post_status']);
                            unset($__get['edit_status']);
                            unset($__get['review_status']);
                            unset($__get['lang-filter']);
                            unset($__get['post-visibility']);
                            unset($__get['has-thumbnail']);
                            unset($__get['seoai-faq']);
                            unset($__get['seoai-interactive']);
                            ?>
                            <a href="<?php echo esc_url($makeFilterBtnURL($__get, ['seoai-lead' => '1']));?>"
                                title="<?php esc_attr_e('Exists', 'seoaic');?>"
                                class="seoaic-filter-btn <?php echo $leadExists ? 'active' : ''; ?>"
                            >
                                <?php esc_html_e('Exists', 'seoaic');?>
                            </a>
                            <a href="<?php echo esc_url($makeFilterBtnURL($__get, ['seoai-lead' => '0']));?>"
                                title="<?php esc_attr_e('Not exists', 'seoaic');?>"
                                class="seoaic-filter-btn <?php echo $leadNotExists ? 'active' : '';?>"
                            >
                                <?php esc_html_e('Not exists', 'seoaic');?>
                            </a>
                        </div>

                        <div class="seoaic-filter-row d-none">
                            <label class="mb-0"><?php esc_html_e('Interactive post:', 'seoaic');?></label>
                            <?php
                            $__get = $__GET;
                            $__get['paged'] = 1;
                            unset($__get['post_status']);
                            unset($__get['edit_status']);
                            unset($__get['review_status']);
                            unset($__get['lang-filter']);
                            unset($__get['post-visibility']);
                            unset($__get['has-thumbnail']);
                            unset($__get['seoai-faq']);
                            unset($__get['seoai-lead']);
                            ?>
                            <a href="<?php echo esc_url($makeFilterBtnURL($__get, ['seoai-interactive' => '1']));?>"
                                title="<?php esc_attr_e('Exists', 'seoaic');?>"
                                class="seoaic-filter-btn <?php echo $interactiveExists ? 'active' : ''; ?>"
                            >
                                <?php esc_html_e('Exists', 'seoaic');?>
                            </a>
                            <a href="<?php echo esc_url($makeFilterBtnURL($__get, ['seoai-interactive' => '0']));?>"
                                title="<?php esc_attr_e('Not exists', 'seoaic');?>"
                                class="seoaic-filter-btn <?php echo $interactiveNotExists ? 'active' : '';?>"
                            >
                                <?php esc_html_e('Not exists', 'seoaic');?>
                            </a>
                        </div>

                        <div class="seoaic-filter-row">
                            <div class="checkbox-wrapper-mc">
                                <input type="checkbox"
                                        id="posts_mass_edit_all"
                                        class="posts-mass-edit"
                                        name="posts_mass_edit_all"
                                        value="all">
                                <label for="posts_mass_edit_all"
                                        class="check"
                                        title="<?php esc_attr_e('Check all posts on current page', 'seoaic'); ?>">
                                    <div class="checkbox-wrapper-svg">
                                        <svg width="18px" height="18px" viewBox="0 0 18 18">
                                            <path d="M1,9 L1,3.5 C1,2 2,1 3.5,1 L14.5,1 C16,1 17,2 17,3.5 L17,14.5 C17,16 16,17 14.5,17 L3.5,17 C2,17 1,16 1,14.5 L1,9 Z"></path>
                                            <polyline points="1 9 7 14 15 4"></polyline>
                                        </svg>
                                    </div>
                                </label>
                            </div>
                            <?php
                            $__get = $__GET;
                            $__get['paged'] = 1;
                            unset($__get['post_status']);
                            unset($__get['edit_status']);
                            unset($__get['review_status']);
                            unset($__get['lang-filter']);
                            unset($__get['post-visibility']);
                            unset($__get['has-thumbnail']);
                            unset($__get['seoai-faq']);
                            unset($__get['seoai-lead']);
                            unset($__get['seoai-interactive']);
                            ?>
                            <a href="<?php echo esc_url($adminUrl . '?' . http_build_query($__get));?>"
                                title="Show all posts"
                                class="seoaic-filter-btn <?php echo $noFiltersSelected ? 'active' : ''; ?>"
                            >
                                <?php esc_html_e('All posts:', 'seoaic');?> <?php echo esc_html($countsByStatus['all']);?>
                            </a>
                        </div>

                    </div>
                    <div class="seoaic-show-all-filters">
                        <?php esc_html_e("All filters", "seoaic");?><span class="dashicons dashicons-arrow-down-alt2"></span>
                    </div>
                </div>
            </div>

            <div class="seoaic-flip-item seoaic-flip-side">
                <div class="head-buttons">
                    <button type="button"
                            title="<?php esc_attr_e('Mass content edit', 'seoaic');?>"
                            class="button-primary seoaic-button-primary mass-effect-button seoaic-edit-posts-button modal-button confirm-modal-button position-relative max-w-25"
                            data-modal="#seoaic_post_mass_edit_modal"
                            data-action="seoaic_posts_mass_edit"
                            data-title="<?php esc_attr_e('Posts mass content edit', 'seoaic');?>"
                            data-form-callback="window_reload"
                            data-content="<?php esc_attr_e('You will edit the following posts:', 'seoaic');?>"
                    >
                        <?php esc_html_e('Mass content edit', 'seoaic');?>
                        <div class="info">
                            <span class="info-btn">?</span>
                            <div class="info-content">
                                <h4><?php esc_html_e('Mass Content Edit', 'seoaic'); ?></h4>
                                <p><?php esc_html_e('You can edit multiple posts at once.', 'seoaic'); ?></p>
                            </div>
                        </div>
                        <div class="dn additional-form-items"></div>
                    </button>

                    <button type="button"
                            title="<?php esc_attr_e('Mass content review', 'seoaic'); ?>"
                            class="button-primary seoaic-button-primary mass-effect-button seoaic-review-posts-button modal-button confirm-modal-button position-relative max-w-25"
                            data-modal="#seoaic_post_mass_review_modal"
                            data-action="seoaic_posts_mass_review"
                            data-title="<?php esc_attr_e('Posts mass content review', 'seoaic'); ?>"
                            data-form-callback="window_reload"
                            data-content="<?php esc_attr_e('The content of the following posts will be reviewed:', 'seoaic'); ?>"
                    >
                        <?php esc_html_e('Mass content review', 'seoaic'); ?>
                        <div class="info">
                            <span class="info-btn">?</span>
                            <div class="info-content">
                                <h4><?php esc_html_e('Mass Content Review', 'seoaic'); ?></h4>
                                <p><?php esc_html_e('You can make a review for multiple posts at once.', 'seoaic'); ?></p>
                            </div>
                        </div>
                        <div class="dn additional-form-items"></div>
                    </button>

                    <?php
                    if ($isMultilang) {
                        ?>
                        <button type="button"
                                title="<?php esc_attr_e('Mass content translate', 'seoaic'); ?>"
                                class="button-primary seoaic-button-primary mass-effect-button seoaic-translate-posts-button modal-button confirm-modal-button position-relative max-w-25"
                                data-modal="#seoaic_post_mass_translate_modal"
                                data-action="seoaic_posts_mass_translate"
                                data-title="<?php esc_attr_e('Posts mass content translate', 'seoaic'); ?>"
                                data-form-callback="window_reload"
                                data-content="<?php esc_attr_e('The content of the following posts will be translated:', 'seoaic'); ?>"
                        >
                            <?php esc_html_e('Mass content translate', 'seoaic'); ?>
                            <div class="info">
                                <span class="info-btn">?</span>
                                <div class="info-content">
                                    <h4><?php esc_html_e('Mass Content Translate', 'seoaic'); ?></h4>
                                    <p><?php esc_html_e('You can make a translate for multiple posts at once.', 'seoaic'); ?></p>
                                </div>
                            </div>
                            <div class="dn additional-form-items"></div>
                        </button>
                        <?php
                    }
                    ?>
                </div>

                <div class="filters-switcher mt-15">
                    <div class="seoaic-filter-rows">
                        <div class="seoaic-remove-post">
                            <button type="button"
                                    title="<?php esc_attr_e('Remove posts', 'seoaic'); ?>"
                                    class="button-primary seoaic-button-primary mass-effect-button seoaic-remove-posts-button modal-button confirm-modal-button position-relative button button-danger-hover"
                                    data-title="<?php esc_attr_e('Delete posts', 'seoaic'); ?>"
                                    data-content="<?php esc_attr_e('The posts will be moved to the trash', 'seoaic'); ?>"
                            >
                                <?php esc_html_e('Delete', 'seoaic'); ?>
                                <div class="info">
                                    <span class="info-btn">?</span>
                                    <div class="info-content">
                                        <h4><?php esc_html_e('Remove posts', 'seoaic'); ?></h4>
                                        <p><?php esc_html_e('You can remove posts.', 'seoaic'); ?></p>
                                    </div>
                                </div>
                            </button>
                        </div>

                        <div>
                            <button type="button"
                                    title="<?php esc_attr_e('Change status', 'seoaic'); ?>"
                                    class="button-primary modal-button seoaic-button-primary mass-effect-button seoaic-change-posts-status-button position-relative"
                                    data-title="<?php esc_attr_e('Change status', 'seoaic'); ?>"
                                    data-modal="#seoaic_reschedule-posts-modal"
                            >
                                <?php esc_html_e('Change status', 'seoaic'); ?>
                                <div class="info">
                                    <span class="info-btn">?</span>
                                    <div class="info-content">
                                        <h4><?php esc_html_e("Change posts' status", 'seoaic'); ?></h4>
                                        <p><?php esc_html_e("You can change selected posts' status by 1 click.", 'seoaic'); ?></p>
                                    </div>
                                </div>
                            </button>
                        </div>

                        <div>
                            <button type="button"
                                title="<?php esc_attr_e('Set thumbnail', 'seoaic'); ?>"
                                class="button-primary seoaic-button-primary seoaic-set-tumbnail-button modal-button position-relative"
                                data-title="<?php esc_attr_e('Set thumbnail', 'seoaic'); ?>"
                                data-content="<?php esc_attr_e('Setting thumbnail for the following posts:', 'seoaic'); ?>"
                                data-modal="#seoaic_post_mass_set_tumbnail_modal"
                            >
                                <?php esc_html_e('Set thumbnail', 'seoaic'); ?>
                                <div class="info">
                                    <span class="info-btn">?</span>
                                    <div class="info-content">
                                        <h4><?php esc_html_e('Set thumbnail', 'seoaic'); ?></h4>
                                        <p><?php esc_html_e('Setting thumbnail to multiple posts at once.', 'seoaic'); ?></p>
                                    </div>
                                </div>
                            </button>
                        </div>

                        <div class="">
                            <button type="button"
                                title="<?php esc_attr_e('Restore posts', 'seoaic');?>"
                                class="button-primary seoaic-button-primary mass-effect-button modal-button confirm-modal-button position-relative"
                                data-title="<?php esc_attr_e('Restore posts', 'seoaic');?>"
                                data-content="<?php esc_attr_e("The posts' content will be restored to their previous state. Is applied only for posts edited by the Mass Content Edit function.", 'seoaic');?>"
                                data-modal="#seoaic-restore-posts-modal"
                            >
                                <?php esc_html_e('Restore', 'seoaic');?>
                                <div class="info">
                                    <span class="info-btn">?</span>
                                    <div class="info-content">
                                        <h4><?php esc_html_e('Restore posts', 'seoaic');?></h4>
                                        <p><?php esc_html_e("You can restore posts' content to their previous state. Is applied only for posts edited by the Mass Content Edit function.", 'seoaic');?></p>
                                    </div>
                                </div>
                            </button>
                        </div>

                        <button type="button"
                            title="<?php esc_attr_e('Add lead form', 'seoaic');?>"
                            class="button-primary seoaic-button-primary mass-effect-button modal-button confirm-modal-button position-relative"
                            data-title="<?php esc_attr_e('Add lead form', 'seoaic');?>"
                            data-content="<?php esc_attr_e("Selected lead form will be added to the next posts' content:", 'seoaic');?>"
                            data-modal="#seoaic-post-mass-add-lead-form-modal"
                            data-action="seoaic_add_lead_form_to_post"
                            data-form-callback="lead_form_mass_add_alert"
                        >
                            <?php esc_html_e('Add lead form', 'seoaic');?>
                            <div class="info">
                                <span class="info-btn">?</span>
                                <div class="info-content">
                                    <h4><?php esc_html_e('Add lead form', 'seoaic');?></h4>
                                    <p><?php esc_html_e("You can add existing lead form to the selected posts' content.", 'seoaic');?></p>
                                </div>
                            </div>
                            <div class="dn additional-form-items"></div>
                        </button>

                        <button type="button"
                            title="<?php esc_attr_e('Generate lead form', 'seoaic');?>"
                            class="button-primary seoaic-button-primary mass-effect-button modal-button confirm-modal-button position-relative max-w-25"
                            data-modal="#seoaic_post_mass_generate_lead_form_modal"
                            data-action="seoaic_generate_lead_form"
                            data-title="<?php esc_attr_e('Generate lead form', 'seoaic');?>"
                            data-form-callback="window_reload"
                            data-content="<?php esc_attr_e('You will edit the following posts:', 'seoaic');?>"
                        >
                            <?php esc_html_e('Generate lead form', 'seoaic');?>
                            <div class="info">
                                <span class="info-btn">?</span>
                                <div class="info-content">
                                    <h4><?php esc_html_e('Generate lead form', 'seoaic'); ?></h4>
                                    <p><?php esc_html_e('You can generate lead forms to multiple posts at once.', 'seoaic'); ?></p>
                                </div>
                            </div>
                            <div class="dn additional-form-items"></div>
                        </button>

                        <button type="button"
                            title="<?php esc_attr_e('Generate FAQ', 'seoaic');?>"
                            class="button-primary seoaic-button-primary mass-effect-button modal-button confirm-modal-button position-relative max-w-25"
                            data-modal="#seoaic_post_mass_generate_faq_modal"
                            data-action="seoaic_generate_faq"
                            data-title="<?php esc_attr_e('Generate FAQ', 'seoaic');?>"
                            data-form-callback="window_reload"
                            data-content="<?php esc_attr_e('You will edit the following posts:', 'seoaic');?>"
                        >
                            <?php esc_html_e('Generate FAQ', 'seoaic');?>
                            <div class="info">
                                <span class="info-btn">?</span>
                                <div class="info-content">
                                    <h4><?php esc_html_e('Generate FAQ', 'seoaic'); ?></h4>
                                    <p><?php esc_html_e('You can generate FAQ to multiple posts at once.', 'seoaic'); ?></p>
                                </div>
                            </div>
                            <div class="dn additional-form-items"></div>
                        </button>

                    </div>
                </div>

                <div class="filters-switcher mt-15">
                    <div class="seoaic-filter-rows">
                        <div class="seoaic-filter-row">
                            <span class="seoaic-checked-amount"><?php esc_html_e('Selected:', 'seoaic'); ?> <span
                                        class="seoaic-checked-amount-num">0</span></span>
                            <button type="button"
                                    class="posts-mass-edit-uncheck-all seoaic-filter-btn"
                            >
                                <?php esc_html_e('Clear selection', 'seoaic');?>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="seoaic-posts-results">
    <?php
    if ($query->have_posts()) {
        if ($editInProgress) {
            ?>
            <input type="hidden"
                    name="mass_edit_in_progress"
                    id="mass_edit_in_progress"
                    value="1"
                    data-action="seoaic_posts_mass_edit_check_status"
                    data-loader="#<?php echo esc_attr((new PostsEditLoader)->getID()); ?>"
                    data-modal="#seoaic-confirm-modal"
                    data-form-callback="window_reload"
            >
            <?php

        } elseif ($reviewInProgress) {
            ?>
            <input type="hidden"
                    name="mass_review_in_progress"
                    id="mass_review_in_progress"
                    value="1"
                    data-action="seoaic_posts_mass_review_check_status"
                    data-loader="#<?php echo esc_attr((new PostsReviewLoader)->getID()); ?>"
                    data-modal="#seoaic-confirm-modal"
                    data-form-callback="window_reload"
            >
            <?php

        } else if ($translateInProgress) {
            ?>
            <input type="hidden"
                    name="mass_translate_in_progress"
                    id="mass_translate_in_progress"
                    value="1"
                    data-action="seoaic_posts_mass_translate_check_status"
            >
            <?php
        }

        if (!empty($generatingThumbnailPostsAll)) {
            ?>
            <input type="hidden"
                value="1"
                name="mass_thumbnails_generate_in_progress"
                id="mass_thumbnails_generate_in_progress"
                data-action="seoaic_posts_mass_thumbnails_generate_check_status"
            >
            <?php
        }

        if (!empty($generatingLeadFormsPostsAll)) {
            ?>
            <input type="hidden"
                value="1"
                name="mass_lead_forms_generate_in_progress"
                id="mass_lead_forms_generate_in_progress"
                data-action="seoaic_generate_lead_form_check_status"
            >
            <?php
        }

        if (!empty($generatingFAQPostsAll)) {
            ?>
            <input type="hidden"
                value="1"
                name="mass_faq_generate_in_progress"
                id="mass_faq_generate_in_progress"
                data-action="seoaic_generate_faq_check_status"
            >
            <?php
        }
        ?>
        <div class="mt-40 d-flex justify-between ai-center">
            <div class="seoaic-stop-buttons">
                <div class="d-flex gap-15">
                    <button type="button"
                            title="<?php esc_attr_e('Stops posts mass edit proccess', 'seoaic'); ?>"
                            class="button-primary seoaic-button-primary outline modal-button mass-effect-button confirm-modal-button max-w-50 <?php echo $editInProgress ? '' : 'd-none'; ?>"
                            data-modal="#seoaic-confirm-modal"
                            data-action="seoaic_posts_mass_stop_edit"
                            data-form-callback="window_reload"
                            data-content="<?php esc_attr_e('Do you really want to stop posts editing?', 'seoaic'); ?>"
                    >
                        <?php esc_html_e('Stop posts editing', 'seoaic'); ?>
                    </button>
                    <button type="button"
                            title="<?php esc_attr_e('Stops posts mass review proccess', 'seoaic'); ?>"
                            class="button-primary seoaic-button-primary outline modal-button mass-effect-button confirm-modal-button max-w-50 <?php echo $reviewInProgress ? '' : 'd-none'; ?>"
                            data-modal="#seoaic-confirm-modal"
                            data-action="seoaic_posts_mass_stop_review"
                            data-form-callback="window_reload"
                            data-content="<?php esc_attr_e('Do you really want to stop posts review?', 'seoaic'); ?>"
                    >
                        <?php esc_html_e('Stop posts review', 'seoaic'); ?>
                    </button>
                    <button type="button"
                            title="<?php esc_attr_e('Stops posts translation', 'seoaic');?>"
                            class="button-primary seoaic-button-primary outline modal-button mass-effect-button confirm-modal-button max-w-50 <?php echo $translateInProgress ? '' : 'd-none';?>"
                            data-modal="#seoaic-confirm-modal"
                            data-action="seoaic_posts_mass_translate_stop"
                            data-form-callback="window_reload"
                            data-content="<?php esc_attr_e('Do you really want to stop posts translation?', 'seoaic');?>"
                    >
                        <?php esc_html_e('Stop translation', 'seoaic');?>
                    </button>
                    <button type="button"
                            title="<?php esc_attr_e('Stops Lead Form(s) generation', 'seoaic');?>"
                            class="button-primary seoaic-button-primary outline modal-button mass-effect-button confirm-modal-button max-w-50 <?php echo $leadFormsInProgress ? '' : 'd-none';?>"
                            data-modal="#seoaic-confirm-modal"
                            data-action="seoaic_generate_lead_form_stop"
                            data-form-callback="window_reload"
                            data-content="<?php esc_attr_e('Do you really want to stop Lead Form(s) generation?', 'seoaic');?>"
                    >
                        <?php esc_html_e('Stop lead forms generation', 'seoaic');?>
                    </button>
                    <button type="button"
                            title="<?php esc_attr_e('Stops thumbnails generation', 'seoaic');?>"
                            class="button-primary seoaic-button-primary outline modal-button mass-effect-button confirm-modal-button max-w-50 <?php echo !empty($generatingThumbnailPostsIDs) ? '' : 'd-none';?>"
                            data-modal="#seoaic-confirm-modal"
                            data-action="seoaic_posts_mass_thumbnails_generate_stop"
                            data-form-callback="window_reload"
                            data-content="<?php esc_attr_e('Do you really want to stop thumbnails generation?', 'seoaic');?>"
                    >
                        <?php esc_html_e('Stop thumbnails generation', 'seoaic');?>
                    </button>
                    <button type="button"
                            title="<?php esc_attr_e('Stops FAQ generation', 'seoaic');?>"
                            class="button-primary seoaic-button-primary outline modal-button mass-effect-button confirm-modal-button max-w-50 <?php echo $faqInProgress ? '' : 'd-none';?>"
                            data-modal="#seoaic-confirm-modal"
                            data-action="seoaic_generate_faq_stop"
                            data-form-callback="window_reload"
                            data-content="<?php esc_attr_e('Do you really want to stop FAQ generation?', 'seoaic');?>"
                    >
                        <?php esc_html_e('Stop FAQ generation', 'seoaic');?>
                    </button>
                </div>
            </div>

            <div class="seoaic-posts-per-page">
                <label class="text-label"><?php esc_html_e('Posts per page', 'seoaic'); ?></label>
                <select id="posts_per_page" class="form-select pp-select">
                    <?php
                    foreach ($available_per_page_options as $option_value) {
                        $selected_attr = $selected_per_page == $option_value ? ' selected="selected"' : '';
                        ?>
                        <option value="<?php echo esc_attr(strval($option_value)) ?>" <?php echo esc_attr($selected_attr); ?>><?php echo esc_html(strval($option_value)); ?></option>
                        <?php
                    }
                    ?>
                </select>
            </div>
        </div>

        <?php
        SEOAIC_postsPagination($query);
        ?>
        <div class="seoaic-posts-table__container">
            <div class="seoaic-posts-table__row seoaic-posts-table__row--head">
                <div class="seoaic-posts-table__row-item sortable position-relative" data-orderby="ID" data-order="<?php echo esc_attr($order_by === 'ID' ? $order : ''); ?>">
                    <?php esc_html_e('ID', 'seoaic'); ?>
                </div>
                <div class="seoaic-posts-table__row-item sortable" data-orderby="date" data-order="<?php echo esc_attr($order_by === 'date' ? $order : ''); ?>">
                    <?php esc_html_e('Date', 'seoaic'); ?>
                </div>
                <div class="seoaic-posts-table__row-item">
                    <?php esc_html_e('Image', 'seoaic'); ?>
                </div>
                <div class="seoaic-posts-table__row-item sortable title" data-orderby="title" data-order="<?php echo esc_attr($order_by === 'title' ? $order : ''); ?>">
                    <?php esc_html_e('Title', 'seoaic'); ?>
                </div>

                <?php if (SEOAIC_SETTINGS::isHidePostsEnabled()) : ?>
                    <div class="seoaic-posts-table__row-item seoaic-post-visibility__row-item">
                        <?php esc_html_e('Post visibility', 'seoaic');?>
                    </div>
                <?php endif; ?>

                <div class="seoaic-posts-table__row-item">
                    <?php esc_html_e('Status', 'seoaic'); ?>
                </div>
                <div class="seoaic-posts-table__row-item">
                    <?php esc_html_e('Mass Edit Status', 'seoaic'); ?>
                </div>
                <div class="seoaic-posts-table__row-item">
                    <?php esc_html_e('Review Results', 'seoaic'); ?>
                </div>
                <div class="seoaic-posts-table__row-action-item seoaic-posts-table__row-action-item--head"></div>
            </div>
            <?php
            while ($query->have_posts()) {
                $query->the_post();

                $id = get_the_ID();
                $status = get_post_status();
                $statusLabel = in_array($status, array_keys($statusesLabels)) ? $statusesLabels[$status] : ucfirst($status);
                $auto_scheduled_status = get_post_meta($id, 'seoaic_auto_scheduled', true);
                if ($auto_scheduled_status) {
                    $statusLabel = esc_html__('Auto scheduled', 'seoaic');
                    $status = 'auto-scheduled';
                }
                $id = get_the_ID();
                $for_id = 'posts_mass_edit_' . $id;
                $update_status = get_post_meta($id, 'seoaic_update_status', true);
                $update_status_time = get_post_meta($id, 'seoaic_update_status_time', true);
                $hasRevision = (new PostRevisionRepository())->hasRevision($id);
                $review_status = get_post_meta($id, 'seoaic_review_status', true);
                $review_time = get_post_meta($id, 'seoaic_review_time', true);
                $review_prompt = get_post_meta($id, 'seoaic_review_prompt', true);
                $review_result_original = get_post_meta($id, 'seoaic_review_result_original', true);
                $review_result = get_post_meta($id, 'seoaic_review_result', true);
                $post_created_date = get_post_meta($id, 'post_created_date', true);
                $post_hiding = get_post_meta($id, 'seoaic_visible_post', true);
                $postLangCode = $SEOAIC->multilang->get_post_language($id, 'code');
                $postLangCode = $postLangCode ?: '';
                $thumbnailStatusField = (new ThumbnailsGenerate($SEOAIC))->getStatusField();
                $thumbnailStatus = get_post_meta($id, $thumbnailStatusField, true);

                $is_pending = 'pending' == $update_status;
                $is_reviewing = 'reviewing' == $review_status;
                $is_reviewed = 'completed' == $review_status;
                $isThumbnailGenerating = in_array($id, $generatingThumbnailPostsIDs);
                $isLeadFormGenerating = in_array($id, $generatingLeadFormsPostsIDs);
                $isFAQGenerating = in_array($id, $generatingFAQPostsIDs);
                ?>
                <div class="seoaic-posts-table__row post<?php echo ($is_pending || $is_reviewing || $isLeadFormGenerating || $isFAQGenerating) ? ' updating' : ''; ?><?php echo $isThumbnailGenerating ? ' thumb-generating' : '';?>"
                        id="seoaic_post_<?php echo esc_attr($id);?>"
                        data-post-id="<?php echo esc_attr($id); ?>">
                    <div class="seoaic-posts-table__row-item position-relative col-id">
                        <div>
                            <?php if ( !$is_pending && !$is_reviewing ) : ?>
                                <div class="checkbox-wrapper-mc">
                                    <input
                                            type="checkbox"
                                            name="posts_mass_edit"
                                            id="<?php echo esc_attr($for_id); ?>"
                                            class="post-mass-edit"
                                            value="<?php echo esc_attr($id); ?>"
                                            data-lang='<?php echo esc_attr($postLangCode);?>'
                                    >
                                    <label for="<?php echo esc_attr($for_id); ?>" class="check">
                                        <div class="checkbox-wrapper-svg">
                                            <svg width="18px" height="18px" viewBox="0 0 18 18">
                                                <path d="M1,9 L1,3.5 C1,2 2,1 3.5,1 L14.5,1 C16,1 17,2 17,3.5 L17,14.5 C17,16 16,17 14.5,17 L3.5,17 C2,17 1,16 1,14.5 L1,9 Z"></path>
                                                <polyline points="1 9 7 14 15 4"></polyline>
                                            </svg>
                                        </div>
                                        <span id="<?php echo esc_attr($for_id); ?>"><?php echo esc_attr($id); ?></span>
                                    </label>
                                </div>
                            <?php else : ?>
                                <span>
                                    <?php echo esc_html($id); ?>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="seoaic-posts-table__row-item">
                        <div class="seoaic-post-datetime">
                            <span data-post-server-date="<?php echo get_the_date('Y-m-d\TH:i:s\Z'); ?>"></span>
                        </div>
                    </div>
                    <div class="seoaic-posts-table__row-item seoaic-post-thumbnail">
                        <?php
                        if ($thumbnailStatus == ThumbnailsGenerate::FAILED_STATUS) {
                            ?>
                            <span class="dashicons dashicons-warning" title="<?php esc_html_e("Thumbnail generation failed", "seoaic");?>"></span>
                            <?php

                        } else {
                            the_post_thumbnail($id, 'medium', ['class' => 'seoaic-post-image']);
                        }
                        ?>
                    </div>
                    <div class="seoaic-posts-table__row-item seoaic-post-title-col">
                        <div>
                            <div class="seoaic-post-title">
                                <?php echo esc_html(get_the_title()); ?>
                            </div>

                            <div class="seoaic-post-datetime">
                                <?php if( $status === 'future'): ?>
                                    <b><?php esc_html_e('Scheduled: ', 'seoaic'); ?></b>
                                    <span data-post-server-date="<?php echo get_the_date('Y-m-d\TH:i:s\Z'); ?>"></span>
                                <?php else: ?>
                                    <b><?php esc_html_e('Modified: ', 'seoaic'); ?></b>
                                    <span data-post-server-date="<?php echo esc_attr(get_the_modified_date('Y-m-d\TH:i:s\Z')); ?>"></span>
                                <?php endif; ?>
                            </div>

                            <div class="seoaic-post-langs-wrapper mt-10">
                                <?php
                                $SEOAIC->multilang->displayPostLanguageFlag($id);
                                $SEOAIC->multilang->displayPostTranslationsFlags($id);
                                ?>
                            </div>
                        </div>
                    </div>
                    <?php
                    if (SEOAIC_SETTINGS::isHidePostsEnabled()) {
                        ?>
                        <div class="seoaic-posts-table__row-item seoaic-post-visibility__row-item">
                            <div>
                                <span class="seoaic-post-visibility dashicons dashicons-visibility <?php echo empty($post_hiding) ? 'd-none' : ''; ?>" data-status="0" title="<?php esc_attr_e("Visible", "seoaic");?>"></span>
                                <span class="seoaic-post-visibility dashicons dashicons-hidden <?php echo empty($post_hiding) ? '' : 'd-none'; ?>" data-status="1" title="<?php esc_attr_e("Hidden", "seoaic");?>"></span>
                            </div>
                        </div>
                        <?php
                        }
                    ?>
                    <div class="seoaic-posts-table__row-item seoaic-post-status-column">
                        <div class="position-relative">
                            <label for="status_<?php echo esc_attr($id);?>"
                                    class="post-status modal-button post-status--<?php echo esc_attr($status); ?> dd-button"
                                    title="<?php esc_attr_e("Click to change post status", "seoaic"); ?>"
                                    data-modal="#seoaic_reschedule-posts-modal"
                            ><?php echo esc_html($statusLabel); ?></label>
                        </div>
                    </div>
                    <div class="seoaic-posts-table__row-item">
                        <div class="position-relative">
                            <?php
                            if (!empty($update_status)) {
                                // mass edit column
                                ?>
                                <div class="tc">
                                    <span class="update-status update-status-<?php echo esc_attr($update_status); ?>"><?php echo esc_html($update_status, 'seoaic'); ?></span>
                                    <?php
                                    if (!empty($update_status_time)) {
                                        ?>
                                        </br>
                                        <span><?php echo esc_html(wp_date('M j, Y', $update_status_time)) . '<br>' . esc_html(wp_date('h:i a', $update_status_time));?></span>
                                        <?php
                                    }
                                    ?>
                                </div>
                                <?php
                                if ($hasRevision) {
                                    ?>
                                    <button
                                        class="seoaic-post-edit-undo-link modal-button confirm-modal-button position-absolute"
                                        title="<?php esc_attr_e('Undo the last post changes.', 'seoaic');?>"
                                        data-posts-ids="<?php echo esc_attr($id);?>"
                                        data-modal="#seoaic-confirm-modal"
                                        data-action="seoaic_mass_posts_edit_undo"
                                        data-form-callback="remove_posts_mass_edit_undo_link"
                                        data-content="<?php esc_attr_e('Do you really want to undo the last post changes?', 'seoaic'); ?>"
                                    >
                                        <?php esc_html_e('restore', 'seoaic');?>
                                    </button>
                                    <?php
                                }
                            }
                            ?>
                        </div>
                    </div>
                    <div class="seoaic-posts-table__row-item">
                        <?php
                        if ($is_reviewed) {
                            $hoverTitle = '';
                            if (
                                'yes' == $review_result
                                || 'no' == $review_result
                            ) {
                                $hoverTitle = esc_html__('Shows if the post\'s content meets the propmt condition.', 'seoaic');
                            } else {
                                $hoverTitle = esc_html__('Need manually check the result of review.', 'seoaic');
                            }
                            $review_label_id = 'review_details_' . $id;
                            ?>
                            <div class="review-result w-100">
                                <div class="tc mb-10 review-result-text review-result-<?php echo esc_attr($review_result); ?>"
                                        title="<?php echo esc_attr($hoverTitle); ?>"
                                >
                                    <?php echo esc_html($review_result); ?>
                                </div>
                                <div class="review-date tc mb-10">
                                    <?php echo esc_html(wp_date('M j, Y', $review_time)) . '<br>' . esc_html(wp_date('h:i a', $review_time));?>
                                </div>
                                <input type="checkbox"
                                        class="d-none"
                                        id="<?php echo esc_attr($review_label_id); ?>">
                                <div class="review-details-wrapper tc">
                                    <div class="w-100">
                                        <div class="review-details w-100">
                                            <b><?php esc_html_e('Prompt:', 'seoaic'); ?></b><br><?php echo esc_html($review_prompt); ?>
                                            <br><b><?php esc_html_e('Result:', 'seoaic'); ?></b><br><?php echo esc_html($review_result_original); ?>
                                        </div>
                                    </div>
                                </div>
                                <label class="w-100 tc" for="<?php echo esc_attr($review_label_id); ?>"></label>
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                    <div class="seoaic-posts-table__row-action-item">
                        <?php
                        $status_text = '';
                        if ($is_pending) {
                            $status_text = $update_status;

                        } elseif ($is_reviewing) {
                            $status_text = $review_status;

                        } elseif ($isLeadFormGenerating) {
                            $status_text = "lead form";

                        } elseif ($isFAQGenerating) {
                            $status_text = "FAQ";
                        }

                        if (!empty($status_text)) {
                            ?>
                            <span class="post-updating-label"><?php echo esc_html($status_text); ?></span>
                            <?php
                        } else {
                            ?>
                            <a title="<?php esc_attr_e('Edit post', 'seoaic');?>"
                                target="_blank"
                                href="<?php echo esc_url(get_edit_post_link());?>"
                            >
                                <span class="dashicons dashicons-arrow-right-alt2"></span>
                            </a>
                            <?php
                        }
                        ?>
                    </div>
                </div>
                <?php
            }
            ?>
        </div>
        <?php
        SEOAIC_postsPagination($query);
        wp_reset_postdata();
    } else {
        ?>
        <p><?php esc_html_e('No posts at the moment.', 'seoaic'); ?></p>
        <?php
    }
    ?>
    </div>
</div>
