<?php

// seoaic-with-loader position-relative bg-commect seoaic-loading-no-slide seoaic-loading

if (!current_user_can('seoaic_edit_plugin')) {
    return;
}

if (isset($_GET['settings-updated'])) {
    add_settings_error('seoaic_messages', 'seoaic_message', esc_html__('Settings Saved', 'mdsf'), 'updated');
}

settings_errors('seoaic_messages');

global $SEOAIC, $SEOAIC_OPTIONS;
?>
<div class="inner-connected tc">
    <h2 class="mb-40"><?php esc_html_e('You are connected', 'seoaic');?><br>to the <span class="accent"><?php esc_html_e('SEO AI Service', 'seoaic');?></span></h2>
    <p class="mb-13 mt-0 fs-small fw-400"><?php esc_html_e('Your connection e-mail', 'seoaic');?>:</p>
    <p class="mt-0 mb-0 fs-20 fw-700"><?php echo esc_html($SEOAIC_OPTIONS['seoaic_api_email']);?></p>
    <p class="mb-13 fs-small mt-40 fw-400"><?php esc_html_e('Your connection API Key', 'seoaic');?>:</p>
    <p class="mt-0 mb-0 fs-20 fw-700"><?php echo esc_html(substr_replace($SEOAIC_OPTIONS['seoaic_api_token'], '************************', 7, strlen($SEOAIC_OPTIONS['seoaic_api_token']) - 14));?></p>

    <button class="seoaic-disconnect-button button-link hide-on-scanning modal-button" type="button"
            data-modal="#seoaic-disconnect"
            data-form-callback="window_reload"
    ><?php esc_html_e('Disconnect', 'seoaic');?></button>
</div>
