<?php
if (!current_user_can('seoaic_edit_plugin')) {
    return;
}

if (isset($_GET['settings-updated'])) {
    add_settings_error('seoaic_messages', 'seoaic_message', esc_html__('Settings Saved', 'mdsf'), 'updated');
}

global $SEOAIC, $SEOAIC_OPTIONS, $pagenow;

// $SEOAIC->competitors->Add_New_Competitor();
$SEOAIC->competitors->clean_all_competitors_data();
// $SEOAIC->competitors->update_competitors_data();
$SEOAIC->competitors->delete_duplicated_competitors();
$ready_to_update = !empty($SEOAIC_OPTIONS['ready_to_update_competitors']) ? $SEOAIC_OPTIONS['ready_to_update_competitors'] : [];
$ready_to_update_count = count($ready_to_update);
$competitors_options = isset($SEOAIC_OPTIONS['competitors']) ? count($SEOAIC_OPTIONS['competitors']) : 0;
$lastUpdatedTimestamp = $SEOAIC->competitors::getLastUpdateTimestamp();
?>

<div id="seoaic-admin-container" class="wrap">
    <h1 id="seoaic-admin-title">
        <?php
        echo wp_kses(seoai_get_logo('logo.svg'), [
            'img' => [
                'title' => [],
                'src'	=> [],
                'alt'	=> [],
            ],
        ]);
        ?>
        <span>
            <?php echo esc_html(get_admin_page_title()); ?>
        </span>
    </h1>

    <?php
    echo wp_kses($SEOAIC->get_background_process_loader(true), [
        'div' => [
            'id'    => [],
            'class' => [],
            'style' => [],
            'title' => [],
        ],
        'p' => [
            'class' => [],
        ],
        'b' => [],
        'button' => [
            'type'              => [],
            'class'             => [],
            'data-modal'        => [],
            'data-action'       => [],
            'data-form-callback' => [],
            'data-content'      => [],
        ],
    ]);
    ?>

    <div id="seoaic-admin-body"
         class="seoaic-with-loader competitors-page"
         data-base-url="<?php echo esc_url(admin_url($pagenow) . "?page=" . $_GET['page']) ?>"
         data-my-site-exists="<?php echo $SEOAIC->competitors->is_our_competitor_exists(); ?>"
         data-my-site-location="<?php echo $SEOAIC->competitors->get_the_location_param(); ?>"
         data-update-modal-content="<?php echo esc_attr(strval($ready_to_update_count)) ?> competitors can be updated"
         data-migrate-modal-content="Action is required: <?php echo esc_attr($competitors_options) ?> competitors needs to be migrated"
         data-ready-to-update="<?php echo esc_attr(json_encode($ready_to_update)) ?>"
         data-migrate-competitors-options="<?php echo esc_attr($competitors_options) ?>"
    >
        <div class="inner">

            <div class="locations-tabs">
                <?php echo $SEOAIC->competitors->locations_tabs_HTML(); ?>
            </div>

            <div class="top">
                <?php echo $SEOAIC->competitors->Competitors_Page_Top_Tabs_HTML(); ?>
            </div>

            <div class="bottom">
                <?php
                if (!empty($lastUpdatedTimestamp)) {
                    ?>
                    <div class="d-flex justify-end">
                        <span class="seoaic-competitors-last-updated"><?php echo esc_html__("Last updated: ", "seoaic") . gmdate("d/m/Y H:i e", $lastUpdatedTimestamp);?></span>
                    </div>
                    <?php
                }
                ?>
                <div class="flex-table compare">
                    <?php echo $SEOAIC->competitors->Competitors_Compare_Section_HTML(); ?>
                </div>
                <div class="per-page competitors-terms-per-page per-page-top"></div>

                <div class="flex-table search-terms-table">
                    <?php echo $SEOAIC->competitors->Competitors_Search_Terms_HTML(); ?>
                </div>

                <a href="#" id="seoaicAddToRankTracking" class="modal-button" data-modal="#add-keyword-modal" data-terms=""
                   data-location=""><?php esc_html_e('Add selected to keywords', 'seoaiс'); ?>
                </a>
            </div>
            <div class="bottom-section">
                <div class="seoaic-pagination-wrapper"></div>
                <div class="per-page competitors-terms-per-page"></div>
            </div>

        </div>
        <div class="lds-dual-ring"></div>
    </div>
</div>