<?php
if (!current_user_can('seoaic_edit_plugin')) {
    return;
}

if (isset($_GET['settings-updated'])) {
    add_settings_error('seoaic_messages', 'seoaic_message', esc_html__('Settings Saved', 'seoaic'), 'updated');
}

global $SEOAIC, $SEOAIC_OPTIONS, $pagenow;

?>

<div id="seoaic-admin-container" class="wrap">
    <h1 id="seoaic-admin-title">
        <?php
        echo wp_kses(seoai_get_logo('logo.svg'), [
            'img' => [
                'title' => [],
                'src'	=> [],
                'alt'	=> [],
            ],
        ]);
        ?>
        <span>
            <?php echo esc_html(get_admin_page_title()); ?>
        </span>
    </h1>
    <div id="seoaic-admin-body" class="calendar-page" data-admin-url="<?php echo esc_url(admin_url()); ?>" data-server-time="<?php echo esc_attr(date('Y-m-d H:i:s')); ?>">
        <?php echo $SEOAIC->onboarding->generate_ob_ideas_form('mb-0', 'Monthly Rollout Plan');?>
        <div class="inner-calendar">
            <div class="sidebar">
                <h3><?php esc_html_e('Monthly summary', 'seoaic')?></h3>
                <div id="seoaic_calendar_view_sidebar"></div>
            </div>
            <div class="weeks_numbers">
                <div class="height-adjustment"></div>
                <div id="seoaic_weeks_numbers"></div>
            </div>
            <div id="seoaic_calendar_view" class="inner"
                 data-single-post="<?php esc_html_e('&nbsp;post', 'seoaic')?>"
                 data-many-posts="<?php esc_html_e('&nbsp;posts', 'seoaic')?>"
                 data-default-posting-time="<?php echo esc_attr(\SEOAIC\SEOAIC_SETTINGS::getScheduledPostingTime());?>"></div>
            <div id="seoaic_open_draft_list_canvas" class="open-draft-list-canvas" data-drafts="<?php echo $SEOAIC->calendar->get_calendar_draft_posts(true, true); ?>" data-button="<?php esc_html_e('Show Drafts', 'seoaic')?>" data-button-active="<?php esc_html_e('Hide Drafts', 'seoaic')?>">
                <div class="inner">
                    <h3><?php esc_html_e('Unscheduled Draft Posts', 'seoaic')?></h3>

                    <a href="#" class="hide-clusters-filters active d-none" data-button="<?php esc_html_e('Show Filters', 'seoaic')?>" data-button-active="<?php esc_html_e('Hide Filters', 'seoaic')?>"><span></span></a>
                    <div class="sort-clusters d-none">
                        <p><?php esc_html_e('Sort by cluster:', 'seoaic')?></p>
                        <a href="#" class="seoaic-cluster-post-draft green"><?php esc_html_e('cluster name', 'seoaic')?></a>
                    </div>

                    <div class="draft-posts-list" id="seoaic_draggable_draft_posts">
                        <?php echo $SEOAIC->calendar->get_calendar_draft_posts(true); ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="lds-dual-ring"></div>
    </div>
</div>