<?php

if ( ! current_user_can( 'seoaic_edit_plugin' ) ) {
    return;
}

use SEOAIC\SEOAIC;

global $SEOAIC;

$get = wp_unslash( $_GET );
$selectedProvider = $get['provider'] ?? 'total';

$adminUrl = SEOAIC::getAdminUrl( 'admin.php' );
$sentiment_analysis_data = $SEOAIC->sentiment_analysis->getResult();

$status = $sentiment_analysis_data['status'] ?? '';

$next_allowed_request_time = $sentiment_analysis_data['next_allowed_request_time'] ?? null;

$refresh_available = false;
if ($next_allowed_request_time && strtotime($next_allowed_request_time) < time()) {
    $refresh_available = true;
}

$providerCounts = [];

if( $sentiment_analysis_data ){
    $providerCounts = array_count_values(
        array_filter(
            array_map(
                fn($r) => trim((string)($r['provider'] ?? '')),
                $sentiment_analysis_data['results']
            ),
            fn($p) => $p !== ''
        )
    );
}

?>

<div id="seoaic-admin-container" class="wrap seoaic-brand-sentiment-analysis-page">
    <h1 id="seoaic-admin-title">
        <?php
        echo wp_kses( seoai_get_logo( 'logo.svg' ), [
            'img' => [
                'title' => [],
                'src'   => [],
                'alt'   => [],
            ],
        ] );
        ?>
        <span>
            <?php echo esc_html( get_admin_page_title() ); ?>
        </span>
    </h1>

    <div id="seoaic-admin-body" class="seoaic-with-loader">
        <div class="row full-width">
            <div class="col">
                <div class="inner">
                    <div class="seoaic-brand-sentiment-analysis-page__controls">
                        <div class="seoaic-brand-sentiment-analysis-page__controls-buttons">
                            <a href="<?php echo admin_url('admin.php?page=seoaic-brand-visibility'); ?>" class="seoaic-brand-sentiment-analysis-page__actions-button outline">
                                <?php esc_html_e( '← Back to Brand Visibility', 'seoaic' ); ?>
                            </a>
                        </div>
                        <div class="seoaic-brand-sentiment-analysis-page__actions">
                            <?php if ( $status === 'completed' ) : ?>
                                <button class="seoaic-brand-sentiment-analysis-page__actions-button refresh-analysis-button outline" <?php echo $refresh_available ? '' : 'disabled'; ?>>
                                    <?php esc_html_e( 'Refresh Brand Sentiment', 'seoaic' ); ?>
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>

                    <?php if ( ! empty( $sentiment_analysis_data['results'] ) ): ?>
                        <div class="seoaic-brand-sentiment-analysis-page__overview-items">
                            <div class="seoaic-brand-sentiment-analysis-page__overview-item <?php echo $selectedProvider === 'total' ? 'active' : '' ?>" data-provider="total">
                                <div class="seoaic-brand-sentiment-analysis-page__overview-item-content">
                                    <h3 class="seoaic-brand-sentiment-analysis-page__overview-item__title"><?php esc_html_e('Total Prompts', 'seoaic'); ?></h3>
                                    <p class="seoaic-brand-sentiment-analysis-page__overview-item__value"><?php echo count( $sentiment_analysis_data['results'] ) ?> <?php esc_html_e('Prompts', 'seoaic'); ?></p>
                                </div>
                            </div>
                            <?php if ( ! empty( $providerCounts ) ): ?>
                                <?php foreach ( $providerCounts as $source => $count ): ?>
                                    <div class="seoaic-brand-sentiment-analysis-page__overview-item <?php echo $selectedProvider === strtolower( $source ) ? 'active' : '' ?>" data-provider="<?php echo strtolower( $source ) ?>">
                                        <?php $source = strtolower( $source ) === 'google_ai_overview' ? 'Google AIO' : $source; ?>
                                        <div class="seoaic-brand-sentiment-analysis-page__overview-item-content">
                                            <h3 class="seoaic-brand-sentiment-analysis-page__overview-item__title <?php echo str_replace(' ', '-', strtolower( $source )) . '-icon' ?>"><?php echo ucfirst( $source ) ?></h3>
                                            <p class="seoaic-brand-sentiment-analysis-page__overview-item__value"><?php echo $count ?> <?php esc_html_e('Prompts', 'seoaic'); ?></p>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>

                    <div class="seoaic-brand-sentiment-analysis-page__tab-content seoaic-brand-sentiment-analysis-page__analysis active">

                        <?php if( ! $sentiment_analysis_data && empty( $sentiment_analysis_data ) ): ?>
                            <div class="seoaic-brand-sentiment-analysis-page__analysis-filters">
                                <div class="seoaic-brand-sentiment-analysis-page__analysis-filters-row mt-20 pb-30">
                                    <div class="seoaic-brand-sentiment-analysis-page__request-analysis-message">
                                        <h3><?php esc_html_e( 'You dont have any data yet.', 'seoaic' ); ?></h3>
                                        <p><?php esc_html_e( 'Click the button below to run a set prompts against multiple AI platforms to gauge brand sentiment. The analysis may take a moment to complete.', 'seoaic' ); ?></p>
                                        <button class="seoaic-brand-sentiment-analysis-page__actions-button run-analysis-button mt-20"><?php esc_html_e( 'Analyze Brand Sentiment', 'seoaic' ); ?></button>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if( isset( $sentiment_analysis_data['status'] ) && in_array( $sentiment_analysis_data['status'], array('in-progress', 'pending' ), true )): ?>
                            <div class="seoaic-brand-sentiment-analysis-page__analysis-filters">
                                <div class="seoaic-brand-sentiment-analysis-page__analysis-filters-row mt-20 pb-30">
                                    <div class="seoaic-brand-sentiment-analysis-page__request-analysis-message">
                                        <h3><?php esc_html_e( 'Your analysis is running.', 'seoaic' ); ?></h3>
                                        <p><?php esc_html_e( 'Please wait while your analysis is running.', 'seoaic' ); ?></p>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                        <div class="seoaic-brand-sentiment-analysis-page__analysis-filters">
                            <?php if ( isset( $sentiment_analysis_data['results'] ) && empty( $sentiment_analysis_data['results'] ) ): ?>
                                <div class="seoaic-brand-sentiment-analysis-page__analysis-filters-row mt-20">
                                    <h3 class="seoaic-brand-sentiment-analysis-page__analysis-filter__selected-count">
                                        <?php esc_html_e( 'No prompts found', 'seoai' ); ?>
                                    </h3>
                                </div>
                            <?php endif; ?>
                        </div>

                        <?php if (! empty( $sentiment_analysis_data['results'] ) ): ?>
                            <div class="seoaic-brand-sentiment-analysis-page__analysis-table">
                                <div class="seoaic-brand-sentiment-analysis-page__analysis-table-head-row">
                                    <div class="seoaic-brand-sentiment-analysis-page__analysis-table-head-row-content">
                                        <div class="seoaic-brand-sentiment-analysis-page__analysis-table-col brand-visibility-col-8">
                                            <div class="seoaic-brand-sentiment-analysis-page__analysis-table-col">
                                                <h3 class="mb-0 mt-0"><?php esc_html_e( 'Detailed Analysis per Prompt', 'seoai' ); ?></h3>
                                            </div>
                                        </div>

                                        <div class="seoaic-brand-sentiment-analysis-page__analysis-table-col brand-visibility-col-4 align-right">
                                            <span><?php esc_html_e( 'Actions', 'seoai' ); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <?php foreach ( $sentiment_analysis_data['results'] as $key => $data ): ?>
                                    <div class="seoaic-brand-sentiment-analysis-page__analysis-table-row <?php echo $selectedProvider !== 'total' && $selectedProvider !== strtolower( $data['provider'] ) ? 'hide' : '' ?>"
                                         data-provider="<?php echo strtolower( $data['provider'] ) ?>">
                                        <div class="seoaic-brand-sentiment-analysis-page__analysis-table-row-content">
                                            <div class="seoaic-brand-sentiment-analysis-page__analysis-table-col brand-visibility-col-8">
                                                <span class="seoaic-brand-sentiment-analysis-page__analysis-table-prompt"></span><?php echo esc_html( $data['prompt'] ); ?></span>
                                            </div>

                                            <div class="seoaic-brand-sentiment-analysis-page__analysis-table-col brand-visibility-col-2 align-right">
                                                <?php $data['provider'] = strtolower( $data['provider'] ) === 'google_ai_overview' ? 'Google AIO' : $data['provider']; ?>
                                                <span><?php echo esc_html( ucfirst( $data['provider'] )); ?></span>
                                            </div>

                                            <div class="seoaic-brand-sentiment-analysis-page__analysis-table-col brand-visibility-col-2 align-right">
                                                <button title="Prompt details" type="button" class="seoaic-details active"></button>
                                            </div>
                                        </div>

                                    <div class="seoaic-brand-sentiment-analysis-page__analysis-table-row-hidden-content">
                                        <div class="seoaic-brand-sentiment-analysis-page__analysis-table-col brand-visibility-col-12 fd-column align-left">
                                            <div class="seoaic-brand-sentiment-analysis-page__analysis-table__tab-content active">
                                                <?php echo $SEOAIC->brand_visibility::mdToHTML(  $data['response']  ); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="lds-dual-ring"></div>
    </div>
</div>
