<?php

if (!current_user_can('seoaic_edit_plugin')) {
    return;
}

?>
<form id="seoaic-sea-settings" class="seoaic-sea-settings-form row" name="seoaic-sea-settings" method="post" autocomplete="off">
    <input type="hidden" class="seoaic-form-item" name="action" value="seoaic_sea_set_settings">
    <div class="col-6 left-side">
        <div class="row">

            <div class="col-12">
                <label for="seoaic_sea_prompt_ad_copy_guideline"><?php esc_html_e('Ad copy guidelines', 'seoaic');?></label>

                <textarea rows="6"
                        id="seoaic_sea_prompt_ad_copy_guideline"
                        name="seoaic_sea_prompt_ad_copy_guideline"
                        class="seoaic-form-item form-input light mb-0 seoaic-textarea-autoresize"
                ></textarea>
            </div>

            <div class="col-12 d-flex seoaic-single-row-switcher">
                <div class="toggle-choose-server">
                    <label class="switch">
                        <input type="checkbox"
                            id="seoaic_sea_utm_enabled"
                            name="seoaic_sea_utm_enabled"
                            class="seoaic-toggle seoaic-form-item"
                            value="on"
                        >
                        <span class="slider round"><span
                                    class="seoaic-toggle-value seoaic-toggle-value-1">On</span><span
                                    class="seoaic-toggle-value seoaic-toggle-value-2">Off</span></span>
                    </label>
                </div>
                <label for="seoaic_ssl_verifypeer"><?php esc_html_e('Enable UTM', 'seoaic');?></label>
            </div>

            <div class="col-12">
                <label for="seoaic_sea_utm_source"><?php esc_html_e('UTM Source', 'seoaic');?></label>
                <input type="text"
                        id="seoaic_sea_utm_source"
                        name="seoaic_sea_utm_source"
                        class="seoaic-form-item form-input light"
                        value=""/>
            </div>

            <div class="col-12">
                <label for="seoaic_sea_utm_medium"><?php esc_html_e('UTM Medium', 'seoaic');?></label>

                <input type="text"
                        id="seoaic_sea_utm_medium"
                        name="seoaic_sea_utm_medium"
                        class="seoaic-form-item form-input light"
                        value=""/>
            </div>
            <div class="group-line">
                <small class="utm-hint">
                    <?php esc_html_e('Available tags: {campaignid}, {adgroupid}, {keyword}', 'seoaic'); ?>
                </small>
                <div class="col-12">
                    <label for="seoaic_sea_utm_campaign"><?php esc_html_e('UTM Campaign', 'seoaic');?></label>

                    <input type="text"
                            id="seoaic_sea_utm_campaign"
                            name="seoaic_sea_utm_campaign"
                            class="seoaic-form-item form-input light"
                            value=""/>
                </div>
                <div class="col-12">
                    <label for="seoaic_sea_utm_content"><?php esc_html_e('UTM Content', 'seoaic');?></label>

                    <input type="text"
                            id="seoaic_sea_utm_content"
                            name="seoaic_sea_utm_content"
                            class="seoaic-form-item form-input light"
                            value=""/>
                </div>
            </div>
            <div class="group-line">
                <h3 class="seoaic-group-title"><?php esc_html_e('Campaign Defaults', 'seoaic'); ?></h3>

                <div class="col-12 d-flex seoaic-single-row-switcher">
                    <div class="toggle-choose-server">
                        <label class="switch">
                            <input type="checkbox"
                                id="seoaic_campaign_conversion_tracking"
                                name="seoaic_campaign_conversion_tracking"
                                class="seoaic-toggle seoaic-form-item"
                                value="on"
                            >
                            <span class="slider round"><span
                                        class="seoaic-toggle-value seoaic-toggle-value-1">On</span><span
                                        class="seoaic-toggle-value seoaic-toggle-value-2">Off</span></span>
                        </label>
                    </div>
                    <label for="seoaic_ssl_verifypeer"><?php esc_html_e('Conversion Tracking', 'seoaic');?></label>
                </div>
                <div class="col-12">
                    <label for="seoaic_campaign_default_goal"><?php esc_html_e('Campaign Goal', 'seoaic'); ?></label>
                    <select id="seoaic_campaign_default_goal" name="seoaic_campaign_default_goal" class="seoaic-form-item form-input light">
                        <option value="WEBSITE_TRAFFIC"><?php esc_html_e('Website traffic', 'seoaic'); ?></option>
                        <option value="SALES" data-option="hide"><?php esc_html_e('Sales', 'seoaic'); ?></option>
                        <option value="LEADS" data-option="hide"><?php esc_html_e('Leads', 'seoaic'); ?></option>
                    </select>
                    <small class="hint"><?php esc_html_e('If conversion tracking is OFF, only "Website Clicks" is available.', 'seoaic'); ?></small>
                </div>
                <div class="col-12">
                    <label for="seoaic_sea_default_bid_strategy"><?php esc_html_e('Bid Strategy', 'seoaic'); ?></label>
                    <select id="seoaic_sea_default_bid_strategy" name="seoaic_sea_default_bid_strategy" class="seoaic-form-item form-input light">
                        <option value="TARGET_SPEND"><?php esc_html_e('Maximize Clicks', 'seoaic'); ?></option>
                        <option value="MAXIMIZE_CONVERSIONS" data-option="hide"><?php esc_html_e('Maximize Conversions', 'seoaic'); ?></option>
                        <?php /* ?>
                        <option value="TARGET_CPA" data-option="hide"><?php esc_html_e('Target CPA', 'seoaic'); ?></option>
                        <option value="TARGET_ROAS" data-option="hide"><?php esc_html_e('Target ROAS', 'seoaic'); ?></option>
                        <?php */ ?>
                    </select>
                    <small class="hint"><?php esc_html_e('If conversion tracking is OFF, only "Maximize Clicks" is available.', 'seoaic'); ?></small>
                </div>
                <div class="seoaic-country-picker col-12" data-nonce="<?php echo wp_create_nonce('seoaic_countries'); ?>">
                    <label for="seoaic_country"><?php esc_html_e('Locations', 'seoaic') ?></label>
                    <div class="seoaic-chosen-wrap" aria-live="polite"></div>
                    <select id="seoaic_country" class="js-seoaic-country" style="width:100%"></select>
                    <input type="hidden" class="seoaic-country-values" name="seoaic_sea_country_ids" value="[]">
                    <small class="hint"><?php esc_html_e('You can select one or multiple countries, or leave empty to include all countries and territories.', 'seoaic') ?></small>
                </div>
            </div>
            <div class="col-12 seoaic-settings-submit-wrapper">
                <button id="seoaic_sea_settings_submit" type="submit" class="button button-primary seoaic-button-primary"><?php esc_html_e('Save settings', 'seoaic');?></button>
            </div>
        </div>
    </div>
</form>