<?php
    if (!current_user_can('seoaic_edit_plugin')) {
        return;
    }

    global $SEOAIC;
    $sea_key = $SEOAIC->sea->getSeaAuthToken();

    $isIntegrated = empty($sea_key['token']);

    $available_dates_options = [
        'last_7_days' => esc_html__('Last 7 days', 'seoaic'),
        'last_28_days' => esc_html__('Last 28 days', 'seoaic'),
        'last_3_months' => esc_html__('Last 3 months', 'seoaic'),
        'last_6_months' => esc_html__('Last 6 months', 'seoaic'),
        'last_12_months' => esc_html__('Last 12 months', 'seoaic'),
        'last_16_months' => esc_html__('Last 16 months', 'seoaic'),
    ];

    $available_status_options = [
        'all' => esc_html__('All', 'seoaic'),
        'ENABLED' => esc_html__('Started', 'seoaic'),
        'PAUSED' => esc_html__('Paused', 'seoaic'),
        'REMOVED' => esc_html__('Removed', 'seoaic'),
    ];

    $available_owner_options = [
        'all' => esc_html__('All', 'seoaic'),
        'not_seoai' => esc_html__('Not SEO AI', 'seoaic'),
        'seoai' => esc_html__('SEO AI', 'seoaic'),
    ];
?>

<div class="seoaic-sea-wrap <?php echo !$isIntegrated ? 'sea-integrated' : '' ?>">
    <div class="seoaic-sea-dashboard">
        <?php if ($isIntegrated) { ?>
            <?php include_once(SEOAIC_DIR . 'inc/view/sea/seoaic-sea-authorize.php'); ?>
        <?php } else { ?>
            <div class="sea-auth d-flex jc-e">
                <?php if($sea_key['is_owner']) { ?>
                    <button class="button-primary seoaic-button-primary seoaic-sea-log-out"><?php esc_html_e('Logout', 'seoaic') ?></button>
                <?php } ?>
                <a href="<?php echo admin_url('admin.php?page=seoaic-sea-select-account') ?>" class="change-account"><?php esc_html_e('Change account', 'seoaic') ?></a>
                <a href="<?php echo admin_url('admin.php?page=seoaic-sea-settings') ?>" class="change-account"><?php esc_html_e('Settings', 'seoaic') ?></a>
            </div>
            <div class="sea-graph sea-block">
                <div class="sea-chart-header">
                    <div class="sea-chart-description">
                        <h2><?php esc_html_e('Overall Site Performance', 'seoaic'); ?></h2>
                        <p><?php esc_html_e('Trend of total clicks and impressions across analyzed pages.', 'seoaic') ?></p>
                    </div>
                    <div class="graph-header sea-chart-filters">
                        <div class="status-filter">
                            <select id="seoaic_available_status_options" class="form-select pp-select">
                                <?php foreach ($available_status_options as $key => $option_value) {
                                    ?>
                                    <option value="<?php echo esc_attr($key) ?>">
                                        <?php echo esc_html(strval($option_value)); ?>
                                    </option>
                                    <?php
                                }
                                ?>
                            </select>
                        </div>
                        <div class="owner-filter">
                            <select id="seoaic_available_owner_options" class="form-select pp-select">
                                <?php foreach ($available_owner_options as $key => $option_value) {
                                    ?>
                                    <option value="<?php echo esc_attr($key) ?>">
                                        <?php echo esc_html(strval($option_value)); ?>
                                    </option>
                                    <?php
                                }
                                ?>
                            </select>
                        </div>
                        <div class="status-filter">
                            <select id="seoaic_available_dates_options" class="form-select pp-select">
                                <?php foreach ($available_dates_options as $key => $option_value) {
                                    ?>
                                    <option value="<?php echo esc_attr($key) ?>" <?php echo $key === 'last_6_months' ? 'selected' : '' ?>>
                                        <?php echo esc_html(strval($option_value)); ?>
                                    </option>
                                    <?php
                                }
                                ?>
                                <option value="custom"><?php esc_html_e('Custom', 'seoaic'); ?></option>
                            </select>
                        </div>
                        <div>
                            <div class="position-relative">
                                <input type="text" id="seoaic_sea_graph_from" disabled name="seoaic_sea_graph_from"
                                        value="" class="mt-0 seoaic-form-item form-input"
                                        placeholder="<?php esc_html_e('Select from', 'seoaic') ?>">
                                <div class="picker-call"></div>
                            </div>
                        </div>
                        <div>
                            <div class="position-relative">
                                <input type="text" id="seoaic_sea_graph_to" disabled name="seoaic_sea_graph_to" value=""
                                        class="mt-0 seoaic-form-item form-input"
                                        placeholder="<?php esc_html_e('Select to', 'seoaic') ?>">
                                <div class="picker-call"></div>
                            </div>
                        </div>
                        <div>
                            <button type="submit" class="filter-search-btn sea-filter-button" title="Filter"></button>
                        </div>
                        <div>
                            <a href="<?php echo esc_url(get_admin_url()); ?>admin.php?page=seoaic-sea-dashboard"
                                class="clear filter-clear-btn" title="Clear data for graph"></a>
                        </div>
                        <div>
                            <button class="seoaic-graph-interval"
                                    data-interval="daily"><?php esc_html_e('Daily', 'seoaic') ?></button>
                            <button class="seoaic-graph-interval active"
                                    data-interval="weekly"><?php esc_html_e('Weekly', 'seoaic') ?></button>
                            <button class="seoaic-graph-interval"
                                    data-interval="monthly"><?php esc_html_e('Monthly', 'seoaic') ?></button>
                        </div>
                    </div>
                </div>
                <div class="sea-chart-container">
                    <div id="chart_sea_performance_gsc"></div>
                    <div class="loader-wrap">
                        <div class="loader"><a href="#" class="loader-ellipsis"></a></div>
                    </div>
                </div>
            </div>
            <div class="sea-block sea-campaigns">
                <h2><?php esc_html_e('All Campaigns', 'seoaic'); ?></h2>
                <p><?php esc_html_e('Overview of your Search Engine Advertising campaigns. Click to expand and view keywords/ads.', 'seoaic') ?></p>
                <div class="sea-filters d-flex">
                    <div class="search">
                        <input type="text" class="search-campaigns" placeholder="<?php esc_html_e('Search campaigns by name...', 'seoaic') ?>">
                    </div>
                    <div class="filter-published-date d-flex flex-column">
                        <select id="seoaic_sea_filter_by_status" name="sea_filter_by_status" class="form-select-ci">
                            <?php foreach ($available_status_options as $key => $option_value) {
                                ?>
                                <option value="<?php echo esc_attr($key) ?>">
                                    <?php echo esc_html(strval($option_value)); ?>
                                </option>
                                <?php
                            } ?>
                        </select>
                    </div>
                </div>
                <div class="sea-campaigns-list"></div>
            </div>
        <?php } ?>
    </div>
</div>

