<?php
if (!current_user_can('seoaic_edit_plugin')) {
    return;
}

global $SEOAIC, $SEOAIC_OPTIONS;

$SEOAIC->sea->handle_auth_callback();

$account_url = esc_url( admin_url('admin.php?page=seoaic-sea-select-account') );
?>

<div class="seoaic-sea-wrap seoaic-sea-auth-success">
    <div class="seoaic-sea-auth">
        <div class="seoaic-sea-header">
            <h2><?php esc_html_e('Authorization Successful!', 'seoaic'); ?></h2>
        </div>

        <p class="seoaic-sea-description">
            <?php esc_html_e('You have successfully connected your account to the SEA for WordPress plugin.', 'seoaic'); ?>
        </p>

        <p class="seoaic-sea-subtitle"><?php esc_html_e('Now you can:', 'seoaic'); ?></p>
        <ul class="seoaic-sea-list">
            <li><?php esc_html_e('Create and manage ad campaigns directly from your WordPress dashboard.', 'seoaic'); ?></li>
            <li><?php esc_html_e('Track key metrics (impressions, clicks, costs, etc.).', 'seoaic'); ?></li>
            <li><?php esc_html_e('Optimize and improve your ads with built-in tools.', 'seoaic'); ?></li>
        </ul>

        <p class="seoaic-sea-cta">
            <?php
            printf(
                wp_kses(
                    __('Continue by selecting your account on the <a class="seoaic-btn" href="%s">Account Selection Page</a>', 'seoaic'),
                    array( 'a' => array( 'href' => array(), 'class' => array() ) )
                ),
                $account_url
            );
            ?>
        </p>
    </div>
</div>