<?php

use SEOAIC\Wizard;

defined( 'ABSPATH' ) || exit;

?>
<div id="wizard_generate_posts" class="seoaic-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3><?php esc_html_e('Generate Post', 'seoaic');?></h3>
        </div>
        <div class="seoaic-popup__content">
            <label class="seoaic-modal-content mb-10"><?php esc_html_e('You will generate post from', 'seoaic');?> <b class="additional-items-amount">1</b> <?php esc_html_e('following idea', 'seoaic');?>:</label>
            <form id="wizard_generate_posts_form" class="seoaic-form" method="post" data-callback="window_reload">
                <input class="seoaic-form-item" type="hidden" name="action" value="seoaic_wizard_posts_mass_create">
                <div class="additional-items mass-create mt-0"></div>
                <div class="seoaic-popup__field">
                    <label class="text-label" for="wizard_posts_prompt_field"><?php esc_html_e('Custom prompt', 'seoaic');?></label>
                    <textarea name="mass_prompt" class="seoaic-form-item" id="wizard_posts_prompt_field"></textarea>
                </div>
            </form>
        </div>
        <div class="seoaic-popup__footer flex-right">
            <button id="btn-generate-posts" type="submit" form="wizard_generate_posts_form" class="seoaic-popup__btn" disabled><?php esc_html_e('Generate Post', 'seoaic');?></button>
        </div>
    </div>
</div>
