<?php

defined('ABSPATH') || exit;

global $SEOAIC;
?>
<div id="settings-description-generate-modal" class="seoaic-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3><?php esc_html_e('Generate Description', 'seoaic'); ?></h3>
        </div>
        <div class="seoaic-popup__content">
            <div class="generate_description_container">
                <input type="hidden" name="action" value="seoaic_settings_generate_description">
                <input type="hidden" name="type" value="">
                <input type="hidden" name="target_name" value="">

                <div id="seoaic_description_current_data" class="current_data preview_text active">
                    <h3><?php esc_html_e('Your current version', 'seoaic');?></h3>
                    <div class="inner current">
                        <label class="label"></label>
                        <div class="inner"></div>
                    </div>
                    <div class="actions">
                        <button
                                style="display:none"
                            type="button"
                            id="seoaic_save_and_close_description_generate"
                            class="seoaic-popup__btn outline seoaic-modal-close">
                            <?php esc_html_e('Save and close', 'seoaic');?>
                        </button>

                        <button
                                type="button"
                                data-default="<?php esc_html_e('Save and close', 'seoaic');?>"
                                data-saving="<?php esc_html_e('Saving', 'seoaic');?>"
                                class="seoaic-branded-button mt-15 seoaic-modal-close small-button seoaic_save_and_close_description_generate">
                            <?php esc_html_e('Save and close', 'seoaic');?>
                        </button>
                    </div>
                </div>

                <div class="generate_data">

                    <div id="seoaic_generate_description_new_data" class="preview_text">
                        <h3><?php esc_html_e('Generated version', 'seoaic');?></h3>
                        <div class="inner current">
                            <label class="label"></label>
                            <div class="inner"></div>
                        </div>
                        <div class="actions">

                            <a id="seoaic_generate_again_data"
                               class="accent accent-underline generate_description_ajax"
                               href="#"><?php esc_html_e('Generate again', 'seoaic');?></a>

                            <a id="seoaic_use_this_generated_data"
                               class="accent accent-underline"
                               href="#"><?php esc_html_e('Use this version', 'seoaic');?></a>

                        </div>
                    </div>

                    <h3><?php esc_html_e('Generate description', 'seoaic');?></h3>
                    <div class="generate_text">
                        <div class="seoaic-popup__field" data-select2-id="select2-data-63-ve6d">
                            <label class="mb-10"><?php esc_html_e('AI user prompt', 'seoaic');?></label>
                            <textarea id="seoaic_user_description_prompt" name="prompt" class="seoaic-form-item mt-0 mb-13"></textarea>
                        </div>
                        <div id="seoaic_description_generate_words"
                             class="words_num_generate seoai-filterable seoai-filter-num display_float label_min_max"
                             data-range-label="Number of words"
                             data-placeholder="How many words?"
                             data-sort="generate_words"
                             data-min="10"
                             data-max="1000"
                             data-default-min="80"
                             data-default-max="300"
                             data-slider-step="10"
                        ></div>
                    </div>
                    <button type="submit"
                            form="settings-description-generate-form"
                            id="btn-add-keyword"
                            class="seoaic-popup__btn generate_description_ajax"
                            data-action="seoaic_settings_generate_description"
                    ><?php esc_html_e('Generate', 'seoaic'); ?></button>
                </div>
            </div>
        </div>
        <div class="seoaic-popup__footer"></div>
    </div>
</div>