<?php
defined('ABSPATH') || exit;
?>
<div id="seoaic-sea-edit-campaign" class="seoaic-modal seoaic-sea-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3 class="modal-title" data-title="<?php esc_html_e('Edit Budget for', 'seoaic');?>"></h3>
        </div>
        <div class="seoaic-popup__content">
            <form id="edit-budget-form" class="seoaic-form">
                <div class="budget">
                    <input class="seoaic-form-item seoaic_sea_budget" type="hidden" name="seoaic_sea_budget" value="">
                    <input class="seoaic-form-item seoaic_campaign_id" type="hidden" name="seoaic_campaign_id" value="">
                    <div class="seoaic-form__group">
                        <label for="budget" class="seoaic-form__label"><?php esc_html_e('Budget', 'seoaic'); ?> <span class="currency-symbol"></span></label>
                        <p><?php esc_html_e('Enter the new budget for this campaign.', 'seoaic'); ?></p>
                        <p class="custom-budget"></p>
                        <input type="number" id="seoaic_sea_create_budget" name="budget" class="seoaic-form__input"
                            placeholder="<?php esc_attr_e('Enter new budget', 'seoaic'); ?>" required>
                    </div>
                </div>
                <div class="seoaic-form__group">
                    <label for="eoaic-sea-campaign-date-start" class="seoaic-form__label"><?php esc_html_e('Set date period', 'seoaic'); ?></label>
                    <div class="sea-campaign-date">
                        <input type="text" id="seoaic-sea-campaign-date-start"
                                value="" placeholder="Start date">
                        <input type="text" id="seoaic-sea-campaign-date-end"
                                value="" placeholder="End date">
                    </div>
                </div>
            </form>
        </div>
        <div class="seoaic-popup__footer">
            <button type="button" class="seoaic-popup__btn-left seoaic-modal-close"><?php esc_html_e('Cancel', 'seoaic');?></button>
            <button type="submit" class="seoaic-popup__btn seoaic-sea_edit_campaign"><?php esc_html_e('Save campaign', 'seoaic');?></button>
        </div>
    </div>
</div>
