<?php
defined('ABSPATH') || exit;

$page_slug = '';
if ( isset($_GET['page']) ) {
    $page_slug = sanitize_key( wp_unslash( $_GET['page'] ) );
}
?>
<div id="seoaic-sea-edit-ad-data" class="seoaic-modal seoaic-sea-modal no-outside-close">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3 class="modal-title"><?php esc_html_e('Edit Ad Copy', 'seoaic');?></h3>
        </div>
        <div class="seoaic-popup__content">
            <p><?php esc_html_e('Modify the Headlines and Description for the keyword.', 'seoaic'); ?></p>
            <form id="edit-ad-copy-form" class="seoaic-form">
                <input class="seoaic-form-item seoaic_sea_post_id" type="hidden" name="seoaic_sea_post_id" value="">
                <input class="seoaic-form-item seoaic_campaign_id" type="hidden" name="seoaic_campaign_id" value="">
                <input class="seoaic-form-item seoaic_group_id" type="hidden" name="seoaic_group_id" value="">
                <input class="seoaic-form-item seoaic_ad_id" type="hidden" name="seoaic_ad_id" value="">
                <input class="seoaic-form-item seoaic_sea_page" type="hidden" name="seoaic_sea_page" value="<?php echo esc_attr( $page_slug ); ?>">
            </form>
        </div>
        <div class="seoaic-popup__footer">
            <button type="button" class="seoaic-popup__btn-left seoaic-modal-close"><?php esc_html_e('Cancel', 'seoaic');?></button>
            <button type="submit" class="seoaic-popup__btn sea-edit-ad-copy"><?php esc_html_e('Save Ad Changes', 'seoaic');?></button>
        </div>
    </div>
</div>
