<?php
defined('ABSPATH') || exit;

$defaultStartDate =  date('Y-m-d');
$defaultEndDate =  date('Y-m-d', strtotime('+89 days'));
?>
<div id="seoaic-sea-create-campaign" class="seoaic-modal seoaic-sea-modal no-outside-close">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3 class="modal-title"><?php esc_html_e('Create campaign', 'seoaic');?></h3>
        </div>
        <div class="seoaic-popup__content">
            <form id="create-campaign-form" class="seoaic-form">
                <input class="seoaic-form-item seoaic_sea_campaign_keywords" type="hidden" name="sea_campaign_keywords" value="">
                <input class="seoaic-form-item seoaic_sea_post_id" type="hidden" name="sea_post_id" value="">
                <div class="seoaic-form__group">
                    <label for="budget" class="seoaic-form__label"><?php esc_html_e('Budget', 'seoaic'); ?> <span class="currency-symbol"></span></label>
                    <div>
                        <p class="budget-hint">
                            <?php
                            echo wp_kses(
                                __('By default, the budget is shown per month (e.g. 5<span class="currency-symbol"></span> / day = 150<span class="currency-symbol"></span> / month). If you select custom dates, the total will be recalculated for that period.', 'seoaic'),
                                ['span' => ['class' => []]]
                            );
                            ?>
                        </p>
                        <p class="custom-budget"></p>
                    </div>
                    <input type="number" id="seoaic_sea_create_budget" name="create-budget" class="seoaic-form__input seoaic_sea_create_budget"
                           value="" required>
                </div>
                <div class="seoaic-form__group">
                    <label class="seoaic-form__label"><?php esc_html_e('Set date period', 'seoaic'); ?></label>
                    <div class="sea-campaign-date">
                        <div class="sea-date-field">
                            <input type="text" id="seoaic-sea-campaign-date-start"
                                value="<?php echo esc_attr($defaultStartDate);?>" placeholder="Start date">
                        </div>
                        <div class="sea-date-field">
                            <input type="text" id="seoaic-sea-campaign-date-end"
                                value="<?php echo esc_attr($defaultEndDate);?>" placeholder="End date">
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="seoaic-popup__footer">
            <button type="button" class="seoaic-popup__btn-left seoaic-modal-close"><?php esc_html_e('Cancel', 'seoaic');?></button>
            <button type="submit" form="create-campaign-form"
                    class="seoaic-popup__btn seoaic-sea-create-campaign-req"><?php esc_html_e('Create', 'seoaic');?></button>
        </div>
        <div class="loader-wrap">
            <div class="loader"><a href="#" class="loader-ellipsis"></a></div>
        </div>
    </div>
</div>
