<?php
defined('ABSPATH') || exit;

$page_slug = '';
if ( isset($_GET['page']) ) {
    $page_slug = sanitize_key( wp_unslash( $_GET['page'] ) );
}
?>
<div id="seoaic-sea-create-ad-data-modal" class="seoaic-modal seoaic-sea-modal no-outside-close">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3 class="modal-title"><?php esc_html_e('Edit Ad Copy', 'seoaic');?></h3>
        </div>
        <div class="seoaic-popup__content">
            <div class="sea-groups-loader">
                <div class="loading-data">
                    <div class="loading-label accent"><?php esc_html_e('Generating ad copy', 'seoaic');?></div>
                    <div class="loading-icon">
                        <div class="loader-ellipsis small do-not-remove"></div>
                    </div>
                </div>
            </div>
            <form id="edit-ad-copy-form" class="seoaic-form">
                <input class="seoaic-form-item seoaic_sea_post_id" type="hidden" name="seoaic_sea_post_id" value="">
                <input class="seoaic-form-item seoaic_sea_start_date" type="hidden" name="seoaic_sea_start_date" value="">
                <input class="seoaic-form-item seoaic_sea_end_date" type="hidden" name="seoaic_sea_end_date" value="">
                <input class="seoaic-form-item seoaic_sea_budget" type="hidden" name="seoaic_sea_budget" value="">
                <input class="seoaic-form-item seoaic_campaign_id" type="hidden" name="seoaic_campaign_id" value="">
                <p><?php esc_html_e('Modify the Headlines and Description for the keyword.', 'seoaic'); ?></p>
            </form>
        </div>
        <div class="seoaic-popup__footer">
            <button type="button" class="seoaic-popup__btn-left seoaic-modal-sea-close"><?php esc_html_e('Back', 'seoaic');?></button>
            <button type="button" class="seoaic-popup__btn-left seoaic-modal-close"><?php esc_html_e('Close', 'seoaic');?></button>
            <button type="submit" class="seoaic-popup__btn sea-create-ad-copy"><?php esc_html_e('Create', 'seoaic');?></button>
        </div>
    </div>
</div>
