<?php
defined('ABSPATH') || exit;
?>
<div id="seoaic-sea-change-status" class="seoaic-modal seoaic-sea-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3 class="modal-title"><?php esc_html_e('Confirm Campaign Status Change', 'seoaic');?></h3>
        </div>
        <div class="seoaic-popup__content">
            <p class="paused-message"><?php esc_html_e('Are you sure you want to pause the campaign "', 'seoaic'); ?><span class="campaign-name"></span></p>
            <p class="enabled-message"><?php esc_html_e('Are you sure you want to activate the campaign "', 'seoaic'); ?><span class="campaign-name"></span></p>
            <p class="disabled-message"><?php esc_html_e('You cannot change the status of this campaign because you are not its manager. Please contact a user with manager rights to perform this action.', 'seoaic'); ?></p>
            <p class="remove-message"><?php esc_html_e('Do you really want to remove this campaign? You will not be able to manage it afterwards.', 'seoaic'); ?></p>
        </div>
        <div class="seoaic-popup__footer">
            <input class="seoaic-form-item seoaic_sea_status_action" type="hidden" name="seoaic_sea_status_action" value="">
            <input class="seoaic-form-item seoaic_campaign_id" type="hidden" name="seoaic_campaign_id" value="">
            <input class="seoaic-form-item seoaic_ad_group_id" type="hidden" name="seoaic_campaign_id" value="">
            <input class="seoaic-form-item seoaic_campaign_status" type="hidden" name="seoaic_campaign_status" value="">
            <button type="button" class="seoaic-popup__btn-left seoaic-modal-close"><?php esc_html_e('Cancel', 'seoaic');?></button>
            <button type="submit" class="seoaic-popup__btn start seoaic-sea-change-campaign-status" data-status="enabled"><?php esc_html_e('Activate Campaign', 'seoaic');?></button>
            <button type="submit" class="seoaic-popup__btn pause seoaic-sea-change-campaign-status" data-status="paused"><?php esc_html_e('Pause Campaign', 'seoaic');?></button>
            <button type="submit" class="seoaic-popup__btn pause seoaic-sea-change-campaign-status" data-status="removed"><?php esc_html_e('Remove Campaign', 'seoaic');?></button>
        </div>
    </div>
</div>
