<?php

defined('ABSPATH') || exit;
global $SEOAIC;
?>
<div id="seoaic-review-onboarding-ideas" class="seoaic-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3 class="modal-title" data-title="<?php esc_attr_e('Review posts and ideas', 'seoaic');?>"><?php esc_html_e('Review posts and ideas', 'seoaic');?></h3>
        </div>
        <div class="seoaic-popup__content fs-18">
            <div class="seoaic-top-actions-on-ideas"><label id="seoaic-select-all-ob-ideas" class="accent accent-underline"><?php esc_html_e('Select all', 'seoaic');?></label></div>
            <div id="confirm-modal-content" class="seoaic-modal-content"></div>
        </div>
        <div class="seoaic-popup__footer flex-right seoaic-flex-wrap ai-center seoiac-top-border-light">
            <?php echo $SEOAIC->onboarding->get_mass_generate_selections(); ?>
            <button disabled type="button" class="seoaic-try-remove-selected-ob-ideas seoaic-branded-button small-button" data-removing="<?php esc_html_e('Removing', 'seoaic');?>" data-default="<?php esc_html_e('Remove', 'seoaic');?>"><?php esc_html_e('Remove', 'seoaic');?></button>
            <button disabled type="button" class="seoaic-accept-selected-ob-ideas seoaic-branded-button small-button ml-10" data-accepting="<?php esc_html_e('Accepting', 'seoaic');?>" data-default="<?php esc_html_e('Accept', 'seoaic');?>"><?php esc_html_e('Accept', 'seoaic');?></button>
            <button disabled type="button" class="seoaic-generated-selected-ob-ideas seoaic-branded-button small-button ml-10"><?php esc_html_e('Generate selected', 'seoaic');?></button>
            <button data-idea-id="0" class="seoaic_edit_meta_settings seoaic_edit_meta_settings_mass dashicons dashicons-admin-generic ml-10" type="button"></button>
            <div class="total-ob-ideas-selected">
                <span><?php echo esc_html('0');?></span><?php esc_html_e(' selected', 'seoaic');?>
            </div>
            <div class="total-ob-ideas-total">
                <span><?php echo esc_html('0');?></span><?php esc_html_e(' total items', 'seoaic');?>
            </div>
            <button type="button" class="seoaic-popup__btn seoaic-popup__btn-right ml-auto seoaic-modal-close seoaic-branded-button small-button outline"><?php esc_html_e('Close', 'seoaic');?></button>
        </div>
        <div class="seoaic-on-action-attention-remove d-none">
            <div class="seoaic-on-action-attention-remove-message">
                <?php esc_html_e('Are you sure you want to remove those items?', 'seoaic');?>
            </div>
            <button type="button" class="seoaic-remove-selected-ob-ideas seoaic-on-action-attention-remove-button seoaic-branded-button small-button ml-15"><?php esc_html_e('Yes', 'seoaic');?></button>
            <button type="button" class="seoaic-on-action-attention-remove-close seoaic-on-action-attention-remove-button seoaic-branded-button small-button ml-10"><?php esc_html_e('No', 'seoaic');?></button>
        </div>
    </div>
</div>