<?php

defined('ABSPATH') || exit;
?>
<div id="seoaic_reschedule-posts-modal" class="seoaic-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3><?php esc_html_e('Reschedule posts', 'seoaic'); ?></h3>
        </div>
        <div class="seoaic-popup__content fs-18">
            <div class="seoaic-modal-content"></div>
            <form id="schedule-posts-form" class="seoaic-form" method="post" data-callback="window_reload">
                <input class="seoaic-form-item" type="hidden" name="action" value="seoaic_reschedule_posts">
                <input class="seoaic-form-item" type="hidden" name="selected_posts" value="">
                <input id="reschedule_post_status_val" class="seoaic-form-item" type="hidden" name="new_status"
                       value="future">
                <input id="reschedule_posting_date_UTC" class="seoaic-form-item" type="hidden"
                       name="reschedule_posting_date_UTC" value="">
                <input class="seoaic-form-item" type="hidden" name="reschedule_date" value="">
                <div class="additional-items" style="display: none"></div>
                <div class="seoaic-popup__field form-reschedule-calendar-input">
                    <label class="text-label"><?php esc_html_e('Reschedule date', 'seoaic'); ?></label>
                    <div class="seoaic-date-picker">
                        <input type="text" id="reschedule_posting_date" name="reschedule_posting_date"
                               value="<?php echo esc_attr(date('Y-m-d')); ?>" class="mt-0 seoaic-form-item">
                        <div class="picker-call"></div>
                    </div>
                </div>
                <div class="seoaic-popup__field">
                    <label class="text-label d-flex"><?php esc_html_e('Auto schedule', 'seoaic'); ?><span class="seoaic-help-icon ml-10" data-seoaic-tooltip-info="<?php esc_html_e('If Auto schedule, the posts will be published according to the post schedule in the plugin Settings.', 'seoaic'); ?>">?</span></label>
                    <div class="seoaic_toggle_selector mt-10">
                        <input id="seoaic_auto_schedule" data-hide-on-checked=".form-reschedule-calendar-input"
                               value="" type="checkbox" class="d-none seoaic_checkbox_toggle_selector seoaic-form-item"
                               name="seoai_auto_schedule">
                        <label for="seoaic_auto_schedule" class="toggler"><span></span></label>
                    </div>
                </div>
                <div class="seoaic-popup__field">
                    <label class="text-label"><?php esc_html_e('Change selected posts status to:', 'seoaic'); ?></label>
                    <div class="status_buttons">
                        <ul class="post-status-dd-menu">
                            <li title="Change to: Published"
                                class="seoaic-posts-new-status post-status post-status--publish" data-status="publish">
                                <?php esc_html_e('Published', 'seoaic'); ?>
                            </li>
                            <li title="Change to: Draft" class="seoaic-posts-new-status post-status post-status--draft"
                                data-status="draft"><?php esc_html_e('Draft', 'seoaic'); ?>
                            </li>
                        </ul>
                    </div>
                </div>
            </form>
        </div>
        <div class="seoaic-popup__footer flex-justify">
            <button type="button"
                    class="seoaic-popup__btn-left seoaic-modal-close"><?php esc_html_e('No', 'seoaic'); ?></button>
            <button type="submit" form="schedule-posts-form"
                    class="seoaic-popup__btn-right seoaic-popup__btn"><?php esc_html_e('Schedule', 'seoaic'); ?></button>
        </div>
    </div>
</div>