<?php

defined('ABSPATH') || exit;

global $SEOAIC;

$promote    = $SEOAIC->promote;
$data       = $promote->getDefaultMediaList();

$filterKeys = array(
    'country_region'    => 'Region',
    'country'           => 'Country',
    'language'          => 'Language',
    'category'          => 'Category',
    'type'              => 'Type',
    'format_type'       => 'Format',
    'extra_features'    => 'Features',
);

?>
<div id="seoaic-promote-modal" class="seoaic-modal seoaic-modal-large seoaic-modal-promote">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3><?php esc_html_e('Promote the Article', 'seoaic');?></h3>
        </div>

        <div class="seoaic-popup__content promote-modal-content">
            <form id="promote-article-form" class="seoaic-form" method="post" data-callback="window_reload">
                <label for="seoaic-promote_post_id" class="text-label"><?php esc_html_e('Choose an article', 'seoaic');?></label>
                <select id="seoaic-promote_post_id" class="seoaic-form-item form-select"></select>

                <input type="hidden" name="media_id" value="">
                <input type="hidden" name="media_name" value="">
                <input type="hidden" name="final_price" value="">
            </form>

            <div class="row full-width promote-modal-media-gallery">
                <div class="col-4 promote-modal-col promote-filter">
                    <div class="promote-modal-col-header">
                        <h3 class="promote-modal-header-title"><?php esc_html_e('Filters', 'seoaic');?></h3>
                        <div class="promote-modal-header-action">
                            <button class="seoaic-clear-all-button"><?php esc_html_e('Clear All', 'seoaic');?></button>
                        </div>
                    </div>
                    <div class="promote-modal-col-content">
                        <?php foreach ( $filterKeys as $key => $title ): ?>
                            <?php if( isset($data['filtersOptions'][$key]) && $data['filtersOptions'][$key] ): ?>
		                        <?php
                                    usort($data['filtersOptions'][$key], function($a, $b) {
                                        return strcmp($a['title'], $b['title']);
                                    });
		                        ?>
                                <button type="button" class="accordion-toggle <?php echo $key === 'country_region' ? 'active' : ''; ?>" data-accordion="filter-<?php echo esc_attr($key);?>"><?php esc_html_e($title, 'seoaic');?></button>
                                <div id="filter-<?php echo esc_attr($key);?>" class="accordion-content filter-content <?php echo $key === 'country_region' ? 'active' : ''; ?>" data-filter="<?php echo esc_attr($key);?>">
			                        <?php foreach ( $data['filtersOptions'][$key] as $index => $item ): ?>
                                        <label class="<?php echo $index >= 3 ? 'seoaic-dni' : ''; ?>">
                                            <input
                                                    class="seoaic-checkbox"
                                                    type="checkbox"
                                                    name="<?php echo esc_attr($key) ?>[]"
                                                    value="<?php echo esc_attr($item['key']); ?>"
                                            >
					                        <?php echo esc_html($item['title']); ?>
                                        </label>
			                        <?php endforeach; ?>
			                        <?php if(count( $data['filtersOptions'][$key] ) >= 3): ?>
                                        <a class="seoaic-show-more-button"
                                           data-show-more-label="<?php esc_html_e('Show more', 'seoaic'); ?>"
                                           data-show-less-label="<?php esc_html_e('Show less', 'seoaic'); ?>"
                                        ><?php esc_html_e('Show more', 'seoaic');?></a>
			                        <?php endif; ?>
                                </div>
	                        <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                    <div class="promote-modal-col-footer">
                        <div class="promote-modal-footer-action">
                            <button class="seoaic-button seoaic-filter-apply-button"><?php esc_html_e('Apply', 'seoaic');?></button>
                        </div>
                    </div>
                </div>

                <div class="col-8 promote-modal-col promote-media-gallery">
                    <div class="promote-modal-col-header">
                        <h3 class="promote-modal-header-title"><?php esc_html_e('Available media outlets', 'seoaic');?></h3>
                        <div class="promote-modal-header-meta">
                            <span class="promote-modal-media-total-count"><?php echo esc_html($data['total']['value']); ?><?php echo $data['total']['relation'] === 'gte' ? '+ ' : ' '; ?></span>
                            <span><?php esc_html_e('resources', 'seoaic');?></span>
                        </div>
                    </div>
                    <div class="promote-modal-col-content">
                        <div class="row-gallery promote-media-cards">
                            <?php foreach( $data['data'] as $media ): ?>
                                <div class="promote-media-card"
                                    data-id="<?php echo esc_attr($media['id']); ?>"
                                    data-name="<?php echo esc_attr($media['name']); ?>"
                                    data-url="<?php echo esc_attr($media['url']); ?>"
                                    data-price="<?php echo number_format($media['price'], 2, '.', ''); ?>"
                                >
                                    <div class="promote-media-logo-image">
                                        <span><?php echo esc_attr($media['name']); ?></span>
                                    </div>
                                    <h4 class="promote-media-title"><?php echo esc_attr($media['name']); ?></h4>
                                    <a target="_blank" href="http://<?php echo esc_attr($media['url']); ?>" class="promote-media-link"><?php echo esc_html($media['url']); ?></a>
                                    <div class="promote-media-price">
                                        <span class="promote-media-price-currency">€</span>
                                        <span class="promote-media-price-value"><?php echo number_format($media['price'], 2, '.', ''); ?></span>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <div class="promote-modal-col-footer">
                        <div class="promote-modal-footer-action">
                            <button class="seoaic-load-more-button" data-page='1' data-filters=''><?php esc_html_e('Load more', 'seoaic');?></button>
                        </div>
                        <div class="promote-modal-footer-meta">
                            <span class="promote-modal-media-shown-count"><?php echo 24; ?></span>
                            <span><?php esc_html_e('from', 'seoaic');?></span>
                            <span class="promote-modal-media-total-count"><?php echo esc_html($data['total']['value']); ?><?php echo $data['total']['relation'] === 'gte' ? '+' : ''; ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="seoaic-popup__error-wrapper">
            <span class="seoaic-popup__error"></span>
        </div>

        <div class="seoaic-popup__footer">
            <label for="seoaic-agree-terms">
                <input class="seoaic-checkbox" type="checkbox" name="seoaic-agree-terms" id="seoaic-agree-terms">
                <span class="seoaic-checkbox-label"><?php esc_html_e('I understand this is a premium paid service and agree to the listed cost.', 'seoaic');?></span>
            </label>
            <button
                    class="seoaic-popup__btn"
                    type="submit"
                    disabled
            >
                <?php esc_html_e('Submit', 'seoaic');?></button>
        </div>
    </div>
</div>

<div id="seoaic-promote-modal-result" class="seoaic-modal seoaic-modal-promote" >
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3 class="modal-title" data-title="<?php esc_html_e('Promote the Article', 'seoaic');?>"><?php esc_html_e('Promote the Article', 'seoaic');?></h3>
        </div>
        <div class="seoaic-popup__content fs-18">
            <div class="modal-content promote-modal-result-content">
                <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 30 30" fill="none">
                    <circle cx="15" cy="15" r="15" fill="#00A56B" fill-opacity="0.11"/>
                    <path d="M10 14.5L13.5 18L19.5 12" stroke="#00A56B" stroke-width="2"/>
                </svg>
                <h2><?php esc_html_e('Success!', 'seoaic');?></h2>
                <p><?php esc_html_e('Our team will handle the publishing process. <br> We’ll contact you if we need any additional details.', 'seoaic');?></p>
            </div>
        </div>
    </div>
</div>

