<?php

defined( 'ABSPATH' ) || exit;

use SEOAIC\collections\prompt_data\PostsMassGeneratePromptDataCollection;
use SEOAIC\SEOAIC_PROMPTS;

global $SEOAIC, $SEOAIC_OPTIONS;

?>
<div id="seoaic-post-mass-outline-generate-modal" class="seoaic-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3 class="modal-title" data-title="<?php esc_html_e('Confirm', 'seoaic');?>"><?php esc_html_e('Confirm', 'seoaic');?></h3>
        </div>
        <div class="seoaic-popup__content fs-18 pb-0 position-relative">
            <label class="seoaic-modal-content mb-10"></label>
            <form id="post-mass-outline-generate-form" class="mt-0 seoaic-form" method="post" data-callback="window_reload" data-action="seoaic_frames_mass_generate">
                <div class="additional-items mass-create mt-0"></div>
                <input type="hidden" name="action" value="seoaic_frames_mass_generate">
                <div class="seoaic-popup__field">
                    <label class="mb-10"><?php esc_html_e('Custom prompt', 'seoaic');?></label>
                    <textarea name="mass_prompt" class="seoaic-form-item mt-0"></textarea>
                </div>

                <?php echo $SEOAIC->competitors->competitor_content_language_selection(); ?>

                <div class="flex-justify modal-ranges">
                    <div id="seoiac-modal-subtitles-range" class="seoaic-settings-range" data-min="0" data-max="15" data-step="1">
                        <label><?php esc_html_e('Subtitles range:', 'seoaic');?>
                            <span class="range-min"><?php echo !empty($SEOAIC_OPTIONS['seoaic_subtitles_range_min']) ? esc_html($SEOAIC_OPTIONS['seoaic_subtitles_range_min']) : '2'; ?></span> -
                            <span class="range-max"><?php echo !empty($SEOAIC_OPTIONS['seoaic_subtitles_range_max']) ? esc_html($SEOAIC_OPTIONS['seoaic_subtitles_range_max']) : '6'; ?></span>
                            <input form="post-mass-outline-generate-form" id="seoaic_modal_subtitles_range_min" class="seoaic-settings-range-min seoaic-form-item" type="hidden" name="seoaic_subtitles_range_min" value="<?php echo !empty($SEOAIC_OPTIONS['seoaic_subtitles_range_min']) ? esc_html($SEOAIC_OPTIONS['seoaic_subtitles_range_min']) : '2'; ?>">
                            <input form="post-mass-outline-generate-form" id="seoaic_modal_subtitles_range_max" class="seoaic-settings-range-max seoaic-form-item" type="hidden" name="seoaic_subtitles_range_max" value="<?php echo !empty($SEOAIC_OPTIONS['seoaic_subtitles_range_max']) ? esc_html($SEOAIC_OPTIONS['seoaic_subtitles_range_max']) : '6'; ?>">
                        </label>
                        <div id="seoiac-modal-subtitles-range-slider" class="seoaic-settings-range-slider"></div>
                    </div>
                </div>
            </form>
        </div>

        <div class="seoaic-popup__footer">
            <?php if ( $SEOAIC->multilang->is_multilang() ) : ?>
                <div class="mb-10 d-none">
                    <label>
                        <input form="post-mass-outline-generate-form" id="seoaic-translate-from-origin" class="seoaic-form-item" type="checkbox" name="seoaic-translate-from-origin" value="yes" checked>
                        <?php esc_html_e('Translate posts from origin', 'seoaic');?>
                    </label>
                </div>
            <?php endif; ?>

            <div class="flex-justify">
                <button form="post-mass-outline-generate-form" id="post-mass-outline-generate-button" type="submit" class="seoaic-popup__btn seoaic-popup__btn-right hide-on-generated"><?php esc_html_e('Generate', 'seoaic');?></button>
            </div>
        </div>
    </div>
</div>
