<?php

use SEOAIC\collections\prompt_data\PostsMassEditPromptDataCollection;
use SEOAIC\helpers\HTMLBuilers;
use SEOAIC\posts_mass_actions\LeadsFormGenerate;
use SEOAIC\preset_types\PresetTypesHelper;
use SEOAIC\SEOAIC_PROMPTS;
use SEOAIC\SEOAIC_SETTINGS;

$instances = PresetTypesHelper::getAll();

defined('ABSPATH') || exit;

global $SEOAIC;

?>
<div id="seoaic_post_mass_generate_lead_form_modal" class="seoaic-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3 class="modal-title"
                data-title="<?php esc_html_e('Confirm', 'seoaic'); ?>"><?php esc_html_e('Confirm', 'seoaic'); ?></h3>
        </div>
        <div class="seoaic-popup__content fs-18 position-relative">
            <label class="seoaic-modal-content mb-10"></label>
            <form id="post-mass-lead-forms-generate-form" class="mt-0 seoaic-form" method="post" data-callback="window_reload">
                <input class="seoaic-form-item" type="hidden" name="action" value="seoaic_generate_lead_form">
                <div class="additional-items mt-0"></div>

                <?php LeadsFormGenerate::generateLeadFormsFormElements('post-mass-generate-lead-forms');?>
            </form>
        </div>
        <div class="seoaic-popup__footer">
            <div class="flex-justify">
                <button type="submit"
                    form="post-mass-lead-forms-generate-form"
                    id="posts-mass-edit-button"
                    class="seoaic-popup__btn seoaic-popup__btn"
                ><?php esc_html_e('Generate lead form', 'seoaic');?></button>
            </div>
        </div>
    </div>
</div>
