<?php

use SEOAIC\SEOAIC_SETTINGS;

defined('ABSPATH') || exit;

global $SEOAIC;

?>
<div id="seoaic_post_mass_generate_faq_modal" class="seoaic-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3 class="modal-title"
                data-title="<?php esc_attr_e('Confirm', 'seoaic'); ?>"
            ><?php esc_html_e('Confirm', 'seoaic'); ?></h3>
        </div>
        <div class="seoaic-popup__content fs-18 position-relative">
            <label class="seoaic-modal-content mb-10"></label>
            <form method="post"
                id="post-mass-generate-faq-form"
                class="mt-0 seoaic-form"
                data-callback="window_reload"
            >
                <input class="seoaic-form-item" type="hidden" name="action" value="seoaic_generate_faq">
                <div class="additional-items mt-0"></div>

                <div class="seoaic-popup__field">
                    <label class="mb-10" for="posts_review_mass_prompt"><?php esc_html_e("Custom FAQ prompt", "seoaic");?></label>
                    <textarea
                    name="custom_prompt"
                    rows="4"
                    class="seoaic-form-item mt-0"
                ><?php echo esc_html(SEOAIC_SETTINGS::getCustomFaqPrompt());?></textarea>
                </div>
            </form>
        </div>
        <div class="seoaic-popup__footer">
            <div class="flex-justify">
                <button type="submit"
                    form="post-mass-generate-faq-form"
                    id=""
                    class="seoaic-popup__btn seoaic-popup__btn"
                ><?php esc_html_e('Generate FAQ', 'seoaic');?></button>
            </div>
        </div>
    </div>
</div>
