<?php

use SEOAIC\collections\prompt_data\PostsMassEditPromptDataCollection;
use SEOAIC\helpers\HTMLBuilers;
use SEOAIC\preset_types\PresetTypesHelper;
use SEOAIC\SEOAIC_PROMPTS;
use SEOAIC\SEOAIC_SETTINGS;

$instances = PresetTypesHelper::getAll();

defined('ABSPATH') || exit;

global $SEOAIC;

?>
<div id="seoaic_post_mass_edit_modal" class="seoaic-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3 class="modal-title"
                data-title="<?php esc_html_e('Confirm', 'seoaic'); ?>"><?php esc_html_e('Confirm', 'seoaic'); ?></h3>
        </div>
        <div class="seoaic-popup__content fs-18 position-relative">
            <?php
            (new SEOAIC_PROMPTS())->makePromptsSection((new PostsMassEditPromptDataCollection()), true);
            ?>
            <label class="seoaic-modal-content mb-10"></label>
            <form id="post-mass-edit-form" class="mt-0 seoaic-form" method="post" data-callback="window_reload">
                <input class="seoaic-form-item" type="hidden" name="action" value="seoaic_posts_mass_edit">
                <div class="additional-items mt-0"></div>

                <div>
                    <label class="mb-10" for=""><?php esc_html_e('Choose predefined editing presets', 'seoaic') ?></label>
                    <div class="toggle-choose-role">
                        <div class="checkbox-list">
                            <?php foreach ($instances as $instance) {
                                echo $instance->makePresetRadio();
                            }?>
                        </div>

                        <div class="preset-tabs-container mt-10">
                            <?php foreach ($instances as $instance) : ?>
                                <div class="preset-tab" id="tab-<?php echo esc_attr($instance->name); ?>" style="display: none;">
                                    <?php $instance->drawHtml();?>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>

                <div>
                    <label class="seoaic-cursor-pointer">
                        <input id="seoaic_generate_thumbnail" class="seoaic-form-item" type="checkbox"
                               name="seoaic_generate_thumbnail">
                        <?php esc_html_e('Generate thumbnails', 'seoaic'); ?>
                    </label>
                </div>

                <div class="seoaic-generate-thumb-wrapper display-none">
                    <div>
                        <label class="mb-10"><?php esc_html_e('Generated image style', 'seoaic'); ?></label>
                        <select name="generate_thumbnail_style" class="seoaic-form-item form-select">
                            <?php
                            $styles = SEOAIC_SETTINGS::getImageGenerateStylesAvailable();
                            $defaultStyle = SEOAIC_SETTINGS::getImageGenerateStyle();
                            echo wp_kses(
                                HTMLBuilers::options($styles, $defaultStyle),
                                [
                                    'option' => [
                                        'value' => [],
                                        'selected' => [],
                                        'class' => [],
                                    ],
                                ]
                            );
                            ?>
                        </select>
                    </div>

                    <div class="seoaic-popup__field">
                        <label class="mb-10 mt-20"><?php esc_html_e('Image generation prompt', 'seoaic'); ?></label>
                        <textarea name="thumbnail_generation_prompt"
                                  class="seoaic-form-item mt-0 seoaic-textarea-autoresize"><?php esc_html_e(SEOAIC_SETTINGS::getImageGeneratePromptDefault()); ?></textarea>
                    </div>
                    <div class="f-words-count seoaic-settings-range seoaic-settings-range-2 mt-20 mb-0"
                         data-min="256"
                         data-max="1440"
                         data-step="32"
                         data-range="min"
                    >
                        <label><?php esc_html_e('Image width (optionally):', 'seoaic'); ?>
                            <span class="range-min"><?php esc_html_e( SEOAIC_SETTINGS::getImageGenerateWidthDefault()); ?></span><?php esc_html_e('px', 'seoaic'); ?>
                            <input type="hidden"
                                   id=""
                                   class="seoaic-settings-range-min seoaic-form-item"
                                   name="thumbnail_generation_width"
                                   value="<?php esc_html_e( SEOAIC_SETTINGS::getImageGenerateWidthDefault()); ?>"
                            >
                        </label>
                        <div id=""
                             class="seoaic-settings-range-slider"
                        ></div>
                    </div>
                    <div class="f-words-count seoaic-settings-range seoaic-settings-range-2 mt-20 mb-0"
                         data-min="256"
                         data-max="1440"
                         data-step="32"
                         data-range="min"
                    >
                        <label><?php esc_html_e('Image height (optionally):', 'seoaic'); ?>
                            <span class="range-min"><?php esc_html_e( SEOAIC_SETTINGS::getImageGenerateHeightDefault()); ?></span><?php esc_html_e('px', 'seoaic'); ?>
                            <input type="hidden"
                                   id=""
                                   class="seoaic-settings-range-min seoaic-form-item"
                                   name="thumbnail_generation_height"
                                   value="<?php esc_html_e( SEOAIC_SETTINGS::getImageGenerateHeightDefault()); ?>"
                            >
                        </label>
                        <div id=""
                             class="seoaic-settings-range-slider"
                        ></div>
                    </div>
                </div>
            </form>
        </div>
        <div class="seoaic-popup__footer">
            <div class="flex-justify">
                <button form="post-mass-edit-form" id="posts-mass-edit-button" type="submit"
                        class="seoaic-popup__btn seoaic-popup__btn"><?php esc_html_e('Edit', 'seoaic'); ?></button>
            </div>
        </div>
    </div>
</div>
