<?php

defined( 'ABSPATH' ) || exit;

use SEOAIC\collections\prompt_data\PostsMassGeneratePromptDataCollection;
use SEOAIC\helpers\HTMLBuilers;
use SEOAIC\posts_mass_actions\LeadsFormGenerate;
use SEOAIC\SEOAIC;
use SEOAIC\SEOAIC_POSTS;
use SEOAIC\SEOAIC_PROMPTS;
use SEOAIC\SEOAIC_SETTINGS;

global $SEOAIC, $SEOAIC_OPTIONS;

$subtitlesRangeMin = !empty($SEOAIC_OPTIONS['seoaic_subtitles_range_min']) ? esc_html($SEOAIC_OPTIONS['seoaic_subtitles_range_min']) : '2';
$subtitlesRangeMax = !empty($SEOAIC_OPTIONS['seoaic_subtitles_range_max']) ? esc_html($SEOAIC_OPTIONS['seoaic_subtitles_range_max']) : '6';
$wordsRangeMin = !empty($SEOAIC_OPTIONS['seoaic_words_range_min']) ? esc_html($SEOAIC_OPTIONS['seoaic_words_range_min']) : '500';
$wordsRangeMax = !empty($SEOAIC_OPTIONS['seoaic_words_range_max']) ? esc_html($SEOAIC_OPTIONS['seoaic_words_range_max']) : '1000';
?>
<div id="seoaic-post-mass-creation-modal" class="seoaic-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3 class="modal-title" data-title="<?php esc_attr_e('Confirm', 'seoaic');?>"><?php esc_html_e('Confirm', 'seoaic');?></h3>
        </div>
        <div class="seoaic-popup__content fs-18 pb-0 position-relative">
            <?php
            (new SEOAIC_PROMPTS())->makePromptsSection((new PostsMassGeneratePromptDataCollection()), true);
            ?>

            <label class="seoaic-modal-content mb-10"></label>
            <form id="post-mass-creation-form" class="mt-0 seoaic-form" method="post" data-callback="window_reload">
                <input class="seoaic-form-item" type="hidden" name="action" value="seoaic_posts_mass_create">
                <div class="additional-items mass-create mt-0"></div>
                <div class="seoaic-popup__field">
                    <label class="mb-10"><?php esc_html_e('Custom prompt', 'seoaic');?></label>
                    <textarea name="mass_prompt" class="seoaic-form-item mt-0"></textarea>
                    <?php echo \SEOAIC\SEOAIC_SETTINGS::createRepeaterHTML('seoaic_services', true) ?>
                    <?php echo \SEOAIC\SEOAIC_SETTINGS::createRepeaterHTML('seoaic_target_audience', true) ?>
                </div>
                <div class="seoaic-popup__field">
                    <label class="mb-10"><?php esc_html_e( 'Select knowledge base', 'seoaic' ); ?></label>
                    <select name="seoaic_knowledge_base" class="seoaic-form-item form-select">
                        <option value="" id="select_knowledge_default" selected disabled hidden><?php esc_html_e('Choose here knowledge base', 'seoaic');?></option>
                    </select>
                </div>

                <div class="">
                    <label class="seoaic-cursor-pointer">
                        <input type="checkbox"
                            name="seoaic_generate_thumbnail"
                            id="seoaic_generate_thumbnail"
                            class="seoaic-form-item"
                        >
                        <?php esc_html_e('Generate thumbnail automatically', 'seoaic');?>
                    </label>
                </div>

                <div>
                    <div class="seoaic-generate-thumb-wrapper display-none">
                        <div>
                            <label class="mb-10"><?php esc_html_e('Generated image style', 'seoaic');?></label>
                            <select name="generate_thumbnail_style" class="seoaic-form-item form-select">
                                <?php
                                $styles = SEOAIC_SETTINGS::getImageGenerateStylesAvailable();
                                $defaultStyle = SEOAIC_SETTINGS::getImageGenerateStyle();
                                echo wp_kses(
                                    HTMLBuilers::options($styles, $defaultStyle),
                                    [
                                        'option' => [
                                            'value'     => [],
                                            'selected'  => [],
                                            'class'     => [],
                                        ],
                                    ]
                                );
                                ?>
                            </select>
                        </div>

                        <div class="seoaic-popup__field">
                            <label class="mb-10 mt-20"><?php esc_html_e('Image generation prompt', 'seoaic');?></label>
                            <textarea name="thumbnail_generation_prompt" class="seoaic-form-item mt-0 seoaic-textarea-autoresize"><?php esc_html_e(SEOAIC_SETTINGS::getImageGeneratePromptDefault());?></textarea>
                        </div>

                        <div class="f-words-count seoaic-settings-range seoaic-settings-range-2 mt-20 mb-0"
                             data-min="256"
                             data-max="1440"
                             data-step="32"
                             data-range="min"
                        >
                            <label><?php esc_html_e('Image width (optionally):', 'seoaic'); ?>
                                <span class="range-min"><?php echo esc_html( SEOAIC_SETTINGS::getImageGenerateWidthDefault() ); ?></span><?php esc_html_e('px', 'seoaic'); ?>
                                <input type="hidden"
                                       class="seoaic-settings-range-min seoaic-form-item"
                                       name="thumbnail_generation_width"
                                       value="<?php echo esc_html( SEOAIC_SETTINGS::getImageGenerateWidthDefault() ); ?>"
                                >
                            </label>
                            <div id=""
                                 class="seoaic-settings-range-slider"
                            ></div>
                        </div>
                        <div class="f-words-count seoaic-settings-range seoaic-settings-range-2 mt-20 mb-0"
                             data-min="256"
                             data-max="1440"
                             data-step="32"
                             data-range="min"
                        >
                            <label><?php esc_html_e('Image height (optionally):', 'seoaic'); ?>
                                <span class="range-min"><?php echo esc_html( SEOAIC_SETTINGS::getImageGenerateHeightDefault() ); ?></span><?php esc_html_e('px', 'seoaic'); ?>
                                <input type="hidden"
                                       id=""
                                       class="seoaic-settings-range-min seoaic-form-item"
                                       name="thumbnail_generation_height"
                                       value="<?php echo esc_html( SEOAIC_SETTINGS::getImageGenerateHeightDefault() ); ?>"
                                >
                            </label>
                            <div id=""
                                 class="seoaic-settings-range-slider"
                            ></div>
                        </div>
                    </div>

                    <div class="seoaic-popup__field seoaic-set-thumb-wrapper">
                        <label class="mb-10"><?php esc_html_e('Set thumbnail from gallery', 'seoaic');?></label>
                        <?php echo SEOAIC_POSTS::seoaicImageUploader();?>
                    </div>
                </div>

                <?php
                $categories_safe = seoaic_get_categories(SEOAIC_SETTINGS::getSEOAICPostType());
                ?>
                <div id="seoaic-idea-content-category" class="col-12 seoaic-select-post-type-cat">
                    <label for="seoaic_default_category"><?php esc_html_e('Posts categories', 'seoaic');?></label>
                    <div class="terms-select"><?php echo $categories_safe;?></div>
                </div>

                <?php echo $SEOAIC->competitors->competitor_content_language_selection(); ?>
            </form>
            <div class="lds-indication">
                <div class="indication-title flex-justify">
                    <span class="on-generating"><?php esc_html_e('Generating...', 'seoaic');?>
                        <span class="generating-process">
                            <span class="dn"><?php esc_html_e('Hold on tight - Your content is being generated', 'seoaic');?></span>
                            <span class="dn"><?php esc_html_e('Hold on tight - Your content is being reviewed', 'seoaic');?></span>
                            <span class="dn"><?php esc_html_e('Hold on tight - Your content is SEO optimised', 'seoaic');?></span>
                            <span class="dn"><?php esc_html_e('Hold on tight - Your content is humanised', 'seoaic');?></span>
                        </span>
                    </span>
                    <span class="vis-on-generated"><?php esc_html_e('Generated!', 'seoaic');?></span> <span class="generating-num"><span class="generating-num-pos"></span>/<span class="generating-num-total"></span></span></div>
                <div class="indication position-relative"><span class="loader accent-bg"></span></div>
            </div>
        </div>

        <div class="seoaic-popup__footer">
            <div class="flex-justify modal-ranges">
                <div id="seoiac-modal-subtitles-range" class="seoaic-settings-range" data-min="0" data-max="15" data-step="1">
                    <label><?php esc_html_e('Subtitles range:', 'seoaic');?>
                        <span class="range-min"><?php echo esc_html($subtitlesRangeMin);?></span> -
                        <span class="range-max"><?php echo esc_html($subtitlesRangeMax);?></span>
                        <input type="hidden"
                            name="seoaic_subtitles_range_min"
                            value="<?php echo esc_attr($subtitlesRangeMin);?>"
                            form="post-mass-creation-form"
                            id="seoaic_modal_subtitles_range_min"
                            class="seoaic-settings-range-min seoaic-form-item"
                        >
                        <input type="hidden"
                            name="seoaic_subtitles_range_max"
                            value="<?php echo esc_attr($subtitlesRangeMax);?>"
                            form="post-mass-creation-form"
                            id="seoaic_modal_subtitles_range_max"
                            class="seoaic-settings-range-max seoaic-form-item"
                        >
                    </label>
                    <div id="seoiac-modal-subtitles-range-slider" class="seoaic-settings-range-slider"></div>
                </div>

                <div id="seoiac-modal-words-range" class="seoaic-settings-range seoaic-posts-mass-create-word-range" data-min="0" data-max="2500" data-step="10">
                    <label><?php esc_html_e("Post words range:", "seoaic");?>
                        <span class="range-min"><?php echo esc_html($wordsRangeMin);?></span> -
                        <span class="range-max"><?php echo esc_html($wordsRangeMax);?></span>
                        <input type="hidden"
                            name="seoaic_words_range_min"
                            value="<?php echo esc_attr($wordsRangeMin);?>"
                            form="post-mass-creation-form"
                            id="seoaic_modal_words_range_min"
                            class="seoaic-settings-range-min seoaic-form-item"
                        >
                        <input type="hidden"
                            name="seoaic_words_range_max"
                            value="<?php echo esc_attr($wordsRangeMax);?>"
                            form="post-mass-creation-form"
                            id="seoaic_modal_words_range_max"
                            class="seoaic-settings-range-max seoaic-form-item"
                        >
                    </label>
                    <div id="seoiac-modal-words-range-slider" class="seoaic-settings-range-slider"></div>
                </div>
            </div>

            <?php if ( $SEOAIC->multilang->is_multilang() ) : ?>
                <div class="mb-10 d-none">
                    <label>
                        <input type="checkbox"
                            name="seoaic-translate-from-origin"
                            value="yes"
                            checked
                            form="post-mass-creation-form"
                            id="seoaic-translate-from-origin"
                            class="seoaic-form-item"
                        ><?php esc_html_e('Translate posts from origin', 'seoaic');?>
                    </label>
                </div>
            <?php endif; ?>

            <div class="mb-10">
                <label class="seoaic-cursor-pointer">
                    <input type="checkbox"
                        name="seoaic_experimental_generation_post"
                        form="post-mass-creation-form"
                        id="seoaic_experimental_generation_post"
                        class="seoaic-form-item"
                    ><?php esc_html_e('Use new content generation flow (experimental feature)', 'seoaic');?>
                </label>
            </div>

            <div class="mb-10">
                <label class="seoaic-cursor-pointer">
                    <input type="checkbox"
                        name="seoaic_optimize_post"
                        form="post-mass-creation-form"
                        id="seoaic_optimize_post"
                        class="seoaic-form-item"
                    ><?php esc_html_e('Use optimized flow', 'seoaic');?>
                </label>
            </div>

            <div class="mb-10 display-none">
                <label class="mb-10"><?php esc_html_e('Optimized flow type', 'seoaic');?></label>
                <select
                    name="seoaic_optimize_post_type"
                    form="post-mass-creation-form"
                    id="seoaic_optimize_post_type"
                    class="seoaic-form-item form-select"
                    title="<?php esc_html_e("Optimized flow type", "seoaic");?>"
                >
                    <option value="base"><?php esc_html_e("Base", "seoaic");?></option>
                    <option value="humanize"><?php esc_html_e("Humanize", "seoaic");?></option>
                    <option value="internal_links"><?php esc_html_e("Internal links", "seoaic");?></option>
                </select>
            </div>

            <div class="mb-10 display-none">
                <label class="seoaic-cursor-pointer">
                    <input type="checkbox"
                        name="seoaic_add_takeaways"
                        form="post-mass-creation-form"
                        id="seoaic_add_takeaways"
                        class="seoaic-form-item"
                    ><?php esc_html_e('Add key takeaways', 'seoaic');?>
                </label>
            </div>

            <div class="mb-10">
                <label class="seoaic-cursor-pointer">
                    <input type="checkbox"
                        name="seoaic_add_faq"
                        form="post-mass-creation-form"
                        id="seoaic_add_faq"
                        class="seoaic-form-item"
                    ><?php esc_html_e('Add FAQ section', 'seoaic');?>
                </label>
            </div>

            <?php LeadsFormGenerate::generatePostFormElements('post-mass-creation-form', true);?>

            <div class="mb-30">
                <label class="seoaic-cursor-pointer">
                    <input type="checkbox"
                        name="interactive_article"
                        class="seoaic-form-item"
                        form="post-mass-creation-form"
                    >
                    <?php esc_html_e('Make article interactive', 'seoaic');?>
                </label>
            </div>

            <div class="flex-justify">
                <button type="button" class="seoaic-popup__btn-left seoaic-modal-close novis-on-generating novis-on-generated"><?php esc_html_e('No', 'seoaic');?></button>
                <button type="button" class="seoaic-popup__btn-right seoaic-modal-close seoaic-popup__btn vis-on-generated"><?php esc_html_e('OK', 'seoaic');?></button>

                <div class="hide-on-generating hide-on-generated seoaic-mass-creation-posting">
                    <select form="post-mass-creation-form" name="seoaic_post_status" class="seoaic_post_status seoaic-form-item">
                        <option value="draft"><?php esc_html_e('Leave draft', 'seoaic');?></option>
                        <option value="publish"><?php esc_html_e('Publish immediately', 'seoaic');?></option>
                        <?php
                        $publish_delay = !empty($SEOAIC_OPTIONS['seoaic_publish_delay']) ? intval($SEOAIC_OPTIONS['seoaic_publish_delay']) : 0;
                        if ($publish_delay > 0) {
                            ?>
                            <option value="delay"><?php esc_html_e('Delay publication', 'seoaic');?></option>
                            <?php
                        }

                        if (!empty($SEOAIC_OPTIONS['seoaic_schedule_days'])) {
                            ?>
                            <option value="schedule"><?php esc_html_e('Schedule publication', 'seoaic');?></option>
                            <?php
                        }
                        ?>
                    </select>

                    <?php
                    $currentDate = date('Y-m-d');
                    $date = new DateTime($currentDate);
                    $publish_delay = !empty($SEOAIC_OPTIONS['seoaic_publish_delay']) ? intval($SEOAIC_OPTIONS['seoaic_publish_delay']) : 0;
                    $date->modify("+$publish_delay hours");
                    $delayDate = $date->format('Y-m-d');
                    ?>
                    <div class="idea-date-picker" style="display: none;">
                        <input type="date"
                               form="post-mass-creation-form"
                               class="seoaic-mass-idea-date seoaic-form-item"
                               name="seoaic-mass-idea-date"
                               value="<?php echo esc_attr($delayDate);?>"
                               min="<?php echo esc_attr($delayDate);?>"
                        >
                    </div>
                </div>

                <button type="submit"
                    form="post-mass-creation-form"
                    id="posts-mass-generate-button"
                    class="seoaic-popup__btn seoaic-popup__btn-right hide-on-generated"
                ><?php esc_html_e('Generate', 'seoaic');?></button>
            </div>
        </div>
    </div>
</div>
