<?php

defined( 'ABSPATH' ) || exit;

?>
<div id="seoaic-post-mass-add-lead-form-modal" class="seoaic-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3 class="modal-title" data-title="<?php esc_html_e('Message', 'seoaic');?>"><?php esc_html_e('Message', 'seoaic');?></h3>
        </div>
        <div class="seoaic-popup__content fs-18 position-relative">
            <label class="seoaic-modal-content mb-10"></label>

            <form method="post"
                id="post-mass-lead-forms-add-form"
                class="mt-0 seoaic-form"
            >
                <input class="seoaic-form-item" type="hidden" name="action" value="seoaic_add_lead_form_to_post">
                <div class="additional-items mt-0"></div>

                <div class="w-100">
                    <div class="flex-center-x">
                        <label class="mb-10" for="seoaic_lead_form_selector"><?php esc_html_e("Lead Form", "seoaic");?></label>
                        <a target="_blank"
                            class="small mb-10"
                            href="<?php echo esc_url(admin_url('site-editor.php?p=%2Fpattern&postType=wp_block&categoryId=leads-forms'));?>"
                        ><?php esc_html_e("Manage lead forms", "seoaic");?> <span class="dashicons dashicons-external text-decoration-none"></span></a>
                    </div>
                    <select
                        name="seoaic_lead_form"
                        id="seoaic_lead_form_selector"
                        class="seoaic-form-item form-select"
                    ></select>
                </div>
            </form>
        </div>
        <div class="seoaic-popup__footer">
            <div class="flex-justify">
                <button type="submit"
                    form="post-mass-lead-forms-add-form"
                    id="posts-mass-edit-button"
                    class="seoaic-popup__btn seoaic-popup__btn"
                ><?php esc_html_e('Add lead form', 'seoaic');?></button>
            </div>
        </div>
    </div>
</div>
