<?php
defined( 'ABSPATH' ) || exit;

global $SEOAIC;

$providers = $SEOAIC->brand_visibility->getProvidersList();
?>


<div id="seoaic-brand-visibility-models-request-modal" class="seoaic-modal seoaic-modal-large seoaic-brand-visibility-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3><?php esc_html_e( 'Models Request', 'seoaic' ); ?></h3>
        </div>


        <div class="seoaic-popup__content">
            <div class="seoaic-brand-visibility-modal__models-list">
                <?php if( !empty($providers) && is_array($providers) ): ?>
                    <?php
                        $providers_order = ['active', 'requested', 'available', 'no_available', 'disabled'];

                        usort($providers, function($a, $b) use ($providers_order) {
                            $posA = array_search($a['status'], $providers_order);
                            $posB = array_search($b['status'], $providers_order);
                            return $posA <=> $posB;
                        });
                    ?>

                    <?php foreach ( $providers as $provider ):
                        $source  = strtolower($provider['provider']) === 'google_ai_overview' ? 'Google AIO' : $provider['provider'];

                        if( $provider['status'] === 'disabled' ) continue;
                    ?>
                        <div class="seoaic-brand-visibility-modal__models-list-item <?= $provider['status']; ?>"
                            data-provider="<?= $provider['provider'] ?>">
                            <div class="seoaic-brand-visibility-modal__models-list-item__title <?= $provider['provider'] ?>-icon">
                                <?php esc_html_e( ucfirst($source), 'seoaic' ); ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>

        <div class="seoaic-popup__footer flex-justify">
            <button type="button" class="seoaic-popup__btn seoaic-popup__btn-right seoaic-modal-close">
                <?php esc_html_e( 'Cancel', 'seoaic' ); ?>
            </button>

            <button type="button"
                    class="seoaic-popup__btn seoaic-popup__btn-right submit-models-request-button" disabled>
                <?php esc_html_e( 'Submit', 'seoaic' ); ?>
            </button>
        </div>
    </div>
</div>