<?php

defined('ABSPATH') || exit;
global $SEOAIC;
?>
<div id="seoaic-manage-clusters" class="seoaic-modal seoaic-fixed-scroll-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
        <span class="seoaic-modal-close">
            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
            </svg>
        </span>
            <h3 class="modal-title"><?php esc_html_e('Accepting generated Ideas', 'seoaic');?></h3>
        </div>
        <div class="seoaic-popup__content fs-18">
            <div class="seoaic-top-actions-on-ideas d-none">
                <label id="seoaic-select-all-accepted-ideas" class="accent accent-underline"><?php esc_html_e('Select all', 'seoaic'); ?></label>
            </div>
            <div class="seoaic-modal-content">
                <div class="seoaic-scroll-vertical seoaic-created-ob-ideas">
                    <?php echo $SEOAIC->onboarding->manage_clusters_html('', false, true, false); ?>
                </div>
            </div>
        </div>
        <div class="seoaic-popup__footer flex-right seoaic-flex-wrap ai-center seoaic-top-border-light">
            <?php echo $SEOAIC->onboarding->get_mass_generate_selections(); ?>
            <span href="#" class="seoaic-modal-close accent accent-underline">
                <?php esc_html_e('Close', 'seoaic');?>
            </span>
            <button type="button"
                    class="seoaic-branded-button small-button mr-0 ml-auto modal-button" data-modal-class="ignore_close_event" data-modal="#seoaic-add-clusters-modal"
            >
                <?php esc_html_e('Add clusters', 'seoaic'); ?>
                <span class="button-text"></span>
            </button>
        </div>
        <div class="seoaic-on-action-attention-remove d-none">
            <div class="seoaic-on-action-attention-remove-message">
                <?php esc_html_e('Are you sure you want to remove those items?', 'seoaic'); ?>
            </div>
            <button type="button"
                    class="seoaic-remove-selected-ob-ideas seoaic-on-action-attention-remove-button seoaic-branded-button small-button ml-15"><?php esc_html_e('Yes', 'seoaic'); ?></button>
            <button type="button"
                    class="seoaic-on-action-attention-remove-close seoaic-on-action-attention-remove-button seoaic-branded-button small-button ml-10"><?php esc_html_e('No', 'seoaic'); ?></button>
        </div>
    </div>
</div>